/*
 * Decompiled with CFR 0.152.
 */
package com.android.uiautomator;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.SyncService;
import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.RootWindowNode;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class UiAutomatorHelper {
    public static final int UIAUTOMATOR_MIN_API_LEVEL = 16;
    private static final String UIAUTOMATOR = "/system/bin/uiautomator";
    private static final String UIAUTOMATOR_DUMP_COMMAND = "dump";
    private static final String UIDUMP_DEVICE_PATH = "/data/local/tmp/uidump.xml";
    private static final int XML_CAPTURE_TIMEOUT_SEC = 40;

    private static boolean supportsUiAutomator(IDevice device) {
        int apiLevel;
        String apiLevelString = device.getProperty("ro.build.version.sdk");
        try {
            apiLevel = Integer.parseInt(apiLevelString);
        }
        catch (NumberFormatException e) {
            apiLevel = 16;
        }
        return apiLevel >= 16;
    }

    private static void getUiHierarchyFile(IDevice device, File dst, IProgressMonitor monitor) {
        CountDownLatch commandCompleteLatch;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.subTask("Deleting old UI XML snapshot ...");
        String command = "rm /data/local/tmp/uidump.xml";
        try {
            commandCompleteLatch = new CountDownLatch(1);
            device.executeShellCommand(command, new CollectingOutputReceiver(commandCompleteLatch));
            commandCompleteLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            // empty catch block
        }
        monitor.subTask("Taking UI XML snapshot...");
        command = String.format("%s %s %s", UIAUTOMATOR, UIAUTOMATOR_DUMP_COMMAND, UIDUMP_DEVICE_PATH);
        commandCompleteLatch = new CountDownLatch(1);
        try {
            device.executeShellCommand(command, new CollectingOutputReceiver(commandCompleteLatch), 40000);
            commandCompleteLatch.await(40L, TimeUnit.SECONDS);
            monitor.subTask("Pull UI XML snapshot from device...");
            device.getSyncService().pullFile(UIDUMP_DEVICE_PATH, dst.getAbsolutePath(), SyncService.getNullProgressMonitor());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static UiAutomatorResult takeSnapshot(IDevice device, IProgressMonitor monitor) throws UiAutomatorException {
        RawImage rawImage;
        UiAutomatorModel model;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.subTask("Checking if device support UI Automator");
        if (!UiAutomatorHelper.supportsUiAutomator(device)) {
            String msg = "UI Automator requires a device with API Level 16";
            throw new UiAutomatorException(msg, null);
        }
        monitor.subTask("Creating temporary files for uiautomator results.");
        File tmpDir = null;
        File xmlDumpFile = null;
        File screenshotFile = null;
        try {
            tmpDir = File.createTempFile("uiautomatorviewer_", "");
            tmpDir.delete();
            if (!tmpDir.mkdirs()) {
                throw new IOException("Failed to mkdir");
            }
            xmlDumpFile = File.createTempFile("dump_", ".uix", tmpDir);
            screenshotFile = File.createTempFile("screenshot_", ".png", tmpDir);
        }
        catch (Exception e) {
            String msg = "Error while creating temporary file to save snapshot: " + e.getMessage();
            throw new UiAutomatorException(msg, e);
        }
        tmpDir.deleteOnExit();
        xmlDumpFile.deleteOnExit();
        screenshotFile.deleteOnExit();
        monitor.subTask("Obtaining UI hierarchy");
        try {
            UiAutomatorHelper.getUiHierarchyFile(device, xmlDumpFile, monitor);
        }
        catch (Exception e) {
            String msg = "Error while obtaining UI hierarchy XML file: " + e.getMessage();
            throw new UiAutomatorException(msg, e);
        }
        try {
            model = new UiAutomatorModel(xmlDumpFile);
        }
        catch (Exception e) {
            String msg = "Error while parsing UI hierarchy XML file: " + e.getMessage();
            throw new UiAutomatorException(msg, e);
        }
        monitor.subTask("Obtaining device screenshot");
        try {
            rawImage = device.getScreenshot();
        }
        catch (Exception e) {
            String msg = "Error taking device screenshot: " + e.getMessage();
            throw new UiAutomatorException(msg, e);
        }
        BasicTreeNode root = model.getXmlRootNode();
        if (root instanceof RootWindowNode) {
            for (int i = 0; i < ((RootWindowNode)root).getRotation(); ++i) {
                rawImage = rawImage.getRotated();
            }
        }
        PaletteData palette = new PaletteData(rawImage.getRedMask(), rawImage.getGreenMask(), rawImage.getBlueMask());
        ImageData imageData = new ImageData(rawImage.width, rawImage.height, rawImage.bpp, palette, 1, rawImage.data);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        loader.save(screenshotFile.getAbsolutePath(), 5);
        Image screenshot = new Image((Device)Display.getDefault(), imageData);
        return new UiAutomatorResult(xmlDumpFile, model, screenshot);
    }

    public static class UiAutomatorResult {
        public final File uiHierarchy;
        public final UiAutomatorModel model;
        public final Image screenshot;

        public UiAutomatorResult(File uiXml, UiAutomatorModel m, Image s) {
            this.uiHierarchy = uiXml;
            this.model = m;
            this.screenshot = s;
        }
    }

    public static class UiAutomatorException
    extends Exception {
        public UiAutomatorException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

