/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.google.common.primitives.Bytes;

public class SystraceTask
implements Runnable {
    private final IDevice mDevice;
    private final String mOptions;
    private volatile boolean mCancel;
    private final Object mLock = new Object();
    private String errorMessage;
    private boolean mTraceComplete;
    private byte[] mBuffer = new byte[1024];
    private int mDataLength = 0;

    public SystraceTask(IDevice iDevice, String string) {
        this.mDevice = iDevice;
        this.mOptions = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mDevice.executeShellCommand("atrace " + this.mOptions, (IShellOutputReceiver)new Receiver(), 0);
        }
        catch (Exception exception) {
            Object object = this.mLock;
            synchronized (object) {
                this.errorMessage = "Unexpected error while running atrace on device: " + exception;
            }
        }
    }

    public void cancel() {
        this.mCancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getError() {
        Object object = this.mLock;
        synchronized (object) {
            return this.errorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAtraceOutput() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTraceComplete ? this.mBuffer : null;
        }
    }

    private class Receiver
    implements IShellOutputReceiver {
        private Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOutput(byte[] byArray, int n, int n2) {
            Object object = SystraceTask.this.mLock;
            synchronized (object) {
                if (SystraceTask.this.mDataLength + n2 > SystraceTask.this.mBuffer.length) {
                    SystraceTask.this.mBuffer = Bytes.ensureCapacity((byte[])SystraceTask.this.mBuffer, (int)(SystraceTask.this.mDataLength + n2 + 1), (int)1024);
                }
                int n3 = 0;
                while (n3 < n2) {
                    ((SystraceTask)SystraceTask.this).mBuffer[((SystraceTask)SystraceTask.this).mDataLength + n3] = byArray[n + n3];
                    ++n3;
                }
                SystraceTask systraceTask = SystraceTask.this;
                systraceTask.mDataLength = systraceTask.mDataLength + n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = SystraceTask.this.mLock;
            synchronized (object) {
                byte[] byArray = new byte[SystraceTask.this.mDataLength];
                int n = 0;
                while (n < SystraceTask.this.mDataLength) {
                    byArray[n] = SystraceTask.this.mBuffer[n];
                    ++n;
                }
                SystraceTask.this.mBuffer = byArray;
                SystraceTask.this.mTraceComplete = true;
            }
        }

        public boolean isCancelled() {
            return SystraceTask.this.mCancel;
        }
    }
}

