/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.preferences;

import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Log;
import com.android.ddmuilib.DdmUiPreferences;
import com.android.ide.eclipse.ddms.DdmsPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.FontData;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String ATTR_LOG_LEVEL = "com.android.ide.eclipse.ddms.logLevel";
    public static final String ATTR_DEBUG_PORT_BASE = "com.android.ide.eclipse.ddms.adbDebugBasePort";
    public static final String ATTR_SELECTED_DEBUG_PORT = "com.android.ide.eclipse.ddms.debugSelectedPort";
    public static final String ATTR_DEFAULT_THREAD_UPDATE = "com.android.ide.eclipse.ddms.defaultThreadUpdateEnabled";
    public static final String ATTR_DEFAULT_HEAP_UPDATE = "com.android.ide.eclipse.ddms.defaultHeapUpdateEnabled";
    public static final String ATTR_THREAD_INTERVAL = "com.android.ide.eclipse.ddms.threadStatusInterval";
    public static final String ATTR_IMAGE_SAVE_DIR = "com.android.ide.eclipse.ddms.imageSaveDir";
    public static final String ATTR_LAST_IMAGE_SAVE_DIR = "com.android.ide.eclipse.ddms.lastImageSaveDir";
    public static final String ATTR_LOGCAT_FONT = "com.android.ide.eclipse.ddms.logcatFont";
    public static final String ATTR_HPROF_ACTION = "com.android.ide.eclipse.ddms.hprofAction";
    public static final String ATTR_TIME_OUT = "com.android.ide.eclipse.ddms.timeOut";
    public static final String ATTR_USE_ADBHOST = "com.android.ide.eclipse.ddms.useAdbHost";
    public static final String ATTR_ADBHOST_VALUE = "com.android.ide.eclipse.ddms.adbHostValue";
    public static final String ATTR_SWITCH_PERSPECTIVE = "com.android.ide.eclipse.ddms.switchPerspective";
    public static final String ATTR_PERSPECTIVE_ID = "com.android.ide.eclipse.ddms.perspectiveId";
    public static final String ATTR_PROFILER_BUFSIZE_MB = "com.android.ide.eclipse.ddms.profilerBufferSizeMb";

    public void initializeDefaultPreferences() {
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setDefault(ATTR_DEBUG_PORT_BASE, 8600);
        iPreferenceStore.setDefault(ATTR_SELECTED_DEBUG_PORT, 8700);
        iPreferenceStore.setDefault(ATTR_DEFAULT_THREAD_UPDATE, false);
        iPreferenceStore.setDefault(ATTR_DEFAULT_HEAP_UPDATE, false);
        iPreferenceStore.setDefault(ATTR_PROFILER_BUFSIZE_MB, 8);
        iPreferenceStore.setDefault(ATTR_THREAD_INTERVAL, 4);
        String string = System.getProperty("user.home");
        iPreferenceStore.setDefault(ATTR_IMAGE_SAVE_DIR, string);
        iPreferenceStore.setDefault(ATTR_LOG_LEVEL, DdmPreferences.DEFAULT_LOG_LEVEL.getStringValue());
        iPreferenceStore.setDefault(ATTR_LOGCAT_FONT, new FontData("Courier", 10, 0).toString());
        iPreferenceStore.setDefault(ATTR_HPROF_ACTION, "hprof.save");
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType iContentType = iContentTypeArray[n2];
            if (iContentType.isAssociatedWith(".hprof")) {
                iPreferenceStore.setDefault(ATTR_HPROF_ACTION, "hprof.open");
                break;
            }
            ++n2;
        }
        iPreferenceStore.setDefault(ATTR_TIME_OUT, 5000);
        iPreferenceStore.setDefault(ATTR_USE_ADBHOST, false);
        iPreferenceStore.setDefault(ATTR_ADBHOST_VALUE, "127.0.0.1");
        iPreferenceStore.setDefault(ATTR_SWITCH_PERSPECTIVE, true);
        iPreferenceStore.setDefault(ATTR_PERSPECTIVE_ID, "org.eclipse.jdt.ui.JavaPerspective");
        iPreferenceStore.setDefault("ddms.logcat.automonitor", true);
        iPreferenceStore.setDefault("ddms.logcat.auotmonitor.level", Log.LogLevel.VERBOSE.getStringValue());
    }

    public static synchronized void setupPreferences() {
        IPreferenceStore iPreferenceStore = DdmsPlugin.getDefault().getPreferenceStore();
        DdmPreferences.setDebugPortBase((int)iPreferenceStore.getInt(ATTR_DEBUG_PORT_BASE));
        DdmPreferences.setSelectedDebugPort((int)iPreferenceStore.getInt(ATTR_SELECTED_DEBUG_PORT));
        DdmPreferences.setLogLevel((String)iPreferenceStore.getString(ATTR_LOG_LEVEL));
        DdmPreferences.setInitialThreadUpdate((boolean)iPreferenceStore.getBoolean(ATTR_DEFAULT_THREAD_UPDATE));
        DdmPreferences.setInitialHeapUpdate((boolean)iPreferenceStore.getBoolean(ATTR_DEFAULT_HEAP_UPDATE));
        DdmPreferences.setProfilerBufferSizeMb((int)iPreferenceStore.getInt(ATTR_PROFILER_BUFSIZE_MB));
        DdmUiPreferences.setThreadRefreshInterval((int)iPreferenceStore.getInt(ATTR_THREAD_INTERVAL));
        DdmPreferences.setTimeOut((int)iPreferenceStore.getInt(ATTR_TIME_OUT));
        DdmPreferences.setUseAdbHost((boolean)iPreferenceStore.getBoolean(ATTR_USE_ADBHOST));
        DdmPreferences.setAdbHostValue((String)iPreferenceStore.getString(ATTR_ADBHOST_VALUE));
    }
}

