/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.IdResourceParser;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceFolder;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ScanningContext;
import com.android.ide.common.resources.ValueResourceParser;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class IdGeneratingResourceFile
extends ResourceFile
implements ValueResourceParser.IValueResourceRepository {
    private final Map<String, ResourceValue> mIdResources = new HashMap<String, ResourceValue>();
    private final Collection<ResourceType> mResourceTypeList;
    private final String mFileName;
    private final ResourceType mFileType;
    private final ResourceValue mFileValue;

    public IdGeneratingResourceFile(IAbstractFile file, ResourceFolder folder, ResourceType type) {
        super(file, folder);
        this.mFileType = type;
        this.mResourceTypeList = new HashSet<ResourceType>();
        this.mResourceTypeList.add(this.mFileType);
        this.mResourceTypeList.add(ResourceType.ID);
        this.mFileName = this.getFileName(type);
        this.mFileValue = this.getFileValue(file, folder);
    }

    @Override
    protected void load(ScanningContext context) {
        this.parseFileForIds(context);
        this.updateResourceItems(context);
    }

    @Override
    protected void update(ScanningContext context) {
        HashSet<String> oldIdNames = new HashSet<String>(this.mIdResources.keySet());
        this.mIdResources.clear();
        if (!this.parseFileForIds(context)) {
            context.requestFullAapt();
        }
        Set<String> keySet = this.mIdResources.keySet();
        assert (keySet != oldIdNames);
        if (!((Object)oldIdNames).equals(keySet)) {
            this.updateResourceItems(context);
        }
    }

    @Override
    protected void dispose(ScanningContext context) {
        ResourceRepository repository = this.getRepository();
        repository.removeFile(this.mResourceTypeList, (ResourceFile)this);
        context.requestFullAapt();
    }

    @Override
    public Collection<ResourceType> getResourceTypes() {
        return this.mResourceTypeList;
    }

    @Override
    public boolean hasResources(ResourceType type) {
        return type == this.mFileType || type == ResourceType.ID && !this.mIdResources.isEmpty();
    }

    @Override
    public ResourceValue getValue(ResourceType type, String name) {
        if (type != this.mFileType && type != ResourceType.ID) {
            return null;
        }
        if (type == this.mFileType && name.equals(this.mFileName)) {
            return this.mFileValue;
        }
        return this.mIdResources.get(name);
    }

    private boolean parseFileForIds(ScanningContext context) {
        IdResourceParser parser = new IdResourceParser(this, context, this.isFramework());
        try {
            IAbstractFile file = this.getFile();
            return parser.parse(this.mFileType, file.getOsLocation(), file.getContents());
        }
        catch (IOException e) {
        }
        catch (StreamException streamException) {
            // empty catch block
        }
        return false;
    }

    private void updateResourceItems(ScanningContext context) {
        ResourceRepository repository = this.getRepository();
        repository.removeFile(this.mResourceTypeList, (ResourceFile)this);
        ResourceItem item = repository.getResourceItem(this.mFileType, this.mFileName);
        item.add(this);
        for (String idName : this.mIdResources.keySet()) {
            item = repository.getResourceItem(ResourceType.ID, idName);
            item.add(this);
        }
        context.requestFullAapt();
    }

    private ResourceValue getFileValue(IAbstractFile file, ResourceFolder folder) {
        DensityQualifier qualifier = folder.getConfiguration().getDensityQualifier();
        ResourceValue value = qualifier == null ? new ResourceValue(this.mFileType, this.mFileName, file.getOsLocation(), this.isFramework()) : new DensityBasedResourceValue(this.mFileType, this.mFileName, file.getOsLocation(), qualifier.getValue(), this.isFramework());
        return value;
    }

    private String getFileName(ResourceType type) {
        String name = this.getFile().getName();
        int pos = name.indexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        return name;
    }

    @Override
    public void addResourceValue(ResourceValue value) {
        this.mIdResources.put(value.getName(), value);
    }

    @Override
    public boolean hasResourceValue(ResourceType type, String name) {
        if (type == ResourceType.ID) {
            return this.mIdResources.containsKey(name);
        }
        return false;
    }
}

