/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.exit;

import com.vladium.util.IJREVersion;
import com.vladium.util.Property;
import java.util.HashMap;
import java.util.Map;

public abstract class ExitHookManager
implements IJREVersion {
    private static ExitHookManager s_singleton;

    public abstract boolean addExitHook(Runnable var1);

    public abstract boolean removeExitHook(Runnable var1);

    public static synchronized ExitHookManager getSingleton() {
        if (s_singleton == null) {
            if (JRE_1_3_PLUS) {
                s_singleton = new JRE13ExitHookManager();
            } else {
                throw new UnsupportedOperationException("no shutdown hook manager available [JVM: " + Property.getSystemFingerprint() + "]");
            }
        }
        return s_singleton;
    }

    protected ExitHookManager() {
    }

    private static final class JRE13ExitHookManager
    extends ExitHookManager {
        private final Map m_exitThreadMap = new HashMap();

        public synchronized boolean addExitHook(Runnable runnable) {
            if (runnable != null && !this.m_exitThreadMap.containsKey(runnable)) {
                Thread thread = new Thread(runnable, "EMMA shutdown handler thread");
                try {
                    Runtime.getRuntime().addShutdownHook(thread);
                    this.m_exitThreadMap.put(runnable, thread);
                    return true;
                }
                catch (Exception exception) {
                    System.out.println("exception caught while adding a shutdown hook:");
                    exception.printStackTrace(System.out);
                }
            }
            return false;
        }

        public synchronized boolean removeExitHook(Runnable runnable) {
            Thread thread;
            if (runnable != null && (thread = (Thread)this.m_exitThreadMap.get(runnable)) != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(thread);
                    this.m_exitThreadMap.remove(runnable);
                    return true;
                }
                catch (Exception exception) {
                    System.out.println("exception caught while removing a shutdown hook:");
                    exception.printStackTrace(System.out);
                }
            }
            return false;
        }

        JRE13ExitHookManager() {
        }
    }
}

