/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.exception;

import com.vladium.util.IJREVersion;
import com.vladium.util.exception.AbstractException;
import com.vladium.util.exception.AbstractRuntimeException;
import com.vladium.util.exception.IThrowableWrapper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

abstract class ExceptionCommon
implements IJREVersion {
    private static final boolean EMBED_ERROR_CODE = true;
    private static final String ROOT_RESOURCE_BUNDLE_NAME;
    private static final ResourceBundle ROOT_RESOURCE_BUNDLE;
    private static final Map s_exceptionCodeMap;
    private static final String NESTED_THROWABLE_HEADER = "[NESTED EXCEPTION]:";
    private static final Class THROWABLE;
    private static final Class ABSTRACT_EXCEPTION;
    private static final Class ABSTACT_RUNTIME_EXCEPTION;
    static final Enumeration EMPTY_ENUMERATION;
    private static final ResourceBundle EMPTY_RESOURCE_BUNDLE;
    private static final String EOL;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle addExceptionResource(Class clazz, String string) {
        if (clazz != null && string != null && string.length() > 0) {
            Object object;
            if (!ABSTRACT_EXCEPTION.isAssignableFrom(clazz) && !ABSTACT_RUNTIME_EXCEPTION.isAssignableFrom(clazz)) {
                throw new Error("addExceptionResource(): class [" + clazz + "] is not a subclass of " + ABSTRACT_EXCEPTION.getName() + " or " + ABSTACT_RUNTIME_EXCEPTION.getName());
            }
            ResourceBundle resourceBundle = null;
            String string2 = null;
            try {
                string2 = ExceptionCommon.getNameInNamespace(clazz, string);
                object = clazz.getClassLoader();
                if (object == null) {
                    object = ClassLoader.getSystemClassLoader();
                }
                resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), (ClassLoader)object);
            }
            catch (Throwable throwable) {
                resourceBundle = null;
            }
            if (resourceBundle != null) {
                object = s_exceptionCodeMap;
                synchronized (object) {
                    ResourceBundle resourceBundle2 = (ResourceBundle)s_exceptionCodeMap.get(clazz);
                    if (resourceBundle2 != null) {
                        return resourceBundle2;
                    }
                    s_exceptionCodeMap.put(clazz, resourceBundle);
                    return resourceBundle;
                }
            }
        }
        return null;
    }

    static void printStackTrace(Throwable throwable, PrintWriter printWriter) {
        if (JRE_1_4_PLUS) {
            if (throwable instanceof IThrowableWrapper) {
                IThrowableWrapper iThrowableWrapper = (IThrowableWrapper)((Object)throwable);
                iThrowableWrapper.__printStackTrace(printWriter);
            } else {
                throwable.printStackTrace(printWriter);
            }
        } else {
            boolean bl = true;
            while (throwable != null) {
                if (bl) {
                    bl = false;
                } else {
                    printWriter.println();
                    printWriter.println(NESTED_THROWABLE_HEADER);
                }
                if (throwable instanceof IThrowableWrapper) {
                    IThrowableWrapper iThrowableWrapper = (IThrowableWrapper)((Object)throwable);
                    iThrowableWrapper.__printStackTrace(printWriter);
                    throwable = iThrowableWrapper.getCause();
                    continue;
                }
                throwable.printStackTrace(printWriter);
                break;
            }
        }
    }

    static void printStackTrace(Throwable throwable, PrintStream printStream) {
        if (JRE_1_4_PLUS) {
            if (throwable instanceof IThrowableWrapper) {
                IThrowableWrapper iThrowableWrapper = (IThrowableWrapper)((Object)throwable);
                iThrowableWrapper.__printStackTrace(printStream);
            } else {
                throwable.printStackTrace(printStream);
            }
        } else {
            boolean bl = true;
            while (throwable != null) {
                if (bl) {
                    bl = false;
                } else {
                    printStream.println();
                    printStream.println(NESTED_THROWABLE_HEADER);
                }
                if (throwable instanceof IThrowableWrapper) {
                    IThrowableWrapper iThrowableWrapper = (IThrowableWrapper)((Object)throwable);
                    iThrowableWrapper.__printStackTrace(printStream);
                    throwable = iThrowableWrapper.getCause();
                    continue;
                }
                throwable.printStackTrace(printStream);
                break;
            }
        }
    }

    static String getMessage(Class clazz, String string) {
        if (string == null) {
            return null;
        }
        try {
            if (string.length() > 0) {
                String string2 = ExceptionCommon.lookup(clazz, string);
                if (string2 == null) {
                    return string;
                }
                return "[" + string + "] " + string2;
            }
            return "";
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    static String getMessage(Class clazz, String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        String string2 = ExceptionCommon.getMessage(clazz, string);
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        try {
            return MessageFormat.format(string2, objectArray);
        }
        catch (Throwable throwable) {
            StringBuffer stringBuffer = new StringBuffer(string + EOL);
            for (int i = 0; i < objectArray.length; ++i) {
                block8: {
                    stringBuffer.append("\t{" + i + "} = [");
                    Object object = objectArray[i];
                    try {
                        stringBuffer.append(object.toString());
                    }
                    catch (Throwable throwable2) {
                        if (object != null) {
                            stringBuffer.append(object.getClass().getName());
                            break block8;
                        }
                        stringBuffer.append("null");
                    }
                }
                stringBuffer.append("]");
                stringBuffer.append(EOL);
            }
            return stringBuffer.toString();
        }
    }

    private ExceptionCommon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookup(Class clazz, String string) {
        Object object;
        if (string == null) {
            return null;
        }
        if (clazz != null) {
            while (clazz != ABSTRACT_EXCEPTION && clazz != ABSTACT_RUNTIME_EXCEPTION && clazz != THROWABLE && clazz != null) {
                Object object2 = s_exceptionCodeMap;
                synchronized (object2) {
                    object = (ResourceBundle)s_exceptionCodeMap.get(clazz);
                    if (object == null && (object = ExceptionCommon.addExceptionResource(clazz, "exceptions")) == null) {
                        s_exceptionCodeMap.put(clazz, EMPTY_RESOURCE_BUNDLE);
                    }
                }
                if (object != null) {
                    object2 = null;
                    try {
                        object2 = ((ResourceBundle)object).getString(string);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (object2 != null) {
                        return object2;
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        if (ROOT_RESOURCE_BUNDLE != null) {
            object = null;
            try {
                object = ROOT_RESOURCE_BUNDLE.getString(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (object != null) {
                return object;
            }
        }
        return null;
    }

    private static String getNameInNamespace(Class clazz, String string) {
        if (clazz == null) {
            return string;
        }
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n <= 0) {
            return string;
        }
        return string2.substring(0, n + 1) + string;
    }

    static {
        s_exceptionCodeMap = new HashMap();
        THROWABLE = Throwable.class;
        ABSTRACT_EXCEPTION = AbstractException.class;
        ABSTACT_RUNTIME_EXCEPTION = AbstractRuntimeException.class;
        EMPTY_ENUMERATION = Collections.enumeration(Collections.EMPTY_SET);
        EMPTY_RESOURCE_BUNDLE = new ResourceBundle(){

            public Object handleGetObject(String string) {
                return null;
            }

            public Enumeration getKeys() {
                return EMPTY_ENUMERATION;
            }
        };
        EOL = System.getProperty("line.separator", "\n");
        ROOT_RESOURCE_BUNDLE_NAME = ExceptionCommon.getNameInNamespace(ExceptionCommon.class, "exceptions");
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(ROOT_RESOURCE_BUNDLE_NAME);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ROOT_RESOURCE_BUNDLE = resourceBundle;
    }
}

