/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class AppLoggers {
    public static final String PREFIX_VERBOSITY = "verbosity.";
    public static final String PROPERTY_VERBOSITY_LEVEL = "verbosity.level";
    public static final String DEFAULT_VERBOSITY_LEVEL = "info";
    public static final String PROPERTY_VERBOSITY_FILTER = "verbosity.filter";
    private static final String COMMA_DELIMITERS = ", \t\r\n";

    public static Logger create(String string, IProperties iProperties, Logger logger) {
        StringTokenizer stringTokenizer;
        if (iProperties == null) {
            throw new IllegalArgumentException("null input: properties");
        }
        String string2 = iProperties.getProperty(PROPERTY_VERBOSITY_LEVEL, DEFAULT_VERBOSITY_LEVEL);
        int n = Logger.stringToLevel(string2);
        String string3 = iProperties.getProperty(PROPERTY_VERBOSITY_FILTER);
        HashSet<String> hashSet = null;
        if (string3 != null && (stringTokenizer = new StringTokenizer(string3, COMMA_DELIMITERS)).countTokens() > 0) {
            hashSet = new HashSet<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
        }
        string2 = hashSet;
        return Logger.create(n, null, string, (Set)((Object)string2), logger);
    }

    private AppLoggers() {
    }
}

