; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN eval (V6) (EVAL (quote V6)))

(DEFUN quote (X) (lisp-form NIL X))

(DEFUN lisp-form (V93 V94)
 (COND ((NULL V94) NIL) ((wrapper (element? V94 V93)) V94)
  ((EQ '_ V94) (LIST 'GENSYM "X"))
  ((EQ T V94) T)
  ((wrapper (variable? V94)) (LIST 'QUOTE V94))
  ((wrapper (symbol? V94)) (LIST 'QUOTE V94))
  ((MEMBER V94 '(true false)) (LIST 'QUOTE V94)) ((NUMBERP V94) V94)
  ((CHARACTERP V94) V94) ((STRINGP V94) V94)
  ((AND (CONSP V94) (EQ '/. (CAR V94)) (CONSP (CDR V94))
    (CONSP (CDR (CDR V94))) (NULL (CDR (CDR (CDR V94)))))
   (LET* ((V95 (CDR V94)) (V96 (CAR V95)))
    (LIST 'FUNCTION
     (LIST 'LAMBDA (LIST V96) (lisp-form (CONS V96 V93) (CAR (CDR V95)))))))
  ((AND (CONSP V94) (EQ 'let (CAR V94)) (CONSP (CDR V94))
    (CONSP (CDR (CDR V94))) (CONSP (CDR (CDR (CDR V94))))
    (NULL (CDR (CDR (CDR (CDR V94))))))
   (LET* ((V97 (CDR V94)) (V98 (CAR V97)) (V99 (CDR V97)))
    (LIST 'LET (LIST (LIST V98 (lisp-form V93 (CAR V99))))
     (lisp-form (CONS V98 V93) (CAR (CDR V99))))))
  ((AND (CONSP V94) (EQ 'rule (CAR V94)))
   (LET* ((V100 (CDR V94)))
    (LET ((Intersection (intersection V93 (flatten V100))))
     (bld-assoc Intersection (process-rule 'single Intersection V100)))))
  ((AND (CONSP V94) (EQ 'multi (CAR V94)))
   (LET* ((V101 (CDR V94)))
    (LET ((Intersection (intersection V93 (flatten V101))))
     (bld-assoc Intersection (process-rule 'multi Intersection V101)))))
  ((AND (CONSP V94) (wrapper (macro? (CAR V94)))) V94)
  ((AND (CONSP V94) (CONSP (CDR V94)) (wrapper (element? (CAR V94) V93)))
   (LET* ((V102 (CDR V94)))
    (lisp-form V93 (apcons (LIST 'apply (CAR V94) (CAR V102)) (CDR V102)))))
  ((AND (CONSP V94) (CONSP (CDR V94)) (CONSP (CAR V94)))
   (LET* ((V103 (CDR V94)))
    (lisp-form V93 (apcons (LIST 'apply (CAR V94) (CAR V103)) (CDR V103)))))
  ((AND (CONSP V94) (wrapper (partial-application? (CAR V94) (CDR V94))))
   (lisp-form V93 (partial-application V94)))
  ((CONSP V94)
   (CONS (CAR V94)
    (THE LIST (MAPCAR #'(LAMBDA (Y) (lisp-form V93 Y)) (CDR V94)))))
  ((TUPLE-P V94) (@p (lisp-form V93 (fst V94)) (lisp-form V93 (snd V94))))
  (T V94)))

(DEFUN bld-assoc (V110 V111)
 (COND ((NULL V110) V111)
  (T (CONS 'PROGN (CONS (LIST 'SETQ '*alist* NIL) (ba-help V110 V111))))))

(DEFUN ba-help (V112 V113)
 (COND
  ((CONSP V112)
   (LET* ((V114 (CAR V112)))
    (CONS (LIST 'PUSH (LIST 'CONS (LIST 'QUOTE V114) V114) '*alist*)
     (ba-help (CDR V112) V113))))
  ((NULL V112) (LIST V113)) (T (f_error 'ba-help))))

(DEFUN intersection (V117 V118)
 (COND ((NULL V117) NIL)
  ((CONSP V117)
   (LET* ((V119 (CAR V117)) (V120 (CDR V117)))
    (if (THE SYMBOL (element? V119 V118)) (CONS V119 (intersection V120 V118))
     (intersection V120 V118))))
  (T (implementation_error 'intersection))))

(DEFUN apcons (V69 V70) (COND ((NULL V70) V69) (T (CONS V69 V70))))

(DEFUN macro? (V71)
 (IF (AND (SYMBOLP V71) (MACRO-FUNCTION V71) (NOT (exempted-macro? V71)))
  'true 'false))

(DEFUN opaque (F)
  (SETQ *exempted-macro* (REMOVE F *exempted-macro*)) 
   F)

(DEFUN transparent (F)
  (SETQ *exempted-macro* (CONS F *exempted-macro*)) 
   F)

(DEFUN exempted-macro? (F) (MEMBER F *exempted-macro*))

(SETQ *exempted-macro* '(if and or time freeze do prolog? list))

(DEFUN partial-application? (V72 V73)
 (arity-F-check V72 (arity V72) (LIST-LENGTH V73)))

(DEFUN arity-F-check (V93 V94 V95)
 (COND ((NULL V94) 'false) 
       ((ABSEQUAL V94 V95) 'false)
       ((EQL V94 -1) 'false)
       ((> V95 V94)
        (output "warning: ~A may not like ~A arguments.~%" V93 V95) 'false)
       (T 'true)))

(DEFUN partial-application (V96)
 (COND
  ((CONSP V96)
   (CONS 'FUNCALL (CONS (partial-application (CAR V96)) (CDR V96))))
  ((fbound? V96) (closure V96)) 
  (T V96)))

(DEFUN fbound? (V26) (NOT (EQL (arity V26) -1)))

(DEFUN closure (V28) (LIST 'FUNCTION (nest-lambdas NIL (arity V28) V28)))

(DEFUN nest-lambdas (V29 V30 V31)
 (COND ((EQL 0 V30) (CONS V31 (REVERSE V29)))
  (T
   (LET ((V (gensym "X")))
    (LIST 'LAMBDA (LIST V) (nest-lambdas (CONS V V29) (1- V30) V31))))))

(DEFUN apply (X Y)
  (IF (> (arity X) 1) 
      (FUNCALL (EVAL (closure X)) Y)   
      (FUNCALL X Y)))