/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.mozftl;

import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters2.text.mozftl.MozillaFTLOptionsDialog;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.Log;
import org.omegat.util.NullBufferedWriter;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class MozillaFTLFilter
extends AbstractFilter {
    public static final String OPTION_REMOVE_STRINGS_UNTRANSLATED = "unremoveStringsUntranslated";
    protected Map<String, String> align;
    protected static final Pattern ATTRIBUTES = Pattern.compile(" +\\.([^ ]+) =(.*)");
    private boolean removeStringsUntranslated = false;

    @Override
    public String getFileFormatName() {
        return OStrings.getString("MOZFTL_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.ftl", StandardCharsets.UTF_8.name(), StandardCharsets.UTF_8.name())};
    }

    private String leftTrim(String s) {
        int i;
        int cp;
        for (i = 0; i < s.length() && ((cp = s.codePointAt(i)) == 32 || cp == 9); i += Character.charCount(cp)) {
        }
        return s.substring(i, s.length());
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        this.removeStringsUntranslated = this.processOptions != null && "true".equalsIgnoreCase((String)this.processOptions.get(OPTION_REMOVE_STRINGS_UNTRANSLATED));
        String comments = null;
        int identation = 1;
        String key = null;
        Object k = null;
        String key_attr = "";
        String value = null;
        boolean multiline = false;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        String str = lbpr.readLine();
        while (str != null) {
            String aux;
            String v;
            int nextOffset;
            String trimmed = str.trim();
            if (trimmed.isEmpty()) {
                outfile.write(str);
                outfile.write(lbpr.getLinebreak());
                comments = null;
                str = lbpr.readLine();
                continue;
            }
            int firstCp = trimmed.codePointAt(0);
            if (firstCp == 35) {
                outfile.write(str);
                outfile.write(lbpr.getLinebreak());
                comments = comments == null ? str : comments + "\n" + str;
                str = lbpr.readLine();
                continue;
            }
            boolean translatedSegment = true;
            int equalsPos = str.indexOf(61);
            if (equalsPos == -1 || multiline) {
                multiline = true;
                equalsPos = str.offsetByCodePoints(str.length(), -1);
            } else {
                key = str.substring(0, equalsPos).trim();
            }
            while (str.codePointCount(equalsPos, str.length()) > 1 && str.codePointAt(nextOffset = str.offsetByCodePoints(equalsPos, 1)) == 32) {
                equalsPos = nextOffset;
            }
            int afterEqualsPos = str.offsetByCodePoints(equalsPos, 1);
            if (multiline) {
                v = str;
                int ide = v.length() - this.leftTrim(v).length();
                identation = identation == 1 ? ide : (identation < ide ? identation : ide);
            } else {
                k = k == null ? "" : (String)k + "\n";
                k = (String)k + str.substring(0, afterEqualsPos);
                v = str.substring(afterEqualsPos);
            }
            value = value == null ? v : (aux = value.concat("\n").concat(v));
            if (!multiline) {
                String string = key = Objects.equals(key, key_attr) ? key : key_attr + key;
            }
            if ((str = lbpr.readLine()) != null && !str.isEmpty()) {
                int cp = str.codePointAt(0);
                if (cp == 32 && !ATTRIBUTES.matcher(str).matches()) {
                    multiline = true;
                    continue;
                }
                if (cp == 32) {
                    String string = key_attr = Objects.equals(key_attr, "") ? key : key_attr;
                    if (value.isEmpty()) {
                        value = null;
                        continue;
                    }
                } else {
                    key_attr = "";
                }
            } else {
                key_attr = "";
            }
            if (this.entryAlignCallback != null) {
                this.align.put(key, value);
            } else if (this.entryParseCallback != null) {
                this.entryParseCallback.addEntry(key, value, null, false, comments, null, this, null);
            } else if (this.entryTranslateCallback != null) {
                String trans = this.entryTranslateCallback.getTranslation(key, value, null);
                if (trans == null) {
                    trans = value;
                    translatedSegment = false;
                }
                if (translatedSegment || !this.removeStringsUntranslated) {
                    outfile.write((String)k);
                    outfile.write(trans);
                    outfile.write(lbpr.getLinebreak());
                }
                k = null;
            }
            multiline = false;
            identation = 1;
            value = null;
            comments = null;
        }
        lbpr.close();
    }

    @Override
    protected void alignFile(BufferedReader sourceFile, BufferedReader translatedFile, FilterContext fc) throws Exception {
        HashMap<String, String> source = new HashMap<String, String>();
        HashMap<String, String> translated = new HashMap<String, String>();
        this.align = source;
        this.processFile(sourceFile, new NullBufferedWriter(), fc);
        this.align = translated;
        this.processFile(translatedFile, new NullBufferedWriter(), fc);
        for (Map.Entry en : source.entrySet()) {
            String tr = (String)translated.get(en.getKey());
            if (StringUtil.isEmpty(tr)) continue;
            this.entryAlignCallback.addTranslation((String)en.getKey(), (String)en.getValue(), tr, false, null, this);
        }
    }

    @Override
    public Map<String, String> changeOptions(Window parent, Map<String, String> config) {
        try {
            MozillaFTLOptionsDialog dialog = new MozillaFTLOptionsDialog(parent, config);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions();
            }
            return null;
        }
        catch (Exception e) {
            Log.log(OStrings.getString("MOZFTL_FILTER_EXCEPTION"));
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean hasOptions() {
        return true;
    }
}

