function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (base.limit_backward > c1 || c1 > base.limit)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (0 > c1 || c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "appendix.LanguageToolPlugin.inOmegaT.html",
 "appendix.ScriptingPlugin.inOmegaT.html",
 "appendix.TeamProjects.html",
 "appendix.TokenizerPlugin.inOmegaT.html",
 "appendix.acknowledgements.html",
 "appendix.keyboard.html",
 "appendix.languages.html",
 "appendix.legal.notices.html",
 "appendix.shortcut.custom.html",
 "appendix.website.html",
 "chapter.about.OmegaT.html",
 "chapter.dictionaries.html",
 "chapter.files.and.directories.html",
 "chapter.files.to.translate.html",
 "chapter.glossaries.html",
 "chapter.installing.and.running.html",
 "chapter.instant.start.guide.html",
 "chapter.machine.translate.html",
 "chapter.menu.html",
 "chapter.misc.html",
 "chapter.plain.text.html",
 "chapter.project.properties.html",
 "chapter.regexp.html",
 "chapter.searches.html",
 "chapter.segmentation.html",
 "chapter.spellchecker.html",
 "chapter.translation.editing.html",
 "chapter.translation.memories.html",
 "chapter.user.interface.html",
 "index.html",
 "ix01.html"
];
wh.search_titleList = [
 "Παράρτημα E. Πρόσθετο Εργαλείο γλώσσας",
 "Παράρτημα F. Πρόσθετο για Δημιουργία σεναρίων",
 "Παράρτημα C. Ομαδικά έργα του OmegaT",
 "Παράρτημα D. Πρόσθετο Σύστημα δημιουργίας λεκτικών μονάδων (Tokenizer plugin)",
 "Παράρτημα J. Αναγνώριση συνεισφορών",
 "Παράρτημα B. Συντμεύσεις πληκτρολογίου στο πρόγραμμα επεξεργασίας (editor)",
 "Παράρτημα A. Γλώσσες - Κατάλογος με κωδικούς κατά ISO 639",
 "Παράρτημα I. Νομικές Προειδοποιήσεις",
 "Παράρτημα H. Παραμετροποίηση συντομεύσεων",
 "Παράρτημα G. Το OmegaT στο διαδίτκυο",
 "Σχετικά με το OmegaT - Εισαγωγή",
 "Λεξικά",
 "OmegaT Αρχεία και Κατάλογοι",
 "Αρχεία προς μετάφραση",
 "Γλωσσάρια",
 "Εγκατάσταση και Λειτουργία του OmegaT",
 "Μάθετε να χρησιμοποιείτε το OmegaT σε 5 λεπτά!",
 "Μηχανική Μετάφραση",
 "Μενού και Συντομεύσεις πληκτρολογίου",
 "Διάφορα θέματα",
 "Εγασίες με απλό κείμενο",
 "Ιδιότητες έργου",
 "Κανονικές εκφράσεις",
 "Αναζητήσεις",
 "Κατάτμηση αρχείων προέλευσης",
 "Ορθογραφικός διορθωτής",
 "Συμπεριφορά επεξεργασίας",
 "Μεταφραστικές μνήμες",
 "Η διεπαφή χρήστη",
 "OmegaT 2.9.9 - Εγχειρίδιο χρήστη",
 "Ευρετήριο"
];
wh.search_wordMap= {
"απαιτούν": [28],
"καζακικά": [6],
"οποίος": [10],
"don\'t": [12],
"αναζήτησή": [23],
"συμβουλή": [17,21,[13,28]],
"άλη": [25],
"βασκικά": [6],
"διατήρηση": [[4,10]],
"hall": [7],
"μέρος": [28,[16,24],[9,18,23,25,26,27]],
"σημεία": [[1,10]],
"λειτουργήσει": [15,25],
"μετακίνηση": [5,18,[24,29,30]],
"δουλεύετε": [8],
"would": [23],
"φίλτρου": [[24,27]],
"σημείο": [24,[5,9]],
"επιτύχουν": [17],
"tel": [6],
"οποίοι": [14],
"γαλικιανά": [6],
"info.plist": [15,3],
"anti-alias": [15],
"ελέγχονται": [18],
"διόρθωσης": [25],
"antonio": [7],
"μολδαβικά": [6],
"tex": [13],
"αυτομάτως": [15,[14,20,28],[0,10,16,19,21,23]],
"συμπεριλαμβανομένων": [28],
"letzeburgesch": [6],
"έχοντας": [17],
"διαστήματος": [22,24],
"click": [12],
"fuzzi": [26,[8,27],18,30,[13,16,28]],
"επισήμανσης": [18],
"διατηρεί": [2],
"left": [[3,5]],
"kua": [6],
"κρατούν": [13],
"γεωργιανά": [6],
"σάμι": [6],
"φανταστείτε": [10],
"δύο": [15,[2,24,27,28],[10,19,25],26,[1,13,14,21]],
"kur": [6],
"γράφετε": [13],
"suffici": [12],
"αιτίες": [15,14],
"dgoogle.api.key": [15],
"ces": [6],
"result": [[12,23]],
"same": [12],
"άνω": [[24,28]],
"tgl": [6],
"tgk": [6],
"περιμένατε": [[9,18,27]],
"αγλλικά": [27],
"after": [24,12],
"quiet": [[15,19]],
"κλάση": [[1,22]],
"χρήστη": [15,28,18,30,10,[17,26,29],[9,19,27],[2,7,8,16,21]],
"ακολουθείστε": [[15,27]],
"πρόβλημα": [[14,20],18],
"περιλαμβάνεται": [27],
"δεσμεύθηκε": [15],
"ενιαίο": [2],
"es_es.d": [25],
"δούμε": [24],
"προκύψει": [15],
"νοτ": [6],
"tha": [6],
"χώρας": [27],
"the": [12,3,27,[15,23],13,19],
"λιγώτερες": [[13,19]],
"download.htm": [15],
"διαβαστούν": [15],
"ευρώπης": [30],
"projectimportmenuitem": [8],
"ενιαία": [22],
"χειρός": [21,27],
"imag": [15,12],
"ειναι": [15],
"πρόσβασαη": [19],
"παραδοσιακές": [15],
"ασαφών": [30],
"αμετάφραστων": [18,[8,21]],
"διάφορες": [[18,27,28],[1,10,13,16,29]],
"συνεπώς": [[9,14,15,16,18,19,21,23,26]],
"μπαίνει": [27],
"αντιγράψτετα": [27],
"διανέμουν": [27],
"υποστηρίζει": [27,[1,13],[2,10]],
"σχημάτων": [[1,29]],
"συνεργασία": [2],
"currsegment.getsrctext": [1],
"σανσκριτικά": [6],
"tir": [6],
"cha": [6],
"μετακινούμενοι": [26],
"παραμετροποιήσετε": [[1,18,30]],
"γλίτωσε": [4],
"che": [6],
"εισαγωγής": [13,[2,18,27]],
"χειρίζεται": [[13,23],[14,15,21,24]],
"αγνοεί": [25],
"check": [[3,23,26]],
"transtip": [18,8,28],
"ενιαίου": [2],
"chv": [6],
"chu": [6],
"ταιριάξει": [15],
"καταλόγων": [[21,27],[2,28]],
"άρα": [[15,24,27,28]],
"xxxx9xxxx9xxxxxxxx9xxx99xxxxx9xx9xxxxxxxxxx": [15],
"απαιτεί": [15,[17,18,25,28]],
"λέει": [15,[19,28]],
"ποικιλία": [[10,17]],
"fr-fr": [25],
"ιδιοτήτων": [30,21,[19,29]],
"εμπλέκεται": [[24,27]],
"ensur": [12],
"από-αριστερά-προς-τα-δεξιά": [30,13,29],
"madlon-kay": [7],
"φιλτραρίσματος": [10],
"σκληρού": [27],
"φύλλο": [28],
"αποτελεί": [[1,29]],
"τελειώνει": [[15,19,22,28]],
"εκατομ": [17],
"xmxzzm": [15],
"root": [27,15,[18,28]],
"webster": [11,30,[28,29]],
"συνδεδεμένα": [15],
"αποδεκτές": [8],
"έγκυρα": [24],
"οποίο": [28,[10,15,27],[21,25]],
"προεπιλεγμένους": [24],
"σώμα": [25],
"cjk": [3],
"όμοια": [28,26,10],
"κροατικά": [6],
"έγκυρη": [19],
"blocks": [29],
"ναβάχο": [6],
"ίδιοι": [[14,20,25,26]],
"οποία": [27,[13,17,19],[0,15,18,20,21,23]],
"παραθέτοντας": [22],
"έγκυρο": [[15,24]],
"επίσης": [30,28,27,[15,18],[10,13,25],[0,2,3,8,9,14,19,23,26,29]],
"λειτουργικού": [[1,15]],
"βοηθήματα": [15],
"ίδιος": [[18,20,22]],
"επίπεδο": [24,30,21,2],
"όμοιο": [[2,27]],
"translation": [29],
"μόλις": [[15,16,28],[0,2,8,14,17,19]],
"ίδιου": [2],
"empti": [12,27,15],
"κατάλληλες": [[10,13,20]],
"εδώ": [[2,18],23,[3,10,15,16,21,28]],
"δίκτυο": [2,15],
"ξαναφορτώθηκε": [14],
"τάξεως": [1],
"lepo": [3],
"spolski": [9],
"αναφέρθηκαν": [[15,27]],
"δυτικοευρωπαίκή": [30],
"απαντώνται": [[10,23]],
"επισυνάψετε": [9],
"αργό": [19],
"μπορούν": [27,2,10,[13,15,24,28],[14,22],[1,8,18,19,21,26]],
"lepa": [3],
"μεταγενέστερων": [15],
"περιγραφεί": [24],
"block": [22,[19,24]],
"tms": [27,[23,28]],
"ισλανδικά": [6],
"tmx": [27,30,15,28,[12,18,19],[10,23]],
"flow": [12],
"order": [12],
"μέγιστα": [[13,28]],
"χρώματος": [18],
"διπλές": [22],
"σαφείς": [20],
"απαιτούμενους": [14],
"απαρίθμση": [10],
"nl-en": [27],
"δικό": [[2,15,17,19,27]],
"τουρκμενικά": [6],
"integ": [26],
"intel": [15,[29,30]],
"fr-ca": [24],
"mainmenushortcuts.properti": [8],
"επιτρέποντας": [10],
"αργή": [18],
"αραβικά": [6],
"επιτρέπονται": [26],
"πρόσβασης": [2],
"cmd": [[5,18],[13,16]],
"επιλέξει": [[1,18,26,28]],
"coach": [22],
"συνολικός": [28],
"συγχέεται": [1],
"ίδιιο": [22],
"ινούπιακ": [6],
"καταλόγου": [[2,16],15,[9,18,27,30]],
"πληκτρολογίου": [18,[10,28,29],[5,30],[2,6,8,21]],
"χρήσιμο": [27,[3,7,10,15,18,21,26,28]],
"project_name-level1": [[12,27]],
"gotohistorybackmenuitem": [8],
"project_name-level2": [[12,27]],
"save": [12],
"αδεια": [27],
"χρήσιμη": [[7,10,16,18,21,24,27]],
"widgets": [29],
"project-save.tmx": [27],
"μοτίβων": [24],
"ton": [6],
"top": [12,30],
"have": [12,23],
"powerpc": [15],
"καταστάσεις": [13],
"τρέξετε": [[1,19]],
"συνέπειας": [[10,18]],
"ίσου": [16],
"διαχείρισης": [[13,14,18,29,30]],
"question": [27],
"platform-independ": [12],
"αρίθμηση": [27],
"ακόλουθους": [2],
"προστέθηκαν": [2],
"στιγμιότυποα": [9],
"littl": [12],
"δικού": [2],
"συνθήκες": [27],
"ταταρικά": [6],
"προϋπάρχουσα": [24],
"οομαδικό": [2],
"χρήσιμα": [27],
"οσσετικά": [6],
"πληκτρολογώντας": [15],
"order2": [27],
"order1": [27],
"διεθνές": [14],
"instal": [12,3],
"δυνατόν": [[4,13,17]],
"ανοικτό": [[1,5,18,19,24,28]],
"ίδιες": [[15,27]],
"αντιστοίχως": [27],
"κοινό": [2],
"cos": [6],
"cor": [6],
"μοιράζονται": [27],
"ενότητα": [[15,20],[17,18,21,23]],
"σήματα": [26,28],
"upon": [12],
"κάποιου": [14],
"εις": [[25,28]],
"κάποιος": [[4,20]],
"org.omegat.plugins.tokenizer.lucenecjktoken": [3],
"antialias": [[15,30]],
"ονποματα": [27],
"function": [[1,12]],
"west": [6],
"κάποιον": [11],
"lao": [6],
"εξαγόμενα": [18],
"lat": [6],
"αποδεχθείτε": [15],
"lav": [6],
"άρθρο": [9],
"επιδόσεις": [17],
"προχωρήστε": [[11,21]],
"subscript": [12],
"ανοικτά": [23],
"cpu": [28],
"revert": [12],
"τσουάνα": [6],
"γίνονται": [13],
"υποστηρίζονται": [22],
"αποτελεσμάτων": [23,[22,29]],
"translat": [12,17,30,15,10,[1,25,27]],
"τελικές": [21],
"αλλοιωμένα": [13],
"προβλημάτων": [[17,30],[2,13,15,27,29]],
"μορφοποίηση": [13,[16,18,21],[24,27]],
"πληθυντικού": [[3,14]],
"τρέχουμε": [1],
"φίλτρων": [21,[2,20,28]],
"εντοπίσετε": [[4,26]],
"δική": [15,[4,10,24]],
"ψήφιο": [19],
"ορίγια": [6],
"εναλλακτικά": [[27,30],[2,23]],
"εναλλακτική": [[18,27,28],[2,8,13,15,20,21,26,30]],
"δικά": [[17,27]],
"respons": [17],
"tsn": [6],
"εκτελείτε": [15],
"εμτάφρασης": [17],
"interesar": [17],
"διαδικασίες": [27],
"tso": [6],
"οθόνης": [9],
"ζεύγο": [19],
"δομής": [24,30],
"ακολουθείται": [[22,24]],
"ξέρω": [15],
"cre": [6],
"σημαντικές": [[1,10,16,28]],
"chmod": [12],
"στείλτε": [19],
"ζεύγη": [17,[27,30],[2,19]],
"τροποποίησης": [8,18],
"gnome": [15],
"εκτελέσιμο": [15],
"κοινή": [[27,30]],
"συνέπειες": [2],
"κατάλληλη": [[10,13,25]],
"κοινά": [10],
"τρίστηλο": [28],
"κατάλληλο": [15,[2,25,27]],
"ανακύπτουν": [13],
"κινεζικά": [[6,27]],
"αναθεωρήσει": [27],
"κινεζική": [27],
"αφρικάνς": [6],
"κουμπί": [[15,21],[23,28],[1,24,25]],
"ειδικούς": [[13,21]],
"ttx": [27,30],
"appdata": [12],
"πλοηγηθείτε": [15,27],
"κατάλληλα": [25],
"θέλουμε": [26],
"ξανακάνετε": [28],
"csv": [13,14],
"ενα": [[22,23]],
"επιλύονται": [2,27],
"συμβουλευτείτε": [10],
"tuk": [6],
"υψηλής-ταχύτητας": [17],
"χωρών": [27],
"σλαβονικά": [6],
"tur": [6],
"υποδείξετε": [10],
"κώμμα": [22],
"σλαβονική": [6],
"απρόθυμοι": [[22,29]],
"προσφέρεται": [28,[2,9,10,15,17,24]],
"tuv": [27],
"γρήγορης": [15],
"lep": [3],
"sotho": [6],
"lepš": [3],
"state": [12],
"press": [8],
"dock": [15],
"γνωστή": [24],
"ddhttp.proxyhost": [15],
"μοτίβου": [24],
"ενεργοποιείστε": [17],
"αριθμό": [28,18,[17,27],[1,13,23]],
"γνωστοποιηθούν": [17],
"ενώ": [28,[8,10,27],[5,11,13,14,17,18,23]],
"υποδεικνύεται": [14],
"επισημάνθηκαν": [27],
"dmicrosoft.api.client_secret": [15],
"δημιουργήστε": [[2,19,25]],
"έλειπαν": [4],
"γράψει": [[15,18]],
"ρωμανικά": [6],
"πατήσετε": [23,5],
"suppli": [12],
"χρώματα": [13],
"χρησιμοποιηθεί": [15,27,[10,14,21],[2,8,16,18,19,25,26]],
"κατάσταση": [[18,28],[4,19,20,21]],
"απότέλεσμα": [27],
"σημασία": [[15,19]],
"filenameon": [28],
"αφήνετε": [21],
"ctrl": [18,8,28,5,30,16,13,27,[12,14,17,23,26],[1,11,21]],
"mykhalchuk": [7],
"αναβαθμισθεί": [27],
"document": [12,[4,15,27]],
"twi": [6],
"εκείνο": [10],
"unix-οειδή": [18],
"two": [12],
"ταυτόσημες": [28],
"netrexx": [1],
"διορθωθούν": [[21,27]],
"πάει": [28],
"χρέωση": [15],
"αδειάζει": [18],
"υποφάκελλο": [27],
"graphic": [12],
"creation": [12],
"ενημερώσεις": [15],
"resourc": [[13,15]],
"κλειστό": [18],
"ανοίξετε": [28,21,[2,8,10]],
"briac": [7],
"φορτώθηκαν": [27],
"ολόκληρων": [[17,24,27]],
"επί": [28,[5,17,19]],
"δουλεύει": [16],
"xx_yy": [27],
"ακολουθεί": [27,[8,10,15,19]],
"εκτελούνται": [15],
"docx": [13,[18,21]],
"txt": [20,[13,14]],
"εκείνη": [28,[13,14,15,23]],
"ιδιότητες": [30,18,[21,27],[10,14,15,24,25,28],[8,11,12,19,29]],
"επιθυμείτε": [27,[21,25,28]],
"μάλλον": [[10,14,23,28]],
"τόγκα": [6],
"εκείνα": [15],
"τεκμηρίωση": [7,30,[8,10,22,28,29]],
"thing": [12],
"λατινικά": [6],
"lib": [12],
"μετακινηθείσες": [18],
"αρχική": [13,28,[15,21]],
"ρίζα": [3],
"αρχικά": [[15,17,27,28]],
"επιβραδύνει": [27],
"lin": [6],
"lim": [6],
"lit": [6],
"viewdisplaymodificationinfoselectedradiobuttonmenuitem": [8],
"μνημες": [10],
"omegat.tmx": [[12,27]],
"entir": [12],
"index.html": [[15,28]],
"προσφέρουν": [[2,28]],
"ρηχή": [17],
"doubl": [12],
"ευκολώτερο": [13],
"κάποιων": [[18,21]],
"μαλαισιανά": [6],
"υποηρεσίες": [15],
"doubt": [12],
"παράγραφοι": [13],
"develop": [12],
"σαρδηνιακά": [6],
"breton": [6],
"μαλαγάσυ": [6],
"κάθετος": [15],
"τζόνγκα": [6],
"τοπικών": [2],
"προτασης": [22],
"αρσενικό": [3],
"cym": [6],
"inlin": [[18,21]],
"διάφορυς": [21],
"ασαφούς": [8,26],
"page": [12],
"μετακινείσθε": [[26,28]],
"βαλούν": [6],
"χωρίζονται": [14],
"ημερομ": [14],
"μνήνα": [19],
"ειδκών": [21],
"παρεμπιτπότνως": [23],
"cards": [29],
"τρέχουσα": [18,[4,17,24,26,28]],
"χρηστών": [9,[19,27]],
"κανόνας": [24,[0,30]],
"εργασσθούν": [2],
"ενημερώνονται": [14],
"ελέγχετε": [18],
"μαλδιβιανά": [6],
"οποίες": [[4,24]],
"προτεινόμενη": [28],
"κέτσουα": [6],
"διαβάζονται": [27],
"κεφάλαιιο": [28],
"προτιμάται": [14],
"project.gettranslationinfo": [1],
"υποδείξει": [27],
"δράσει": [11],
"τρία": [[2,11,27],9],
"κλίναμε": [2],
"βίαια": [2],
"συμβαίνει": [9],
"αντιληφθείτε": [25],
"χρειαστείτε": [15],
"πλατφορμών": [15],
"start": [15,30,29],
"μνήμη": [27,28,18,[19,21],[2,10,13,14,15,16,22,24,29,30]],
"καστιλιάνικα": [25],
"αρχικό": [[13,19,27,28],[1,2,15,18,23]],
"smolej": [[7,29]],
"κόσο": [13],
"γρηγορώτερο": [14],
"προ-μετάφραση": [27],
"equal": [27,15],
"συμμορφώνεται": [[24,27]],
"εγκαθίστανται": [15],
"πλαίσιο": [22],
"φάσμα": [[23,25]],
"συνεχόμενα": [10],
"διάδοσης": [30],
"αντικαθίστανται": [18],
"αναγνωρίζει": [[10,27,28]],
"ρίξετε": [15],
"γνωστό": [[1,15,27]],
"optionsalwaysconfirmquitcheckboxmenuitem": [8],
"tmxs": [[8,18,27]],
"οπουδήποτε": [[15,25,27]],
"παίρνει": [27,19],
"κρατήστε": [[21,27]],
"ελληνικά": [6],
"three": [12],
"κόπο": [2],
"ανοίξει": [[2,18],[16,25,28],[1,23,26]],
"αμέσως": [18],
"enter": [18,5,8,[13,15,26,28]],
"επιλέξτετον": [27],
"applic": [12,30],
"bidi": [13],
"projectteamnewmenuitem": [8],
"εφαρμόσατε": [17],
"αρμενικά": [6],
"κιργιζία": [6],
"προσαρμοσμένο": [28],
"παρουσιάζει": [16],
"γκουτζαράτι": [6],
"ακριβή": [23,18],
"κορυφαία": [28],
"εγκατεστημένη": [15],
"preced": [12],
"άκυρο": [15],
"βελτιώσεων": [9],
"κρύβουν": [11],
"πλοήγησης": [15],
"ενεργήσει": [27],
"memori": [12,15],
"ελλάττωση": [28],
"άκυρα": [27],
"γαλλικά": [24,15,[0,6]],
"επανεκκινείστε": [8],
"godfrey": [7],
"avestan": [6],
"log": [3,[9,12]],
"μεμονωμένο": [23],
"kannada": [6],
"παρωχημένη": [13],
"αρχή": [5,15,[14,22,27],2,[0,1,3,4,6,7,8,9,10,11,12,13,16,17,18,19,20,21,23,24,25,26,28,30]],
"λέξη": [23,18,[5,9,15],[10,14,22,24,25,27,28]],
"προύπάρχον": [1],
"μέρει": [17],
"εναλλαγή": [[5,13,18]],
"κακομεταφρασμένα": [21],
"καταστεί": [13],
"ζητά": [[2,18]],
"καταχωρήστε": [9],
"χειρίζεσθε": [21],
"αντιστοίχισης": [28,30,18,8,29,27,13],
"μορφής": [[14,23]],
"θιβετιανά": [6],
"μεμονωμένες": [10],
"ορίστε": [24,13],
"ευρύ": [23],
"περίπου": [[19,28]],
"εξωτερικές": [28,18],
"σύνολο": [28],
"εναι": [11],
"prof": [24],
"camproj": [13],
"dmicrosoft.api.client_id": [15],
"προέρχεται": [8],
"σύνολα": [28],
"διαχωρίστε": [27],
"μορφές": [[13,30],[3,27,29],[14,15,16,17,28]],
"διάφοροι": [26],
"μεταφρασμένο": [16,28,[10,13,19,21,23,29]],
"config-fil": [[15,19]],
"σχεδιάστηκαν": [13],
"γραμμής": [15,22,5,19,[4,24,27]],
"μη-αντιστοιχίσεις": [18],
"checker": [12],
"ρωτήσετε": [27],
"προχωρημένη": [16],
"κόμι": [6],
"dan": [6],
"τροποποιηθεί": [[8,21]],
"επτιρέπει": [18],
"ενημερώσετε": [15],
"ακόλουθη": [22],
"σίντι": [6],
"ενέργεια": [18,5],
"προχωρήσει": [8],
"ακόλουθα": [[2,19]],
"day": [27],
"πρόσθετες": [[14,19,22]],
"προκαλούσαν": [2],
"obtain": [12],
"βρεθεί": [27,[14,18,20,23]],
"εντελώς": [27],
"μεταφράζεται": [[19,28]],
"wolof": [6],
"δικών": [24],
"οποιαδήποτε": [14,15,[7,9,16,19,23,24,27,28]],
"ανορθόγραφης": [25],
"μεταφράσθηκε": [27],
"console.println": [1],
"μιας": [22,[17,21],[18,19,23,25,27]],
"αποδεχθεί": [17],
"ανοίγετε": [28],
"ιδιαιτερότητες": [3,29],
"έναρξη": [19],
"βρείτε": [15,[9,19],[22,28]],
"ίσως": [[9,15]],
"αθώα": [28],
"κλάσης": [1],
"συνεισέφεραν": [4],
"ούτως": [13,[10,23,27]],
"περιβάλλον": [15,19,[2,10],[14,17]],
"αλλαγή": [24,8,[19,21,28],[2,5,13,18,22,23,30]],
"μεταφρασμένα": [28,[13,18,26],[10,16,17,19,23]],
"αφήστε": [[2,15,24,26]],
"επιβεβαιώσετε": [2],
"λιγώτερρο": [4],
"παρακαλώ": [[6,15]],
"μετακινήσετε": [24],
"χωρισμένο-με-tab": [28],
"pars": [[18,24,27]],
"part": [12,[19,27]],
"υποδείξεις": [[25,26]],
"χεριού": [27],
"ερμηνεύονται": [20],
"leender": [7],
"επιτυγχάνεται": [26],
"βιβλιογραφίες": [22],
"browser": [28,30,12,[15,18]],
"κρύψει": [18],
"απαιτείται": [[15,18,22]],
"στυλιστικές": [24],
"κορυφαίο": [1],
"αναπαραγωγή": [9],
"αποθηκευμένα": [15],
"λάβετε": [15],
"αποθηκευμένη": [19],
"αναβαθμισμένη": [27],
"κλικ": [15,28,2,1,25,[9,16,18,24],[5,13,14,21,23,26]],
"τροποποιηθούν": [19],
"ltr": [13,30],
"συνεχή": [27],
"γραμμές": [8,24],
"εγγραφείτε": [9,[2,16]],
"σταθερή": [4],
"μη-ψηφίο": [22],
"optionsexttmxmenuitem": [8],
"ακόλουθο": [[15,17]],
"επιλέξτε": [15,2,[23,25],[16,18,19,26,28],[1,20,27]],
"ltz": [6],
"υπηρεσία": [17,[2,18],15],
"build": [19],
"φροντίσει": [4],
"lub": [6],
"αναζήτηση": [23,16,[18,22,30],[8,10,15,28]],
"tonga": [6],
"marketplac": [15],
"lug": [6],
"μεταφραστικού": [13],
"entries.s": [1],
"εξειδικευμένες": [22],
"addit": [12],
"απόδοσης": [2],
"del": [[26,28]],
"επιλεγμένης": [19],
"gotonextuntranslatedmenuitem": [8],
"subdirectori": [12],
"ένα": [18,[15,27],28,2,14,19,22,[10,16,24],25,[1,17],8,[21,23,26],[3,9,13],[11,20],[0,5,7,12]],
"path": [[15,19]],
"deu": [6],
"record": [12],
"ματιά": [15],
"χρησιμοποίησαν": [21],
"έγινε": [23],
"βεβαιωθείτε": [15,17,[2,13,14,16,25,27]],
"χάσατε": [[19,27]],
"allsegments.tmx": [15],
"στοιχείου": [15],
"κύρια": [30,[27,28],[26,29]],
"λειτυργία": [25],
"πέραν": [[11,13]],
"helpcontentsmenuitem": [8],
"έξω": [5],
"παίρνετε": [27],
"κύριο": [30,28,29,18,[19,24],[1,8,27]],
"μεταφράσεις": [27,10,28,18,[24,26,29],[2,21,22,23,30]],
"μεταφρασθεί": [27,[15,28],[19,24,26]],
"τοποθετώντας": [8],
"προεπιλογής": [[13,18,24,28],[2,20,21,23,27]],
"όπως": [17,28,10,[13,15],[2,7,11,18,19,21,23,27],[14,16,22,24,25]],
"εκκίνηση": [15,19,30,[24,29]],
"προσφορά": [30],
"εργάζεσθε": [[10,27]],
"σενάρια": [1,[15,28]],
"υπογραμμισμένος": [14],
"δεκαεξαδική": [22],
"επιλεγμένες": [[1,25]],
"περιηγητής": [[28,30]],
"αποθηκευμένες": [19],
"διαδραστικά": [22],
"uig": [6],
"εγγραφή": [[15,17]],
"ανεμπόδιστη": [2],
"term": [14,23],
"φορτωθεί": [[15,16]],
"backslash": [15,22],
"ψηλώτερα": [24],
"dotx": [13],
"γραφεί": [20],
"έχει": [15,18,27,[14,28],[2,13,25],[20,24],[5,8,19,21,23,26]],
"προσθέσετε": [15,2,[8,28],[1,9,13,14,16,17,18,19,26,27]],
"δωθεί": [10],
"υπολογιστή": [15,20,[2,29]],
"right": [5],
"ιστότοπος": [9],
"duden": [28],
"σενάριό": [15],
"ιστότοποι": [9,[29,30]],
"λιθουανικά": [6],
"εξυπηρετούν": [27],
"σενάριο": [15,1],
"εαυτοί": [22],
"απποτελεί": [1],
"επισήμασνης": [28],
"σλαβομακεδονικά": [6],
"spotlight": [15],
"μεγέθη": [13],
"τροποποιήσετε": [15,[18,21,27]],
"ρουμανικά": [[0,6]],
"tswana": [6],
"imper": [1],
"reserv": [1],
"πόσες": [4],
"catlik": [3],
"murray": [[4,7]],
"εξαγωγή": [27,14,[18,30],26,[8,13]],
"άλλο": [18,[2,9,17,19,23,28]],
"μορφοποιημένες": [13],
"dir": [15],
"latex": [13],
"σύντομο": [5],
"div": [6],
"άλλη": [15,[1,7,17,19,24]],
"habit": [12],
"later": [12],
"υποστηριζόμενο": [27],
"θέμα": [27,9,21],
"υιοθετηθεί": [24],
"σύντομη": [[2,10,20]],
"συμβουλευθείτε": [22],
"viewfilelistmenuitem": [8],
"υποστηριζόμενη": [13],
"άλλα": [30,28,27,[15,18],29,[2,10,26],[9,11,13,19,23]],
"ukr": [6],
"info": [3],
"πάτε": [[15,25]],
"brows": [15],
"κεντιρκής": [30],
"test": [15,19],
"υποκαταλόγους": [[2,21,27]],
"γραφής": [19],
"τοποθετήστετο": [14],
"omegat": [15,30,[12,27],19,10,29,28,[2,16],[9,13],18,[8,20],26,21,17,[1,23,25],[0,7,14],[3,4,24],[5,11,22]],
"αρχείου": [30,13,[20,21],28,[14,18],23,[16,27],[8,15,17,19,24,29],[5,10,25]],
"αποθηκεύσεις": [18],
"διεξάγετε": [18],
"συστήματός": [[15,18]],
"kanuri": [6],
"εξοικειωθείτε": [28],
"my-project-dir": [19],
"ταξινομημένα": [27],
"πελάτες": [2],
"σχολιασμένες": [8],
"virtual": [1],
"rather": [15],
"τοποοθεσία": [25],
"ακάν": [6],
"μείνουν": [13],
"console-align": [15,19],
"συμβολοσειράς": [23,[26,28]],
"back": [18],
"ms-dos": [15],
"συλλογή": [28,[11,14,22,30]],
"κρίνετε": [17],
"παραγράφους": [10],
"jean-christoph": [[4,7]],
"επικρατήσει": [27],
"λέξης": [5,[3,22,25]],
"δεξιά": [5,[13,28],[15,18,24]],
"πλήκτρων": [8],
"λογαριασμό": [[2,15,28]],
"έσω": [5],
"επεξετάθη": [17],
"εκκινήσετε": [15,[1,19]],
"σημειώσεων": [28],
"κατάλογος": [27,30,[15,29],6,[10,19],[0,1,2,5,11,17,18,24]],
"henri": [7],
"υποκαταλόγου": [27,2],
"προστασίας": [21],
"αποτελούνται": [[24,27]],
"ανάγνωση": [13],
"χαρατκήρας": [22],
"προσέξτε": [[15,19]],
"συμβολοσειρές": [[13,14,27]],
"αποφασίσετε": [21,[26,27]],
"εσπεράντο": [6],
"und": [25],
"project_save.tmx.temporari": [[19,27]],
"από-τα-δεξιά-προς-τα-αριστερά": [30],
"une": [14],
"τοποθετηθεί": [16],
"τοπικού": [2],
"μεταφόρτωσης": [1],
"κατάλογοι": [30,27,12,[2,10,13,18,21,29]],
"πάσα": [[16,19,27,28]],
"πελάτης": [2],
"editoverwritemachinetranslationmenuitem": [8],
"relat": [12],
"αριθμούς": [28,[13,26]],
"ingreek": [22],
"επιλεγμένου": [[18,28]],
"ημερομηνία": [[23,28]],
"γραμαμματοσειρά": [8],
"x_windows_without_jr": [15],
"es_es.aff": [25],
"συστήματα": [15,[18,30],2,[17,19,27,29]],
"ignor": [12],
"πέριξ": [18,30],
"construct": [22],
"υποκαταλόγων": [10],
"βελτιωθεί": [17],
"σύνδεσης": [15],
"pojavnem": [14],
"projectexitmenuitem": [8],
"ομοιογένειας": [10],
"συγκρούσεων": [2],
"κεφαλαία": [18,[8,22,24,28]],
"απαιτήσουν": [13],
"text": [[12,20]],
"διαμάχες": [27],
"κεφαλαίο": [22],
"x_source.zip": [15],
"μεταφόρτωση": [15,30,[2,8]],
"αναζ\'ητηση": [23],
"συστήματος": [[14,15],[2,8,17]],
"block-level": [24],
"manag": [12],
"προ-μεταφράσει": [27],
"μαζί": [15,21,28],
"ταιριάζουν": [[21,27]],
"εισάγατε": [[17,18,28]],
"maco": [[3,15]],
"εναλλακτκή": [26],
"πολλών": [4],
"doc": [[13,28],12],
"τμήματος-στόχου": [26],
"αποθήκευση": [18,8,[2,10,13,15]],
"υπάρχοντα": [[16,17,21]],
"πάρα": [9],
"status": [15],
"server": [2],
"προσέγγιση": [28],
"ενημερώσουν": [2],
"μισά": [[19,21]],
"paramet": [12],
"dot": [12],
"αντιμετωπισθεί": [20],
"κοιτώντας": [23],
"θελήσετε": [27],
"μισή": [14],
"αριθμών": [26,[28,30]],
"mac": [15,5,[3,8],[12,18,29],[2,10,13,16,30]],
"φάκελλο": [27,25,[2,10,15,28]],
"γενικής": [7],
"επισήμαση": [18],
"αναγνώριση": [4,[7,10,29,30]],
"παραχθούν": [24],
"mah": [6],
"αντένδειξη": [14],
"λογική": [20],
"lepša": [3],
"συνδυάζοντγαι": [15],
"mal": [6],
"πάνω": [15,[1,5,18,24,25,28],[0,9,16,17,21,22,26,27]],
"man": [15],
"συνδυασμού": [5],
"αναφέρονται": [[27,28]],
"lepši": [3],
"mar": [6],
"may": [12],
"urd": [6],
"αμπχαζιανά": [6],
"shona": [6],
"συμβουλές": [[25,30],[13,27,29]],
"τσεκαρισμένο": [24],
"url": [2,[15,18,25,28]],
"ξεκινήσετε": [15],
"εικονική": [1],
"αξίζει": [2],
"αντιθέτως": [18,9],
"megabyt": [15],
"προβλέπουν": [20],
"uppercasemenuitem": [8],
"αριθμός": [28,[15,18],[8,13,30]],
"viewmarkuntranslatedsegmentscheckboxmenuitem": [8],
"απαιτούνται": [[15,17]],
"faroes": [6],
"relev": [12],
"quantifiers": [29],
"κουανιάμα": [6],
"www.omegat.org": [9],
"τυχόν": [[4,15]],
"mail": [12],
"προφανείς": [14],
"use": [12,23,3,[15,30]],
"subject": [12],
"πάλι": [27,15,[6,23]],
"έως": [19],
"χωρις": [7],
"main": [12],
"πάντωςμ": [19],
"ονόματά": [28],
"βοήθεια": [[4,18,30],[8,10,16,28]],
"επαναφορτώνει": [28],
"όπου": [27,[2,15,28],8,[3,10,13,14,18,21,24,25,26]],
"omegat.jar": [3,12,[0,1,19,27]],
"παράδειγμα": [27,15,[20,22,25],28,[2,13,19,24],[3,11,14,17,23,29],[1,8,18,30]],
"omegat.app": [3],
"usr": [15],
"ονόματα": [25,26,[3,13,21,28]],
"παράδειγμά": [27],
"logo": [12],
"πατηθούν": [8],
"παρόμοι": [26],
"credit": [18],
"μετατρέψει": [[16,21,26]],
"παραγράφου": [24],
"δημιουργήθηκαν": [27,[10,13,18,28]],
"utf": [20,14],
"σύνδεσμο": [28,9],
"επικυρωτής": [15],
"μπελάς": [13],
"πλήκτρου": [16],
"feed": [22],
"servic": [[2,12]],
"υπολογισμό": [28],
"αναβάθμιση": [30,[15,27],[18,29]],
"διαφόρων": [[10,13,26]],
"οφειλόμενες": [2],
"νεώτερες": [14],
"διάστημα": [[18,22,24],15],
"dsl": [11],
"αποθηκεύσετε": [14],
"επαναφέρετε": [18],
"ανάγκη": [17],
"μερικής": [30,[18,28]],
"χρησιμεύουν": [27,26],
"τοπικοποίηση": [[9,13,30]],
"συμπεριφοράς": [[26,27],[10,29,30]],
"dtd": [13],
"πρόσθετους": [10],
"ασφαλέστερο": [21],
"τελικό": [15,10],
"make": [12,3,19],
"χίντι": [6],
"τροποποιήσεων": [10],
"projectcompilemenuitem": [8],
"δημιουργήθηκε": [1],
"διορθωθεί": [14],
"console-transl": [[15,19]],
"γραμμάτων": [[18,27],[22,23,30]],
"δευτερόλεπτα": [18],
"μεταφράσετε": [10,[9,13,16,26]],
"πόσον": [27],
"τονισμένη": [28],
"σφάλματα": [19,[15,28],[0,4,16,18,27]],
"τρόπο": [19,15,13,28,[18,21,27,30],[1,2,5,10,16]],
"συνοψίζουν": [28],
"τελική": [[4,10,16,17]],
"μπιχάρι": [6],
"αρχείων": [30,28,[13,18],[25,27],23,[8,20],[2,10,15,16,24,26,29],[9,12,14,19,21]],
"optionsviewoptionsmenuitem": [8],
"inform": [12,3],
"depend": [12],
"ίδια": [[2,26],[13,15,27,28],[14,19,20,30]],
"commit": [2],
"εναλλακτικές": [28,18,[2,21,26]],
"μεταφράσεων": [28,30,[17,26]],
"project_stats_match.txt": [[2,12,28]],
"μεταφράσεως": [28],
"tab-separ": [[14,28]],
"dvd": [19],
"δυνατότητα": [[15,18],27],
"quarkxpress": [13],
"μονολεκτική": [14],
"δομημένων": [14],
"πρόσβαση": [28,15,2,[1,10,11,18]],
"meniju": [14],
"αρχέιου": [21],
"one_spac": [18],
"limburg": [6],
"αναβαθμίζονται": [15],
"βαθμολογία": [28],
"εναλλακτικής": [[18,21,28]],
"ανεξαρτήτως": [22],
"διαιρούμενος": [28],
"μερικών": [30,28,27,18],
"μερικώς": [28],
"μήκος": [[15,24]],
"κλείνει": [28,18,27],
"κατεγράφη": [18],
"αποσυμπιεσμένο": [15],
"krunner": [15],
"γλώσσες-στόχος": [10],
"libreoffic": [25,16],
"γαλάζιο": [18],
"συμφραζόμενα": [28],
"ψάξτε": [11],
"παραγράφων": [13],
"into": [12],
"χωρίς": [[1,2,4,15,27],[14,19,28],[16,17,24,26]],
"εξειδικεύστε": [24],
"καλύτερης": [18],
"απόδοση": [18],
"επιβεβαιώνει": [18],
"διευθύνσεων": [2],
"defin": [12],
"κάπως": [[15,27]],
"uzb": [6],
"συνδέοντας": [13],
"παλιούς": [21],
"πρώϊμες": [27],
"σταματήσει": [15],
"περιορίσετε": [23],
"διεύθυνση": [15,[9,30]],
"ίδιο": [27,[15,26],[1,2,11,13,16,18,21,22,28]],
"viewdisplaysegmentsourcecheckboxmenuitem": [8],
"μορφοποιημένου": [[10,13]],
"appear": [[12,15]],
"μπορεί": [27,28,14,[13,15],10,21,[2,16],[8,19,24,26],[0,1,20,25],[17,18,22,23]],
"βοσνιακά": [6],
"progress": [12],
"troubleshooting": [29],
"oper": [[12,15]],
"open": [12,[3,8,13,27]],
"καταγράφονται": [[15,19]],
"www.oracle.com": [15],
"mkd": [6],
"project": [12,[15,19,30],[3,21,29],8],
"προϋποθέσεις": [19],
"xmx1024m": [15,3],
"ινουκτίτουτ": [6],
"ειδοποιήσεις": [15],
"κατατμηθού": [24],
"όριο": [22],
"ενημερωμένες": [10],
"sever": [[12,23]],
"στείλετε": [19],
"μικρό": [[10,25]],
"dzo": [6],
"ορισμένα": [10],
"greedy": [29],
"αντιγράψατε": [27],
"penalty-xxx": [27,30],
"αντίγραφο": [2,27,[19,21]],
"gotonextsegmentmenuitem": [8],
"περιλαμβάνοντας": [[17,28]],
"συνδέονται": [[2,10]],
"εύκολα": [[13,16]],
"προσφέρονται": [[8,18],[3,13,23,24,27,28]],
"παγίδα": [11],
"επικαλύπτεται": [26],
"mlg": [6],
"greedi": [22],
"nnn.nnn.nnn.nnn": [15],
"βοηθά": [27],
"look": [3,[12,27]],
"εύκολη": [[10,28]],
"mlt": [6],
"abort": [19,15],
"μεταφράσεών": [10],
"ταιριάζει": [[14,21,28]],
"δυσανάγνωστους": [23],
"τοπικές": [27],
"internet": [[2,12],28],
"ήδη": [28,[15,18],[1,21],[14,25,26,27],[0,2,8,10,13,19,24]],
"allow": [12],
"μεταφραστικών": [27,30,29,21],
"συνδυασμός": [[5,15]],
"κλικάρετε": [[14,15,18]],
"εργασίες": [[2,28]],
"ορθές": [3],
"proper": [[3,12]],
"ορίσατε": [23,[19,25]],
"σημειώσεις": [28,[18,23],[8,10]],
"questionnair": [12],
"αυτόνομων": [15],
"έντονα": [28,18],
"printf": [18],
"αντίγραφα": [27,19,30,9],
"appli": [3],
"interest": [[12,17]],
"πραγματικότητα": [21],
"δημιουργείτε": [[14,30],[2,13,15,27,29]],
"ορθογραφικά": [25,10],
"ενημερωμένης": [30],
"σταματά": [26,[15,19]],
"πάρετε": [[27,28]],
"προσφέροντας": [28],
"εκκινείστε": [30,15],
"φορτώνετε": [[2,27]],
"διακομιστή": [2,15,[18,30],8],
"middl": [12],
"επλογής": [26],
"επεκτάσεις": [11,[13,14,20]],
"ζουλού": [6],
"αποεπειλέξτε": [21],
"ορθογραφική": [25],
"μετακινηθεί": [5],
"χτίσατε": [28],
"κινεζικών": [18],
"μηχανήματος": [15],
"τυπικό": [27],
"es-mx": [25],
"layout": [28],
"ουζμπεκικά": [6],
"διαθέσιμος": [[2,15]],
"μεμονωμένων": [23],
"μικρά": [[8,18,28]],
"ορθογραφικό": [25,0],
"διάφορους": [10],
"bash": [12],
"μη-λέξης": [22],
"προβολή": [18,19,30,[2,13,28,29]],
"basi": [12],
"mark": [[4,28]],
"stem": [3],
"base": [[14,27]],
"περί": [27],
"συναντήσετε": [27],
"συνεπάγονται": [15],
"σπάνιες": [[21,27]],
"ιδιαίτερο": [15],
"διευκρινισθεί": [19],
"παράμετρο": [15],
"romansh": [6],
"σουαχίλι": [6],
"τιμές": [15,19],
"προκαλέσει": [[21,27]],
"ιδιαίτερη": [1],
"mon": [6],
"τυπικά": [15,6],
"αριθμού": [28,13],
"εηρρεάζουν": [21],
"loss": [12],
"εγγραφεί": [27],
"υπάρχουσα": [[15,27]],
"εισαγόμενα": [27],
"lost": [12],
"volapük": [6],
"περιπέχονται": [15],
"αποφεύγεται": [28],
"work": [12],
"lose": [12],
"ερμηνεύει": [20],
"αλφάβητο": [20],
"ενικός": [3],
"gedit": [14],
"αριθμοί": [28,26],
"τιμής": [28],
"δίνει": [[15,27]],
"εξαχθούν": [24],
"ιδιαίτερα": [19,[13,15,21]],
"word": [[13,23],[12,16]],
"swati": [6],
"εκκινήσει": [15],
"έντονο": [28],
"ομαδικού": [2,[15,29]],
"φορά": [[2,16,27],[10,13,15,17,18,19,24]],
"εξάγετε": [[10,11,26]],
"εργασίας": [15,[27,28],[18,19,23]],
"χρειασθείτε": [22],
"μπουρμέζικα": [6],
"γραμμτοσειράς": [19],
"κάποιες": [[17,21],[10,13,24,28]],
"άλλους": [15,[10,13]],
"μη-λέξη": [22],
"ρωτά": [15],
"οποίων": [10],
"τμημάτων": [28,18,[8,23],10,26,[13,21,27]],
"καταλληλοτητας": [7],
"αυξανόμενο": [17],
"συνολικοί": [30],
"εγκατασταθεί": [15,[0,2]],
"καταγραφεί": [27],
"συνώνυμη": [10],
"συμπεριλάβει": [2],
"κασμιριανά": [6],
"κατακερματίσει": [24],
"βοηθητικών": [27],
"include": [29],
"τιμή": [22,[15,19,27],[17,28]],
"mri": [6],
"vcs": [2],
"chamorro": [6],
"εφαρμοσθούν": [[8,24]],
"απλοποιημένο": [10],
"lingvo": [11],
"εγκατεστημένες": [15],
"κορσικανικά": [6],
"βάζετε": [2],
"mrs": [24],
"ολοένα": [17],
"tortoisegit": [2],
"συνδεθείτε": [[2,9,15]],
"sourceforge": [29],
"μήνυμα": [15,[2,9,19,27]],
"msa": [6],
"οντότητα": [23],
"εξής": [22,8,[20,24],[2,3,10,13,26,27,28],[1,15,16,17,18,19,21,23]],
"αποτελέσματα": [[17,28]],
"ιστοσελίδων": [17],
"σύγχρονα": [6],
"επιμόλυνση": [27],
"float": [26],
"καλύτερες": [24],
"υπηρεσιών": [17],
"pt_pt.aff": [25],
"υποκατάλογοι": [30],
"x_sourc": [15],
"κουτάκι": [[21,24,25,26],[15,27]],
"υπαρχουν": [13],
"html": [15,13,24,[1,12,16,19,27,28]],
"αναβαθμίσει": [21],
"υποκατάλογος": [30,[25,28]],
"εντοπίζεται": [27],
"ενεργοποιήσετε": [[17,18,23]],
"μελλοντική": [[18,27]],
"ven": [6],
"δείκτης": [18,[24,28]],
"καταγραφής": [9],
"spell": [12],
"ενός": [2,[14,15,18,30],24,[10,26,29],[1,17,19,20,22,27]],
"μελλοντικά": [[2,16]],
"συμβουλεύουμε": [24],
"δικές": [[5,22]],
"βοηθήσει": [27,[9,10]],
"ακολουθήστε": [[15,25]],
"omegat.bat": [12],
"απλοποίηση": [28],
"πληροφορίες": [15,28,13,[10,27],[8,18],[20,21],[2,6,11,14,17,19]],
"ρυθμίζετε": [[14,18]],
"artund": [25],
"διαθέσιμες": [[15,28],[8,18,19,27]],
"πολυγλωσσικός": [30],
"υπόλοιπα": [28],
"θέση": [[8,14,18,24],[10,25,27,28]],
"ακπομη": [27],
"ξαναφορτώνει": [18],
"υπόλοιπη": [2],
"σελίδες": [[18,28]],
"πατήστε": [16,[2,14,15],[17,23,27,28]],
"eed": [27],
"εφαρμογές": [15,[10,18,19,25]],
"sawuła": [7],
"jres": [15],
"www.ibm.com": [15],
"τροποποιήσεις": [7,[23,27]],
"αριστερό": [1],
"κάποιαν": [25],
"πετύχετε": [[15,26],[13,24]],
"μερικοί": [[14,27]],
"εξαιρετική": [4],
"platform": [12],
"πρέπει": [15,24,2,8,27,19,25,13,26,[3,9,14,16,18,21],[11,17,22,28],[4,20,29]],
"urdu": [6],
"postfix": [3],
"εισαγωγικό": [4],
"εφαρμογής": [15],
"ντιβέχι": [6],
"αριστερή": [13,28],
"αποθηκεύστε": [[8,13,15]],
"αριστερά": [5,24],
"ληφθεί": [23],
"χρειαστεί": [24,14],
"improv": [15],
"command": [12,[8,18],[2,15]],
"project-specif": [12],
"πάντα": [27,[2,8,14,18]],
"κόστους": [28],
"φιλοξενούμενη": [2],
"αναζήτησης": [23,28,30,29,18,[13,19,22]],
"παρουσία": [[15,23]],
"συγκρούσεις": [2],
"ξεκινά": [[15,19]],
"εισαγωγικά": [14],
"τσεκάρει": [25],
"νέας": [[14,22]],
"ορισμάτων": [[15,30]],
"viewmarkbidicheckboxmenuitem": [8],
"στατιστικών": [28,8],
"year": [[19,27]],
"επικύρωσης": [28,19,18,[15,29]],
"μπισλάμα": [6],
"αρκετό": [19],
"μοτίβα": [24],
"χρησιμοποιούνται": [27,[17,28],[1,10,13,22,25]],
"στοιχείο": [15],
"ανατολικοευρωπαΐκές": [20],
"παρεμβαίνει": [[2,21]],
"κάθε": [[2,16],13,[18,24,27,28],[0,15,17,19,26]],
"περίπτωση": [27,15,28,[2,10],[14,19,20,21],[3,5,13,16,17,26]],
"περιοχές": [28,30,[13,18]],
"μαλτεζικά": [6],
"vie": [6],
"μεθόδους": [23],
"fileshortpath": [28],
"προβάλλεται": [[18,28]],
"double-click": [12,3],
"μοτίβο": [24,22,20],
"subdirectories": [29],
"στοιχεία": [[13,26]],
"instruct": [3],
"χρονοβόρα": [28],
"πάρει": [[18,19,25]],
"αρκετά": [27,[10,17,22]],
"google": [29],
"αρκετή": [27],
"version": [[2,12,15],[27,29]],
"project-dir": [[15,19]],
"συγγραφή": [24],
"ελέγξει": [[27,28]],
"folder": [12,15,30],
"mya": [6],
"αφήσετε": [26],
"de-fr": [27],
"handl": [10],
"ξεχάσατε": [11],
"detail": [12],
"vista": [12],
"λέξεις": [28,23,[3,18,22],[10,13,14,16,17]],
"προ-επεξεργασθείτε": [27],
"εξαρτώνται": [0],
"όρους": [14,7,28],
"υποδείξουμε": [27],
"projecteditmenuitem": [8],
"least": [12],
"λεπτομέρειες": [[17,28],7,[13,15,22]],
"κειμένων": [17],
"βέλτιστης": [26],
"britannica": [30],
"εμπειρία": [21],
"συνέχεια": [25,[10,16,26,27]],
"προηγούμενες": [10,[4,24,28]],
"machin": [1],
"behavior": [12],
"αρμονικά": [27],
"ακρωνυμίου": [24],
"επαναλαμβάνονται": [28],
"μη-ορατή": [[18,21]],
"ανοίγει": [18,[14,27,28],[2,16,17,19,21,26]],
"μικρών-κεφαλαίων": [[22,30]],
"ιδιωτικότητα": [15],
"περιεχομενό": [27],
"αλλαγών": [2,[15,28]],
"iceni": [13],
"συγχωνεύονται": [2],
"οτι": [[4,8]],
"οτε": [15],
"ελεύθερου": [7,29],
"κρατάτε": [28],
"x_mac.zip": [15],
"όρων": [28],
"συμβάσεις": [27],
"προφανώς": [[27,28]],
"ελέγχθηκε": [15],
"περαιτέρω": [[14,24]],
"ρυθμίστε": [19],
"specif": [12],
"ανοίγοντας": [28,15],
"αντιστοίχιση": [28,18,27,8,[3,14,22,24]],
"στάδια": [17],
"διαφορετικό": [27,25],
"κανονικές": [23,[22,30],[15,24],[11,21,29]],
"στάδιο": [13],
"συνδυασμένες": [28],
"αντικατάσταση": [18,8,30],
"αποδέχεται": [28],
"κατατμηθούν": [24],
"φακέλλους": [21],
"μόνον": [[15,18,23],[2,11,13,24,25,26,28]],
"ell": [6],
"need": [12,3],
"ομάδα": [[2,21],[9,24],27,[8,18,19,22,23,28]],
"μεταφρασμένων": [[13,18],[8,30],21],
"βλέπε": [27,18,22,[2,15,17,21],[13,16,28],[0,8,19,23,24,25,26]],
"γλωσσαρίου": [14,30,28,18,[2,8],[3,13,19,29]],
"x0b": [22],
"αποδειχθούν": [10],
"ταξινομηθούν": [28],
"διαφορετικά": [2,13,[5,24,28]],
"κανονικής": [[19,22,29]],
"altern": [12],
"διαφορετική": [28,[13,27]],
"επιλογών": [[18,24,28,29,30]],
"σημείωση": [18,[22,27,28],[8,19],[2,13,14,16,17,23,24]],
"http": [15,1,[3,17]],
"καθίσταται": [13],
"λεπτά": [[2,16,18,19],[7,10,15,27,29]],
"σήμα": [2],
"εικέτες": [28],
"γενική": [[3,21]],
"μορείτε": [15],
"μόνονν": [27],
"καθόλου": [22,[2,15,24,26]],
"τροποποιείται": [[13,15]],
"γενικά": [28,[21,22,24,27]],
"ρωσικά": [15,[6,19,20]],
"χρησιμοπιοείτε": [13],
"ρωσική": [15],
"επεξεργαστή": [1],
"εσωτερικές": [28],
"πελάτη": [[2,27],[10,15,28]],
"εμφανίσει": [[18,27]],
"vol": [6],
"αμετάβλητα": [26],
"τελείωσε": [[2,28]],
"end": [[5,12,23]],
"de-en": [27],
"docbook": [[4,13]],
"ασφαλείς": [20],
"πηγή-στόχος": [11],
"helton": [4],
"eng": [6],
"σλαβική": [6],
"κληρονομούνται": [13],
"οξιτάνικα": [6],
"συμβολοσειρών": [30,13,[23,28]],
"κάποιο": [[25,27,28]],
"διόρθωση": [25],
"σαμοανικά": [6],
"κάποπιου": [27],
"αντικειμενοστραφούς": [1],
"okapi": [30],
"προγραμματιστές": [[9,18]],
"επικυρώστε": [16,29],
"σχεδόν": [[14,20]],
"κάποια": [27,[19,21]],
"ορισάτων": [30],
"αρχικοποίηση": [26],
"γράφονται": [13],
"λίγο": [25],
"προμετάφραση": [30],
"βέντα": [6],
"copyright": [7,18],
"εγκατάστασης": [15,[0,1,25,28,29]],
"moran": [7],
"project_nam": [[12,27]],
"occurr": [23],
"optionstabadvancecheckboxmenuitem": [8],
"ετικέτας": [28,19,[15,30],18,[8,13,29]],
"περιπώσεις": [28],
"specifi": [[3,12],15],
"optionsviewoptionsmenuloginitem": [8],
"μερικά": [[15,16,24,29],[0,11,27,28,30]],
"κειμένου": [13,30,18,20,[10,26],[5,24,28],[14,25,27],[1,22],[2,15,16,19,23,29]],
"μερική": [28,18],
"περάτωση": [10],
"invis": [12],
"συστατικά": [18],
"συμπιεσμένες": [30],
"πολλές": [[13,27],[0,15,19,23,24,28]],
"nav": [6],
"προχωρήσετε": [[10,13,18]],
"nau": [6],
"tar.bz2": [11],
"epo": [6],
"καθαρό": [13],
"υπάρχουσες": [27,[1,18,29,30]],
"νόημα": [[23,24,25]],
"επόμενες": [[2,28]],
"απόλυτο": [27],
"λουγκάντα": [6],
"πολυάριθμους": [9],
"omegat-token": [3],
"σειρά": [[23,24],27,[26,28]],
"x64": [15],
"nbl": [6],
"μερικό": [27],
"αποσαφήνιση": [17],
"μη-τυποποιημένες": [19],
"είχατε": [19],
"κοστους": [28],
"βάλετε": [[16,27]],
"keyev": [8],
"γλώσσας": [25,0,27,[6,24,29,30],[10,15,21],[1,3,11,17,28]],
"βασισμένο": [1],
"λέγεται": [15,16],
"παραμετροποιηθούν": [[10,28]],
"πιθανότατα": [14],
"εξάγει": [18,[16,26,27]],
"οποιοδήποτε": [27,28,[2,5,8,14,22,24]],
"login": [8],
"isn\'t": [22],
"αριχικό": [5],
"interfac": [19],
"κάνετε": [28,[15,25],23,[1,26],[2,5,14,16,18,19,22,24,27]],
"ρύθμιση": [30,28,29,18,[16,21,25],[1,15,23]],
"φτιάξατε": [2],
"share": [27],
"προτιμήσουν": [27],
"μέσων": [19],
"εγκαταταστήσετε": [25],
"ξαναμετατραπούν": [13],
"αποδειχθεί": [[13,24]],
"περικλείονται": [[14,18]],
"optionsteammenuitem": [8],
"gzip": [27],
"σελίδα": [[9,13,15,24,28]],
"πράγματι": [[18,27]],
"ταυτόχρονα": [23],
"nde": [6],
"επόμενης": [5],
"πράγματα": [16,[8,9,18,28,29]],
"μεταφρασμένου": [[13,28]],
"τρίστηλους": [14],
"βασισμένα": [17],
"esc": [28,18],
"x86": [15],
"αναγνωσιμότητας": [18],
"ndo": [6],
"exampl": [3,[12,23]],
"ντέμπελε": [6],
"logic": [23],
"περιλαμβάνει": [15,[0,2,7,17,22,23,27,28]],
"βασισμένη": [[1,10],24],
"εξηγεί": [10],
"nostemscor": [28],
"πέρα": [5,[15,17]],
"δικαιώματα": [2,15],
"πορτογαλικά": [[6,25]],
"σημεώστε": [27],
"προσετέθησαν": [14],
"αποφασίζει": [18],
"νομολογία": [27],
"est": [6],
"σκάσιμο": [2],
"ανάπτυξης": [9,2],
"εξυπηρετεί": [2],
"μικρώτερος": [13],
"console-createpseudotranslatetmx": [15],
"ίσχυε": [28],
"μέλος": [2],
"συνδεθεί": [[2,15]],
"etc": [[12,27]],
"longman": [[11,30]],
"εμπρός": [18],
"nep": [6],
"αγνοηθούν": [15,27],
"fuzzyflag": [28],
"αναθεωρημμένο": [11],
"δυνατή": [[21,27]],
"ετικέτες": [[18,30],13,[16,28],21,27,[15,29]],
"δυνατά": [[1,15]],
"θαυμαστικό": [2],
"merriam": [11,[28,29,30]],
"new": [12],
"escap": [15,22],
"settings": [29],
"παρουσιάζουν": [2],
"συνδεθούν": [13],
"έκαστος": [10],
"καθαρισμό": [26],
"projectname-omegat.tmx": [27],
"καλάλισουτ": [6],
"tool": [12],
"εξειδικευμένο": [10],
"καταντήσει": [28],
"βάση": [[9,28]],
"πληκτρολογείστε": [15,2],
"θυμάται": [18],
"εξειδικευμένη": [28],
"νουόζου": [6],
"therefor": [12],
"boundary": [29],
"eus": [6],
"συνηθισμένες": [21],
"project_sav": [28],
"συνειδητοποιήσετε": [21],
"όροι": [14,[2,17,28]],
"περιήγηση": [24],
"επικαλύπτετε": [28],
"οδηγίες": [15,[10,13,29]],
"βρέθηκαν": [28],
"δομικές": [24],
"όρος": [14,5],
"βιβλίου": [17],
"όρου": [14],
"υλοποιήθηκαν": [1],
"καλύπτουν": [20],
"magento": [13],
"καταλλήλως": [27],
"vxd": [13],
"αδειάσετε": [28],
"μηνύματος": [9],
"βρετανική": [11],
"καλύπτει": [20],
"υπάρχοντες": [24],
"γλυτώνοντάς": [[26,27]],
"λογότυπo": [18],
"boundari": [22],
"ewe": [6],
"στόχο-ορόσημο": [27],
"offlin": [15],
"ελεύθερων": [25],
"martin": [7],
"συνένωση": [21],
"xslt": [1],
"omegat-plugin": [3],
"ανοίγουν": [13],
"προγραμμάτων": [[1,16]],
"εικονίδιό": [2],
"αλλάξτε": [20,[24,25,27]],
"προορισμό": [[18,23,28]],
"maintain": [12],
"τρέχουσας": [5],
"shift": [18,8,[5,13],[14,16],[26,30]],
"μεταβλητές": [[18,28]],
"προσφέρει": [28,[2,15],[10,14,17,21,23,26]],
"παράμτερος": [15],
"ορισμού": [2],
"εγκυκλοπαίδεια": [11],
"wunderlich": [7],
"επιτρέπεται": [26,27],
"java": [15,12,[1,19],[8,30],3,[22,29],[13,18,27]],
"exe": [15],
"προβάλλετε": [15],
"τελειώσετε": [27],
"αποσυμπιέστε": [15,[0,1,3]],
"κατηγορίες": [28,[22,29]],
"project_save.tmx": [27,19,[12,13],[2,18]],
"εξετάστε": [20],
"παραδείγματος": [28],
"sourceforge.net": [3],
"dictionari": [12],
"μεταφραστικής": [27,10,[2,3,16,17,19,21,28]],
"δεσμεύσετε": [15],
"remain": [12],
"μέθοδο": [[15,23]],
"απαιτούμενο": [11],
"αλλάζει": [18],
"δείκτη": [24,18,14],
"βάζοντας": [9],
"μνήμες": [27,10,28,[16,23,30],[15,21,29],[13,17,18,20,24]],
"flash": [13],
"λ.ς": [15],
"συχνές": [15],
"ταυτόσημα": [28,23],
"μογγολικά": [6],
"appl": [18,16,15],
"κακής": [21],
"πλεονέκτημα": [15],
"default": [12],
"σαφές": [27],
"ανατολικής": [30],
"τρόπους": [[13,15,19,21,24,25]],
"καταμήσουν": [13],
"ερευνητικών": [17],
"υποβάλλει": [2],
"εμπιστευτικότητας": [2],
"πράξη": [[4,13,15]],
"διαδικασία": [[10,19,27],[2,24,25,26]],
"αρχής": [5],
"φούλα": [6],
"αποστέλλεται": [17],
"κατατεθέντα": [26,28],
"nld": [6],
"ικανό": [23],
"αρχήν": [9],
"πράγμα": [15,[10,14,27]],
"such": [12],
"πολύ": [10,[24,27],[3,8,9,18,20,22,23,25]],
"τροποποιείστε": [28],
"plugin": [[3,30],[0,2,10,12,18,29]],
"πορέλευσηςη": [27],
"εικονίδιο": [15],
"διαμοιρασμένων": [2],
"οποιονδήποτε": [22,23,[25,27]],
"omegat-l10n-request": [9],
"εικονίδια": [15],
"ζουάνγκ": [6],
"άδεια": [7,[11,15,18]],
"περιγραφή": [[2,4,8,15,27,28]],
"ανακτά": [28],
"διαχειριστή": [25,2],
"x_without_jre.zip": [15],
"άριστη": [4],
"σκοπο": [7],
"editinsertsourcemenuitem": [8],
"κάτω": [28,[2,15,24,27],[1,22,23],[5,11,18,19,25,26]],
"εγγράφου": [[5,13],[1,10,18,28]],
"βρέθηκε": [[14,28]],
"microsoft": [13,[15,30],[10,14,16,28]],
"projectnewmenuitem": [8],
"μονάδων": [[3,30],[0,2,29]],
"optionstranstipsenablemenuitem": [8],
"ποια": [27,[15,18,21,24]],
"αξιόπιστοι": [24],
"σκοπό": [[14,17]],
"segment": [12,18],
"κάτι": [15,[10,19,27]],
"δηλαδή": [17],
"changes.txt": [12],
"δώσουν": [28],
"glossari": [[12,14],16],
"ignored_words.txt": [[2,12]],
"βρίσκατε": [15],
"αναθέσετε": [2],
"ορισθούν": [[19,24]],
"ποιο": [[16,17]],
"συλλέγονται": [27],
"δημιουργήσατε": [16,25],
"νέοι": [14],
"ξαναρχίσετε": [24],
"nno": [6],
"αλλαχθεί": [[13,14,21]],
"εξυπηρέτηση": [28],
"συγχρονισθεί": [15],
"νέου": [30,16,[24,25,27,29],[2,10,18]],
"υπονοούμενη": [7],
"αλλα": [30],
"προβολής": [18],
"γλώσσες": [30,[13,27],[1,24],[17,19,20],[6,29],[0,5,10,14,21,25]],
"nob": [6],
"σύγκρουση": [8],
"προσθέσει": [1],
"σίγουρα": [27],
"string": [3,1],
"ελέγξτε": [17,11,[2,13,23,25,27],[6,19]],
"import": [12],
"μεταφραστικές": [27,10,28,[23,30],[15,16,21,29],[13,17,18,20,24]],
"διάλογος": [30,21,[1,14,16],[2,18,19,26,29]],
"μεταφράζει": [19],
"γλωσσάρια": [14,30,29,[10,16],[11,17,18,28]],
"διαφορά": [28],
"κεκλιμμένες": [14],
"εκκινείτε": [15,27],
"διάλογοι": [30,28,29],
"αγγλκή": [4],
"nor": [6],
"not": [12,[3,15]],
"ιστορικό": [18,8],
"τρεις": [13,[12,16,18,20,27,28]],
"μεταφραστικήγ": [19],
"πια": [25],
"now": [0],
"συνδέσμους": [28,9],
"αλλαγμένες": [21],
"ascii": [13],
"έγκυρος": [17],
"χρησιμεύσει": [[14,27]],
"greek": [22],
"ηλεκτρονικό": [28],
"καταμέτρηση": [28],
"πιο": [15,[2,27],[22,28],19,25,[10,16],[3,6,9,14,17,18,20,21,23,26]],
"βρίσκνται": [14],
"βάλει": [27],
"μόνη": [28],
"selection.txt": [26,18],
"τελεστές": [[22,29]],
"way": [12],
"xhtml": [[13,24,28]],
"ποιότητα": [17,13,[3,27]],
"μόνο": [27,15,23,[2,21,28],[5,14],[1,18,19,26]],
"itoken": [3],
"what": [3],
"παρελθόν": [[10,18,27]],
"μαρσαλιανά": [6],
"ελέγχει": [[15,18]],
"εργαλείου": [[22,29]],
"τμήμα": [18,28,26,27,5,[14,16,23],[8,17],[13,15],[10,19,21,24]],
"εισάγει": [18,28,[17,26]],
"window": [15,12,[2,30],18,[10,11,13,14,19,22]],
"απίθανους": [23],
"επελέγη": [18,15],
"ελέγχου": [2,25,[8,18,22,27]],
"γερμανικό": [23],
"χαμηλώτερη": [27],
"από-δεξιά-προς-τα-αριστερά": [30],
"αβαρικά": [6],
"omegat.pref": [12],
"when": [12],
"πολλαπλά": [15],
"ύπαρξη": [14],
"αφήνει": [26],
"προσθέστε": [15,[2,8,20]],
"διάλειμμα": [25],
"fao": [6],
"txml": [13],
"εργαλείων": [[8,29,30],[18,24,28]],
"περιορισμένη": [14],
"carriage-return": [22],
"faq": [9],
"αρχίσει": [[21,28]],
"πολλοί": [[2,27]],
"fas": [6],
"περίερργη": [20],
"προηγούμενο": [18,[8,27]],
"bartko": [7],
"υπάρχοντος": [18],
"περιγράφει": [10,[5,18,28]],
"εφικτά": [8],
"omegat-script": [1],
"προαπαιτούμενα": [15],
"διαφυγής": [22],
"εφικτή": [[13,27]],
"pt_pt.dic": [25],
"τιγκρίνυα": [6],
"ομοιότητας": [26],
"futur": [12],
"διστάσετε": [19],
"καταφέρω": [4],
"level1": [[16,27],18],
"level2": [[16,27],18],
"δικαιωμάτων": [7,2],
"οκταδική": [22],
"widget": [[28,30]],
"μαλαγιάλαμ": [6],
"αλλά": [27,[15,23],[5,22],[1,2,10,14,19,28],[4,7,13,16,17,18,21,24,25,26]],
"επιτρέπει": [18,26,[1,13,14,15,27],[2,19,22,28]],
"direct": [12],
"flags": [29],
"πρότασης": [30,[10,21,24]],
"τελεί": [7],
"προστεθούν": [14],
"αντικείμενο": [1],
"δίπλα": [[8,25,28]],
"μαζικό": [15],
"συγκεκριμμένες": [28],
"ίντο": [6],
"υπάρει": [14],
"web": [15,9,30,[17,28,29]],
"φορτώσει": [27],
"πληκτρολόγια": [18],
"ευχαριστώ": [4,29],
"γκουαρανί": [6],
"επαρκείς": [24],
"λιγώτερο": [[10,14,15,22,27]],
"berlin": [7],
"σφάλματος": [[9,15,27]],
"ξαναβάζει": [28],
"φωνήεντα": [22],
"ορολογία": [[27,28],23],
"nth": [18],
"editselectfuzzy4menuitem": [8],
"κωδικό": [25,[2,15,18,20]],
"αξιόπιστες": [27],
"γερμανικά": [[0,6]],
"γϊνεται": [23,30],
"πακέτου": [15],
"εγγράψιμο": [14],
"κατεβάστε": [15,[3,11]],
"επαλήθευσης": [14],
"κονσόλας": [19,15,30,29],
"χειρισμός": [30],
"pt_br.dic": [25],
"στρατηγικές": [26],
"βοηθητικές": [[27,28]],
"certain": [[12,27]],
"πρώτα": [2,[14,24],[0,1,9,15,16,22,25]],
"ειδικές": [27,[4,10,24,28]],
"μρπςο-πίσω": [13],
"περιορισμοί": [26],
"μορφοροποιημένων": [13],
"ορίσουν": [22],
"σχετικά": [[10,21,28,29],[6,8,13,15,16,17,18,24]],
"σωστά": [[14,15],[13,20,27],[17,28]],
"σωστή": [[13,14],15],
"λεκτικών": [[3,30],[0,2,29]],
"δοκιμαστή": [22],
"afrikaan": [6],
"προηγούμενου": [[5,18]],
"εντολής": [30,[2,15],[8,17]],
"ευελιξίας": [24],
"φορτώνονται": [27,14],
"κλειδιά": [28],
"περιέχουν": [[23,27],13,26,[10,14,20],[24,28]],
"γλωσσαρίων": [10],
"ορόμο": [6],
"συμπεριφορές-κλειδί": [5],
"φέρουν": [27],
"περιγράψαμε": [15,23],
"σύροντας": [[15,28]],
"που": [15,28,27,18,2,10,23,[14,16],[13,17,19],21,[20,25,26],[1,22,24],8,3,0,[5,9],[4,7,29]],
"πληκτρολόγιο": [[18,23,26]],
"σωστό": [[2,11,17,25]],
"μπενγκαλέζικα": [6],
"προσπελάσετε": [15],
"λεπτομερειακά": [28],
"ανάλογα": [27,[15,28],18,13],
"πρώτο": [18,[4,15,21,23,28]],
"nnnn": [28,15],
"project_save.tmx.yearmmddhhnn.bak": [[19,27]],
"keep": [12],
"effect": [15],
"εγκαταστήσατε": [15],
"παραμετροποιημένες": [18],
"πρώτη": [18,[15,28],[2,8,10,14,27]],
"εγγράφων": [13,18,[27,30],[1,8]],
"εφαρμογών": [[10,13,15]],
"οποιαδήπ": [15],
"option": [3,12],
"συντομέυσεων": [[18,29]],
"ηλεκτρονικώς": [10],
"εφικτό": [21],
"δεδομέν": [2],
"myproject": [27],
"επεξργασία": [[18,29]],
"προβλήματα": [30,14,[11,29],[19,20,27,28]],
"zh_cn.tmx": [27],
"αλλάξει": [[21,24]],
"chuvash": [6],
"δοθούν": [15],
"wordfast": [13],
"αλλάχωρις": [7],
"εξαίρεση": [24,27],
"προηγούμενη": [[8,18,19,27,28]],
"huriaux": [7],
"απλές": [[10,13]],
"wix": [13],
"σχετικό": [27],
"ελπίδα": [7],
"διακρατάται": [13],
"ολοκλήρωση": [24],
"τεχνικές": [17],
"txt2": [20],
"visio": [13],
"εντολές": [15,5],
"nya": [6],
"txt1": [20],
"archiv": [12,15],
"επιλέξατε": [18,[25,26]],
"προκαλέσουν": [28],
"νέες": [8,[14,18,21]],
"user": [12,15,[19,30],[16,23,28,29]],
"κλασική": [1],
"proxi": [15,[8,30]],
"προστίθεται": [15],
"extens": [[1,12]],
"απώλειας": [19,30,[21,29]],
"fij": [6],
"πινάκων": [29],
"κωδικοπίησής": [24],
"ζεύγος": [27,17,28,[2,21,24]],
"fin": [6],
"προτιμώτερη": [21],
"kinyarwanda": [6],
"hausa": [6],
"ελέγξατε": [13],
"ρυθμίσειε": [16],
"προτιμώτερο": [2],
"απάντηση": [17],
"marāṭhī": [6],
"πρότυπα": [[1,13,17,25,27]],
"rang": [22],
"ψάξετε": [23],
"περιοχών": [28,[29,30]],
"aa": [6],
"ab": [6],
"sure": [[3,12]],
"ad": [12],
"ae": [6],
"af": [6],
"πρότυπη": [[1,10,15]],
"αντικαταστήστε": [27],
"ak": [6],
"δυνατότητές": [10],
"diff": [28],
"automat": [12],
"am": [6],
"an": [12,22,6],
"editmultiplealtern": [8],
"προγραμματισμού": [1,[2,18]],
"πρότυπο": [28,14,25],
"απλούστερο": [25],
"συνεργάζεται": [[2,27]],
"ar": [6],
"as": [12,[3,6]],
"at": [12],
"matchers": [29],
"αποθηκεύθηκε": [27],
"av": [6],
"hierarchi": [12],
"ay": [6],
"wln": [6],
"προτείνει": [10,25],
"az": [6],
"ba": [6],
"συμπεριέλαβε": [28],
"be": [12,3,[6,23]],
"αποεπιλέξτε": [[17,21,24]],
"bg": [6],
"bh": [6],
"top-level": [12],
"bi": [6],
"filters.xml": [12,[2,21]],
"διαμοιρασμός": [2,[27,30],29],
"bm": [6],
"bn": [6],
"μέγεθος": [28,[13,19]],
"bo": [6],
"κενες": [26],
"διανέμεται": [7,3],
"δημιουργός": [[2,18]],
"br": [[6,15]],
"bs": [6],
"ρηχής-μεταφοράς": [17],
"search": [23],
"τοποθετούν": [13],
"ανάλυση": [[17,28]],
"εξοικείωση": [[15,19]],
"by": [12],
"περιμένει": [15],
"αντιλαμβάνεται": [10],
"δίνετε": [15],
"θεωρήστε": [4],
"οσσετιανά": [6],
"segmentation.conf": [[12,19],[15,21]],
"panel": [15,1],
"έργων": [12],
"τέλει": [25],
"ca": [[6,15,17]],
"δημιουργήσει": [[15,21],27,[14,19]],
"cd": [15,19],
"ce": [[6,13]],
"öäüqwß": [23],
"fli": [27],
"ch": [6],
"απαγκυρώσετε": [28],
"cn": [15],
"familiar": [23],
"co": [6],
"cr": [6],
"cs": [6],
"cu": [6],
"σύρετε": [28],
"cv": [6],
"τοποικοποίησης": [13],
"cx": [22],
"cy": [6],
"έλεγχος": [25,2,[0,8,15,18,22,29,30]],
"αποδίδει": [24],
"apach": [[2,25]],
"ακόλουθες": [15,28],
"da": [6],
"adjustedscor": [28],
"font": [15,30],
"dd": [[19,27]],
"de": [[6,28]],
"ειδικά": [21,[0,19,24,28]],
"άκυρες": [15],
"κάνουν": [27],
"ειδική": [[13,15,19],5],
"τέτοιες": [13],
"extern": [12],
"f0": [18],
"f1": [18,28,[8,30]],
"do": [12],
"f2": [15],
"f3": [18,[8,30]],
"μεταφράζετε": [[27,28],[13,16,19],[10,24,26]],
"dr": [24],
"χμέρ": [6],
"f5": [[8,18]],
"κύριος": [27,30],
"κύριου": [28,8],
"φράσεων": [16],
"επιλογής": [21,15,[18,24],[25,26],[2,8,14]],
"dv": [6],
"εμφάνιση": [8,[28,29],[23,30],[13,14,15,18,27]],
"μεταφρσαθεί": [15],
"wol": [6],
"κίνδυνο": [27],
"dz": [[6,11]],
"επαναχρησιμοποιηθούν": [27],
"editundomenuitem": [8],
"κανονικών": [22,24],
"εμφάνισή": [28],
"κίτρινο": [[18,28]],
"όρους-κλειδί": [22],
"ee": [6],
"which": [12],
"u000a": [22],
"ειδικό": [23],
"αναθεώρησης": [27],
"τύπου": [16],
"el": [6],
"visualsvn": [2],
"belazar": [17,30,29],
"τύποι": [27],
"en": [[6,15,19,28]],
"eo": [6],
"μπορείτε": [15,28,23,2,[18,25,27],19,[13,16],24,[9,26],[0,1,7,10,21],[5,8,11,14,17,20,22]],
"es": [[6,17]],
"u000d": [22],
"et": [6],
"u000c": [22],
"eu": [6],
"διορθώνει": [[10,17]],
"integr": [12],
"επιλογές": [[28,30],18,[23,26,29],[8,15,17,25],[20,24,27],[0,2,13,19,21,22]],
"παρεμπιπτόντως": [[2,27,28]],
"ορισμός": [[2,28]],
"γραμματοσειρά": [19,18,28,[13,30]],
"first-class": [1],
"παραγόμενο": [19],
"fa": [6],
"κατακερματίζονται": [24],
"inadvert": [12],
"ff": [6],
"stats.txt": [12],
"u001b": [22],
"παραλείψεις": [4],
"fi": [6],
"μέρους": [[4,28]],
"fj": [6],
"for": [12,1,[3,23,27]],
"exclud": [27],
"fo": [6],
"γίντις": [6],
"fr": [15,19,[6,17,24,25]],
"εντοπισμό": [[0,13,18,23]],
"content": [12,15,3],
"διαγράψετε": [27,[14,15,16,26]],
"κουτάκια": [26],
"fy": [6],
"απλούστερος": [15],
"alert": [22],
"applescript": [15],
"πως": [30,[11,13,15],[7,10,14,27,29],[4,16,17,26,28]],
"επαναφέρει": [18],
"ga": [[6,17]],
"επαναφορτωθεί": [27],
"gd": [6],
"πολυάριθμες": [10],
"τυπογραφικά": [10],
"gl": [6],
"editoverwritetranslationmenuitem": [8],
"outputfilenam": [15],
"gn": [6],
"βιβλιοθήκες": [1],
"fijian": [6],
"aeiou": [22],
"gu": [6],
"gv": [6],
"κυρίου": [[18,28]],
"form": [12],
"υπογραμμίζεται": [0],
"αλφαβήτους": [19],
"σειριοποιηθεί": [1],
"ha": [6],
"restor": [12],
"προχωρημέους": [27],
"he": [6],
"γνώμη": [28],
"hh": [[19,27]],
"διαδικτυακή": [23],
"προσθέτει": [[25,28]],
"hi": [6],
"duser.languag": [15],
"ελεγχθεί": [2],
"ho": [6],
"πληθώρας": [27],
"αξίζουν": [2],
"easili": [13],
"hr": [6],
"εμφανισθούν": [[8,15,18,23,24,25]],
"tab-delimit": [14],
"ht": [6],
"hu": [6],
"σομαλέζικα": [6],
"μοναδικών": [28],
"βοηθήσετε": [9],
"εξάγουν": [27],
"hy": [6],
"κενού": [[8,13,22,24]],
"veri": [12],
"συστήνουμε": [2],
"hz": [6],
"fra": [6],
"oci": [6],
"ia": [6],
"context": [28,18],
"διαφορετικούς": [27],
"briel": [[4,7]],
"id": [[6,28]],
"drag": [15],
"ie": [6],
"fri": [6],
"if": [12,3,[1,23]],
"ούτε": [[7,17,27],15],
"project_stats.txt": [28,2],
"french": [3],
"ig": [6],
"ειδικούτς": [13],
"τέλος": [5,22,[8,15,16,24]],
"ocr": [[18,21]],
"μηνυμάτων": [2],
"ii": [6],
"επιστρέψει": [15],
"ik": [6],
"δυνατότητες": [[18,21,27]],
"καταλόγους": [2,[15,27],[14,21]],
"in": [12,3,[1,13,23],18],
"io": [6],
"ip": [15,30],
"termin": [22],
"έργου": [27,18,30,28,2,16,21,29,8,[10,15,19,25],[11,13,14,23],[0,1,12,24]],
"is": [12,[3,6,22,27]],
"it": [12,3,[6,14,23]],
"iu": [6],
"διαθέσιμα": [25,28,[15,18,22]],
"πεδίου": [[10,25,28]],
"odf": [13,24],
"διαθέσιμη": [[2,15],[10,18]],
"ja": [[6,15,27]],
"fsf": [7],
"multiterm": [14,30,29],
"gave": [3],
"jc": [4],
"απαράλλακτα": [26],
"odp": [13],
"γραφείο": [28],
"διαθέσιμο": [15,[8,19,28]],
"odt": [13,[18,21]],
"επιτρέψει": [[2,19]],
"librari": [12],
"κανόνες": [24,30,10,21,[13,15,29],[0,17,22,28]],
"jp": [20],
"επεξεργασία": [18,30,15,27,[8,28,29],[13,16,19,26]],
"js": [1],
"διορθώνονται": [10],
"μη-κενού": [22],
"χαρακτήρα": [22,5,[15,24],[14,23,26]],
"jv": [6],
"εικονιδίων": [15],
"ορθογραφικός": [25,30,10,[0,8,17,18,19,29]],
"learned_words.txt": [[2,12]],
"πηγή": [[18,27,28],30,[15,23],[13,19,26,29]],
"ρήματα": [17],
"προτογαλικά": [15],
"maxym": [7],
"φέρετε": [18],
"ka": [6],
"υπολογισθούν": [28],
"επεξεργασίς": [18],
"συγχωνεύσετε": [27],
"σωστές": [27,[15,16,25,26,28]],
"kg": [6],
"κύριας": [27],
"εσθονικά": [6],
"ki": [6],
"προχωρημένους": [[10,19,22]],
"kj": [6],
"υλικού": [2],
"kk": [6],
"προσθέσουμε": [2],
"kl": [6],
"km": [6],
"uyghur": [6],
"ορίσει": [15,[8,10,17]],
"kn": [6],
"ko": [6],
"νέων": [[8,18]],
"ελλεττωματικού": [27],
"kr": [6],
"ks": [6],
"viewdisplaymodificationinfoallradiobuttonmenuitem": [8],
"ku": [6],
"ποσό": [15],
"kv": [6],
"kw": [6],
"ky": [6],
"ασαφή": [16],
"διότι": [27],
"la": [6],
"lb": [6],
"καναδά": [15],
"lg": [6],
"έναντι": [18],
"ful": [6],
"li": [6],
"dswing.aatext": [15],
"αντιστοιχίζεται": [24],
"αποφύγουμε": [26],
"ln": [6],
"lo": [6],
"αβεστανικά": [6],
"αναθεωρήσεων": [2],
"οποιωνδηποτε": [2],
"ls": [12],
"lt": [6],
"lu": [22,6],
"dist": [15],
"lv": [6],
"while": [12,27],
"ακόλουθοι": [2],
"that": [12,3],
"cycleswitchcasemenuitem": [8],
"ήμουν": [24],
"mb": [15],
"κέρδος": [2],
"επισημαίνει": [[2,28]],
"than": [15],
"mg": [6],
"τροποποιεί": [15],
"καθορίσει": [25],
"mh": [6],
"mi": [6],
"mk": [6],
"τρέχοντος": [28,18,26,[1,23,30]],
"ml": [6],
"mm": [[19,27]],
"entri": [1],
"mn": [6],
"αντίθεση": [17],
"πιστεύετε": [[19,27]],
"διασπασθεί": [24],
"γραμμένες": [28],
"άνοιγμα": [23,18,15,[5,8,10,30]],
"mr": [24,6],
"ms": [[6,24]],
"mt": [17,[6,10]],
"διαβασθεί": [27],
"thai": [6],
"wxl": [13],
"my": [[6,12]],
"διαφέρουν": [15],
"στυλιστικά": [10],
"προσωρινά": [28],
"chosen": [12],
"ορθογραφικών": [25,[29,30]],
"na": [6],
"nb": [6],
"nd": [6],
"ne": [6],
"περιορισμό": [15],
"ng": [6],
"updat": [12],
"ανεξάρτητα": [[18,26,27,28]],
"nl": [[6,27]],
"στόχευε": [17],
"nn": [[6,19,27]],
"no": [[0,6]],
"προσαρτηθεί": [18],
"code": [8,[12,17]],
"nr": [6],
"δυνατές": [[3,10]],
"αντίθετο": [[13,17]],
"πατείστε": [28],
"υποβοήθηση": [29],
"nv": [6],
"ελεγξετε": [24],
"αντίθετα": [28],
"gotohistoryforwardmenuitem": [8],
"κενά": [[10,14,15]],
"ny": [6],
"κενή": [24,30],
"διαφυλάσσεται": [27],
"oc": [[6,17]],
"αργότερα": [[15,16,21],[18,26,27,28]],
"od": [13],
"of": [12,[15,27],[3,13,19,23]],
"πατήματα": [[8,26]],
"διαστήματα": [[18,22],[13,14,19,24,28]],
"possibl": [12],
"oj": [6],
"βλάβη": [14],
"ok": [2,[15,16]],
"om": [6],
"on": [12,3,27],
"σημαντικών": [19],
"τσεκάρατε": [21],
"αλγορίθμων": [8],
"χειρισμού": [18,28],
"or": [12,8,27,[6,18,21,23]],
"ειδικοί": [21],
"os": [15,[3,30],12,29,[2,6,10,13]],
"ot": [13],
"πλειοψηφία": [[2,24]],
"σύγχυση": [[0,27]],
"κενό": [[2,26,27],[14,24,28]],
"οδηγήσει": [[26,28]],
"σάνγκο": [6],
"αντιπροσωπεύει": [24],
"oji": [6],
"περιστάσεις": [23,[21,25,27]],
"pa": [6],
"editinserttranslationmenuitem": [8],
"περιέχεται": [28],
"pc": [15],
"διεξάγονται": [23],
"στιγμή": [17,[2,3,13,16,21,23,27,28]],
"επιπτώσεις": [21],
"υποβιβάζεται": [27],
"pi": [6],
"σλοβενικής": [17],
"διατηρηθούν": [15],
"pl": [6],
"po": [28,13,[27,30]],
"ψευδο-ματαφρασμένη": [27,[29,30]],
"δεδομένα": [[2,17,19,26],[3,14,15,18,27,28]],
"μετονομασθεί": [27],
"ps": [6],
"pt": [[6,15,17]],
"δεδομένη": [24,27],
"ουδέτερο": [3],
"ρυθμίσεων": [[15,19],[25,28,30],[18,21,27,29]],
"επανεκκινηθεί": [8],
"δεδομένο": [27,19,15,[13,17,20,21,28]],
"factori": [12],
"κωδικοποιημένα": [20],
"είνα": [27],
"μεταβλητών": [28],
"necessari": [12],
"στιγμιαίος": [28],
"λόγους": [18,[2,14,27]],
"εγκατάσταση": [15,30,[25,29],3,[0,1,10,17,28],[16,18,19]],
"κατεβάσετε": [[0,1,2,15]],
"σκοπιά": [13],
"λείπουν": [28],
"they": [12,23],
"αντιστοιχίσει": [22,23],
"διευκολύνει": [20],
"qu": [6],
"χώρου": [[8,13]],
"edit": [3],
"varieti": [13],
"editselectfuzzy5menuitem": [8],
"προσπάθεια": [[9,14,26]],
"ορισμένων": [20],
"ταυτόχορνα": [2],
"x_windows_without_jre.ex": [15],
"them": [12],
"επιβεβαιώστε": [15],
"then": [12],
"θυμάστε": [16,[9,29]],
"χρωμάτων": [13],
"διάδοση": [21],
"εξάγεται": [18],
"άρνηση": [22],
"includ": [12,27],
"τουρκικά": [6],
"πόρους": [[9,10,28]],
"privaci": [15],
"ορατά": [9],
"rm": [6],
"εφαρμόζεται": [27],
"rn": [6],
"ro": [6],
"minut": [4],
"ru": [6],
"χερίζεται": [13],
"ακολυθήστε": [13],
"ορφανές": [27],
"rw": [6],
"optionstranstipsexactmatchmenuitem": [8],
"ευρετήριο": [30,4],
"δουλειάς": [21],
"sa": [6],
"sc": [[6,22]],
"sd": [6],
"se": [6],
"sg": [6],
"πτυχή": [16],
"si": [6],
"τροφοδοτούνται": [15],
"sk": [6],
"sl": [[2,6]],
"samuel": [[4,7]],
"sm": [6],
"αντικαταστήσει": [[17,18,27]],
"sn": [6],
"ορίσθηκαν": [[14,15]],
"so": [3,6],
"sq": [6],
"λεποτομέρειες": [13],
"sr": [6],
"ss": [6],
"st": [6],
"su": [6],
"ακύρωση": [15],
"sv": [6],
"sw": [6],
"onc": [12],
"one": [12,[18,19]],
"reinstal": [12],
"καθορίστε": [[15,20]],
"ώρες": [[19,27]],
"επίσημο": [29],
"δουλειές": [[27,28]],
"ta": [6],
"editoverwritesourcemenuitem": [8],
"λέξεων": [28,14,29,[0,3,10,16,18,23,30]],
"εγγενείς": [27],
"te": [6],
"απευθύνεται": [22],
"αρχίσατε": [27],
"εξέλιξη": [28],
"tg": [6],
"υποβολή": [2],
"th": [6],
"μορφολογική": [17],
"saṁskṛta": [6],
"ti": [6],
"ναούρου": [6],
"tk": [6],
"tl": [6],
"tm": [27,[28,30],[2,23],16],
"παρατίθεται": [[8,15]],
"tn": [6],
"to": [12,3,15,19,[23,27],[1,6,8,13]],
"v2": [17,[15,30]],
"tr": [6],
"ts": [6],
"tt": [6],
"συγγραφής": [19],
"αναγνωρίζονται": [[10,16]],
"στήσατε": [2],
"tw": [[6,15]],
"ty": [6],
"αναγνωρίζοντας": [3],
"επεξεργάσιμο": [5],
"hmxp": [13],
"θεωρήσει": [20],
"projectwikiimportmenuitem": [8],
"κοινότητα": [2],
"countri": [15],
"gaelic": [6],
"ug": [6],
"αναίρεση": [18,8],
"εικόνα": [30,[0,23,25]],
"uk": [6],
"yahoo": [[9,12]],
"sinhales": [6],
"disambigu": [17],
"αλφαβητική": [27],
"γίνει": [15,2,[19,24,27],18],
"un": [14],
"έργο": [27,[18,21,28,30],2,19,15,16,14,9,[23,24],[1,10,25,29],[3,8,12,13,17,26]],
"reluctant": [29],
"ur": [6],
"us": [17],
"usual": [12],
"γυρίσει": [15],
"uz": [6],
"μπντέλου": [17],
"μη-διαχωρίσμων": [18],
"έργα": [[2,27],30,[3,5,10,15,16,18,21,29]],
"this": [12,[3,15,22,23]],
"vc": [2],
"εξασφαλίζει": [[2,15]],
"υπάρχουσας": [[14,26]],
"ρυθμίσετε": [18,[10,24]],
"πολλαπλών": [[28,30],29,14],
"κειμένμου": [14],
"μεταξύ": [13,[1,18,26,28,29]],
"ve": [6],
"εναρμονίζοντας": [24],
"vi": [[6,15]],
"extract": [12],
"περιλαμβάνουν": [28,[26,27]],
"αποκλειστικά": [[4,25]],
"διατηρείτε": [2],
"ουκρανικά": [6],
"vo": [6],
"κρατήσετε": [15],
"έκφραση": [[22,23]],
"διαδίτκυο": [[9,30],[1,8,29]],
"vs": [30],
"εφαρμόζονται": [24,0],
"drop": [15],
"διπλού": [15],
"καταχρήσεις": [15],
"προϊόν": [10],
"creationd": [28],
"wa": [6],
"we": [3],
"αγάπης": [4],
"αρχαρίους": [[10,16]],
"omegat.sourceforge.net": [15],
"groovy.codehaus.org": [1],
"wo": [6],
"δημιουργικές": [24],
"υλοποιείται": [17],
"backspac": [5],
"αποστέλλει": [17],
"choic": [12],
"εξαρτηθεί": [13],
"ίδρυμα": [7],
"ζευγών": [17],
"licens": [12],
"emac": [15],
"ori": [6],
"distribut": [12],
"κωδικοσειράς": [1],
"καθώς": [[27,28],[2,3],[10,13,14,15,16,18]],
"orm": [6],
"ουιγουρικά": [6],
"φράσεις": [[10,28]],
"xf": [15],
"xh": [6],
"επινοήσουν": [22],
"xi": [29],
"venda": [6],
"xp": [12],
"εισαγάγετε": [[14,16]],
"βελτιώνουν": [3],
"ενημερώσει": [[2,19]],
"xx": [15],
"xy": [22],
"sourc": [12,27,3,[1,13,15,30],16],
"δεκαδικό": [26],
"type": [[1,8,12]],
"βήμα": [[2,9,28]],
"υπερθετικός": [3],
"στήλες": [14],
"oss": [6],
"volker": [7],
"yi": [6],
"κατάτμησης": [[21,24],30,[3,10,13],[22,28],29],
"συνολικά": [[18,28],[21,30]],
"yo": [6],
"συνολική": [28],
"κλάσεις": [[22,29]],
"περσικά": [6],
"yu": [7],
"burmes": [6],
"τεχνολογία": [15],
"ενεργοποιήστε": [21,30],
"stylesheet": [1],
"μηχανής": [8,[10,17,28]],
"τόσο": [13,[27,28],[10,15,23]],
"είδη": [13,[24,28]],
"τελευταίο": [18,[4,23,27]],
"πάντοτε": [[21,24]],
"εγκαθιστάτε": [30,11,29],
"ενημερωμένο": [[2,13]],
"σύνταξη": [1,[8,24],3],
"χρησιμοποιηθούν": [[2,27]],
"αραγονέζικα": [6],
"za": [6],
"otp": [13],
"κατηγορία": [27],
"κόκκινο": [2],
"δημιουργεί": [18,15,2],
"zh": [6],
"ott": [13],
"σύνταξή": [24],
"exist": [12,23],
"συχνά": [16,[2,10,13,27]],
"δημοσιεύεται": [7],
"περιορίζει": [23],
"penalti": [27],
"εξαίρεσης": [24,30],
"ήταν": [4,[13,27,28]],
"exact": [23],
"zu": [6],
"αντιστοιχούν": [27,28,[2,25]],
"τότε": [15,[23,27],[13,16,17],[10,14,18,19,24]],
"εντοπίζει": [[0,3,27,28]],
"τελευταία": [[15,23,28]],
"μπορούσα": [4],
"zz": [15],
"yiddish": [[6,17]],
"καλύτερο": [[27,28]],
"τόπο": [27],
"μπορούσε": [[4,19,27]],
"utf8": [14,20,13],
"καλύτερη": [17],
"copi": [12],
"out": [27],
"ενημερωμένα": [2],
"συγγραφέα": [23],
"παλιότερη": [19],
"καλύτερα": [[19,27]],
"ορθογραφίας": [25],
"κενές": [[8,24,26]],
"get": [[3,12]],
"statist": [12,30],
"άποψη": [[2,28]],
"packag": [12,3],
"λογιμσικού": [7],
"αντικαθιστά": [18],
"ενημερωμένη": [2],
"ροή": [28],
"επικάλυψη": [15],
"σύγκριση": [28],
"πρόσθετο": [0,1,3,[29,30],27,[2,9,28]],
"στόχο": [[3,13],[16,26]],
"δημόσιας": [7],
"tag-valid": [19,15],
"κόσμου": [20],
"πολωνικά": [[0,6]],
"μονάδες": [[24,27],[10,18]],
"alway": [12],
"απλοποιώντας": [13],
"tokenizer": [29],
"μορφών": [[10,13,17,28]],
"help": [28,30,18],
"μότου": [6],
"πρόσθετα": [[0,1],[3,10,18,23,30]],
"κενής": [26],
"u0009": [22],
"xhh": [22],
"u0007": [22],
"repositori": [2],
"πρόσθετη": [15],
"προσπαθεί": [26],
"έχετε": [15,[14,25],19,[2,28],[13,18,23,27],[9,10,11,16,17,20,21]],
"xho": [6],
"ετικετών": [18,28,13,[8,16],[10,24,27,30]],
"ειδικών": [21,2],
"data": [12,27],
"καταβάσετε": [25],
"γλωσσάρι": [14,28,2,[16,18,29]],
"xht": [13],
"lowercasemenuitem": [8],
"firefox": [25,1],
"lists.sourceforge.net": [9],
"συνεισφέρει": [[13,28]],
"translate": [29],
"μετακινείται": [18,24],
"μνημών": [27,30,29,21],
"αντιγραφή": [[18,28],[2,5,25,29,30]],
"εναλλάσσεται": [13],
"απαλό": [18],
"filepath": [28],
"μορφοποίησής": [27],
"εφόσον": [[0,26]],
"oasi": [13],
"σίγουρος": [24],
"αναφορές": [9],
"συνεχίζει": [[15,19]],
"λέγονται": [16],
"ψευδο-μεταφρασμένη": [27],
"χρόνω": [17],
"nl-zh": [27],
"like": [3,12,27],
"μήνας": [[19,27]],
"αγγλικών": [11],
"κανόνων": [24,21,[10,22,28]],
"ρωσικά-λευκορωσικά": [17],
"χρόνο": [[19,25,28]],
"προγράμματα": [13,[3,15]],
"μεταφράζονται": [10],
"εξωτερικά": [18,[8,13,28]],
"ενδιαφέροντα": [10],
"προβάλλει": [15],
"εξωτερική": [2],
"επεξήγηση": [19],
"openoffic": [25],
"ψευδο-μεταφρασμένης": [27],
"ενεργοποίηση": [[8,17,18,21,25]],
"αλλού": [[25,27]],
"μετονομάσετε": [25],
"αναφοράς": [[10,27],[9,18,23]],
"send": [12],
"here": [12],
"note": [12],
"στίξεως": [24],
"line": [12,22],
"ξαναφορτώσετε": [24],
"link": [12],
"τιμοκατάλογος": [17],
"αποθηκευθούν": [[14,21]],
"μοναδικού": [28],
"helari": [[4,7]],
"δείτε": [30,28,24,[0,7,10,16,23],[5,9,26,27]],
"git": [2,27],
"σλοβενικού": [28],
"μετακύλιση": [5],
"frisian": [6],
"βρίσκεται": [[15,18],28,27,1,[0,3,5,19,21,22,26]],
"κωδικοποιημένο": [[13,20]],
"χρήσης": [7,30,[22,29],[2,4,8,15,17]],
"will": [12,[3,4,23]],
"τροποποιημένο": [18],
"ρυθμίσεις": [15,[19,30],21,18,16,[14,25,27,29]],
"virgul": [14],
"πετυχαίνοντας": [27],
"αντιστοιχίσουν": [22],
"αποτέλεσμά": [24],
"follow": [12,3],
"αποτέλεσμα": [[18,27,28]],
"optionsspellcheckmenuitem": [8],
"περιοχής": [30,28,29,14],
"xlf": [13],
"αποκοπή": [18,[5,28,29]],
"μονάδας": [27],
"optionssetupfilefiltersmenuitem": [8],
"απαντήσεις": [9],
"υφίσταται": [15],
"προχείρου": [18],
"εντολών": [15,19,30,[3,29],[4,10,27]],
"wild": [23,30,29],
"εισαχθεί": [[14,23,24]],
"αυτό": [15,27,28,18,21,[2,10,17,26],25,[13,19,20,22],[3,14,16],[0,1,4,5,9,23,24,29]],
"altgraph": [8],
"ισοδύναμο": [[18,27,28]],
"πληκτρολόγηση": [16],
"δοκιμής": [27],
"ιαπωνικά": [[6,15,19,20,24,27]],
"εκτελέσετε": [15,[16,19,27]],
"your": [12,3],
"τάχιστα": [17],
"άχρηστος": [28],
"μεταφορά": [17],
"without": [12],
"αυτές": [27,[13,15],28,[10,18,23,25,26]],
"these": [12],
"μεγέθους": [[13,19]],
"διορθωτής": [25,[10,30],[0,17,19,29]],
"παλαιοεκκλησιαστικά": [6],
"ιαπωνική": [24],
"αυτήν": [25],
"xml": [13,1,[12,14,17]],
"τρίτη": [[14,28]],
"δοθεί": [[15,19]],
"τσόγκα": [6],
"ασφαλείας": [27,19,30,15],
"gla": [6],
"αυτα": [24],
"περιηγηθείτε": [28],
"αυτά": [27,28,10,[19,26],[2,3,5,12,13,15,24,25]],
"gle": [6],
"καταχωρήσεις": [14,28,[1,8,18,29,30]],
"αυτή": [15,18,27,2,28,[10,26],[13,14,19,20,24],[11,16,17]],
"sometim": [12],
"glg": [6],
"χρήσεις": [2],
"πουεισάγει": [5],
"δίσκου": [27],
"μεγιστοποιεί": [28],
"reluct": [22],
"αρχίζετε": [[10,15,27]],
"σουηδικά": [6],
"βιαστικούς": [10],
"αυτής": [[24,27]],
"εγγραφούν": [2],
"glv": [6],
"ελαχιστοποιημένες": [28],
"επάνω": [15,[2,24]],
"befor": [24,12,27],
"επαναλήψεων": [28,18],
"συμπερίληψη": [28],
"τερματικό": [15],
"επαναφορτώνετε": [27],
"tar.bz": [11],
"xltx": [13],
"ορίσματα": [30,15,[17,19]],
"ιδέα": [28],
"chapter": [12],
"όλοι": [20],
"συντομογραφημένη": [2],
"παίρνοντας": [28],
"χρησιμοποιήσει": [15,[10,17],[14,19,27]],
"μένει": [4],
"εγκρίθηκε": [14],
"υπομενού": [[1,15]],
"δεξί": [2,28,[1,14,15,18,25,26]],
"ορισμένες": [27],
"χειριστεί": [10],
"εξαφανισθούν": [25],
"βρίσκονται": [28,[15,18,27],[2,14]],
"προηγουμένως": [[5,18,27]],
"εμπορευσιμοτητας": [7],
"xlsx": [13],
"ενεργοποιείτε": [18],
"ετικέτα": [[18,28]],
"απεριόριστη": [15],
"όταν": [[18,27],15,28,26,19,[2,13],14,[10,16,21,24],[0,1,5,23],[17,22]],
"gnu": [7,12],
"νομικές": [30,7,[4,8,10,29]],
"έρων": [24],
"επισημαίνοντας": [13],
"target.txt": [26],
"εμπλακείτε": [[14,24]],
"σκοπός": [30,27,[15,19]],
"discuss": [12],
"όσους": [4],
"standard": [12],
"σεναρίου": [30,[1,26]],
"ακολουθούμενοι": [24],
"εφαρμογή": [[13,15],7,[10,14,19,20,25,28,29,30]],
"ακολουθούμενοο": [8],
"ακολουθούμενος": [27],
"wish": [[3,12]],
"επιθέτου": [3],
"σλοβενική": [17,23],
"σλοβενικά": [[3,6,14]],
"απλότητας": [2],
"ακκολοουθούμενη": [24],
"προτιμώμενη": [28,[18,24]],
"pan": [6],
"avert": [12],
"προστίθενται": [15],
"αποδεσμεύει": [28],
"gotonextnotemenuitem": [8],
"υπόδειξη": [13],
"tar.gz": [15],
"εξαγωγής": [26,27],
"gpl": [7,11],
"trados": [29],
"list": [12],
"κοινού": [27],
"ανοιχτό": [23,14],
"λεξικού": [25,28,30,[2,14]],
"συναφή": [9],
"ακριβείς": [[14,18,23,28]],
"in-lin": [27],
"lisa": [14],
"ακόμη": [27,[2,4,15,16,18,21],[13,19,22,29]],
"azur": [15],
"ακόμα": [[14,28]],
"μορφοποίησης": [13,27,28,[16,18,21]],
"χρησιμοποιείται": [28,13,[1,8,18],[2,10,19,21,24]],
"λεπτομερώς": [18],
"rashid": [7],
"παραθύρου": [[18,28],15,[8,24,26]],
"λειτουργικότητα": [2],
"ανοιχτά": [[23,28]],
"determin": [12],
"απαραίτητη": [13],
"navegar": [17],
"καταλαβαίνει": [27],
"πρακτική": [28],
"απαραίτητο": [[13,15],[2,14,25,28]],
"αλλάζετε": [13],
"κλειδί": [[17,23],15,5,[18,28,29]],
"ποιότητας": [27],
"τοποθεσίες": [27,15],
"μετακινήσει": [18,[21,28]],
"grn": [6],
"δημιουργία": [30,[1,18],2,27,[8,13,21,24,29],[0,9,14,16,17,26,28]],
"πλέον": [[15,21,27],28],
"μετατραπούν": [24],
"xtg": [13],
"bindownload.cgi": [15],
"απαραίτητα": [15,[9,11,13,17,28]],
"σφάλαμ": [27],
"προσθέτων": [1],
"μη-διασπάσιμων": [8],
"with": [12,3],
"pdf": [[1,18,21]],
"αναιρεί": [18],
"μετάφρασης": [17,28,18,10,[13,21,23,26,27],[12,16,19,30],[2,15]],
"δεύτερο": [28,[10,27]],
"there": [0],
"αποπακετάρετε": [15],
"δεύτερη": [[8,14,15,27,28]],
"διαχειρίζονται": [2],
"κομμάτια": [[24,28]],
"επιλέγοντας": [[15,20,28]],
"γκρι": [18,16],
"toolsshowstatisticsmatchesmenuitem": [8],
"χωριστό": [18,28],
"μεγάλου": [19],
"viewdisplaymodificationinfononeradiobuttonmenuitem": [8],
"έρχεται": [15],
"ρόλο": [10],
"κεντροευρωπαϊκές": [20],
"e-mail": [9,12],
"πληκτρο": [5],
"προσαρμόστηκε": [3],
"period": [15,26],
"κωδικοσειρά": [3],
"επισημάνετε": [18],
"understand": [12],
"αντιστοιχισμένων": [28],
"ίντερνετ": [[10,28]],
"αμφότερες": [17],
"είτε": [27,26,[7,17,24,28],[2,21,22,25]],
"ισχύει": [28,[2,17,18,19,23,27]],
"gui": [19,15,12],
"guj": [6],
"μεταφραστικκής": [19],
"στοίχιση": [13,[15,19]],
"regexp": [15,19,24],
"ομάδες": [10,[24,27]],
"δείχνουμε": [2],
"στήλη": [14,28],
"stemmer": [3,30],
"uhhhh": [22],
"είχε": [[19,24,27]],
"ουγγρικά": [6],
"πίσω": [18,28,1],
"αποφεύγετε": [[10,24]],
"moldovan": [6],
"ενδιαφέρουν": [16],
"optionssentsegmenuitem": [8],
"συγγραφέως": [28],
"ημέρα": [[19,27]],
"αμετάβλητες": [10],
"γιορούμπα": [6],
"χωριστά": [[2,13,24,27]],
"εντός": [27],
"dokuwiki": [13],
"εξοικειωθούν": [2],
"προτύπων": [[0,13]],
"πλήρεις": [18],
"charact": [23],
"αποσυμπιέσετε": [15,11],
"test.html": [15],
"δημιούργησε": [27],
"συμπεριφέρονται": [[5,19,24]],
"εκτεταμένα": [10],
"xxx": [27],
"ενσωματώνει": [27],
"smalltalk": [1],
"αλγόριθμος": [3],
"εκτεταμένη": [10],
"διαχειρίσιμες": [13],
"ant.apache.org": [15],
"νομίσματος": [22],
"σύρτε": [15],
"αρθρώματα": [15],
"παραμείνουν": [15],
"ψάχνει": [23],
"άλλου": [[2,15,27]],
"βασισμένες": [17],
"προσπαθήσει": [15],
"περιέχονται": [10],
"αντιγράψετε": [25,[15,16,27]],
"όλες": [27,23,[18,19,28],[1,15,17,21],[2,3,4,8,10,13,20,24,25]],
"διαχειριστής": [2],
"ολόκληρο": [[24,27]],
"pseudotranslatetmx": [[15,27]],
"διεργασία": [28],
"whether": [12],
"ομαδικό": [[2,30]],
"άλλοι": [14],
"start-up": [3],
"arno": [7],
"quantifi": [22],
"velasco": [7],
"παρέχονται": [[8,10]],
"ισπανική": [17],
"πληρωμή": [17],
"αρχεια": [27],
"ισπανικά": [25,[6,17]],
"μονάδα": [27],
"παρέχοντας": [28],
"pilpré": [7],
"nuosu": [6],
"υποβιβασθούν": [27],
"έρογυ": [27],
"διαχειριστές": [2],
"κριτήρια": [23],
"συντηρείται": [2],
"ανπεπαρκής": [17],
"γλωσσολογικών": [17],
"εφικτές": [13],
"websit": [12],
"παρέμβαση": [27],
"ομάδας": [2,27,[8,21,24]],
"κοντά": [27],
"συνδυάσετε": [23],
"tο": [25],
"συνεισφορών": [30,[4,9,29],[7,10]],
"υποβιβάζονται": [27],
"χρειάζονται": [[2,15,23,27]],
"χειρονακτικά": [[13,17,18,25,26]],
"θεωρείται": [[13,23,27,28]],
"creationid": [28],
"επεκτείνετε": [24],
"συνοπτική": [11],
"θεωρείτε": [[9,21,27]],
"λέξεις-κλειδί": [23],
"σαs": [15],
"pli": [6],
"αντιστοιχιζόμενο": [28],
"φινλανδικά": [6],
"εκκινητή": [15],
"ορθογραφικής": [25],
"όμοιας": [10],
"βλέπει": [14],
"παρόν": [3],
"βάλτετα": [[0,1]],
"διαφορές": [28],
"τσιτσέβα": [6],
"optionstagvalidationmenuitem": [8],
"φύλλων": [[14,28]],
"αντικειμώνων": [1],
"περισσότερες": [[15,22],[20,28],[7,17,18,21],[6,13,24]],
"ατελούς": [13],
"πρωτότυπα": [1],
"γεμίζει": [27],
"pt_br": [25,15],
"αναγνώρισης": [18],
"βολική": [27],
"σύστημά": [15,25],
"a-z": [22],
"διάθεση": [1],
"zoltan": [7],
"πεδία": [14,[13,15]],
"ασυνέπειες": [4,28],
"πεδίο": [28,[15,26],18,[2,23],[19,25]],
"αγγλικά-καταλανικά": [17],
"onlin": [[17,25]],
"συγκεκριμμένα": [26],
"ιταλικά": [6],
"προεπιλεγμένο": [[18,28]],
"ταυτοχρόνως": [28],
"png": [15],
"αντί": [[8,15,16,18,20]],
"προεπιλεγμένη": [8,20,[28,30],[13,14,18,27,29]],
"γκικούγιου": [6],
"javascript": [1],
"mediawiki": [[18,28],8],
"αντικειμένων": [[1,24]],
"ποινή": [27],
"τμήματα": [27,28,18,24,23,30,10,21,13,[15,26],17,[1,9,16,19]],
"ξεκινάτε": [[19,21]],
"αυτού": [[2,14,16,20,23]],
"walloon": [6],
"αυτπή": [15],
"καμία": [18,14,[13,15,27,28],[5,8,16]],
"γίνεται": [15,30,[18,27],28,[19,29],[10,13,14,26]],
"must": [12],
"join.html": [12],
"διασπά": [[10,24]],
"κάντε": [15,2,[1,9,16,24,28],[14,18,21,25,26]],
"φυλάσσεται": [2],
"org.omegat.plugins.tokenizer.lucenefrenchtoken": [3],
"μεταγενέστερη": [7],
"pod": [13],
"πορσθέστε": [24],
"facto": [28],
"υπέρ": [2],
"υπολογίζονται": [28],
"απενεργοποιήσετε": [18],
"pol": [6],
"μεταγενέστερο": [13],
"σύνθετους": [22],
"αρχείο": [15,27,16,14,18,28,[8,20],13,[11,19,23],[10,29],[0,1,2,3,17,25,30]],
"por": [6],
"σεναρίων": [1,30,[0,9,10,15,19,29]],
"found": [[12,15]],
"επιστρέψετε": [[16,28],[18,23]],
"αντιστοιχηθούν": [8],
"όρισμα": [[15,27]],
"παρουσιάσει": [16],
"χάρη": [18],
"αρχεία": [27,30,13,15,28,[18,20],10,[2,16,19,25],26,21,[11,12,14,23],[3,24],[0,1,8,29],9],
"απαρίθμηση": [10],
"latest": [12],
"πρακτορείο": [[10,28]],
"ποιον": [3,[15,19]],
"πρόοδο": [[2,28]],
"αναφέρει": [[17,26]],
"παράγουν": [27],
"προς": [18,28,24,[5,13,19,26,27],[2,4,8,10,12,14,15,21,29]],
"project_name-omegat.tmx": [27],
"κάνοντας": [28,[1,13,15]],
"εκφράσεις": [23,22,30,[15,24],[11,28,29]],
"σύστημα": [15,2,[3,30],[0,5,14,20,29]],
"googl": [17,[15,30],[10,23]],
"αποθηκεύετε": [25],
"σχήμα": [28,[12,14,25],[0,11,17,21,22,23,26]],
"ομαδικά": [30,2,[3,5,29]],
"εξηγούν": [10],
"συνεδρίας": [21],
"ομαδική": [15],
"εμπλακούν": [27],
"ενώσετε": [9],
"διάκριση": [27],
"χώρο": [1],
"φροντίζει": [2],
"εντάξει": [27],
"δημοφιλή": [[1,2]],
"αντιγράφει": [18,28],
"εκτός": [22,15,5,[2,14,21,23]],
"κανόνα": [24,30,29],
"ισχυρά": [1],
"πολλαπλές": [10],
"οπποία": [25],
"sourceforg": [9,[8,12,30],2],
"εκτέλεσης": [17],
"εγχειρίδιο": [28,[10,18,29],[4,7,8,9,16,30]],
"structur": [12],
"μελλοντικών": [27],
"περικυκλώνουν": [16],
"ότου": [19],
"hat": [6],
"has": [12],
"keyword": [23],
"hau": [6],
"εγχειρίδια": [13],
"time-stamp": [28],
"given": [[12,23]],
"pre": [3],
"σκωτικά": [6],
"last": [27],
"editmultipledefault": [8],
"batch": [[12,15]],
"προορίζονται": [[15,27]],
"παρόμοιο": [[15,22]],
"editfindinprojectmenuitem": [8],
"εμφάνισης": [13,[18,28],[23,27]],
"έλεγχο": [2,[0,25]],
"μηχανή": [17,[1,23]],
"warn": [19,15],
"αμορφοποίητα": [26],
"αναζητήσεων": [17],
"sindhi": [6],
"technetwork": [15],
"γραμματικής": [0],
"μεταφραστή": [[13,27]],
"έξοδο": [[8,15,18,27]],
"βιετναμέζικα": [6],
"βασιζόμενο": [18,[10,15,25]],
"ότνα": [27],
"σχετικές": [[10,18]],
"γλυτώσει": [20],
"εργαλειο": [0],
"ξόζα": [6],
"μελών": [27],
"ιδια": [27],
"άμεσου": [2],
"συσχετιζόμενα": [28],
"miscellanea": [12],
"μάνξ": [6],
"συντομεύσεως": [8],
"αίτιανά": [6],
"παρόμοια": [[2,10,16]],
"δεξιά-προς-τα-αριστερά": [30,13],
"μηχανική": [17,18,30,29,[14,25,28]],
"jacob": [7],
"μηχανικά": [18],
"συντομεύσεων": [8,[18,29,30],[10,15],[5,7,9,28]],
"λάβατε": [28],
"ονομαστούν": [25],
"αποεπιλέξετε": [27],
"παραγωγής": [10],
"υποκατάλογο": [[16,27],2,[15,19],[21,26,28]],
"επεξεργάζεται": [17],
"ποσοτικοποιητές": [22,29],
"τρεχόντως": [28,27,[5,10,13,18,21]],
"διορθωτή": [25,29,[18,30]],
"windows": [29],
"χώρα": [15,27,30],
"interlingu": [6],
"διανομή": [15,7],
"ανάκτηση": [18,8],
"λεξικών": [25,[29,30],[10,11,28]],
"chang": [12],
"νυνόρσκ": [6],
"οδηγό": [[9,15,29]],
"quotation": [29],
"ένωσης": [27],
"καμια": [7,28],
"ορίζετε": [[15,18]],
"heb": [6],
"brune": [7],
"kanji": [20],
"καμιά": [11],
"ανοικτές": [28],
"όλων": [[15,28],[5,8,18,23,30]],
"program": [15],
"ανα": [27],
"αλλαγμένα": [27],
"ανά": [24,21,[27,28],[2,8,13,15,16,17,18,19]],
"pus": [6],
"παλιών": [18],
"keith": [7],
"σωστού": [15],
"her": [6],
"υλοποιημένα": [17],
"χωριστεί": [24],
"τίτλο": [23],
"τσέβα": [6],
"ευθείαν": [15],
"χτίζεται": [[15,30],29],
"πρακτικών": [15],
"ενημερωθούν": [[2,14]],
"πριν": [18,[5,15],[27,28],[2,8,13,14,16,17,19,24,25]],
"βασίζονται": [[3,10,11,17]],
"διορθώσετε": [[23,28]],
"right-click": [3],
"χρησιμοποιήσουν": [2],
"camtasia": [13],
"εστιάζετε": [10],
"αφάρ": [6],
"κατάφεραν": [17],
"μεταγλωττίζονται": [17],
"σινχάλα": [6],
"πατήσατε": [14],
"ντόνγκα": [6],
"κονσοόλας": [30],
"άχρηστες": [21],
"μνλήμες": [27],
"εκπαιδεύσετε": [25],
"έκδοση": [15,2,7,[17,27],19,[4,9,13]],
"doc-license.txt": [12],
"yid": [6],
"copyflowgold": [13],
"παραμέτρων": [4],
"γρήγορα": [[23,28]],
"διάλογο": [18,16,[19,25],[2,14,21,26,27]],
"φροντίδα": [4],
"άλλων": [[4,15,16]],
"κλείσιμο": [18,[8,28]],
"editor": [5,29,[0,1,2,6,10,20,26]],
"pseudotranslatetyp": [[15,27]],
"προτιμώμενο": [1],
"φίλτρο": [[13,21]],
"hhc": [13],
"κατ": [[9,15]],
"χρονική": [23],
"οθόνη": [15,[8,19]],
"αντιγράφονται": [18],
"καν": [7],
"hhk": [13],
"και": [28,15,27,30,[2,18],10,[13,14],17,23,19,[16,25],[1,21,24],29,[20,26],[3,22],[0,4,9],[7,8],11,12,[5,6]],
"προσχέδιο": [4],
"καθ": [2],
"μετονομάστε": [[19,27]],
"φίλτρα": [21,30,20,[18,28],[8,13,16]],
"cycl": [8],
"από": [15,27,28,18,22,24,13,17,2,[1,8,10],30,[5,20,25],[14,26],19,[3,21,23],[7,29],[0,4,11],[9,16]],
"πέντε": [[1,27]],
"ρυθμισεις": [19],
"απο": [[18,19,27]],
"αντιμέτωπος": [20],
"ορφανά": [27,30,[24,28]],
"javaapplicationstub": [[3,15]],
"projectclosemenuitem": [8],
"καταλήξουν": [27],
"όλους": [4,[17,22,29]],
"hin": [6],
"viewmarknonuniquesegmentscheckboxmenuitem": [8],
"αγγλικής": [17],
"χειρισθείτε": [27],
"hit": [[23,27],[21,22,28]],
"αγγλικές": [27],
"λευκορωσικά": [6],
"εσιάγετε": [18],
"προβληθεί": [15],
"titl": [[8,18]],
"proofread": [0],
"διεξαχθεί": [23],
"group": [12,[16,28]],
"πρσφέρει": [25],
"μορφή": [14,13,30,27,[10,11,28],16,[1,2,3,8,15,20,29]],
"tree": [12],
"προσχεδίου": [24],
"readme.txt": [[3,7,12]],
"δημοσίως": [9],
"σύγχρονων": [11],
"languagetool": [[0,29]],
"υπολογιστές": [2],
"αναγνωρίσει": [2],
"αναφορά": [9,[27,30],[10,28,29]],
"source.txt": [26],
"παρόλο": [23],
"files.s": [1],
"siband": [7],
"histori": [18],
"tigrinya": [6],
"exchang": [14],
"output-tag-valid": [15],
"βρετονικά": [6],
"projectlock": [2],
"request": [12,17],
"βραζιλία": [15],
"επφάνεια": [15],
"ανάδραση": [28],
"currseg": [1],
"υπολογιστής": [20],
"their": [27,[0,13,15]],
"generat": [12,19],
"χρησιμοποιήθηκε": [[2,23]],
"προεπιλεγμένοι": [24],
"κουτί": [21,[23,24],2],
"καταστήσει": [21],
"δίγλωσσα": [[27,30]],
"general": [12],
"l4j.ini": [15],
"ασθενή": [1],
"δίγλωσση": [27],
"αλλάξετε": [28,[15,21],[8,13,20,24]],
"δίγλωσσο": [10],
"υποστηριζόμενες": [13],
"process": [[12,19]],
"θυέλετε": [27],
"δίγλωσσω": [17],
"attribut": [[24,28]],
"ορθογραφικού": [25,[18,29],30],
"clear": [23],
"κεν": [2],
"andrzej": [7],
"downloaded_file.tar.gz": [15],
"συγκεκριμμένο": [[15,19,21,25,27]],
"αποτελέσουν": [28],
"προϋπάρχοντος": [1],
"εναλλάσσοντας": [13],
"mean": [23],
"προεπιλεγμένου": [18],
"τσετσενικά": [6],
"υπόλοιπες": [28],
"γινεται": [26],
"νορβηγικά": [6],
"been": [12],
"αποθηκεύουν": [27],
"αντιστοίχησης": [[5,26]],
"dhttp.proxyhost": [15],
"εργαλεία": [30,[18,28],[17,27],[13,22],1,[8,10,24,29]],
"τεκμηρίωσης": [4,8],
"συμμετάσχετε": [9],
"διαθεσιμότητα": [17],
"hmo": [6],
"φυσικά": [25],
"στατιστικές": [[28,30],18,8,[17,29]],
"ενοποίηση": [13],
"μεταφραστικά": [[19,27]],
"αλβανικά": [[6,17]],
"αμφίδρομων": [8],
"αλλαγής": [24,[13,18,30]],
"δεσμίδες": [13],
"εργαλείο": [0,10,[1,17,27,29,30],[3,15,19,28]],
"μεταφραστική": [27,28,18,[2,10,19,21,22,24]],
"ignored_word": [30],
"yor": [6],
"you": [12,[3,27]],
"λογότυπο": [18],
"αποκαταστήσετε": [19],
"στo": [27],
"απλός": [0],
"contient": [14],
"αμετάφραστα": [[18,21,23,27,28]],
"ενδεχόμενες": [2],
"εργοστασιακών": [30],
"τρόπων": [13],
"βρίσκει": [14,[15,18,22,23]],
"ελαχιστοποιεί": [28],
"αποφύγετε": [27,[2,13,19]],
"θεωρούνται": [28],
"unicode": [29],
"αμετάφραστο": [[18,26,28],[8,16]],
"απενεργοποιείτε": [18],
"σουάτι": [6],
"δομική": [17],
"troubl": [12],
"είδατε": [9],
"buloichik": [7],
"προβλέπεται": [15],
"πραγματικό": [28],
"θύρας": [15,30],
"optionsworkflowmenuitem": [8],
"τελεία": [22,24],
"how": [12],
"πραγματική": [[17,18]],
"releas": [[8,15]],
"peter": [7],
"αποφυγή": [2],
"προαιρετικά": [[15,19,27]],
"cordonni": [7],
"sparc": [15],
"λόγο": [[15,25,27]],
"μεταφράστε": [16,[13,29]],
"μετά": [[15,24],2,[5,14,19,21,23,27],[8,13,16,18,22,25,28]],
"μεταφραστών": [[2,9,27]],
"εκτυπώνονται": [19,15],
"τοπική": [2,15],
"προτεραιότητα": [18],
"προορισμού": [18,27,[14,25],[21,23,28],17,15,19,[2,16,20]],
"μετα": [22],
"λόγω": [[2,21,27]],
"ορίσθηκε": [15,28],
"τοπικά": [2],
"διαγράψτε": [[15,21,27,28,30]],
"προέλευσης": [27,28,18,16,[14,26],30,21,[13,17,24],[8,20],23,[3,15],19,[0,1,2,5,10,29]],
"μεταφραστικό": [[10,27]],
"οριετε": [15],
"έκφρασης": [[19,22,29]],
"εγασίες": [20,[26,27,29,30]],
"δωρεάς": [30],
"πατώντας": [28,16,18,[1,13,26]],
"sandra": [7],
"ενόσω": [19],
"δωρεάν": [[10,11,17,25]],
"προαιρετικό": [27],
"υποστηριζόμενων": [[0,28]],
"προορισμπύ": [25],
"αλλαγές": [[15,24],2,[13,27],[14,18,19,21]],
"τρέχει": [[15,20]],
"ενσωματώσετε": [13],
"διαμοιράζονται": [2],
"αναντιστοιχίες": [4],
"προκαλεί": [13],
"εκφράσεων": [22,24],
"rtl-ltr": [5],
"γράμματα": [[18,28],8,[22,27]],
"κάναντα": [6],
"δέσμη": [19],
"αναρωτηθεί": [4],
"βρει": [19,[0,23],[8,10,15]],
"περιβάλλοντος": [2],
"τονίζονται": [28],
"κλπ": [13,[24,27],[14,15,18,21,23],[0,2,3,11,22,28]],
"κάνει": [[2,20,25]],
"επαναφορτώνεται": [[14,19,27]],
"prior": [4],
"σάς": [15],
"ούρντου": [6],
"επικολλά": [18],
"ενφανίζει": [18],
"προβαλλόμενο": [28],
"ψευδο-μετάφραση": [27],
"γράφεται": [3],
"hrv": [6],
"ορίστηκαν": [8],
"take": [12],
"σαφή": [4],
"συνεργατική": [2],
"κανένας": [14],
"επειδή": [[1,23,24]],
"κιργιζιανά": [6],
"συνδέσετε": [15],
"επιστρέφει": [[15,19]],
"προχωρημένοι": [15],
"some": [12,27],
"συντομεύσεις": [18,8,[29,30],10,[15,28],[5,14,21]],
"οδηγός": [10],
"session": [12],
"οδηγήσουν": [27],
"τήρηση": [28],
"vilei": [7],
"διαδίκτυο": [30,[10,17,25]],
"δώσετε": [16],
"tang": [7],
"μεταβάσεις": [27],
"δουλέψει": [25],
"εκδόσεις": [15,27,[4,14,22,25]],
"βασικά": [[13,25]],
"ήμισυ": [24],
"βασική": [15],
"just": [12,[3,23,27]],
"συμβολοσειρά": [23,[14,28]],
"διαμοιράζεσθε": [2],
"πλήρως": [27],
"αντιστοιχίσεως": [19],
"κινυαργουάντα": [6],
"κεφαλαίων": [10,[15,23,29]],
"πρότινος": [24],
"διορθώστε": [28],
"κατεύθυνση": [13],
"αντιστοιχίσεων": [30,28,27,18,[3,29]],
"χρεαστείτε": [16],
"editexportselectionmenuitem": [8],
"λαμβάνετε": [19],
"σασς": [2],
"ουαλικά": [6],
"ανάμεσα": [28,[14,18,27],[19,22,26]],
"επανειλημμένα": [28],
"περίληψης": [28],
"home": [12,[5,15,19]],
"ανάμεσά": [[15,28]],
"michael": [7],
"φρυσικά": [6],
"βασικό": [10,14],
"build.xml": [15],
"εσείς": [10,[18,20,26,27]],
"καθορίσετε": [15],
"hun": [6],
"τρόπςο": [13],
"αντιστοιχίζονται": [[14,18,22]],
"καλούδια": [15],
"λεξικό": [[11,25],[2,10,29]],
"θέματα": [19,[2,6,10,25,29,30]],
"τακτικά": [[19,27]],
"πληκτρολογήστε": [15],
"εμπλέκουν": [18],
"μπασκίρ": [6],
"συμπιεσθούν": [27],
"έχουν": [27,[13,21],[1,14,15,16,18,28],[2,10,20,23,24]],
"x_windows.ex": [15],
"επανάχρηση": [27,30,29],
"μετατροπές": [13],
"διαδοχικές": [18],
"μπροστά": [28],
"προσωπικές": [10],
"aligndir": [[15,19]],
"μπορέσει": [[15,19]],
"επικυρώνετε": [13],
"σαν": [27,[1,15,23,24],[2,13,28],[3,10,17,19,20,26]],
"creat": [12],
"python": [1],
"προτάσεις": [10,28,[4,24,27]],
"θηλυκό": [3],
"λεξικά": [25,30,11,29,28,[10,14,22]],
"es_mx.dic": [25],
"πρακτικώτερος": [15],
"χάσετε": [28],
"abil": [12],
"διπλούν": [28],
"δύναμη": [3],
"μη-άπληστοι": [22,29],
"infix": [13],
"προσαρμογή": [[21,28]],
"τυχερός": [28],
"bell": [22],
"αποτελούν": [9],
"πλεονεκτική": [24],
"μοιάζει": [15,[3,16,28]],
"τίποτε": [22,[5,17],0],
"συνηθέστερες": [9],
"ανάπτυξη": [[15,22,30]],
"ανοικτού": [[0,1,10,17,27]],
"πλατφόρμες": [[10,15]],
"χάριν": [24],
"καλείτε": [28],
"δώσει": [15],
"tarbal": [11],
"λογικοί": [[22,29]],
"hindi": [6],
"σας": [15,16,27,28,2,18,10,25,17,20,[19,24,26],[4,8,21,23],[9,14,29],[1,3,5,13,22]],
"κωδικών": [[6,27,29]],
"απαρχαιωμένος": [28],
"βάλτε": [15,[18,23,27]],
"συγχρόνως": [[1,10,13,15,24]],
"omegat-development-request": [9],
"περιιοχή": [30],
"οποιουσδήποτε": [14],
"ειτκέτας": [27],
"λογαριασμός": [9],
"προτεραιότητας": [24,30,29],
"πρωτεύοντος": [15],
"αυξήσετε": [24],
"συνήθως": [15,[13,19],[1,10,27]],
"file": [12,30,1,[3,15],27],
"μελη": [2],
"member": [12],
"προσβάσιμες": [18],
"παρέχει": [17],
"ενοχλούν": [23],
"λατβιανά": [6],
"αφού": [15,[14,21,28],[2,16,19],[10,24,27]],
"φορτώστε": [[1,13,15]],
"meni": [14],
"πηγαίας": [23],
"within": [12],
"case-insensit": [22],
"σχόλια": [14,[28,30]],
"προέκταση": [14],
"catti": [3],
"menu": [[8,28],[12,14]],
"εφικτός": [27],
"ασσαμέζικα": [6],
"κωδικός": [8,27,[15,25]],
"γλώσσας-χώρας": [24],
"σχόλιο": [14],
"hye": [6],
"ρίναι": [27],
"υποχρεωμένος": [17],
"a-za-z": [22,23],
"κωδικόμ": [27],
"προϊόντων": [13],
"στοίχισης": [[19,30],29],
"return": [[17,18]],
"προχωρημένες": [23,30],
"τροποποιήσατε": [8],
"radio": [[23,28]],
"source-pattern": [[15,19]],
"συνημμένη": [18],
"χαρακτηριστικό": [[11,17,18]],
"παρακάτω": [[8,15],[1,18,28],[2,13,22,25,27]],
"find": [12,3],
"χρειάζεστε": [15,17],
"host": [[2,12]],
"errat": [12],
"απλού": [13,20,[14,30],[2,18]],
"χρησιμοποιήσετε": [15,[3,17,25,28],27,[2,8,14,18,21]],
"κσι": [15],
"chua": [7],
"εγχειριδίου": [[13,28]],
"μη-μοναδικού": [18],
"προηγ": [[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30]],
"παρατηρήσετε": [2],
"προτιμάτε": [7],
"κείμενο": [28,13,18,27,[24,26],20,23,[5,10],[16,17,30],[1,2,3,4,14,21,22,29]],
"βρίσκετε": [[18,19]],
"κείμενα": [[10,18,26],[17,19,20,21,27]],
"προστασία": [7,16],
"πραγματικά": [[2,15,21]],
"ίγκμπο": [6],
"τρέξει": [1],
"χαρακτηριστικά": [10,[1,29]],
"xliff": [13],
"true": [15],
"επικόλληση": [[18,28],[5,29,30]],
"αρχεί": [14],
"ξαναμεταφρασθεί": [27],
"present": [12],
"δεδομένων": [19,[1,14,17,30],[2,10,13,21,29]],
"κλίσεις": [14],
"groovi": [1],
"μακροπρόθεσμα": [20],
"αποθηκευθεί": [[13,21],[19,27]],
"επανάληψη": [18,28],
"στοιχίσει": [15],
"multi-paradigm": [1],
"εντοπίσω": [4],
"πληροφορία": [13],
"αρχίστε": [27],
"επικυρώνεται": [28],
"transform": [1],
"execut": [12],
"ορίσετε": [24,[13,15,19,27],[3,14,28]],
"kmenueditor": [15],
"οτζίμπουε": [6],
"προβάλλονται": [14],
"κοινόχρηστες": [16],
"tortoisesvn": [2],
"συνθέτουν": [12],
"δείχνει": [28,[14,15],[10,11,17,18,20,23]],
"περίληψη": [10,29],
"χτίσετε": [[15,17]],
"τρόποι": [[2,14,15,20]],
"καλός": [3],
"abov": [3,12],
"βασικές": [15],
"διατίθενται": [10],
"μετατροπής": [[13,20,21,26,30]],
"δείγμα": [19],
"επιλογή": [18,[15,30],[8,19],26,[5,28],[24,27]],
"kmenuedit": [15],
"σερβικά": [6],
"επιλεγμένο": [18,27,[1,16]],
"form-fe": [22],
"συγκεκριμμενο": [7],
"ρύθμισης": [[0,2,15]],
"επιλεγμένα": [27,[18,25,28]],
"τρόπου": [28,[4,15,19]],
"τρόπος": [15,30,19,[13,21,23,29]],
"xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx": [15],
"μνήμης": [27,15,10,19,[2,3,16,17,24,28,30]],
"writer": [16],
"προειδοποίηση": [15,[24,28]],
"ελέγχεται": [26],
"επιλεγμένη": [18,28,[8,15,17,27]],
"dalloway": [24],
"rubi": [1],
"παράθυρο": [28,30,18,29,23,2,[15,19,25],[21,27],[1,13,17]],
"χρειάζεσθε": [27,19],
"dzongkha": [6],
"ρητές": [4],
"ορολογίας": [14,10,[28,30]],
"προσωπικό": [15],
"διαδρομή": [28,15],
"cover": [12],
"reflect": [12],
"αναφοά": [10],
"πάρτε": [[15,19]],
"πιθανότερη": [28],
"σφάλμα": [[9,15,21,27,28]],
"επαναλήψεις": [28,10],
"ομάδος": [10],
"immedi": [3],
"κορεατικά": [6],
"βοηθητική": [27],
"ωραία": [22],
"βοηθητικά": [13],
"μαορί": [6],
"αναζητάτε": [19],
"therebi": [15],
"καλές": [17],
"βγαίνει": [18],
"μεξικανικά": [25],
"ατιήματα": [9],
"αμηχανία": [4],
"αν": [15,18,27,28,19,25,23,[14,17,21],[16,24,26],13,[1,2,5,8,10,11,20],[0,7,9,22],3],
"locmanag": [13],
"αρ": [14],
"ας": [[3,27]],
"regex": [22,29,30],
"meta": [8],
"keystrok": [8],
"declar": [1],
"πίνακας": [18,22,8,28,10,[5,6,13,29]],
"αποκλίνοντα": [17],
"τρίτης": [28],
"ευκαιρία": [23],
"παράθυρα": [30,28,29,23,[18,19]],
"σφαλμάτων": [9,30,[0,13,19,29]],
"βασισμένου": [26],
"ευαίσθητος": [28],
"πλαιότερης": [10],
"εκεί": [18,[15,28],[21,26]],
"προκαθορισμένες": [[22,29]],
"υποψήφιες": [27],
"διατηρούν": [13],
"μέση": [22],
"άμεση": [[13,19]],
"πλευράς": [2],
"διαχωρισμό": [21],
"άμεσα": [15,24],
"βλέπετε": [1],
"σαφώς": [[17,19]],
"εισάγετε": [[15,18,26],[2,21,28],[14,22]],
"διαγράψει": [25],
"ευχαριστίες": [4],
"unless": [12],
"εκδόσεών": [17],
"γραμμένη": [24],
"χρώμα": [18,[13,28],[0,16]],
"μέσω": [[2,9],[26,28],[8,15,18]],
"κατακερματίζει": [24],
"free": [15],
"χρησιμοποιούν": [18,[3,8,15,17,25]],
"γραμμένο": [20],
"οικονομική": [[9,30]],
"παρέμβει": [15],
"σλοβακικά": [6],
"ανγνωρισθούν": [14],
"ενεργοί": [24],
"κουρδικά": [6],
"συμπιεσμένου": [23],
"εντολή": [15,18,28,3],
"δεκτή": [27],
"μετακινούν": [5],
"αναβαθμίσετε": [[15,27]],
"επόμενου": [18],
"ibm": [15],
"fish": [3],
"ibo": [6],
"πρώτης": [1],
"ιστότοπο": [2,[16,17]],
"επαναφόρτωση": [[8,18]],
"παρά": [27,[24,25]],
"λινγκάλα": [6],
"συμβατό": [1],
"λάο": [6],
"δομή": [27,24],
"δημιουργούν": [27],
"αντίστροφο": [21],
"επιρροή": [13],
"μετακινεί": [18],
"μέρη": [28],
"αντίστροφη": [15],
"απαιτητική": [28],
"υποβάλετε": [9],
"ενεργοποιήσατε": [28],
"γαελικά": [6],
"jean": [7],
"διορθώσουν": [9],
"χέρι": [16],
"ικανοποιητικές": [17],
"ευρέως": [2],
"ενημέρωση": [2,[10,14,15]],
"συμβατά": [24],
"συμβατή": [15],
"λόγια": [27],
"εκ": [[2,4,18,21,28]],
"ελ": [17],
"εν": [[2,22],[1,11,17,21,25]],
"εξ": [[2,16]],
"θέλει": [24],
"καταχώρηση": [8,14,18,[15,17,19,20,22,26,27]],
"έστειλε": [17],
"κατάστασης": [28,18,[15,19,27]],
"εφ": [27],
"ido": [6],
"καστίλης": [6],
"τονίζεται": [28],
"idx": [11],
"μέσα": [27,15,14,[2,23,26,28],[3,5,10,16,18,25],[8,21,22]],
"πρώτες": [14],
"conflict": [27],
"que": [6],
"βοηθητικό": [11],
"qui": [14],
"λιγωτερες": [15],
"άλλες": [30,13,[10,15,19],[0,16,17,27,28,29]],
"εκδόσεων": [2,27],
"rule": [12],
"αποθηκεύσατε": [18],
"linux": [15,30,[2,12],[10,14,19,22,28,29]],
"οποιασδήποτε": [28],
"checkout": [2],
"κοινών": [[2,28]],
"παραθέτει": [[22,28]],
"ομοιότητα": [27],
"χερέρο": [6],
"αναβαθμίζει": [27],
"επισημαίνεται": [28],
"κορυφή": [28,[22,23,24]],
"αναγνωρίσιμα": [27],
"παραμετροποίηση": [30,8,[9,29],[5,7,10,18,28]],
"αντιστοιχίσεις": [27,28,[18,26,30],[14,23,24]],
"περιγράφεται": [10],
"μεταφράσατε": [[18,28]],
"zha": [6],
"popup": [26],
"ifo": [11],
"διαδρομη": [15],
"λογαριασμού": [15],
"θα": [15,27,18,2,16,21,[23,25,28],14,24,19,13,1,[4,9,17,22,26],[0,20],[3,5,8,10],7,11],
"φέρει": [18],
"εκτιμήσεις": [28],
"έτοιμος": [10],
"zho": [6],
"μένα": [4],
"κλίνονται": [3],
"herebi": [12],
"consist": [12],
"ταξινόμηση": [8],
"μετάφραση": [28,[17,18,27],[10,13,26],30,21,[8,19,29],15,14,[1,2,12,24,25]],
"σχέση": [28,[16,25]],
"αρχειοθετήσετε": [27],
"δημιουργούνται": [[13,14,17,27]],
"ια": [27],
"βορ": [6],
"λεγόμενα": [[10,27]],
"υπολογίζεται": [28],
"μετάφρασή": [[16,28],[14,27],[13,18]],
"ιρλανδικά": [6],
"συναρτήσεις": [1],
"zip": [[3,12,15]],
"παραγωγικότητά": [24],
"compress": [12],
"hesit": [12],
"λακ": [17],
"αναφέρω": [4],
"λέιτουργικό": [15],
"επιθυμητή": [[15,18,28]],
"ibai": [7],
"επιθυμητό": [27],
"yahoogroups.com": [9],
"λογισμικό": [[0,2,7]],
"πρόέλευσης": [27],
"sdlxliff": [13],
"customer-id": [15],
"κα": [28,22],
"πιστοποιητικά": [2],
"δημιουργίας": [1,[3,30],[0,2,8,14,29]],
"κι": [[13,20]],
"διαπλατφορμικές": [15],
"επαναχρησιμοποιήσετε": [27],
"όμως": [21,[10,18,20,25,27]],
"στρατηγικών": [27],
"κπ": [2],
"πρώτου": [[18,24,28]],
"στιβαρή": [19],
"iii": [6],
"μάθετε": [16,[10,15,29]],
"τεράστιο": [25],
"requir": [12],
"μέλη": [2,27],
"προτάσεων": [[17,21,24,30]],
"επκύρωσης": [28],
"λογισμικά": [1],
"επιθυμίες": [5],
"kyle": [7],
"viewmarknotedsegmentscheckboxmenuitem": [8],
"αντιστοιχεί": [[20,22,25]],
"επιφάνεια": [[15,23]],
"tracker": [4],
"εφαρμμογή": [30],
"χρησιμοποιείστε": [28,18,[16,17,19,27]],
"event": [8],
"μη-μοναδικών": [[8,18]],
"τροποποιητής": [8],
"παραμέτρους": [[13,15],[19,20,27]],
"αδυνατεί": [27],
"τερματικού": [15],
"είστε": [17,[10,15,20,28]],
"δώστε": [16],
"subscrib": [9],
"υψηλής": [27],
"πρότυπες": [28],
"συγχρονίζει": [2],
"ειδάλλως": [[18,27]],
"εγγυάται": [10],
"στο": [15,28,18,27,2,9,[14,30],[23,25],[13,16],5,10,[1,26,29],8,[19,22],[17,20,24],3,21,4,11,[0,6]],
"επιβεβαίωση": [18,8],
"optionssaveoptionsmenuitem": [8],
"εγκατασταθούν": [25],
"τμημάτων-λόγου": [17],
"runn": [23],
"στη": [15,28,27,19,[13,17],[14,18],[2,9,16,24,26],[1,3,10,11,21,22,25],23],
"άπαξ": [22,[27,28]],
"με": [[15,28],27,18,13,10,[14,19],30,23,2,[8,21],[24,26],25,[7,20,22,29],[11,16],1,17,[5,6],3,[4,9],[0,12]],
"τοποθεσία": [30,15,[14,27],[19,23],[2,8,21,28]],
"μη": [[24,26],[2,14,15,19,30]],
"stardict": [11,30],
"στα": [15,[18,28],13,2,[5,27,30],[14,19,21,23],[17,20,24,26],[0,1,3,10,11,29]],
"first": [[12,23]],
"omegat.l4j.ini": [15],
"προσκήνιο": [18],
"δεδομένης": [27],
"πιθανώς": [22],
"prefer": [12],
"ασυμβατότητες": [18],
"quotat": [22],
"hans-pet": [7],
"ενεργού": [5],
"overridden": [12],
"iku": [6],
"pijffer": [7],
"να": [15,27,28,2,24,13,18,16,[14,19],10,[25,26],8,21,17,9,23,30,1,[11,20],22,4,[3,29],[0,7],5],
"zakharov": [7],
"συν": [17],
"simpl": [26],
"προπονητής": [22],
"νε": [15],
"εισαγωγή": [[18,29],30,8,[2,27],[10,13,16,26,28],[0,1,3,5,14,17],23],
"from": [12,3,[23,27]],
"λόγος": [25],
"hardwar": [19],
"thunderbird": [25],
"προτιμήσεις": [15,[8,10]],
"ile": [6],
"editselectfuzzy3menuitem": [8],
"you\'ll": [3],
"βιομηχανικό": [28],
"project.projectfil": [1],
"εκτυπώσει": [1],
"μείζον": [21],
"χρήσιμες": [[10,22],[15,16]],
"έκανα": [0],
"phillip": [7],
"πίνακες": [[6,8,13]],
"βρεθούν": [23],
"ιδιωτικό": [[2,15,17]],
"μείζονες": [24],
"ποντίκι": [0],
"κλικάρατε": [18],
"φτιάχτηκε": [17],
"περιορίζεται": [2],
"αιτιατική": [14],
"έννοια": [[24,25]],
"συντόμευση": [8,[13,15,18,28]],
"πληκτρολογήσετε": [15],
"error": [12],
"αιτήματα": [9],
"μεγάλες": [[17,28]],
"shortcut": [8],
"δανέζικα": [6],
"public": [12],
"χτιστεί": [17],
"array": [3],
"επεξεργάζεσθε": [28],
"εμφανίζουν": [28],
"στόχους": [26],
"οι": [27,28,15,[14,18],[13,24],10,[8,23],[2,21,22],[16,26],[1,25],[0,17,19],[3,4,5,9,20,30]],
"εκκίνησης": [15,[9,19,24,30]],
"απλών": [[10,20]],
"ina": [6],
"τώρα": [[2,8,15,26,27,28]],
"ind": [6],
"pt_br.aff": [25],
"τσεχικά": [[6,20]],
"αναζητά": [10],
"ελεύθερα": [16],
"ini": [13,[15,30]],
"ου": [27],
"απλώς": [[14,15,20],[1,9,24,25,27,28]],
"εσωτερική": [[18,28],21],
"δίνουν": [20],
"εμπλέκονται": [[2,27]],
"μετάφρασής": [19],
"προορισμός": [27],
"μεταβείτε": [[9,17,18,25,28,29]],
"συνεχόμενες": [27],
"εξοικειωμένος": [19],
"ελεύθερο": [7,[2,10]],
"dhttp.proxyport": [15],
"διαχωρισθούν": [24],
"trado": [14,30],
"αζέρικα": [6],
"ελεύθερη": [[2,11]],
"ορισμό": [8],
"subrip": [13],
"πχ": [13],
"kangaroo": [10],
"χρήστης": [21,17,[8,9,10,18,28]],
"ταυτοποιηθείτε": [17],
"αυτόματα": [[2,15,18,26]],
"αντίστοιχοι": [13],
"υπηρεσίες": [15,17,[2,10,28]],
"κανούρι": [6],
"describ": [3],
"score": [28],
"παρεχόμενα": [17],
"ipk": [6],
"επόμενα": [2,[15,21]],
"όλη": [26],
"υποβολής": [2],
"βαθύ": [[14,23]],
"ενημερώνεται": [27],
"όλα": [[15,27],28,[1,18],[9,23],[0,5,13,16,21]],
"παλιότερες": [18],
"αυτόματη": [21,15,26],
"επόμενο": [18,26,[8,16],[2,11,14,15,23,27,28],[0,1,3,4,5,6,7,9,10,12,13,17,19,20,21,22,24,25,29]],
"προέρχονται": [28],
"αυτόματο": [13],
"χαμηλή": [8],
"σελίδας": [[8,13]],
"επόμενη": [[8,15,18,28]],
"όλο": [[18,20,28],[5,15]],
"πιθανόν": [[14,15,24]],
"aaa": [22],
"southern": [6],
"solari": [15,12],
"βάλατε": [18],
"μεταφραστής": [28,27,[13,24]],
"πρόγραμμα": [15,19,30,[5,13,29],[0,2,6,10,11,14,18,20,26,28]],
"επιτρέψετε": [27],
"manual": [12],
"χρησιμοποιώντας": [28,[1,11,17,18,19,21,23,24,25,26,27,30]],
"σε": [27,15,28,13,18,[10,19],2,[20,24],[14,16],17,[1,21],30,26,25,[8,23],4,[3,5,9,11,22,29],7],
"aar": [6],
"διατηρούνται": [14],
"ταϊτιανά": [6],
"αρχείο-στόχο": [13,1],
"κάνατε": [15,28,27,[17,18,21,23,26]],
"εκπαιδεύεται": [19],
"χειρισμό": [[10,20]],
"marshalles": [6],
"ερμηνεύσει": [20],
"επεξεργασίας": [30,28,26,18,13,[23,29],[5,10,14,15,16,19,20],[2,6,8,21]],
"εκκινεί": [15],
"τροποποιείτε": [7,13],
"μαράθι": [6],
"iστον": [2],
"εντοπίσει": [[14,15]],
"abc": [22],
"rcs": [27],
"μεταφραστές": [27],
"navaho": [6],
"abl": [12],
"abk": [6],
"τάϊ": [6],
"τα": [27,18,[15,28],2,19,25,[13,30],10,24,21,[14,22],23,20,[3,17,26],[11,16],1,[5,8],[0,9,29],4],
"πλήρους": [5],
"τη": [15,28,18,27,17,10,21,13,[23,24],14,[2,4,25,26],1,[9,16],[0,3,19,29,30],[8,11,20,22]],
"τι": [9],
"δικούς": [2],
"σόνα": [6],
"επαναπροσδιορίσετε": [5],
"το": [15,28,27,18,2,19,24,[10,16],[14,17],[13,26],21,22,30,1,8,[20,23],25,29,7,0,[5,11],9,[3,4],12],
"μορφοποιημένο": [[10,13,16]],
"ψάξει": [16],
"ελέγχουν": [27],
"μορφοποιημένα": [30,13,18],
"isl": [6],
"iso": [6,30,20,29,[5,10,14,19,24,27]],
"τω": [17],
"εξωτερικούς": [28],
"αποθηκεύει": [18,10,[15,19,20,27,28]],
"contribut": [12],
"υπηρεσίας": [17],
"πάρουν": [15],
"καταλανικά": [6],
"τσουάνγκ": [6],
"zul": [6],
"μακριά": [27],
"act": [12],
"παρουσιαστεί": [8],
"θεωρηθεί": [21],
"glossary.txt": [14],
"ita": [6],
"απώλεια": [[10,19]],
"υπ": [[18,21],[13,23,26,28]],
"προγούνται": [22],
"εξόδου": [13],
"μετατρέποντας": [17],
"περιλαμβανομένων": [28],
"εκείνον": [[21,27]],
"παραρτήματα": [[10,18]],
"add": [12],
"initi": [12],
"εγγράφεται": [18],
"αποτελείται": [28],
"equival": [12],
"δημιουργείται": [27,24],
"respect": [13],
"υπάρχει": [15,27,14,[1,13,18,19,26,28],[0,2,11,24,25]],
"μεταφράσθηκαν": [[27,28],17],
"αντιληφθεί": [26],
"εγκαταστήσετε": [15,[2,11,25]],
"larouss": [28],
"ελάχιστο": [18],
"untar": [11],
"μεταγλωττιστής": [13],
"ονομάζεται": [15],
"prevent": [12],
"benjamin": [7],
"καθημερινή": [15],
"filters.conf": [19,15],
"γραμμή": [15,28,30,19,[3,8,27,29],[10,17,18,22,24]],
"συμπεριφορά": [30,[26,28],[5,13,18,29],[8,10,15,20]],
"modifi": [[8,12]],
"όρο": [14,23],
"τρέχετε": [15,2],
"μοιάζουν": [23],
"εισάγουν": [27],
"αποδίδοντας": [22],
"παλιά": [6,27],
"διαχείριση": [[10,18],30,[1,2,13,17,26,27]],
"anyth": [12],
"afr": [6],
"μετακινηθείτε": [18,[16,28],5],
"επίλυση": [[17,30],[27,29]],
"αυτούς": [2],
"διάρκεια": [21,[10,24,27,28]],
"σόθο": [6],
"pgdn": [5],
"επαναλαμβάνει": [18],
"saboga": [7],
"directori": [12],
"έστω": [21],
"αποθετήρια": [2],
"backup": [12],
"sensit": [23],
"αγνοηθεί": [[5,8]],
"χρέωσης": [17],
"διατηρείται": [[18,21]],
"ιαπωνικών": [18],
"properti": [12,[13,19]],
"κάπου": [27],
"έγγραφό": [14],
"εμπορικά": [26,28],
"σταδιακά": [27],
"συνεισφέρετε": [9],
"κεφάλαια": [10,28],
"fisher": [3],
"συμπεριφέρεται": [28],
"αποθετήριο": [2,[17,27]],
"ακριβής": [[23,28],[8,18]],
"μεταφορτωθεί": [14],
"number": [12,3],
"όσα": [27],
"περιεχόμενο": [26,[1,14]],
"ενεργοποιηθεί": [18,[0,10,21]],
"υποστήριξη": [9,[1,4,30]],
"ως": [27,28,15,18,21,[2,14,20,24],[8,9,10,25],[3,13,17,22,26],[0,1,11,19,23,30]],
"μορρφοποίηση": [27],
"περιπτώσεις": [27,[13,19,21,24],[17,20,22,28]],
"αυστηρές": [27],
"ενδέχεται": [27,[14,15,19,24]],
"κεφάλαιο": [10,28,27,[17,21],[4,16,22,23,24]],
"troubleshoot": [3],
"έγγραφα": [27,[18,21],[24,26],[1,9,13,16,19,28]],
"κακές-μεταφράσεις": [26],
"αντικαταστείστε": [[27,28]],
"όσο": [[27,28],[13,22],[10,15,23]],
"τοποθετήστε": [25],
"μπορέσετε": [[2,10,17,25]],
"έγγραφά": [15],
"συντήρηση": [2],
"script": [12,30,[1,2,10,15,19,26]],
"ώστε": [13,27,[2,28],[10,23]],
"ισχυρός": [23],
"system": [[3,15]],
"spellcheck": [25],
"πρόληψη": [[19,30],[21,29]],
"επιλέχθηκε": [18,26],
"ενσωματωμένο": [25],
"αγνοώντας": [28],
"καθορισμό": [[10,21]],
"γλωσσολογικά": [17],
"γλωσσικών": [17],
"πούμε": [27],
"έγγραφο": [13,[1,28],[5,7],[2,10,16,18,29]],
"συνεχίσετε": [16],
"καταγεγραμμένα": [21],
"other": [12],
"επικίνδυνο": [23],
"διαιρείται": [28],
"μοναδικό": [[17,23]],
"προκαλείται": [17],
"khmer": [6],
"πλευρά": [17],
"ανταλλαγή": [14],
"local": [[2,13,15,19]],
"ότι": [15,27,28,17,[2,21],25,19,9,[5,14,16,24],[4,10,11,13,18,20,22,23,26]],
"αντίστοιχα": [14,2,[13,17,19,25]],
"ανάμειξη": [30,13],
"αποκατάσταση": [28],
"locat": [12,[3,15]],
"μηδέν": [22,24],
"τέλεια": [27],
"samoan": [6],
"cree": [6],
"επεξεργάσιμου": [5],
"μοναδικά": [28,21],
"θέσεις": [[1,13]],
"αντίστοιχο": [[15,28],[19,24]],
"περιεχόμενα": [2,[18,28],[14,15,19,26],[20,27]],
"περιεχόμενά": [27,2,[10,11,23,28]],
"πρόταση": [16,[0,21,24],[18,27]],
"τοποθεσιών": [18],
"αντίστοιχη": [0],
"προγραμαμτιστής": [1],
"προόδους": [19],
"θέματος": [[2,27]],
"τελούγκου": [6],
"aka": [6],
"εσάς": [21],
"αντίστοιχό": [11],
"μοναδική": [23],
"αρχίσετε": [[15,16,17,19,28]],
"παραγωγή": [17],
"καιρού": [25],
"σύνδεση": [[8,10,18,25]],
"tsonga": [6],
"μεταφέρει": [15],
"βέβαια": [[21,28]],
"αριθμ": [18],
"μη-διαχωρίσιμα": [18],
"es_mx.aff": [25],
"πρόσφατα": [[3,17,19]],
"επιλεγούν": [0],
"πρόσφατη": [[2,15],[9,19]],
"πληκτρολογείτε": [28,[13,14]],
"correspond": [12,3],
"πατήστερ": [18],
"όχι": [5,[15,22,28],[13,21,23,26,27],[2,4,14,17,18,19,20]],
"βρισκόταν": [5],
"mode": [15,19,13,30],
"συνέχιση": [9],
"εντόπιση": [[4,10]],
"toolsshowstatisticsstandardmenuitem": [8],
"φακέλλων": [21],
"all": [12,23],
"προγενέστερο": [27],
"της": [15,28,2,27,[18,19,30],24,17,[5,21,23],[7,10,14,26],[13,25],[1,3,4,9,16],[0,8,22,29]],
"read": [12],
"την": [28,15,18,27,13,[2,24],[14,20],[7,17,19,23],10,1,30,3,[5,8],[4,22],[9,21,25,26,29],11,[0,16]],
"umarov": [7],
"διαθέτει": [1,[2,20]],
"alt": [5,[1,8,15]],
"εκείνες": [[22,27]],
"εργασία": [10,[2,18]],
"κομμάτι": [[15,17,18]],
"αλλάξουν": [18],
"ρυθμισθεί": [2],
"βέβαιο": [17],
"επιλεχθείσα": [18],
"διαμοιραζόμενα": [2],
"διαμοιρασθούν": [2],
"org.omegat.core.matching.token": [3],
"alreadi": [12],
"όψη": [21,[13,18,23,26,28]],
"εκτελέστε": [[15,19]],
"υποτίτλων": [13],
"wildrich": [7],
"pinfo.list": [17],
"εκτέλεση": [[17,28],[18,30]],
"amh": [6],
"collect": [[12,14]],
"μικρών": [[15,23]],
"βασίζεται": [2,[3,17,25]],
"unix": [18],
"επιτάχυνση": [27],
"χτίζει": [1],
"αφαίρεση": [22],
"περιλαμβανομένου": [22],
"πλοηγούμενοι": [28],
"παράμετροι": [[13,15,17,30]],
"βασίσθηκε": [17],
"λεξεις-κλειδιά": [1],
"τσαμόρο": [6],
"μηχάνημα": [19],
"roh": [6],
"παράγραφο": [24,21,27],
"χρήστες": [15,30,29,18,[2,10,17],[13,16,19,22,27]],
"δρομέας": [5],
"μηχάνημά": [[15,19]],
"γωνία": [28],
"ron": [6],
"λίστα": [[18,20,22,23,25,26]],
"εμφανίζοντας": [18],
"καναδικά": [24],
"εϊναι": [1],
"and": [12,[3,23],13,[2,15,29,30]],
"είπαμε": [13],
"ταμίλ": [6],
"παραδίδουν": [27],
"μετάφραστικής": [24],
"πατά": [26],
"ani": [12],
"απολύτως": [[13,17]],
"έκδοσης": [2,29],
"αλληλεπιδράτε": [2],
"παράμετρος": [15,19],
"τις": [15,[27,28],18,10,13,[16,19],[2,21,23],17,[14,20,25,26],[3,4,24],[5,8],[1,29],[9,22,30]],
"ant": [15],
"ονομάζονται": [[10,25]],
"λέξεις-κλειδιά": [10],
"αποδεκτή": [[17,27]],
"επικυρωθεί": [18],
"πίνακα": [[24,28]],
"εμφανίζεται": [28,[13,18,27],[0,2,8,14,17,21,23]],
"application": [29],
"ορίστηκε": [0],
"παρακολουθούνται": [2],
"jnlp": [15],
"προόδου": [28],
"οποιωνδήποτε": [[10,13,17]],
"omegat.ex": [15],
"πλήρης": [[8,28]],
"reason": [12],
"επισημανθούν": [18,[2,27]],
"διαστάσεων": [18],
"για": [15,28,27,18,24,2,13,17,[16,21],[10,25],22,19,8,[1,20],[3,9],14,[7,23],[0,11,26,30],[4,29],[5,6]],
"γραμματικά": [[3,10]],
"εμφανίζετε": [13],
"sourcetext": [28],
"ακριβης": [14],
"αριχκό": [27],
"κεντρικά": [6],
"γραμματοσειρές": [19],
"δρομέα": [5],
"δημιουργείστε": [16,[0,1,3,27,29]],
"μεταφράσει": [15,[16,19,25]],
"διαφορετικών": [[1,10,27]],
"jar": [15,19,[3,12],27],
"μετρητές": [28,[29,30]],
"api": [17,15],
"παραδείγματα": [30,22,[15,29],24,26],
"άπληστοι": [22,29],
"jav": [6],
"editselectfuzzy2menuitem": [8],
"ορίζεται": [[13,19,27]],
"app": [15],
"using": [29],
"assames": [6],
"ιστοσελίδες": [1],
"μερικές": [27,18,[19,28],[1,15]],
"τέτοια": [[26,27]],
"ζητήσετε": [28],
"λιμβουργιανά": [6],
"ακολουθείτε": [28],
"επέκτασή": [[11,13]],
"γραμματοσειράς": [19,[13,28]],
"ενσωματωμένος": [28],
"γραμής": [19],
"alex": [7],
"συνεχίστε": [4],
"θεωρούν": [18],
"επέκταση": [14,20,[11,13,27]],
"πολύτιμη": [4],
"μηχανικής": [17,28,18,30],
"στον": [15,[2,27],18,28,[16,19],[1,14,25],[0,26],[8,20,23],[3,4,5,11,13,17,21,29]],
"αντικαταστήσετε": [28,17],
"προσθήκη": [15,[2,24],[1,14,28,30]],
"λογιστικό": [28],
"διαμοιραζόμενο": [2],
"πλήρες": [11],
"ara": [6],
"επικύρωση": [30,18,[19,28],[8,15],[13,27]],
"βασιμένο": [14],
"τελειώσει": [[2,27]],
"are": [12,3,[13,27]],
"αρχίζει": [[15,28]],
"arg": [6],
"κόμματος": [14],
"αρχίζουν": [[8,15,22]],
"εναλλαγής": [13],
"where": [12],
"τέτοιο": [27,[15,19]],
"δυναμική": [1],
"paypal": [9],
"εφαρμοσιμότητά": [24],
"έτος": [[19,27]],
"art": [25],
"holder": [[1,13]],
"εξαρτάται": [[13,17,27]],
"ποσοστά": [27],
"rtl": [13,30],
"βγείτε": [18,27],
"αποθηκεύονται": [2],
"αρκεί": [[14,15]],
"διαγράφονται": [21,18],
"vmoption": [15,3],
"jdk": [15],
"επεξεργαστείτε": [24],
"υποστηρίζεται": [14],
"ask": [12],
"asm": [6],
"αντιπροσωπεύουν": [[27,28]],
"λύση": [30,20,[13,27,29]],
"καταχώρησης": [8,18,[2,14]],
"run": [23,[6,12,13]],
"στις": [[23,27],[15,28],[13,24],[8,17,26],[1,2,4,9,10,18,19,20,21,25]],
"μία": [27,[2,5,19,24,25],[10,13,17,23]],
"rus": [6],
"view": [12,13],
"either": [12],
"συνταγή": [27],
"διαγράφοντας": [28],
"aymara": [6],
"titlecasemenuitem": [8],
"λειτουργίες": [28,18,[10,16,23,27]],
"ενδεχομένως": [[16,27]],
"editcreateglossaryentrymenuitem": [8],
"ourc": [13],
"του": [15,28,30,27,2,18,13,5,16,19,24,[9,14],29,[17,26],[4,10,25],[20,21],[1,8],[3,23],11,0,7,22],
"alic": [27],
"dure": [12],
"bold": [28,[13,18]],
"τον": [15,28,22,18,27,[2,25],[10,14],21,[3,16,19],5,[0,1,13,17,23],[9,26],[8,11,24,29]],
"αποκτήσετε": [[19,21]],
"ιαβαϊκά": [6],
"χειροκίνητη": [25],
"συναδέλφων": [28],
"μεταφράσιμων": [[24,28]],
"τρέχον": [18,28,14,26,[10,19,21,27]],
"αναγνωρίσιμες": [14],
"name": [[3,12]],
"ψευδομετάφραση": [30],
"παραμένουν": [[15,27]],
"εντοπισμού": [23],
"χειροκίνητα": [14,27],
"κατάταξη": [[10,27,28]],
"web-bas": [17],
"στην": [28,15,14,27,18,17,[2,5,19,23],[9,16,20],[10,13,21],[0,1,4,8,11,22,24],[3,25,26]],
"επιλέγετε": [21],
"απαιτούμενων": [2],
"android": [13],
"show": [[3,23]],
"στης": [26],
"ακολουθούμενο": [22,[8,24]],
"ava": [6],
"pushto": [6],
"ισοδυναμεί": [28],
"ave": [6],
"δημιουργούμενα": [18],
"εγγύηση": [7],
"ορισθεί": [15,13,[8,14]],
"τομέα": [10],
"κινεζικής": [15],
"διαχειρίζεσθε": [2],
"μας": [27,[1,26]],
"περισσότερη": [15],
"διεπαφή": [15,28,10,[9,13,18,29,30]],
"κωδικοποίησηη": [14],
"περισσότερα": [14,[8,9,10,13,18,22,23,24,27]],
"pgup": [5],
"λειτουργίας": [[4,26]],
"κωδικοποίησης": [10],
"subfold": [12,30,16],
"περισσότερο": [28,[17,19,22]],
"ιδιαίτερες": [24],
"δημοφιλείς": [2],
"συμφέρει": [27],
"ένα-προς-ένα": [10],
"κλασεις": [[22,29]],
"target": [3,[12,13,27],[1,16,30]],
"σύνθετες": [[10,13]],
"χαρακτηρισιτκά": [1],
"μέθοδος": [15],
"κανονική": [22,[15,23]],
"επιλέξετε": [15,28,[23,25],[14,16,21,24,27]],
"στοιχίζει": [19],
"αποφασίσει": [[2,21]],
"κανείς": [8],
"μέθοδοι": [23,[15,30],[13,29]],
"fabián": [7],
"κανονικά": [[15,19],9],
"config-dir": [[15,19]],
"αποφύγει": [27],
"τελευταίας": [18,8],
"υπάρχουν": [15,[13,21],[14,24,26,27,28],[0,1,2,10,11,16,18,19,20,25]],
"υποφακέλλους": [10],
"tρόπος": [30],
"βοήθειας": [[28,30],[8,18,29],13,19],
"εκτελέσθηκαν": [18],
"αντιστοιχισμένο": [28],
"ελέγξετε": [[2,15,20,23,28]],
"είδους": [[11,20]],
"www.netrexx.org": [1],
"προφυλάξεις": [19],
"εισόδου": [17],
"εντοπίσουν": [9],
"κωδικοί": [27,[10,25,30]],
"ισπανικής": [17],
"συναρμολόγησης": [17],
"όνομά": [28,[1,14,18,27]],
"case": [[8,23],18],
"όνομα": [[15,27],28,2,16,[3,6,8,11,18,19,23,24]],
"επαναμορφοποίηση": [17],
"πνευματικών": [7],
"item": [8,12],
"κατεγράφησαν": [27],
"μεγάλο": [[25,28]],
"ασφαλές": [27],
"έντυπων": [28],
"matcher": [22],
"χρειάζεται": [[2,14,27,28],[10,15,21,23,26]],
"βρήκαν": [4],
"επαναφορά": [[8,18,28,30]],
"χρησιμοποιείτε": [15,13,[16,27,28],[10,19],[2,17,18,21,29]],
"σημαίνει": [[5,11,13,27,28]],
"targettext": [28],
"φορές": [22,28,[1,13,27]],
"consid": [12],
"aym": [6],
"οτιδήποτε": [9],
"κλείνετε": [18],
"μπορούσαν": [27],
"πειστρέψετε": [28],
"style": [13],
"κεφαλαίου": [[7,14]],
"card": [23,30],
"care": [12],
"συμπεριληφθούν": [27,[2,23]],
"μήνα": [[15,27]],
"aaabbb": [22],
"διαχωριστικά": [28],
"aze": [6],
"ερωτήσεις": [9],
"caus": [[12,15]],
"ασύμβατα": [27],
"μέχρι": [22,[5,15,21],[10,24,27,28]],
"edittagpaintermenuitem": [8],
"ενέργειας": [18,8],
"τριών": [27],
"επικυρώσετε": [16],
"bokmål": [6],
"παντζάμπι": [6],
"γεμίσετε": [27],
"more": [12,23],
"display": [[13,23]],
"διαστημάτων": [[8,18,28]],
"επέκτσαση": [20],
"viewmarknbspcheckboxmenuitem": [8],
"unicod": [20,[14,22,30]],
"λίστες": [17],
"ενδιάμεσου": [15,30],
"νυάντζα": [6],
"σχολίων": [28,30,[14,15,27,29]],
"απενεργοποιεί": [18],
"πιθανό": [[13,17,20]],
"overwrit": [18],
"en-us": [27],
"κιρούντι": [6],
"εκτελέσει": [[15,16]],
"whitespac": [8],
"προϋπόθεση": [13],
"μετονομάσουμε": [27],
"τοπικό": [2],
"ποσοστό": [28],
"φυλάσσετε": [2],
"δοκιμάσουν": [18],
"κανονες": [13],
"simpli": [12],
"τελευταίες": [18],
"μήλο": [18],
"λειτουργούν": [24],
"σαρώσει": [1],
"μακροεντολές": [1],
"katarn": [7],
"παρακολούθηση": [9],
"χτίσιμο": [17],
"untransl": [12],
"επισήμανση": [8,18,[26,28,30]],
"πιθανά": [[26,27]],
"πιθανή": [27],
"δημιουργήσετε": [[16,27],15,[24,26]],
"ενότητες": [13],
"daili": [12],
"πόρων": [13],
"πρόσφατης": [27],
"μην": [[1,4,8,13,16,19,21,23,24]],
"αναδυόμενα": [21],
"bashkir": [6],
"κορεατικών": [18],
"both": [23],
"αποκαταστήσει": [28],
"most": [12],
"αναθέστετα": [27],
"γράφει": [1],
"πλεονεκτικές": [24],
"περιοχή": [28,30,14,[21,27,29],[16,17,18,19],[1,5,13,23,26]],
"omegat.project": [[2,12,30]],
"μετσαφραστικές": [27],
"job": [12],
"x_without_jr": [15],
"αναδυόμενο": [28,[14,18,19,25,26]],
"δοκιμή": [22],
"οποιεσδήποτε": [[2,15,26]],
"τουςl": [2],
"webstart": [15],
"αντιγραμμένα": [2],
"θέλετε": [15,27,[8,9,16,17,26,28],[2,3,10,18,20,22,23,25]],
"ενέργειες": [18,15],
"καθορίζονται": [27],
"των": [28,27,18,2,[10,13],17,21,[15,24,30],[1,14,20,25,26],[3,4,5,16,23,29],[0,8,11,19]],
"αντιγράψτε": [27,15,19],
"κικούγιου": [6],
"sag": [6],
"μια": [15,27,28,18,13,23,17,[1,19,24],[2,26],[10,16],[8,21,22,25],[9,14,20],[0,4,5,7]],
"messag": [12],
"πολλοίς": [22],
"αγγλική": [28],
"αγγλικά": [22,[0,3,6,15,27]],
"μεταφρραστική": [18],
"επιταχύνοντας": [27],
"subvers": [2,30],
"αναγνωρισμένου": [24],
"καταγράψετε": [9],
"ψηφίο": [18,22],
"san": [6],
"move": [18],
"καιρόν": [25],
"resp": [3],
"εμφανίζει": [18,28,[10,20],23],
"νεπαλέζικα": [6],
"επιλεγεί": [15,[18,24]],
"πρόσφατες": [[6,17]],
"jpn": [6],
"also": [12],
"ανθρώπων": [4],
"resx": [13],
"μεταφράσιμα": [27],
"differ": [[3,12]],
"πολυεθνική": [27],
"consol": [3],
"σύμφωνα": [[10,15],[2,5,18,22,26]],
"pāli": [6],
"κωδικού": [2],
"πιθανές": [[14,18,27]],
"itokenizertarget": [3],
"a123456789b123456789c123456789d12345678": [15],
"ρχείου": [23],
"viewmarkwhitespacecheckboxmenuitem": [8],
"πράσινο": [[2,28],18],
"πρόθεση": [24],
"projects": [29],
"bad": [17],
"περισσότερους": [[8,24]],
"δίσκο": [[2,15,18]],
"δείχνουν": [[27,28]],
"δεσμεύει": [15],
"lucen": [3,30],
"complet": [[12,27]],
"bak": [[2,6,12]],
"μενού": [8,29,18,30,28,15,21,[1,10,16,19,20,24],[13,14,17,25,26]],
"bam": [6],
"λοιπόν": [[15,27]],
"αρχικές": [16],
"bar": [15],
"bat": [15],
"built-in": [28],
"παρέχεται": [[10,28]],
"συσχετιζόμενων": [17],
"μπλέ": [28],
"jre": [15],
"μπλε": [28,[0,23]],
"optionsfontselectionmenuitem": [8],
"posit": [23],
"χρόνος": [18],
"λεπτομερείς": [28],
"συνηθισμένο": [15,5],
"παραπάνω": [28,27,23,[11,13,14,15],[0,1,2,17,20,22]],
"translatedfil": [19],
"συντάσσεται": [17],
"επεξεργασθείτε": [[15,25,27,28]],
"αναθεώρηση": [[0,4]],
"συνηθισμένη": [18],
"είναι": [15,28,27,14,2,[13,17,18,24],19,10,26,8,[16,20,21,25],1,[7,22],11,23,[0,3,9],5],
"aaron": [7],
"συνηθισμένα": [14,[27,29,30]],
"παρούσα": [13],
"προεπιλογή": [18,27,[2,26],[13,15,20,22,23]],
"αϊτιανά": [6],
"project2": [2],
"project1": [2],
"λεξικολογική": [17],
"deal": [12],
"freebsd": [[12,22]],
"είδος": [13,[18,24,28]],
"rexx": [1],
"affect": [12],
"icon": [12],
"delet": [5],
"λειτουργικό": [15,2],
"αυτόν": [[11,15,16,19,25]],
"αυτός": [1,[0,5,14,17,22,24]],
"προσφέρετε": [9],
"see": [12,3],
"vito": [[7,29]],
"απλό": [20,[10,13,22],[1,15,26,27,29,30]],
"στόχος": [30,13],
"seq": [14],
"κατά": [15,[5,19,27],[6,30],[10,24,28],[3,17,21,29],[13,14,18,23,25]],
"developerwork": [15],
"προσθήκες": [1],
"contain": [12,[3,27]],
"set": [12,30,[15,20]],
"συγγραφέας": [28,7],
"λειτουργικά": [18,2],
"μννήμες": [10],
"optionsrestoreguimenuitem": [8],
"λειτουργεί": [[17,18],[10,12,19,25]],
"απόφαση": [17],
"ιντερλίνγκουα": [6],
"μη-μοναδικά": [18],
"λαμβάνονται": [[2,26,28]],
"αυτών": [25],
"απλά": [30,[13,24,26],[14,17,20,29]],
"απλή": [[13,14,22,27]],
"αφορά": [27,[19,21,28]],
"fleurk": [7],
"γράφτηκαν": [18,1],
"διάφορα": [30,[10,19,28],[2,6,16,18,25,27,29]],
"γλωσσες": [17],
"bihari": [6],
"offic": [13],
"terminolog": [14],
"ποικιλίες": [27,22],
"φόντο": [28,18],
"bel": [6],
"αναζητήσεις": [23,[10,22,30],[18,24,28,29]],
"ben": [6],
"φράση": [23,24],
"εξήγηση": [[0,2,15]],
"welsh": [6],
"διαιρέσετε": [28],
"φορτώσετε": [26],
"ακέραια": [4],
"αποκαλούνται": [24],
"projectsavemenuitem": [8],
"πόσα": [28],
"joel": [9],
"ζητήθηκε": [[15,17]],
"digit": [27],
"στόχου": [13,30],
"άδειας": [7],
"υποστηρίζουν": [[10,14,27]],
"πόσο": [28],
"τρέχοντα": [15,[2,18,19,27]],
"μου": [4],
"δηλώνω": [4],
"αδειάστε": [28],
"pptx": [13],
"αποθετηρίων": [4],
"ιαπωνικούς": [20],
"βημάτων": [24],
"εξηγήσεις": [13],
"ασήμαντες": [27],
"ρίζες": [3],
"τύπους": [[12,13]],
"καταμηθεί": [24],
"εργάζονται": [[2,10,27]],
"example_project": [12],
"prototype-bas": [1],
"cursor": [18],
"σουδανέζικα": [6],
"ορίζονται": [[25,28]],
"προστεθεί": [14,[1,19]],
"xhosa": [6],
"παρακολουθούν": [28],
"εγγράψιμου": [30],
"σκληρό": [[15,18]],
"υπεύθυνων": [10],
"sin": [6],
"υποκατάλογ": [11],
"τακτά": [[13,19]],
"συνδυασμό": [11],
"ουσιαστικά": [17,20],
"aεπιτρέπει": [17],
"ενθαρρύνεται": [13],
"εισαχθούν": [[18,23,27]],
"γουόλοφ": [6],
"someth": [12],
"τσεκάρετε": [18,15,24,[2,25,27]],
"πλήκτρο": [18,8,[5,16]],
"punjabi": [6],
"tiago": [7],
"μάθησης": [17],
"μπει": [27],
"απο-μορφοποίηση": [17],
"βρείτεi": [15],
"πλήκτρα": [[5,18],8],
"πλήρη": [15,[10,16,28]],
"λογισμικού": [15,[2,7,19]],
"χάουζα": [6],
"setup": [12],
"εναλάσσεστε": [13],
"bih": [6],
"select": [12],
"αντιγράψει": [16],
"bin": [12],
"καποιον": [7],
"ενημερωθεί": [28],
"μηνύματα": [[15,19,28]],
"apertium": [17,30,29],
"bit": [20],
"κυριλλικό": [20],
"πλαίσο": [22],
"bis": [[6,22]],
"εκτελεσθεί": [15],
"clipboard": [18],
"ονομαστική": [[3,14]],
"άρχισε": [22],
"projectopenmenuitem": [8],
"autom": [15],
"yoruba": [6],
"κακή": [18],
"εοιλογές": [30],
"π.χ": [27,[14,28],[2,18],25,[15,19,21],[10,11,20,23,26],[0,1,3,13,16,17]],
"βραζιλιανά": [25],
"ολανδικά": [27,[0,6]],
"ordinari": [12],
"join": [12],
"μπαμπάρα": [6],
"δεσμεύοντας": [15],
"κατεβάσατε": [15],
"ενεργό": [18],
"προεπιλεγμένες": [8,[15,19]],
"toolsvalidatetagsmenuitem": [8],
"γλώσσα-στόχο": [0],
"σημειώστε": [15,27,28,[2,17,25],21,[5,9,11,14,19,23,24]],
"χρησμοποιώντας": [18],
"μίας": [[27,28]],
"τροφοδότηση": [22],
"καιι": [27],
"πραγματοποιείτε": [27],
"αντιστοιχίζει": [22,23],
"βολικές": [15],
"ορισμούς": [8],
"ιστορία": [14],
"επιπλέον": [[15,19],[22,26]],
"ακριβώς": [[9,19,23,25,26]],
"συνεχώς": [27],
"slk": [6],
"λείπει": [[14,22,28]],
"λούμπα-κατάνγκα": [6],
"έναn": [27],
"όποτε": [27,16],
"john": [7],
"slv": [6],
"βήματα": [2],
"begin": [12],
"σύμβολα": [[28,30]],
"σιωπηλό": [[15,19]],
"απωλεσθείσες": [18],
"ανοίξτε": [[15,16],[2,19,20,23,27,28]],
"viewmarktranslatedsegmentscheckboxmenuitem": [8],
"επιθυμητής": [15],
"valu": [[13,28]],
"ενεργοποιήθηκε": [[17,18]],
"sme": [6],
"κλείσετε": [[16,18,28]],
"υποβοηθούμενη": [10],
"shallow-transf": [17],
"μετακινείτε": [[0,16]],
"ανεξάρτητη-γλώσσας": [17],
"αναζητήσετε": [[23,25]],
"δεν": [15,18,14,28,27,21,17,19,[13,24,25],[0,16],[1,4,20,23],[5,8,9,11]],
"smo": [6],
"καλό": [[9,24]],
"σιωπηλή": [19,15],
"χειρισθεί": [[13,16]],
"δεξιού": [28],
"pojavni": [14],
"λειτουργήσετε": [3],
"εκμάθηση": [[4,7]],
"περιηγείσθε": [28],
"ποληροφορίες": [28],
"επιθυμητές": [17],
"δεσμεύονται": [15],
"ενεργοποιούνται": [18],
"κατώφλι": [26],
"editselectfuzzy1menuitem": [8],
"sna": [6],
"snd": [6],
"τάγκαλογκ": [6],
"didier": [4,7],
"case-sensit": [22],
"ξεκινήσει": [15],
"αισθάνεσθε": [19],
"γλώσσα": [15,27,[1,25],[3,13,30],[17,28],[16,19,20,24],[0,4,14,21,23]],
"στυλ": [[2,27]],
"πολλή": [4],
"προειδοποιήσεις": [30,7,[4,8,15,29]],
"καλή": [28,9],
"πολλά": [[23,26,28],[2,19]],
"report": [12],
"γροιλανδικά": [6],
"οποιαδήότε": [23],
"πλεονεκτήματα": [2],
"δείξει": [2],
"περιεχομένων": [[15,28,29]],
"auto": [27,[20,30]],
"notepad": [14],
"αφορούν": [10,28],
"som": [6],
"γραφικό": [19,15],
"πουλάρ": [6],
"διορθώσεις": [4],
"download": [12,9],
"επιλέγεται": [18,28],
"φυλά": [2],
"δηλ": [2,[15,27],[14,19,20,21,23]],
"κρεολικά": [6],
"oracl": [15,8],
"sot": [6],
"τατζικικά": [6],
"στςι": [18],
"προτάθηκε": [18],
"στήσετε": [2],
"πακέτα": [2],
"βελτιώνοντας": [17],
"δημιουργικά": [10],
"spa": [6],
"level": [27],
"υπογραμμισμένη": [[0,25]],
"λειτουργία": [15,30,[2,10,25,28],[14,16,18,24,26,29]],
"χαρακτήρων": [[5,15,17,22,29],[8,14,18,20,28]],
"περιηγητή": [28],
"παρουσιάζεται": [2],
"modif": [12],
"πακέτο": [15,[1,3]],
"γίνουν": [2,27],
"bob": [27],
"bod": [6],
"μικρές": [[10,24,28]],
"αυτόματης": [30,19,29],
"ινδονησιακά": [6],
"διαχειριστών": [2],
"άμεσης": [10,15],
"άλλαξε": [2,1],
"ανταλλάσσετε": [10],
"δια": [28],
"αυτόματες": [18],
"bos": [6],
"ανατρέξτε": [[9,13]],
"συνεισφορές": [30],
"διά": [21,[27,28]],
"sqi": [6],
"box": [[23,26]],
"μωβ": [18],
"λουξεμβουργιανά": [6],
"φορτώνει": [[16,19,27,28]],
"συνδεδεμένος": [17],
"fouri": [7],
"τετραψήφια": [27],
"κόμμα": [14],
"συνδεδεμένοι": [17],
"ασαφείς": [26],
"δεόντως": [2],
"kal": [6],
"bundl": [[13,15,19]],
"συμβεί": [[15,27]],
"επιπρόσθετα": [27],
"περιέχει": [27,28,19,15,[10,18],[9,14,23],[0,1,2,8,11,16,21,25,29]],
"kan": [6],
"φορτώνεται": [27],
"kas": [6],
"thoma": [7],
"δοκιμαστής": [[22,29]],
"kau": [6],
"kat": [6],
"κατόπιν": [27],
"διαβάστε": [9],
"αποθετηρίου": [2,27,30],
"srd": [6],
"kaz": [6],
"εγγυηση": [7],
"gigabyt": [15],
"control": [[2,18],[8,29]],
"αύξηση": [27],
"no-team": [[15,30]],
"srp": [6],
"γραφική": [10],
"φανούν": [22],
"κατατμήσουν": [27],
"ισχυρές": [23],
"srt": [13],
"έτσι": [[2,15,28],[24,27],[7,10,20,25]],
"αποεπιλεγμένο": [[21,24]],
"διαγραφή": [5,18,[21,26],[15,25]],
"παράρτημα": [5,[0,1,2,3,7,8,9],[4,6],[19,24,27,28,30]],
"κατακερματισμένο": [27],
"δυνάμεις": [9],
"κομματάκι": [1],
"χαρακτήρες": [14,[13,20,22,23],[18,28]],
"πρόιγραμμα": [3],
"συνχείζει": [19],
"λεπτομερειών": [4],
"επεξεργασθεί": [15],
"τουλάχιστον": [[2,17,26,27]],
"πληθυντικός": [3],
"environ": [15,12],
"τονίσετε": [28],
"αυτοματοποιούν": [15],
"ονόματος": [[14,20]],
"bre": [6],
"προορίζεται": [18],
"αναβαθμισθούν": [27],
"ssw": [6],
"τελείας": [24],
"επεξεργαζόμενοι": [26],
"γραμματοσειρών": [30,[13,19],[18,29]],
"συγκριτικός": [3],
"νέο": [[15,18],[1,27],16,[14,17,20,24,25,26,28,30]],
"ενεργούν": [5],
"δυτικοευρωπαϊκές": [20],
"εμφανίζονται": [[23,28],[14,18,27],[15,26],[8,10,13,19,22]],
"διαφορετικές": [28,[13,15,18,19,27]],
"οφείλονται": [4],
"on-lin": [10],
"kde": [15,30],
"σημαίνουν": [28],
"νέα": [15,[8,21,24],[2,6,13,16,22,26,27,28]],
"accept": [12],
"ενεργοποιημένο": [17],
"προ-επεξεργασία": [13],
"βουλγαρικά": [6],
"οργανωμένο": [2],
"ανάγκες": [[2,18]],
"πιθανότητα": [19],
"συντομία": [[1,2,22]],
"sub": [14],
"δημιουργηθούν": [27],
"access": [[3,12]],
"ανώδυνη": [9],
"δημιοθργήσει": [18],
"languag": [15,[1,3,12]],
"υπάροχυσα": [15],
"διαδικασίας": [[13,21,24,27]],
"sun": [6],
"διεπαφής": [[15,30]],
"current": [12,23],
"έναρξης": [10,28],
"διακομιστής": [2],
"υπολογισμός": [28],
"αρχικού": [13,[10,28]],
"ένας": [[0,10,24],[2,14,15,27],[1,3,8,13,23,28]],
"δυσκολίες": [4],
"implic": [12],
"στους": [2,27,[4,22,25,28]],
"key": [3,8,18,[13,17,28]],
"εξάγονται": [[14,26]],
"λογαρισμούς": [17],
"svg": [15],
"έναν": [15,2,27,22,[24,28],[5,18,25],[10,14,16,17],[3,8,13,19,21,23]],
"ισχύουν": [15,21,5],
"δημιουργηθεί": [[13,14,15,16,18,27,28]],
"όποια": [27],
"στέλνοντας": [9],
"svn": [2,30,[15,27,29]],
"launch": [12,3,30],
"διορθωμένο": [17],
"κλείστε": [[19,23,27]],
"δουλειά": [15,[2,4,16,27]],
"stand-alon": [22],
"tagalog": [6],
"bug": [12],
"κονσόλα": [15,19],
"ανζήτηση": [23],
"συστήνεται": [24],
"bul": [6],
"ολανδικές": [27],
"swa": [6],
"but": [[3,12]],
"πάστο": [6],
"swe": [6],
"χαρακτήρας": [[22,29]],
"εκκλησία": [6],
"express": [10,23],
"υπο": [21],
"διαχωρίζεται": [14],
"τροποποίηση": [28,[18,21],[1,10,14]],
"δίπλα-δίπλα": [15],
"zero": [23],
"αποθηκεύεται": [[15,21],[2,19,27,28]],
"χρειάζεθε": [27],
"μειώνει": [[3,13]],
"κώδικα": [1,[0,2,10,15,27]],
"χρωματίζονται": [28],
"δημιουργηθέν": [[2,27]],
"υπό": [7,[2,11,13,15,19,27]],
"gotoprevioussegmentmenuitem": [8],
"εκτεταμένος": [10],
"ευρωπαϊκής": [27],
"διαλόγου": [27,[16,20],[24,26]],
"limburgan": [6],
"ευαίσθητα": [9],
"gotopreviousnotemenuitem": [8],
"υλικό": [2,10],
"ναι": [15],
"editredomenuitem": [8],
"uilayout.xml": [12],
"κατάλογο": [15,27,2,18,28,19,14,[0,1],[3,16],[11,23,25],[13,24,26]],
"αναλύει": [[22,24]],
"αρχεία-στόχο": [13],
"διψήφιο": [15],
"khm": [6],
"κατακτήσει": [27],
"αυτόματος": [25],
"ορίζει": [15,[2,18]],
"πρόχειρο": [18],
"hint": [13],
"περιγράφουν": [28],
"αντιμετωπίζει": [10],
"συνέπεια": [[15,23,25]],
"πλατφόρμα": [17,[11,15]],
"κατάλογό": [8],
"λογιστικών": [28,14],
"ευρωπαϊκές": [24],
"learned_word": [30],
"εισήχθη": [[23,28]],
"ανοιχτών": [13],
"επιλέγει": [18,26],
"σύμβολο": [15,[14,18,22,23,28]],
"κυρίαρχος": [21],
"πηγαίνετε": [26],
"kik": [6],
"εγκαταστήσουν": [2],
"kim": [7],
"kin": [6],
"διαγράφει": [[13,18]],
"τσουβάς": [6],
"kir": [6],
"lakunza": [7],
"εντοπισθούν": [27],
"πτυχές": [10],
"επιμέλειά": [4],
"corrupt": [12],
"guido": [7],
"κωδικοποίησή": [[20,28]],
"behav": [12],
"γράμμα": [[18,22],13],
"κσαι": [25],
"δανειστούμε": [3],
"ενδιάμεσο": [18,[8,15,27]],
"παλιές": [21],
"κωδικοποίηση": [20,30,14,[13,17,29]],
"επίλυσης": [2],
"license.txt": [12],
"φόρμας": [22],
"runtim": [15,12,[1,17]],
"περιπτώσεων": [27,2],
"πρόκειται": [[15,28]],
"συνετώτερο": [25],
"ιστοσελίδα": [[0,1]],
"avar": [6],
"μεταφορτωνετε": [30,11,29],
"ακολούθως": [11],
"παλιάς": [15],
"filenam": [27],
"ακολουθούν": [15,[22,23]],
"roam": [12],
"γώσσα": [20],
"αμχαρικά": [6],
"between": [12],
"αφήνονται": [21],
"τμήματος": [5,18,[26,28],24,[17,30],[1,2,8,10,23]],
"αμφίδρομο": [13],
"υψηλή": [8],
"μετάβαση": [[8,18,30],[26,28,29],16],
"ατνιστοιχίσεις": [28],
"χίρι": [6],
"ασφαλώς": [25,[14,15,17,20,21,27]],
"gotosegmentmenuitem": [8],
"σημαντικό": [[4,13,17,27,28]],
"αφήσατε": [18],
"οπότε": [27,[24,28],[13,14,18]],
"intact": [12],
"απλοποιεί": [13],
"opportun": [12],
"cornish": [6],
"xx_yy.tmx": [27],
"εκτιμηθεί": [9],
"ισπανικών": [25],
"πάντως": [[13,15],[27,28],[4,16,17,24,25]],
"flag": [28,[21,22]],
"είνια": [27],
"κατάτμηση": [24,30,21,10,[18,27,28],[8,22,23,29]],
"helpaboutmenuitem": [8],
"επιδιορθώσεις": [27],
"weak": [1],
"εθελοντική": [9],
"αντιγραφεί": [18],
"περιεχομένου": [27],
"πουλάαρ": [6],
"αναδιανέμετε": [7],
"mandelbaum": [7],
"place": [1],
"δέσμευση": [[15,30]],
"δυτ": [6],
"regular": [10,23],
"εκείνος": [[2,27]],
"προγράμματος": [15,[2,14]],
"διπλό": [15,28],
"c\'est": [14],
"άτομο": [2],
"κανένα": [18,[15,28],[2,19]],
"token": [3,30,28,[0,2,10]],
"ετος": [19],
"τομέρος": [2],
"filter": [12],
"x_linux.tar.bz2": [15],
"site": [17],
"omegat.log": [12],
"μεγιστοποίησης": [28],
"αϋμάρα": [6],
"διάταξη": [28],
"najlepših": [3],
"τουί": [6],
"argument": [15,[3,30]],
"πειραχθεί": [14],
"έτοιμο": [28],
"μοντέλο": [1,17],
"kom": [6],
"εαυτούς": [2],
"εμπνέονται": [1],
"εβραϊκά": [[6,17]],
"kon": [6],
"omegat-rel": [12],
"επίμονη": [4],
"kor": [6],
"μεταφρασθούν": [[15,27],17],
"tab": [14,18,8,24,[22,28]],
"χρήση": [29,30,15,14,27,25,[2,19,28],[0,1,3,11,13,18,24],[8,10,17,20,26]],
"υπολογιστών": [18],
"μείωση": [13],
"έξοδος": [8,[1,18,27]],
"διακόπτεται": [19],
"should": [12,3],
"tah": [6],
"tag": [13,[10,26,30]],
"γλωσσών": [27,17,21,[2,19,24,30],[0,3,10,13,18,28]],
"χρησιμοποιεί": [10,[25,27],15,17,[0,1,14,19,20,24,28]],
"τους": [27,24,10,13,28,2,[15,22],[6,14,21],[7,8,17,18,23,26],[1,5,9,19,20,25]],
"αναλύονται": [27],
"έτοιμη": [2],
"tam": [6],
"tar": [12,15],
"συντμεύσεις": [5,[2,6,29]],
"tat": [6],
"έρθει": [28],
"βόλαπουκ": [6],
"onli": [[12,15]],
"εμπλεκόμενα": [25],
"προορσμούς": [27],
"projectreloadmenuitem": [8],
"χρησιμοποιήστε": [15,[11,16,21]],
"βελτιωμένη": [1],
"κλείσει": [18],
"files": [29],
"στατιστικά": [[28,29]],
"φόρτωση": [[18,28]],
"μετατροπή": [1,[13,18,30]],
"νοιώσετε": [15],
"νήσοι": [6],
"sail": [17],
"πηγές": [[26,27],30,[13,29]],
"καθοδηγείται": [26],
"σημαντική": [[10,15]],
"winrar": [11],
"tbx": [14,30],
"σημαντικά": [10,19,29],
"ματάβαση": [28],
"συνοψισθούν": [2],
"λάθη": [10,[0,16]],
"υπολογισμούς": [28],
"κωδικούς": [6,[27,30],[24,25],[5,18,19,29]],
"can": [12,[19,23]],
"χάνετε": [14],
"cat": [10,3,[6,27,28]],
"συμπεριφοα": [15],
"εγκαταστάτη": [25],
"duser.countri": [15],
"tcl": [26],
"provid": [12],
"tck": [26],
"τροποποιήστε": [8],
"υπολογισμού": [28],
"υπεύθυνος": [2],
"readm": [15],
"πρόθεμα": [26,27],
"πηγής": [18,30,[13,15,17,21]],
"συνηδοτηποιήσετε": [2],
"κουμπιά": [28,23],
"match": [26,[12,18,23,27,30],[13,16]],
"categori": [22],
"κόγκο": [6],
"tajik": [6],
"ισχυρότερους": [22],
"επιτρέπουν": [28,[14,15,24]],
"typo3": [13],
"align.tmx": [15,19],
"εμφανισθεί": [15,[2,18],[17,24,28]],
"υπάρχον": [14]
};
