/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.stardict;

import io.github.eb4j.stardict.DictionaryData;
import io.github.eb4j.stardict.IndexEntry;
import java.util.ArrayList;
import java.util.List;
import org.trie4j.MapTrie;
import org.trie4j.patricia.MapPatriciaTrie;

final class DictionaryDataBuilder<T> {
    private final MapTrie<Object> mapPatriciaTrie = new MapPatriciaTrie();
    private final List<String> keys = new ArrayList<String>();

    DictionaryDataBuilder() {
    }

    public DictionaryData<T> build() {
        return new DictionaryData(this.mapPatriciaTrie);
    }

    public void add(String key, IndexEntry entry) {
        this.keys.add(key);
        Object[] stored = this.mapPatriciaTrie.get(key);
        if (stored == null) {
            this.mapPatriciaTrie.insert(key, (Object)entry);
        } else {
            stored = stored instanceof Object[] ? this.extendArray(stored, entry) : new Object[]{stored, entry};
            this.mapPatriciaTrie.put(key, (Object)stored);
        }
    }

    public void addSynonym(String key, int index) {
        String ref = this.keys.get(index);
        Object stored = this.mapPatriciaTrie.get(key);
        IndexEntry entry = stored instanceof Object[] ? (IndexEntry)((Object[])stored)[0] : (IndexEntry)stored;
        this.add(ref, entry);
    }

    Object[] extendArray(Object[] array, Object value) {
        Object[] newArray = new Object[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }
}

