/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.io.File;
import java.util.ArrayList;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.madlonkay.supertmxmerge.SuperTmxMerge;
import org.madlonkay.supertmxmerge.util.LocString;

public class Main {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "SuperTMXMerge");
        }
        catch (UnsupportedLookAndFeelException ex) {
            throw new RuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        try {
            if (args.length == 0) {
                SuperTmxMerge.promptForFiles();
                return;
            }
            if ("--combine".equals(args[0])) {
                int i;
                ArrayList<File> files = new ArrayList<File>();
                File outputFile = null;
                for (i = 1; i < args.length && !"-o".equals(args[i]); ++i) {
                    File file = new File(args[i]);
                    if (files.contains(file)) continue;
                    files.add(file);
                }
                if (i < args.length - 1) {
                    outputFile = new File(args[i + 1]);
                }
                SuperTmxMerge.combineTo(outputFile, files.toArray(new File[0]));
                return;
            }
            if (args.length == 2) {
                SuperTmxMerge.diff(new File(args[0]), new File(args[1]));
                return;
            }
            if (args.length == 3) {
                SuperTmxMerge.merge(new File(args[0]), new File(args[1]), new File(args[2]));
                return;
            }
            if (args.length == 4) {
                if (args[2].equals("-o")) {
                    SuperTmxMerge.diffTo(new File(args[0]), new File(args[1]), new File(args[3]));
                    return;
                }
                SuperTmxMerge.mergeTo(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]));
                return;
            }
            Main.printUsage();
        }
        catch (Exception ex) {
            System.err.println(ex.getLocalizedMessage());
        }
    }

    private static void printUsage() {
        System.out.print(LocString.get("STM_USAGE_DIRECTIONS"));
    }
}

