/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Window;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.WikiGet;

public class Google2Translate
extends BaseTranslate {
    protected static final String PROPERTY_PREMIUM_KEY = "google.api.premium";
    protected static final String PROPERTY_API_KEY = "google.api.key";
    protected static final String GT_URL = "https://translation.googleapis.com/language/translate/v2";
    protected static final Pattern RE_HTML = Pattern.compile("&#([0-9]+);");

    @Override
    protected String getPreferenceName() {
        return "allow_google2_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_GOOGLE2");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String v;
        String trText = text.length() > 5000 ? text.substring(0, 4997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, trText);
        if (prev != null) {
            return prev;
        }
        String targetLang = tLang.getLanguageCode();
        if (tLang.getLanguage().compareToIgnoreCase("zh-cn") == 0 || tLang.getLanguage().compareToIgnoreCase("zh-tw") == 0) {
            targetLang = tLang.getLanguage();
        } else if (tLang.getLanguage().compareToIgnoreCase("zh-hk") == 0) {
            targetLang = "ZH-TW";
        }
        String googleKey = this.getCredential(PROPERTY_API_KEY);
        if (googleKey == null || googleKey.isEmpty()) {
            return OStrings.getString("GOOGLE_API_KEY_NOTFOUND");
        }
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.isPremium()) {
            params.put("model", "nmt");
        }
        params.put("key", googleKey);
        params.put("source", sLang.getLanguageCode());
        params.put("target", targetLang);
        params.put("q", trText);
        params.put("format", "html");
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("X-HTTP-Method-Override", "GET");
        try {
            v = WikiGet.post(GT_URL, params, headers);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        String tr = this.getJsonResults(v);
        if (tr == null) {
            return "";
        }
        tr = this.unescapeHTML(tr);
        tr = this.cleanSpacesAroundTags(tr, trText);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }

    private String unescapeHTML(String text) {
        text = text.replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        Matcher m = RE_HTML.matcher(text);
        while (m.find()) {
            String g = m.group();
            int codePoint = Integer.parseInt(m.group(1));
            String cpString = String.valueOf(Character.toChars(codePoint));
            text = text.replace(g, cpString);
        }
        return text;
    }

    protected String getJsonResults(String json) {
        Map rootNode;
        try {
            rootNode = (Map)JsonParser.parse(json);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_JSON_ERROR");
        }
        try {
            Map dataNode = (Map)rootNode.get("data");
            List translationsList = (List)dataNode.get("translations");
            Map translationNode = (Map)translationsList.get(0);
            return (String)translationNode.get("translatedText");
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private boolean isPremium() {
        String value = System.getProperty(PROPERTY_PREMIUM_KEY, Preferences.getPreference(PROPERTY_PREMIUM_KEY));
        return Boolean.parseBoolean(value);
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        final JCheckBox premiumCheckBox = new JCheckBox(OStrings.getString("MT_ENGINE_GOOGLE2_PREMIUM_LABEL"));
        premiumCheckBox.setSelected(this.isPremium());
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                String key = this.panel.valueField1.getText().trim();
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                Google2Translate.this.setCredential(Google2Translate.PROPERTY_API_KEY, key, temporary);
                System.setProperty(Google2Translate.PROPERTY_PREMIUM_KEY, Boolean.toString(premiumCheckBox.isSelected()));
                Preferences.setPreference(Google2Translate.PROPERTY_PREMIUM_KEY, premiumCheckBox.isSelected());
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_GOOGLE2_API_KEY_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_API_KEY));
        dialog.panel.valueLabel2.setVisible(false);
        dialog.panel.valueField2.setVisible(false);
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_API_KEY));
        dialog.panel.itemsPanel.add(premiumCheckBox);
        dialog.show();
    }
}

