/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnMarkReplaced;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgMarkReplaced
extends SvnNgOperationRunner<Void, SvnMarkReplaced> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        for (SvnTarget target : ((SvnMarkReplaced)this.getOperation()).getTargets()) {
            File path = target.getFile();
            File lock = this.getWcContext().acquireWriteLock(path, true, true);
            try {
                ISVNWCDb db = context.getDb();
                SVNWCContext.ScheduleInternalInfo schedule = context.getNodeScheduleInternal(path, true, false);
                boolean alreadyReplaced = schedule.schedule == SVNWCContext.SVNWCSchedule.replace;
                if (alreadyReplaced) continue;
                this.doReplace(db, path);
            }
            finally {
                this.getWcContext().releaseWriteLock(lock);
            }
        }
        return null;
    }

    private ISVNWCDb.SVNWCDbKind getKind(ISVNWCDb db, File path) throws SVNException {
        Structure<StructureFields.NodeInfo> info = db.readInfo(path, StructureFields.NodeInfo.kind);
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.NodeInfo.kind));
        info.release();
        return kind;
    }

    private void doReplace(ISVNWCDb db, File path) throws SVNException {
        if (db.isWCRoot(path)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "''{0}'' is the root of a working copy and cannot be replaced", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        List<File> deletedPaths = this.markDeletedRecursively(db, path);
        Collections.sort(deletedPaths);
        for (File deletedPath : deletedPaths) {
            this.markAdded(db, deletedPath);
        }
    }

    private void markAdded(ISVNWCDb db, File path) throws SVNException {
        ISVNWCDb.SVNWCDbKind kind = this.getKind(db, path);
        if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
            db.opAddDirectory(path, null, null);
        } else if (kind == ISVNWCDb.SVNWCDbKind.File) {
            db.opAddFile(path, null, null);
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(path, kind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, null, -1L, SVNEventAction.ADD, SVNEventAction.ADD, null, null, 1L, 1L);
        this.handleEvent(event);
    }

    private List<File> markDeletedRecursively(ISVNWCDb db, File path) throws SVNException {
        final ArrayList<File> deletedPaths = new ArrayList<File>();
        final ISVNEventHandler eventHandler = ((SvnMarkReplaced)this.getOperation()).getEventHandler();
        db.opDelete(path, null, true, null, null, new ISVNEventHandler(){

            @Override
            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                if (event != null && event.getAction() == SVNEventAction.DELETE) {
                    deletedPaths.add(event.getFile());
                }
                if (eventHandler != null) {
                    eventHandler.handleEvent(event, progress);
                }
            }

            @Override
            public void checkCancelled() throws SVNCancelException {
                if (eventHandler != null) {
                    eventHandler.checkCancelled();
                }
            }
        });
        return deletedPaths;
    }
}

