/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.EncodingDetector;
import org.omegat.util.StringUtil;

public final class GlossaryReaderTSV {
    private GlossaryReaderTSV() {
    }

    public static String getFileEncoding(File file) throws IOException {
        return GlossaryReaderTSV.getFileEncoding(file, Charset.defaultCharset().name());
    }

    public static String getFileEncoding(File file, String defaultEncoding) throws IOException {
        String fnameLower = file.getName().toLowerCase(Locale.ENGLISH);
        if (fnameLower.endsWith(".utf8")) {
            return StandardCharsets.UTF_8.name();
        }
        return EncodingDetector.detectEncodingDefault(file, defaultEncoding);
    }

    public static List<GlossaryEntry> read(File file, boolean priorityGlossary) throws IOException {
        String encoding = GlossaryReaderTSV.getFileEncoding(file);
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));){
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                if (!s.startsWith("#")) {
                    String[] tokens = s.split("\t");
                    for (int i = 0; i < tokens.length; ++i) {
                        tokens[i] = tokens[i].trim();
                    }
                    if (tokens.length >= 2 && !tokens[0].isEmpty()) {
                        String comment = "";
                        if (tokens.length >= 3) {
                            comment = tokens[2];
                        }
                        result.add(new GlossaryEntry(tokens[0], tokens[1], comment, priorityGlossary, file.getPath()));
                    }
                }
                s = in.readLine();
            }
        }
        return result;
    }

    public static synchronized void append(File file, GlossaryEntry newEntry) throws IOException {
        String encoding = StandardCharsets.UTF_8.name();
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        } else {
            encoding = GlossaryReaderTSV.getFileEncoding(file, StandardCharsets.UTF_8.name());
        }
        try (OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), encoding);){
            ((Writer)wr).append(newEntry.getSrcText()).append('\t').append(newEntry.getLocText());
            if (!StringUtil.isEmpty(newEntry.getCommentText())) {
                wr.append('\t').append(newEntry.getCommentText());
            }
            ((Writer)wr).append(System.lineSeparator());
        }
    }
}

