/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Toolkit;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.omegat.core.Core;
import org.omegat.gui.search.SearchWindowController;
import org.omegat.gui.shortcuts.PropertiesShortcuts;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.openide.awt.Mnemonics;

public class SearchWindowMenu
extends JMenuBar {
    private final SearchWindowController controller;

    public SearchWindowMenu(SearchWindowController controller) {
        this.controller = controller;
        this.init();
    }

    private void init() {
        JMenu fileMenu = this.add(new JMenu());
        Mnemonics.setLocalizedText((AbstractButton)fileMenu, (String)OStrings.getString("SW_FILE_MENU"));
        JMenuItem item = fileMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SW_FILE_MENU_SELECT_SEARCH_FIELD"));
        item.setActionCommand("editFindInProjectMenuItem");
        item.addActionListener(e -> {
            String selection = this.controller.getViewerSelection();
            if (!StringUtil.isEmpty(selection)) {
                this.controller.setSearchText(selection);
            }
            this.controller.focusSearchField();
        });
        item = fileMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SW_FILE_MENU_CLOSE"));
        item.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(e -> this.controller.doCancel());
        JMenu editMenu = this.add(new JMenu());
        Mnemonics.setLocalizedText((AbstractButton)editMenu, (String)OStrings.getString("SW_EDIT_MENU"));
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("TF_MENU_EDIT_SOURCE_INSERT"));
        item.setActionCommand("editInsertSourceMenuItem");
        item.addActionListener(e -> this.controller.insertIntoActiveField(Core.getEditor().getCurrentEntry().getSrcText()));
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("TF_MENU_EDIT_SOURCE_OVERWRITE"));
        item.setActionCommand("editOverwriteSourceMenuItem");
        item.addActionListener(e -> this.controller.replaceCurrentFieldText(Core.getEditor().getCurrentEntry().getSrcText()));
        editMenu.addSeparator();
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("TF_MENU_EDIT_CREATE_GLOSSARY_ENTRY"));
        item.setActionCommand("editCreateGlossaryEntryMenuItem");
        item.addActionListener(e -> Core.getGlossary().showCreateGlossaryEntryDialog(this.controller.getWindow()));
        editMenu.addSeparator();
        item = editMenu.add(new JMenuItem());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)OStrings.getString("SW_EDIT_MENU_RESET_OPTIONS"));
        item.addActionListener(e -> this.controller.resetOptions());
        PropertiesShortcuts.getMainMenuShortcuts().bindKeyStrokes(this);
    }
}

