/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import gen.core.tbx.Descrip;
import gen.core.tbx.DescripGrp;
import gen.core.tbx.Hi;
import gen.core.tbx.LangSet;
import gen.core.tbx.Martif;
import gen.core.tbx.Note;
import gen.core.tbx.Ntig;
import gen.core.tbx.TermEntry;
import gen.core.tbx.TermNote;
import gen.core.tbx.Tig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.omegat.core.Core;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public final class GlossaryReaderTBX {
    protected static final JAXBContext TBX_CONTEXT;
    static final SAXParserFactory SAX_FACTORY;

    private GlossaryReaderTBX() {
    }

    public static List<GlossaryEntry> read(File file, boolean priorityGlossary) throws Exception {
        Martif tbx = GlossaryReaderTBX.load(file);
        return GlossaryReaderTBX.readMartif(tbx, priorityGlossary, file.getPath());
    }

    public static List<GlossaryEntry> read(String data, boolean priorityGlossary, String origin) throws Exception {
        Martif tbx = GlossaryReaderTBX.loadFromString(data);
        return GlossaryReaderTBX.readMartif(tbx, priorityGlossary, origin);
    }

    public static List<GlossaryEntry> readMartif(Martif tbx, boolean priorityGlossary, String origin) throws Exception {
        if (tbx.getText() == null) {
            return Collections.emptyList();
        }
        String sLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String tLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        StringBuilder note = new StringBuilder();
        StringBuilder descTerm = new StringBuilder();
        StringBuilder descTig = new StringBuilder();
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        ArrayList<String> sTerms = new ArrayList<String>();
        ArrayList<String> tTerms = new ArrayList<String>();
        for (TermEntry te : tbx.getText().getBody().getTermEntry()) {
            note.setLength(0);
            descTerm.setLength(0);
            descTig.setLength(0);
            GlossaryReaderTBX.appendDescOrNote(te.getDescripOrDescripGrpOrAdmin(), descTerm);
            for (LangSet ls : te.getLangSet()) {
                Language termLanguage = new Language(ls.getLang());
                String lang = termLanguage.getLanguageCode();
                GlossaryReaderTBX.appendDescOrNote(ls.getDescripOrDescripGrpOrAdmin(), descTig);
                for (Object o : ls.getTigOrNtig()) {
                    if (o instanceof Tig) {
                        Tig t = (Tig)o;
                        if (sLang.equalsIgnoreCase(lang)) {
                            sTerms.add(GlossaryReaderTBX.readContent(t.getTerm().getContent()));
                        } else if (tLang.equalsIgnoreCase(lang)) {
                            tTerms.add(GlossaryReaderTBX.readContent(t.getTerm().getContent()));
                            GlossaryReaderTBX.appendDescOrNote(t.getTermNote(), note);
                        }
                        GlossaryReaderTBX.appendDescOrNote(t.getDescripOrDescripGrpOrAdmin(), descTig);
                        continue;
                    }
                    if (!(o instanceof Ntig)) continue;
                    Ntig n = (Ntig)o;
                    if (sLang.equalsIgnoreCase(lang)) {
                        sTerms.add(GlossaryReaderTBX.readContent(n.getTermGrp().getTerm().getContent()));
                    } else if (tLang.equalsIgnoreCase(lang)) {
                        tTerms.add(GlossaryReaderTBX.readContent(n.getTermGrp().getTerm().getContent()));
                        GlossaryReaderTBX.appendDescOrNote(n.getTermGrp().getTermNoteOrTermNoteGrp(), note);
                    }
                    GlossaryReaderTBX.appendDescOrNote(n.getDescripOrDescripGrpOrAdmin(), descTig);
                }
            }
            StringBuilder comment = new StringBuilder();
            GlossaryReaderTBX.appendLine(comment, descTerm.toString());
            GlossaryReaderTBX.appendLine(comment, descTig.toString());
            GlossaryReaderTBX.appendLine(comment, note.toString());
            for (String s : sTerms) {
                boolean addedForLang = false;
                for (String t : tTerms) {
                    result.add(new GlossaryEntry(s, t, comment.toString(), priorityGlossary, origin));
                    addedForLang = true;
                }
                if (addedForLang) continue;
                result.add(new GlossaryEntry(s, "", comment.toString(), priorityGlossary, origin));
            }
            sTerms.clear();
            tTerms.clear();
        }
        return result;
    }

    protected static void appendDescOrNote(List<?> list, StringBuilder str) {
        for (Object o : list) {
            String line = null;
            if (o instanceof Descrip) {
                Descrip d = (Descrip)o;
                if ("context".equalsIgnoreCase(d.getType())) {
                    if (Preferences.isPreferenceDefault("glossary_tbx_display_context", true)) {
                        line = d.getType() + ": " + GlossaryReaderTBX.readContent(d.getContent());
                    }
                } else {
                    line = d.getType() + ": " + GlossaryReaderTBX.readContent(d.getContent());
                }
            } else if (o instanceof DescripGrp) {
                DescripGrp dg = (DescripGrp)o;
                if (dg.getDescrip() != null) {
                    if ("context".equalsIgnoreCase(dg.getDescrip().getType())) {
                        if (Preferences.isPreferenceDefault("glossary_tbx_display_context", true)) {
                            line = dg.getDescrip().getType() + ": " + GlossaryReaderTBX.readContent(dg.getDescrip().getContent());
                        }
                    } else {
                        line = dg.getDescrip().getType() + ": " + GlossaryReaderTBX.readContent(dg.getDescrip().getContent());
                    }
                }
            } else if (o instanceof TermNote) {
                TermNote tn = (TermNote)o;
                line = GlossaryReaderTBX.readContent(tn.getContent());
            } else if (o instanceof Note) {
                Note n = (Note)o;
                line = GlossaryReaderTBX.readContent(n.getContent());
            }
            if (line == null) continue;
            GlossaryReaderTBX.appendLine(str, line);
        }
    }

    protected static void appendLine(StringBuilder str, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (str.length() > 0) {
            str.append('\n');
        }
        str.append(line);
    }

    protected static String readContent(List<Object> content) {
        StringBuilder res = new StringBuilder();
        for (Object o : content) {
            if (o instanceof Hi) {
                Hi hi = (Hi)o;
                res.append(" *").append(hi.getContent()).append("* ");
                continue;
            }
            res.append(o.toString());
        }
        return res.toString();
    }

    static Martif load(File f) throws Exception {
        Unmarshaller unm = TBX_CONTEXT.createUnmarshaller();
        SAXParser parser = SAX_FACTORY.newSAXParser();
        NamespaceFilter xmlFilter = new NamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unm.getUnmarshallerHandler());
        try (FileInputStream in = new FileInputStream(f);){
            SAXSource source = new SAXSource(xmlFilter, new InputSource(in));
            Martif martif = (Martif)unm.unmarshal((Source)source);
            return martif;
        }
    }

    static Martif loadFromString(String data) throws Exception {
        Unmarshaller unm = TBX_CONTEXT.createUnmarshaller();
        SAXParser parser = SAX_FACTORY.newSAXParser();
        NamespaceFilter xmlFilter = new NamespaceFilter(parser.getXMLReader());
        xmlFilter.setContentHandler((ContentHandler)unm.getUnmarshallerHandler());
        try (StringReader in = new StringReader(data);){
            SAXSource source = new SAXSource(xmlFilter, new InputSource(in));
            Martif martif = (Martif)unm.unmarshal((Source)source);
            return martif;
        }
    }

    static {
        try {
            TBX_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Martif.class});
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(OStrings.getString("STARTUP_JAXB_LINKAGE_ERROR"));
        }
        SAX_FACTORY = SAXParserFactory.newInstance();
        SAX_FACTORY.setNamespaceAware(true);
        SAX_FACTORY.setValidating(false);
    }

    public static class NamespaceFilter
    extends XMLFilterImpl {
        private static final InputSource EMPTY_INPUT_SOURCE = new InputSource(new ByteArrayInputStream(new byte[0]));

        public NamespaceFilter(XMLReader xmlReader) {
            super(xmlReader);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return EMPTY_INPUT_SOURCE;
        }
    }
}

