/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.MTConfigDialog;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.WikiGet;

public class IBMWatsonTranslate
extends BaseTranslate {
    protected static final String PROPERTY_LOGIN = "ibmwatson.api.login";
    protected static final String PROPERTY_PASSWORD = "ibmwatson.api.password";
    protected static final String PROPERTY_MODEL = "ibmwatson.api.model";
    protected static final String PROPERTY_URL = "ibmwatson.api.url";
    protected static final String WATSON_URL = "https://gateway.watsonplatform.net/language-translator/api/v3/translate";
    protected static final String WATSON_VERSION = "2018-05-01";
    protected static final Pattern RE_HTML = Pattern.compile("&#([0-9]+);");

    @Override
    protected String getPreferenceName() {
        return "allow_ibmwatson_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_IBMWATSON");
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        String v;
        String trText = text.length() > 5000 ? text.substring(0, 4997) + "..." : text;
        String prev = this.getFromCache(sLang, tLang, trText);
        if (prev != null) {
            return prev;
        }
        String apiLogin = this.getCredential(PROPERTY_LOGIN);
        String apiPassword = this.getCredential(PROPERTY_PASSWORD);
        if (apiLogin == null || apiLogin.isEmpty()) {
            return OStrings.getString("IBMWATSON_API_KEY_NOTFOUND");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            apiPassword = apiLogin;
            apiLogin = "apiKey";
        }
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"text\":[" + JsonParser.quote(trText) + "],");
        String modelId = this.getModelId();
        if (modelId != null && !modelId.isEmpty()) {
            json.append("\"model_id\":" + JsonParser.quote(modelId) + ",");
        }
        json.append("\"source\":" + JsonParser.quote(sLang.getLanguageCode().toUpperCase()) + ",");
        json.append("\"target\":" + JsonParser.quote(tLang.getLanguageCode().toUpperCase()) + "}");
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("X-Watson-Learning-Opt-Out", "true");
        String authentication = "Basic " + Base64.getMimeEncoder(-1, new byte[0]).encodeToString((apiLogin + ":" + apiPassword).getBytes(StandardCharsets.ISO_8859_1));
        headers.put("Authorization", authentication);
        headers.put("Accept", "application/json");
        try {
            v = WikiGet.postJSON(this.getWatsonUrl() + "?version=" + WATSON_VERSION, json.toString(), headers);
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        String tr = this.getJsonResults(v);
        if (tr == null) {
            return "";
        }
        tr = this.unescapeHTML(tr);
        tr = this.cleanSpacesAroundTags(tr, trText);
        this.putToCache(sLang, tLang, trText, tr);
        return tr;
    }

    private String getModelId() {
        return System.getProperty(PROPERTY_MODEL, Preferences.getPreference(PROPERTY_MODEL));
    }

    private String getWatsonUrl() {
        String url = System.getProperty(PROPERTY_URL, Preferences.getPreference(PROPERTY_URL));
        if (url == null || url.isEmpty()) {
            url = WATSON_URL;
        }
        return url;
    }

    protected String getJsonResults(String json) {
        Map rootNode;
        try {
            rootNode = (Map)JsonParser.parse(json);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "MT_JSON_ERROR", new Object[0]);
            return OStrings.getString("MT_JSON_ERROR");
        }
        try {
            List translationsList = (List)rootNode.get("translations");
            Map translationNode = (Map)translationsList.get(0);
            return (String)translationNode.get("translation");
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private String unescapeHTML(String text) {
        text = text.replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
        Matcher m = RE_HTML.matcher(text);
        while (m.find()) {
            String g = m.group();
            int codePoint = Integer.parseInt(m.group(1));
            String cpString = String.valueOf(Character.toChars(codePoint));
            text = text.replace(g, cpString);
        }
        return text;
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void showConfigurationUI(Window parent) {
        JPanel watsonPanel = new JPanel();
        watsonPanel.setLayout(new GridBagLayout());
        watsonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        watsonPanel.setAlignmentX(0.0f);
        JLabel iamAuthLabel = new JLabel(OStrings.getString("MT_ENGINE_IBMWATSON_IAM_AUTHENTICATION"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        watsonPanel.add((Component)iamAuthLabel, gridBagConstraints);
        JLabel urlLabel = new JLabel(OStrings.getString("MT_ENGINE_IBMWATSON_URL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        watsonPanel.add((Component)urlLabel, gridBagConstraints);
        final JTextField urlField = new JTextField(Preferences.getPreferenceDefault(PROPERTY_URL, WATSON_URL));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        urlLabel.setLabelFor(urlField);
        watsonPanel.add((Component)urlField, gridBagConstraints);
        JLabel modelIdLabel = new JLabel(OStrings.getString("MT_ENGINE_IBMWATSON_MODELID_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        watsonPanel.add((Component)modelIdLabel, gridBagConstraints);
        final JTextField modelIdField = new JTextField(Preferences.getPreferenceDefault(PROPERTY_MODEL, ""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        modelIdLabel.setLabelFor(modelIdField);
        watsonPanel.add((Component)modelIdField, gridBagConstraints);
        MTConfigDialog dialog = new MTConfigDialog(parent, this.getName()){

            @Override
            protected void onConfirm() {
                boolean temporary = this.panel.temporaryCheckBox.isSelected();
                String login = this.panel.valueField1.getText().trim();
                IBMWatsonTranslate.this.setCredential(IBMWatsonTranslate.PROPERTY_LOGIN, login, temporary);
                String password = this.panel.valueField2.getText().trim();
                IBMWatsonTranslate.this.setCredential(IBMWatsonTranslate.PROPERTY_PASSWORD, password, temporary);
                System.setProperty(IBMWatsonTranslate.PROPERTY_MODEL, modelIdField.getText());
                Preferences.setPreference(IBMWatsonTranslate.PROPERTY_MODEL, modelIdField.getText());
                System.setProperty(IBMWatsonTranslate.PROPERTY_URL, urlField.getText());
                Preferences.setPreference(IBMWatsonTranslate.PROPERTY_URL, urlField.getText());
            }
        };
        dialog.panel.valueLabel1.setText(OStrings.getString("MT_ENGINE_IBMWATSON_LOGIN_LABEL"));
        dialog.panel.valueField1.setText(this.getCredential(PROPERTY_LOGIN));
        dialog.panel.valueLabel2.setText(OStrings.getString("MT_ENGINE_IBMWATSON_PASSWORD_LABEL"));
        dialog.panel.valueField2.setText(this.getCredential(PROPERTY_PASSWORD));
        dialog.panel.temporaryCheckBox.setSelected(this.isCredentialStoredTemporarily(PROPERTY_PASSWORD));
        dialog.panel.itemsPanel.add(watsonPanel);
        dialog.show();
    }
}

