/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.DockerUtils;
import org.netbeans.modules.docker.api.DockerEntityType;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerInstanceEntity;
import org.netbeans.modules.docker.api.DockerTag;

public final class DockerImage
implements DockerInstanceEntity {
    private final DockerInstance instance;
    private final List<DockerTag> tags = new ArrayList<DockerTag>();
    private final String id;
    private final long created;
    private final long size;
    private final long virtualSize;

    DockerImage(DockerInstance instance, List<String> tags, String id, long created, long size, long virtualSize) {
        this.instance = instance;
        this.id = id;
        this.created = created;
        this.size = size;
        this.virtualSize = virtualSize;
        if (tags != null) {
            for (String tag : tags) {
                this.tags.add(new DockerTag(this, tag));
            }
        } else {
            Logger.getLogger(DockerImage.class.getName()).log(Level.INFO, "Null tags for {0}", id);
        }
    }

    @Override
    public DockerInstance getInstance() {
        return this.instance;
    }

    public List<DockerTag> getTags() {
        return this.tags;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getShortId() {
        return DockerUtils.getShortId(this);
    }

    public long getCreated() {
        return this.created;
    }

    public long getSize() {
        return this.size;
    }

    public long getVirtualSize() {
        return this.virtualSize;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.instance);
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockerImage other = (DockerImage)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return Objects.equals(this.instance, other.instance);
    }

    public String toString() {
        return "DockerImage{instance=" + this.instance + ", id=" + this.id + '}';
    }

    @Override
    public DockerEntityType getType() {
        return DockerEntityType.Container;
    }
}

