/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.regex.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.netbeans.modules.java.hints.regex.parser.RegexConstructs;

public class RegExParser {
    private final String input;
    private int pos;
    private int groupNo;
    private HashMap<Integer, RegexConstructs.RegEx> groupMap;
    private HashMap<String, RegexConstructs.RegEx> namedGroupMap;
    private static final char OR = '|';
    private static final char AND = '&';
    private static final char NOT = '^';
    private static final char DASH = '-';
    private static final char DOT = '.';
    private static final char ESCAPE = '\\';
    private static final char COMMA = ',';
    private static final char EQUAL = '=';
    private static final char EXCLM = '!';
    private static final char COLON = ':';
    private static final char OPT = '?';
    private static final char STAR = '*';
    private static final char PLUS = '+';
    private static final char PAR_OP = '(';
    private static final char PAR_CL = ')';
    private static final char CLASS_OP = '[';
    private static final char CLASS_CL = ']';
    private static final char BRAC_OP = '{';
    private static final char BRAC_CL = '}';
    private static final char NAMED_OP = '<';
    private static final char NAMED_CL = '>';
    private static final char QUOT_OP = 'Q';
    private static final char QUOT_CL = 'E';
    private static final char[] DIGIT = "0123456789".toCharArray();
    private static final char[] BOUNDRY_MATCHERS = "bBAGzZ".toCharArray();
    private static final char[] OPEN_LOOP = new char[]{'?', '*', '+', '{'};

    public RegExParser(String input) {
        this.input = input;
        this.pos = 0;
        this.groupNo = 0;
        this.groupMap = new HashMap();
        this.namedGroupMap = new HashMap();
    }

    public RegexConstructs.RegEx parse() {
        if (this.input == null) {
            return null;
        }
        if (this.input.isEmpty()) {
            return new RegexConstructs.Blank();
        }
        return this.regex();
    }

    private char peek() {
        return this.input.charAt(this.pos);
    }

    private void eat(char c) {
        if (this.peek() == c) {
            ++this.pos;
        } else {
            throw new RuntimeException("Expected: " + c + "; got: " + this.peek());
        }
    }

    private char next() {
        char c = this.peek();
        this.eat(c);
        return c;
    }

    private char nextChar() {
        return this.input.charAt(this.pos + 1);
    }

    private boolean nextIn(char[] arr) {
        if (this.more()) {
            char c = this.peek();
            for (char a : arr) {
                if (c != a) continue;
                return true;
            }
        }
        return false;
    }

    private boolean more() {
        return this.pos < this.input.length();
    }

    private RegexConstructs.RegEx regex() {
        RegexConstructs.RegEx term = this.term();
        while (this.more() && this.peek() == '|') {
            this.eat('|');
            term = RegexConstructs.Choice.subChoices(term, this.term());
        }
        return term;
    }

    private RegexConstructs.RegEx term() {
        RegexConstructs.RegEx factor = new RegexConstructs.Blank();
        while (this.more() && this.peek() != ')' && this.peek() != '|') {
            RegexConstructs.RegEx nextFactor = this.factor();
            factor = new RegexConstructs.Sequence(factor, nextFactor);
        }
        factor = this.flatten(factor);
        return factor;
    }

    private RegexConstructs.RegEx factor() {
        RegexConstructs.RegEx base = this.base();
        while (this.more() && this.nextIn(OPEN_LOOP)) {
            switch (this.peek()) {
                case '+': {
                    base = new RegexConstructs.OneOrMore(base);
                    this.eat('+');
                    if (this.more() && this.peek() == '?') {
                        this.eat('?');
                        break;
                    }
                    if (!this.more() || this.peek() != '+') break;
                    this.eat('+');
                    break;
                }
                case '*': {
                    base = new RegexConstructs.Repetition(base);
                    this.eat('*');
                    if (this.more() && this.peek() == '?') {
                        this.eat('?');
                        break;
                    }
                    if (!this.more() || this.peek() != '+') break;
                    this.eat('+');
                    break;
                }
                case '?': {
                    base = new RegexConstructs.Optional(base);
                    this.eat('?');
                    if (this.more() && this.peek() == '?') {
                        this.eat('?');
                        break;
                    }
                    if (!this.more() || this.peek() != '+') break;
                    this.eat('+');
                    break;
                }
                case '{': {
                    base = this.greedyBound(base);
                }
            }
        }
        return base;
    }

    private RegexConstructs.RegEx base() {
        switch (this.peek()) {
            case '[': {
                this.eat('[');
                RegexConstructs.RegEx c = this.charClass(false);
                this.eat(']');
                return c;
            }
            case '(': {
                return this.handleParenthesis();
            }
            case '\\': {
                return this.handleEscape();
            }
            case '.': {
                this.eat('.');
                return new RegexConstructs.AnyChar();
            }
            case '^': {
                this.eat('^');
                return new RegexConstructs.Blank();
            }
            case '$': {
                this.eat('$');
                return new RegexConstructs.Blank();
            }
        }
        return new RegexConstructs.Primitive(this.next());
    }

    private RegexConstructs.RegEx handleParenthesis() {
        this.eat('(');
        ++this.groupNo;
        RegexConstructs.Group r = null;
        if (this.peek() == '?') {
            this.next();
            StringBuilder name = new StringBuilder();
            block0 : switch (this.peek()) {
                case '<': {
                    this.next();
                    switch (this.peek()) {
                        case '=': {
                            this.next();
                            r = new RegexConstructs.SpecialConstructGroup(RegexConstructs.GroupType.POSITIVE_LOOKBEHIND, this.regex());
                            break block0;
                        }
                        case '!': {
                            this.next();
                            r = new RegexConstructs.SpecialConstructGroup(RegexConstructs.GroupType.NEGATIVE_LOOKBEHIND, this.regex());
                            break block0;
                        }
                    }
                    while (this.peek() != '>') {
                        name.append(this.next());
                    }
                    this.next();
                    r = new RegexConstructs.NamedGroup(this.groupNo, name.toString(), this.regex(), this);
                    break;
                }
                case '=': {
                    this.next();
                    r = new RegexConstructs.SpecialConstructGroup(RegexConstructs.GroupType.POSITIVE_LOOKAHEAD, this.regex());
                    break;
                }
                case '!': {
                    this.next();
                    r = new RegexConstructs.SpecialConstructGroup(RegexConstructs.GroupType.NEGATIVE_LOOKAHEAD, this.regex());
                    break;
                }
                case ':': {
                    this.next();
                    --this.groupNo;
                    r = new RegexConstructs.SpecialConstructGroup(RegexConstructs.GroupType.NON_CAPTURE_GROUP, this.regex());
                }
            }
        } else {
            r = new RegexConstructs.CapturingGroup(this.groupNo, this.regex(), this);
        }
        this.eat(')');
        return r;
    }

    private RegexConstructs.RegEx handleEscape() throws NumberFormatException, RuntimeException {
        this.eat('\\');
        if (this.nextIn(BOUNDRY_MATCHERS)) {
            this.next();
            return new RegexConstructs.Blank();
        }
        if (this.nextIn(DIGIT)) {
            int parseInt;
            String number = "";
            int n = this.getGroupMap().size();
            while (this.more() && this.nextIn(DIGIT) && (parseInt = Integer.parseInt(String.valueOf(number + this.peek()))) <= n) {
                number = number + this.next();
            }
            int num = Integer.parseInt(String.valueOf(number));
            return this.getGroupMap().get(num);
        }
        char esc = this.next();
        if (esc == 'Q') {
            return this.handleQuotations();
        }
        if (esc == 'p' && this.peek() == '{') {
            StringBuilder s = new StringBuilder();
            this.eat('{');
            while (this.peek() != '}') {
                s.append(this.next());
            }
            this.eat('}');
            return this.handlePosix(s.toString());
        }
        if (esc == 'k' && this.peek() == '<') {
            StringBuilder s = new StringBuilder();
            this.next();
            while (this.peek() != '>') {
                s.append(this.next());
            }
            this.next();
            return this.getNamedGroupMap().get(s.toString());
        }
        if (RegexConstructs.SpecialChar.sChars.containsKey(Character.valueOf(esc))) {
            return RegexConstructs.SpecialChar.sChars.get(Character.valueOf(esc));
        }
        return new RegexConstructs.Primitive(esc);
    }

    private RegexConstructs.RegEx handleQuotations() throws RuntimeException {
        ArrayList<RegexConstructs.RegEx> quotations = new ArrayList<RegexConstructs.RegEx>();
        while (this.peek() != '\\' || this.nextChar() != 'E') {
            char quot = this.next();
            quotations.add(new RegexConstructs.Primitive(quot));
        }
        this.eat('\\');
        this.eat('E');
        if (this.nextIn(OPEN_LOOP)) {
            throw new RuntimeException(this.input + " token not Quantifiable at " + (this.pos - 1));
        }
        return new RegexConstructs.Concat(quotations);
    }

    private RegexConstructs.RegEx charClass(boolean isIntersection) {
        RegexConstructs.CharClass charClass;
        if (this.peek() == '^') {
            this.eat('^');
            charClass = new RegexConstructs.CharClass(true, isIntersection);
        } else {
            charClass = new RegexConstructs.CharClass(false, isIntersection);
        }
        if (this.peek() == ']' || this.peek() == '-') {
            charClass.addToClass(new RegexConstructs.Primitive(this.peek()));
            this.next();
        }
        while (this.peek() != ']') {
            if (this.nextChar() == '-') {
                char from = this.peek();
                this.eat(from);
                this.next();
                if (this.peek() == ']') {
                    charClass.addToClass(new RegexConstructs.Primitive('-'));
                    continue;
                }
                char to = this.peek();
                this.eat(to);
                charClass.addToClass(new RegexConstructs.Range(from, to));
                continue;
            }
            if (this.peek() == '[') {
                this.eat('[');
                RegexConstructs.RegEx c = this.charClass(false);
                this.eat(']');
                charClass.addToClass(c);
                continue;
            }
            if (this.peek() == '&') {
                this.next();
                if (this.peek() == '&') {
                    this.next();
                    if (this.peek() != '[') continue;
                    this.eat('[');
                    RegexConstructs.RegEx c = this.charClass(true);
                    this.eat(']');
                    charClass.addToClass(c);
                    continue;
                }
                charClass.addToClass(new RegexConstructs.Primitive('&'));
                continue;
            }
            if (this.peek() == '\\' && RegexConstructs.SpecialChar.sChars.containsKey(Character.valueOf(this.nextChar()))) {
                this.next();
                charClass.addToClass(RegexConstructs.SpecialChar.sChars.get(Character.valueOf(this.peek())));
                this.next();
                continue;
            }
            charClass.addToClass(new RegexConstructs.Primitive(this.next()));
        }
        return charClass;
    }

    private RegexConstructs.RegEx greedyBound(RegexConstructs.RegEx base) {
        RegexConstructs.GreedyBound gr = new RegexConstructs.GreedyBound(base);
        this.eat('{');
        String number = "";
        while (this.peek() != '}' && this.peek() != ',') {
            number = number + this.next();
        }
        int min = Integer.parseInt(String.valueOf(number));
        gr.setMin(min);
        if (this.peek() == ',') {
            this.eat(',');
            if (this.nextIn(DIGIT)) {
                number = "";
                while (this.peek() != '}') {
                    number = number + this.next();
                }
                gr.setMaxPresent(true);
                int max = Integer.parseInt(String.valueOf(number));
                gr.setMax(max);
            } else {
                gr.setMaxPresent(false);
            }
        } else if (this.peek() == '}') {
            gr.setMaxPresent(true);
            gr.setMax(min);
        }
        this.eat('}');
        return gr;
    }

    private RegexConstructs.RegEx flatten(RegexConstructs.RegEx factor) {
        ArrayList<RegexConstructs.RegEx> flattenedList = new ArrayList<RegexConstructs.RegEx>();
        RegexConstructs.Sequence factorCopy = (RegexConstructs.Sequence)factor;
        while (factorCopy.firstSeq != null && factorCopy.firstSeq instanceof RegexConstructs.Sequence) {
            flattenedList.add(0, factorCopy.secondSeq);
            factorCopy = (RegexConstructs.Sequence)factorCopy.firstSeq;
        }
        flattenedList.add(0, factorCopy.secondSeq);
        if (flattenedList.size() == 1) {
            return (RegexConstructs.RegEx)flattenedList.get(0);
        }
        return new RegexConstructs.Concat(flattenedList);
    }

    private RegexConstructs.Posix handlePosix(String posix) {
        RegexConstructs.Posix posixClass = new RegexConstructs.Posix(posix, false, false);
        switch (posix) {
            case "Lower": {
                posixClass.addToClass(new RegexConstructs.Range('a', 'z'));
                break;
            }
            case "Upper": {
                posixClass.addToClass(new RegexConstructs.Range('A', 'Z'));
                break;
            }
            case "ASCII": {
                posixClass.addToClass(new RegexConstructs.Range('\u0000', '\u007f'));
                break;
            }
            case "Alpha": {
                posixClass.addToClass(this.handlePosix("Lower"), this.handlePosix("Upper"));
                break;
            }
            case "Digit": {
                posixClass.addToClass(new RegexConstructs.Range('0', '9'));
                break;
            }
            case "Alnum": {
                posixClass.addToClass(this.handlePosix("Alpha"), this.handlePosix("Digit"));
                break;
            }
            case "Punct": {
                String punctuations = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
                for (int i = 0; i < punctuations.length(); ++i) {
                    posixClass.addToClass(new RegexConstructs.Primitive(punctuations.charAt(i)));
                }
                break;
            }
            case "Graph": {
                posixClass.addToClass(this.handlePosix("Alnum"), this.handlePosix("Punct"));
                break;
            }
            case "Print": {
                posixClass.addToClass(this.handlePosix("Graph"), new RegexConstructs.Primitive(' '));
                break;
            }
            case "Blank": {
                posixClass.addToClass(new RegexConstructs.Primitive(' '), new RegexConstructs.Primitive('\t'));
                break;
            }
            case "Cntrl": {
                posixClass.addToClass(new RegexConstructs.Range('\u0000', '\u001f'), new RegexConstructs.Primitive('\u007f'));
                break;
            }
            case "XDigit": {
                posixClass.addToClass(new RegexConstructs.Range('0', '9'), new RegexConstructs.Range('a', 'f'), new RegexConstructs.Range('A', 'F'));
                break;
            }
            case "Space": {
                posixClass.addToClass(new RegexConstructs.Primitive(' '), new RegexConstructs.Primitive('\t'), new RegexConstructs.Primitive('\n'), new RegexConstructs.Primitive('\u000b'), new RegexConstructs.Primitive('\f'), new RegexConstructs.Primitive('\r'));
                break;
            }
        }
        return posixClass;
    }

    public HashMap<String, RegexConstructs.RegEx> getNamedGroupMap() {
        return this.namedGroupMap;
    }

    public void setNamedGroupMap(HashMap<String, RegexConstructs.RegEx> namedGroupMap) {
        this.namedGroupMap = namedGroupMap;
    }

    public HashMap<Integer, RegexConstructs.RegEx> getGroupMap() {
        return this.groupMap;
    }

    public void setGroupMap(HashMap<Integer, RegexConstructs.RegEx> groupMap) {
        this.groupMap = groupMap;
    }
}

