/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class J2SELibraryClassPathProvider
implements ClassPathProvider {
    private static final Set<? extends String> SUPPORTED_CLASS_PATH_TYPES = new HashSet<String>(Arrays.asList("classpath/source", "classpath/boot", "classpath/compile", "modules/boot"));
    private FileObject lastUsedRoot;
    private Library lastUsedLibrary;
    private Reference<FileObject> lastUsedFile;
    private URL lastUsedFileURL;

    public ClassPath findClassPath(@NonNull FileObject file, @NonNull String type) {
        assert (file != null);
        if (!SUPPORTED_CLASS_PATH_TYPES.contains(type)) {
            return null;
        }
        Library ll = this.getLastUsedLibrary(file);
        if (ll != null) {
            ClassPath[] cp = this.findClassPathOrNull(file, type, ll);
            return cp != null ? cp[0] : null;
        }
        for (LibraryManager mgr : LibraryManager.getOpenManagers()) {
            for (Library lib : mgr.getLibraries()) {
                ClassPath[] cp = this.findClassPathOrNull(file, type, lib);
                if (cp == null) continue;
                return cp[0];
            }
        }
        return null;
    }

    private ClassPath[] findClassPathOrNull(@NonNull FileObject file, @NonNull String type, @NonNull Library lib) {
        if (lib.getType().equals("j2se")) {
            List resources = lib.getContent("src");
            try {
                FileObject root = this.getOwnerRoot(file, resources);
                if (root != null) {
                    JavaPlatform defPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
                    this.setLastUsedLibrary(root, lib);
                    if ("classpath/source".equals(type)) {
                        return new ClassPath[]{ClassPathSupport.createClassPath((URL[])resources.toArray(new URL[resources.size()]))};
                    }
                    if ("classpath/compile".equals(type)) {
                        resources = lib.getContent("classpath");
                        return new ClassPath[]{ClassPathSupport.createClassPath((URL[])resources.toArray(new URL[resources.size()]))};
                    }
                    if ("classpath/boot".equals(type)) {
                        return new ClassPath[]{defPlatform.getBootstrapLibraries()};
                    }
                    if ("modules/boot".equals(type) && Util.JDK9.compareTo(defPlatform.getSpecification().getVersion()) <= 0) {
                        return new ClassPath[]{defPlatform.getBootstrapLibraries()};
                    }
                    return new ClassPath[]{null};
                }
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException ne = new IllegalArgumentException("LibraryImplementation:[" + J2SELibraryClassPathProvider.getImplClassName(lib) + "] returned wrong root:" + e.getMessage());
                Exceptions.printStackTrace((Throwable)ne.initCause(e));
            }
        }
        return null;
    }

    private FileObject getOwnerRoot(@NonNull FileObject fo, @NonNull List<? extends URL> roots) {
        URL foURL = this.toURL(fo);
        if (foURL == null) {
            return null;
        }
        URL archiveFileURL = FileUtil.getArchiveFile((URL)foURL);
        boolean isInArchive = archiveFileURL != null;
        FileObject ownerFo = isInArchive ? URLMapper.findFileObject((URL)archiveFileURL) : null;
        HashSet<FileObject> candidates = new HashSet<FileObject>();
        for (URL uRL : roots) {
            FileObject rootFo;
            if ("jar".equals(uRL.getProtocol())) {
                FileObject rootFo2;
                FileObject rootFileFo;
                URL rootFileUrl;
                if (!isInArchive || ownerFo == null || (rootFileUrl = FileUtil.getArchiveFile((URL)uRL)) == null || !ownerFo.equals(rootFileFo = URLMapper.findFileObject((URL)rootFileUrl)) || (rootFo2 = URLMapper.findFileObject((URL)uRL)) == null) continue;
                candidates.add(rootFo2);
                continue;
            }
            if (isInArchive || (rootFo = URLMapper.findFileObject((URL)uRL)) == null) continue;
            candidates.add(rootFo);
        }
        return candidates.isEmpty() ? null : J2SELibraryClassPathProvider.findOwnerRoot(fo, candidates);
    }

    private static FileObject findOwnerRoot(FileObject resource, Set<? extends FileObject> roots) {
        for (FileObject f = resource; f != null; f = f.getParent()) {
            if (!roots.contains(f)) continue;
            return f;
        }
        return null;
    }

    private static String getImplClassName(Library lib) {
        String result = "";
        try {
            Class<?> cls = lib.getClass();
            Field fld = cls.getDeclaredField("impl");
            if (fld != null) {
                fld.setAccessible(true);
                Object res = fld.get(lib);
                if (res != null) {
                    result = res.getClass().getName();
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return result;
    }

    private synchronized Library getLastUsedLibrary(FileObject fo) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)fo)) {
            return this.lastUsedLibrary;
        }
        return null;
    }

    private synchronized void setLastUsedLibrary(FileObject root, Library lib) {
        this.lastUsedRoot = root;
        this.lastUsedLibrary = lib;
    }

    private synchronized URL toURL(@NonNull FileObject file) {
        FileObject luw;
        FileObject fileObject = luw = this.lastUsedFile == null ? null : this.lastUsedFile.get();
        if (luw != file) {
            this.lastUsedFileURL = URLMapper.findURL((FileObject)file, (int)1);
            this.lastUsedFile = new WeakReference<FileObject>(file);
        }
        return this.lastUsedFileURL;
    }
}

