/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.html.editor.api.gsf.HtmlErrorFilterContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.PositionRange;
import org.netbeans.modules.web.jsf.editor.hints.FixLibDeclaration;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.NamespaceUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LibraryDeclarationChecker
extends HintsProvider {
    private static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Logger LOG = Logger.getLogger(LibraryDeclarationChecker.class.getName());

    @Override
    public List<Hint> compute(RuleContext context) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        this.checkLibraryDeclarations(hints, context);
        return hints;
    }

    private void checkLibraryDeclarations(final List<Hint> hints, final RuleContext context) {
        final HtmlParserResult result = (HtmlParserResult)context.parserResult;
        final Snapshot snapshot = result.getSnapshot();
        int errorType = 0;
        if (context instanceof HtmlErrorFilterContext) {
            errorType = ((HtmlErrorFilterContext)context).isOnlyBadging() ? 2 : 1;
        }
        Set declaredNamespaces = result.getNamespaces().keySet();
        ArrayList<Library> declaredLibraries = new ArrayList<Library>();
        JsfSupportImpl jsfSupport = JsfSupportImpl.findFor(context.parserResult.getSnapshot().getSource());
        Map<Object, Object> libs = Collections.emptyMap();
        if (jsfSupport != null) {
            libs = jsfSupport.getLibraries();
        }
        final HashMap<String, Attribute> namespace2Attribute = new HashMap<String, Attribute>();
        Node root = result.root();
        if (root.children().isEmpty()) {
            root = DefaultLibraryInfo.FACELETS.getValidNamespaces().stream().filter(Predicate.not(DefaultLibraryInfo.FACELETS.getNamespace()::equals)).map(arg_0 -> ((HtmlParserResult)result).root(arg_0)).filter(Objects::nonNull).filter(node -> node.children().isEmpty()).findFirst().orElse(result.root(DefaultLibraryInfo.FACELETS.getNamespace()));
        }
        final CharSequence docText = LibraryDeclarationChecker.getSourceText(snapshot.getSource());
        final String jsfNsPrefix = (String)NamespaceUtils.getForNs((Map)result.getNamespaces(), (String)DefaultLibraryInfo.JSF.getNamespace());
        final String passthroughNsPrefix = (String)NamespaceUtils.getForNs((Map)result.getNamespaces(), (String)DefaultLibraryInfo.PASSTHROUGH.getNamespace());
        final boolean[] jsfUsage = new boolean[1];
        final ArrayList wrongJsfNsUsages = new ArrayList();
        ElementVisitor prefixCollector = new ElementVisitor(){

            public void visit(Element node) {
                OpenTag openTag = (OpenTag)node;
                Collection nsAttrs = openTag.attributes(attribute -> {
                    if (attribute.unquotedValue() == null) {
                        return false;
                    }
                    CharSequence nsPrefix = attribute.namespacePrefix();
                    if (nsPrefix == null) {
                        return false;
                    }
                    return LexerUtils.equals((CharSequence)"xmlns", (CharSequence)nsPrefix, (boolean)true, (boolean)true) || jsfNsPrefix != null && LexerUtils.equals((CharSequence)jsfNsPrefix, (CharSequence)nsPrefix, (boolean)true, (boolean)true);
                });
                for (Attribute attr : nsAttrs) {
                    if (LexerUtils.equals((CharSequence)"xmlns", (CharSequence)attr.namespacePrefix(), (boolean)true, (boolean)true)) {
                        namespace2Attribute.put(attr.unquotedValue().toString(), attr);
                        continue;
                    }
                    jsfUsage[0] = true;
                }
            }
        };
        ElementUtils.visitChildren((Element)root, (ElementVisitor)prefixCollector, (ElementType)ElementType.OPEN_TAG);
        Node undeclaredComponentsTreeRoot = result.rootOfUndeclaredTagsParseTree();
        if (undeclaredComponentsTreeRoot != null && errorType != 1) {
            ElementUtils.visitChildren((Element)undeclaredComponentsTreeRoot, (ElementVisitor)prefixCollector, (ElementType)ElementType.OPEN_TAG);
            ElementUtils.visitChildren((Element)undeclaredComponentsTreeRoot, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    OpenTag openTag = (OpenTag)node;
                    Set<Named> undeclaredNodes = LibraryDeclarationChecker.parseForUndeclaredElements(result, openTag);
                    ArrayList<FixLibDeclaration> fixes = new ArrayList<FixLibDeclaration>();
                    Set libs = LibraryDeclarationChecker.getLibsByPrefixes(context, LibraryDeclarationChecker.getUndeclaredNamespaces(undeclaredNodes));
                    for (Library lib : libs) {
                        FixLibDeclaration fix = new FixLibDeclaration((Document)context.doc, lib.getDefaultPrefix(), lib);
                        fixes.add(fix);
                    }
                    for (Named undeclaredEntry : undeclaredNodes) {
                        hints.add(new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT", (Object)undeclaredEntry.image()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, undeclaredEntry.from(), undeclaredEntry.from() + undeclaredEntry.name().length() + 1), new ArrayList(fixes), 50));
                        CloseTag matchingCloseTag = openTag.matchingCloseTag();
                        if (undeclaredEntry.equals(openTag) && matchingCloseTag != null) {
                            hints.add(new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT", (Object)openTag.name().toString()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, matchingCloseTag.from(), matchingCloseTag.to()), new ArrayList(fixes), 50));
                        }
                        fixes.clear();
                    }
                }
            }, (ElementType)ElementType.OPEN_TAG);
        }
        for (String namespace : declaredNamespaces) {
            if (SCHEMA_INSTANCE.equals(namespace)) continue;
            Library lib = (Library)NamespaceUtils.getForNs(libs, (String)namespace);
            if (lib != null) {
                if (DefaultLibraryInfo.PASSTHROUGH.getNamespace().equals(lib.getNamespace()) || DefaultLibraryInfo.PASSTHROUGH.getValidNamespaces().contains(lib.getNamespace())) continue;
                declaredLibraries.add(lib);
                continue;
            }
            Attribute attr = (Attribute)namespace2Attribute.get(namespace);
            if (attr == null || errorType == 1) continue;
            Hint hint = new Hint((Rule)ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_LIBRARY", (Object)namespace), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, attr.nameOffset(), attr.valueOffset() + attr.value().length()), Collections.emptyList(), 50);
            hints.add(hint);
        }
        if (errorType < 2) {
            final boolean declaredPassthroughOrJsf = NamespaceUtils.containsNsOf(declaredNamespaces, (DefaultLibraryInfo)DefaultLibraryInfo.JSF) || NamespaceUtils.containsNsOf(declaredNamespaces, (DefaultLibraryInfo)DefaultLibraryInfo.PASSTHROUGH);
            final boolean[] passthroughUsage = new boolean[1];
            ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
            for (Library lib : declaredLibraries) {
                List nodes = lib.getValidNamespaces().stream().map(arg_0 -> ((HtmlParserResult)result).root(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
                if (nodes.isEmpty()) continue;
                final int[] usages = new int[1];
                for (Node rootNode : nodes) {
                    ElementUtils.visitChildren((Element)rootNode, (ElementVisitor)new ElementVisitor(){

                        public void visit(Element node) {
                            usages[0] = usages[0] + 1;
                            if (declaredPassthroughOrJsf) {
                                OpenTag ot = (OpenTag)node;
                                for (Attribute attribute : ot.attributes(new AttributeFilter(){

                                    public boolean accepts(Attribute attribute) {
                                        return attribute.namespacePrefix() != null;
                                    }
                                })) {
                                    if (passthroughNsPrefix != null && LexerUtils.equals((CharSequence)passthroughNsPrefix, (CharSequence)attribute.namespacePrefix(), (boolean)true, (boolean)true)) {
                                        passthroughUsage[0] = true;
                                        continue;
                                    }
                                    if (jsfNsPrefix == null || ot.namespacePrefix() == null || !LexerUtils.equals((CharSequence)jsfNsPrefix, (CharSequence)attribute.namespacePrefix(), (boolean)true, (boolean)true)) continue;
                                    wrongJsfNsUsages.add(attribute);
                                }
                            }
                        }
                    }, (ElementType)ElementType.OPEN_TAG);
                }
                usages[0] = usages[0] + (LibraryDeclarationChecker.isFunctionLibraryPrefixUsedInEL(context, lib, docText) ? 1 : 0);
                usages[0] = usages[0] + (DefaultLibraryInfo.JSF.getValidNamespaces().contains(lib.getNamespace()) && jsfUsage[0] ? 1 : 0);
                if (usages[0] != 0) continue;
                this.addUnusedLibrary(ranges, namespace2Attribute, lib.getNamespace(), snapshot, docText);
            }
            if (NamespaceUtils.containsNsOf(declaredNamespaces, (DefaultLibraryInfo)DefaultLibraryInfo.PASSTHROUGH) && !passthroughUsage[0]) {
                this.addUnusedLibrary(ranges, namespace2Attribute, DefaultLibraryInfo.PASSTHROUGH.getNamespace(), snapshot, docText);
            }
            for (OffsetRange range : ranges) {
                List fixes;
                try {
                    fixes = context.doc != null ? Arrays.asList(new RemoveUnusedLibraryDeclarationHintFix(context.doc, LibraryDeclarationChecker.createPositionRange(context, range)), new RemoveUnusedLibrariesDeclarationHintFix(context.doc, LibraryDeclarationChecker.createPositionRanges(context, ranges))) : Collections.emptyList();
                }
                catch (BadLocationException ex) {
                    fixes = Collections.emptyList();
                }
                Hint hint = new Hint((Rule)DEFAULT_WARNING_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNUSED_LIBRARY_DECLARATION", (Object)docText.subSequence(range.getStart(), range.getEnd())), context.parserResult.getSnapshot().getSource().getFileObject(), range, fixes, 50);
                hints.add(hint);
            }
            for (Named attr : wrongJsfNsUsages) {
                Hint hint = new Hint((Rule)DEFAULT_ERROR_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_JSF_NS_USED_IN_JSF_AWARE_TAG"), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, attr.from(), attr.from() + attr.name().length() + 1), Collections.emptyList(), 50);
                hints.add(hint);
            }
        }
    }

    private void addUnusedLibrary(Collection<OffsetRange> ranges, Map<String, Attribute> namespace2Attribute, String namespace, Snapshot snapshot, CharSequence docText) {
        Attribute declAttr = (Attribute)NamespaceUtils.getForNs(namespace2Attribute, (String)namespace);
        if (declAttr != null) {
            int to;
            int from = declAttr.nameOffset();
            if (from < (to = declAttr.valueOffset() + declAttr.value().length()) && to > 0 && to < docText.length()) {
                OffsetRange documentRange = JsfUtils.createOffsetRange(snapshot, docText, from, to);
                ranges.add(documentRange);
            } else {
                LOG.log(Level.WARNING, "Range definition out of bounds of the source: from={0},to={1},text={2}", new Object[]{from, to, docText});
            }
        }
    }

    private static Set<String> getUndeclaredNamespaces(Set<Named> undeclaredEntries) {
        HashSet<String> undeclaredNamespaces = new HashSet<String>();
        for (Named named : undeclaredEntries) {
            undeclaredNamespaces.add(named.namespacePrefix().toString());
        }
        return undeclaredNamespaces;
    }

    public static Set<Named> parseForUndeclaredElements(HtmlParserResult result, OpenTag openTag) {
        HashSet<Named> undeclaredEntries = new HashSet<Named>();
        for (Map.Entry entry : result.roots().entrySet()) {
            for (Element element : ((Node)entry.getValue()).children()) {
                if (!LibraryDeclarationChecker.elementEqualsOpenTag(element, openTag)) continue;
                return undeclaredEntries;
            }
        }
        if (openTag.namespacePrefix() != null && !result.getNamespaces().containsValue(openTag.namespacePrefix().toString())) {
            undeclaredEntries.add((Named)openTag);
        }
        for (Attribute attribute : openTag.attributes(new AttributeFilter(){

            public boolean accepts(Attribute attribute) {
                return attribute.namespacePrefix() != null;
            }
        })) {
            if (result.getNamespaces().containsValue(attribute.namespacePrefix().toString())) continue;
            undeclaredEntries.add((Named)attribute);
        }
        return undeclaredEntries;
    }

    private static boolean elementEqualsOpenTag(Element element, OpenTag openTag) {
        return element.type() == ElementType.OPEN_TAG && element.from() == openTag.from() && element.to() == openTag.to();
    }

    private static PositionRange createPositionRange(RuleContext context, OffsetRange offsetRange) throws BadLocationException {
        return new PositionRange(context.doc, offsetRange.getStart(), offsetRange.getEnd());
    }

    private static Collection<PositionRange> createPositionRanges(RuleContext context, Collection<OffsetRange> offsetRanges) throws BadLocationException {
        ArrayList<PositionRange> ranges = new ArrayList<PositionRange>();
        for (OffsetRange offsetRange : offsetRanges) {
            ranges.add(LibraryDeclarationChecker.createPositionRange(context, offsetRange));
        }
        return ranges;
    }

    private static Set<Library> getLibsByPrefixes(RuleContext context, Set<String> prefixes) {
        HashSet<Library> libs = new HashSet<Library>();
        JsfSupportImpl sup = JsfSupportImpl.findFor(context.parserResult.getSnapshot().getSource());
        if (sup != null) {
            for (Library lib : new HashSet<Library>(sup.getLibraries().values())) {
                if (!prefixes.contains(lib.getDefaultPrefix())) continue;
                libs.add(lib);
            }
        }
        return libs;
    }

    private static boolean isFunctionLibraryPrefixUsedInEL(RuleContext context, Library lib, CharSequence sourceText) {
        String libraryPrefix = (String)NamespaceUtils.getForNs((Map)((HtmlParserResult)context.parserResult).getNamespaces(), (String)lib.getNamespace());
        TokenHierarchy th = TokenHierarchy.create((CharSequence)sourceText, (Language)Language.find((String)"text/xhtml"));
        TokenSequence ts = th.tokenSequence();
        ts.moveStart();
        while (ts.moveNext()) {
            TokenSequence elts = ts.embeddedJoined(ELTokenId.language());
            if (elts == null) continue;
            elts.moveStart();
            while (elts.moveNext()) {
                if (elts.token().id() != ELTokenId.TAG_LIB_PREFIX || !CharSequenceUtilities.equals((CharSequence)libraryPrefix, (Object)elts.token().text())) continue;
                return true;
            }
        }
        return false;
    }

    private static class RemoveUnusedLibrariesDeclarationHintFix
    implements HintFix {
        protected Collection<PositionRange> ranges = new ArrayList<PositionRange>();
        protected BaseDocument document;

        public RemoveUnusedLibrariesDeclarationHintFix(BaseDocument document, Collection<PositionRange> ranges) {
            this.document = document;
            this.ranges = ranges;
        }

        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_ALL_UNUSED_LIBRARIES_DECLARATION");
        }

        public void implement() throws Exception {
            this.document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (PositionRange range : ranges) {
                            int firstNonWhite;
                            int from = range.getFrom();
                            int to = range.getTo();
                            int lineBeginning = Utilities.getRowStart((BaseDocument)document, (int)from);
                            if (lineBeginning > (firstNonWhite = Utilities.getFirstNonWhiteBwd((BaseDocument)document, (int)from))) {
                                from = lineBeginning - 1;
                            }
                            document.remove(from, to - from);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class RemoveUnusedLibraryDeclarationHintFix
    extends RemoveUnusedLibrariesDeclarationHintFix {
        public RemoveUnusedLibraryDeclarationHintFix(BaseDocument document, PositionRange range) {
            super(document, Collections.singletonList(range));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_UNUSED_LIBRARY_DECLARATION");
        }
    }
}

