/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.Ordering;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

final class MIMESupport {
    private static final Reference<CachedFileObject> EMPTY = new WeakReference<Object>(null);
    private static final Reference<CachedFileObject> CLEARED = new WeakReference<Object>(null);
    private static Reference<CachedFileObject> lastCfo = EMPTY;
    private static final Object lock = new Object();
    private static final Logger ERR = Logger.getLogger(MIMESupport.class.getName());

    private MIMESupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeCaches() {
        CachedFileObject cfo;
        Object object = lock;
        synchronized (object) {
            cfo = lastCfo.get();
            lastCfo = CLEARED;
        }
        if (cfo != null) {
            cfo.clear();
        }
    }

    static void resetCache() {
        CachedFileObject.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findMIMEType(FileObject fo, String ... withinMIMETypes) {
        Object object;
        Object object2;
        if (!fo.isValid() || fo.isFolder()) {
            return null;
        }
        CachedFileObject cfo = null;
        CachedFileObject lcfo = null;
        try {
            object2 = lock;
            synchronized (object2) {
                lcfo = lastCfo.get();
                cfo = lcfo == null || fo != lcfo.fileObj ? new CachedFileObject(fo) : lcfo;
                lastCfo = EMPTY;
            }
            object2 = cfo.getMIMEType(withinMIMETypes);
            object = lock;
        }
        catch (Throwable throwable) {
            Object object3 = lock;
            synchronized (object3) {
                if (lastCfo != CLEARED) {
                    lastCfo = new SoftReference<Object>(cfo);
                } else if (cfo != lastCfo.get()) {
                    cfo.clear();
                }
                if (cfo != lcfo && lcfo != null) {
                    lcfo.clear();
                }
            }
            throw throwable;
        }
        synchronized (object) {
            if (lastCfo != CLEARED) {
                lastCfo = new SoftReference<CachedFileObject>(cfo);
            } else if (cfo != lastCfo.get()) {
                cfo.clear();
            }
            if (cfo != lcfo && lcfo != null) {
                lcfo.clear();
            }
        }
        return object2;
    }

    static MIMEResolver[] getResolvers() {
        return CachedFileObject.getResolvers();
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private FileObject fileObject;
        private byte[] buffer = null;
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;
        private IOException cantRead;

        CachedInputStream(InputStream is, FileObject fo) {
            this.inputStream = is;
            this.fileObject = fo;
        }

        @Override
        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        private boolean ensureBufferLength(int requiredLen) throws IOException {
            int retries = 0;
            if (!this.eof && requiredLen > this.len) {
                if (this.cantRead != null) {
                    throw this.cantRead;
                }
                int newLen = this.computeNewLength(this.len, requiredLen);
                byte[] tmpBuffer = new byte[newLen];
                if (this.len > 0) {
                    System.arraycopy(this.buffer, 0, tmpBuffer, 0, this.len);
                }
                while (true) {
                    try {
                        int readLen = this.inputStream.read(tmpBuffer, this.len, newLen - this.len);
                        if (readLen > 0) {
                            this.buffer = tmpBuffer;
                            this.len += readLen;
                            break;
                        }
                        this.eof = true;
                    }
                    catch (InterruptedIOException ex) {
                        ERR.log(Level.INFO, "Ignoring Interrupted I/O exception #{0}", ++retries);
                        if (retries <= 3) continue;
                        throw ex;
                    }
                    catch (IOException ex) {
                        this.cantRead = ex;
                        throw ex;
                    }
                    break;
                }
            }
            return this.len >= requiredLen;
        }

        private int computeNewLength(int currLen, int requiredLen) {
            int recommendedIncrease = Math.max(64, Math.min(8192, currLen));
            int newLen = Math.max(requiredLen, currLen + recommendedIncrease);
            if (newLen > 64 && ERR.isLoggable(Level.FINE)) {
                ERR.log(Level.FINE, "CachedInputStream buffer length for {0} will be increased to {1}", new Object[]{this.fileObject, newLen});
            }
            return newLen;
        }

        @Override
        public int read(byte[] b, int off, int blen) throws IOException {
            int retval;
            this.ensureBufferLength(this.pos + blen);
            int readPos = Math.min(this.len, this.pos + blen);
            int n = retval = readPos > this.pos ? readPos - this.pos : -1;
            if (retval != -1) {
                System.arraycopy(this.buffer, this.pos, b, off, retval);
                this.pos += retval;
            }
            return retval;
        }

        @Override
        public int read() throws IOException {
            int retval = -1;
            this.ensureBufferLength(this.pos + 1);
            if (this.len > this.pos) {
                retval = (retval = this.buffer[this.pos++]) < 0 ? retval + 256 : retval;
            }
            return retval;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String retVal = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            retVal = retVal + new String(this.buffer);
            return retVal;
        }
    }

    private static class CachedFileObject
    extends FileObject {
        static Lookup.Result<MIMEResolver> result;
        private static Union2<MIMEResolver[], Set<Thread>> resolvers;
        private static MIMEResolver[] previousResolvers;
        private static final Set<String> warningPrinted;
        String mimeType;
        Date lastModified;
        Long size;
        CachedInputStream fixIt;
        String ext;
        final FileObject fileObj;
        private static final FileChangeListener declarativeFolderListener;
        private static final FileChangeListener weakDeclarativeFolderListener;
        private static FileObject declarativeFolder;

        CachedFileObject(FileObject fo) {
            this.fileObj = fo;
        }

        final void clear() {
            this.freeCaches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MIMEResolver[] getResolvers() {
            Class<CachedFileObject> clazz = CachedFileObject.class;
            synchronized (CachedFileObject.class) {
                HashSet<Thread> creators;
                if (resolvers != null && resolvers.hasFirst()) {
                    // ** MonitorExit[var1] (shouldn't be in output)
                    return (MIMEResolver[])resolvers.first();
                }
                if (resolvers != null) {
                    creators = (HashSet<Thread>)resolvers.second();
                    if (creators.contains(Thread.currentThread())) {
                        MIMEResolver[] toRet;
                        if (ERR.isLoggable(Level.FINE)) {
                            ERR.fine("Stack Overflow prevention. Returning previousResolvers: " + previousResolvers);
                        }
                        if ((toRet = previousResolvers) == null) {
                            toRet = new MIMEResolver[]{};
                        }
                        // ** MonitorExit[var1] (shouldn't be in output)
                        return toRet;
                    }
                } else {
                    creators = new HashSet<Thread>();
                    resolvers = Union2.createSecond(creators);
                }
                if (result == null) {
                    result = Lookup.getDefault().lookupResult(MIMEResolver.class);
                    result.addLookupListener(new LookupListener(){

                        public void resultChanged(LookupEvent evt) {
                            CachedFileObject.resetCache();
                        }
                    });
                }
                creators.add(Thread.currentThread());
                // ** MonitorExit[var1] (shouldn't be in output)
                ERR.fine("Computing resolvers");
                ArrayList<MIMEResolver> all = new ArrayList<MIMEResolver>(CachedFileObject.declarativeResolvers());
                all.addAll(result.allInstances());
                MIMEResolver[] toRet = all.toArray(new MIMEResolver[all.size()]);
                ERR.fine("Resolvers computed");
                Class<CachedFileObject> clazz2 = CachedFileObject.class;
                synchronized (CachedFileObject.class) {
                    if (resolvers != null && resolvers.hasSecond() && resolvers.second() == creators) {
                        resolvers = Union2.createFirst((Object)toRet);
                        previousResolvers = null;
                        ERR.fine("Resolvers assigned");
                    } else if (ERR.isLoggable(Level.FINE)) {
                        ERR.fine("Somebody else computes resolvers: " + resolvers);
                    }
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    return toRet;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static synchronized void resetCache() {
            ERR.fine("Clearing cache");
            Union2<MIMEResolver[], Set<Thread>> prev = resolvers;
            if (prev != null && prev.hasFirst()) {
                previousResolvers = (MIMEResolver[])prev.first();
            }
            resolvers = null;
            Object object = lock;
            synchronized (object) {
                CachedFileObject cfo = (CachedFileObject)lastCfo.get();
                if (cfo != null) {
                    cfo.clear();
                }
                lastCfo = EMPTY;
            }
        }

        private static synchronized List<MIMEResolver> declarativeResolvers() {
            ArrayList<MIMEResolver> declmimes = new ArrayList<MIMEResolver>();
            if (declarativeFolder == null) {
                declarativeFolder = FileUtil.getConfigFile("Services/MIMEResolver");
            }
            if (declarativeFolder != null) {
                for (FileObject f : Ordering.getOrder(Arrays.asList(declarativeFolder.getChildren()), true)) {
                    if (!f.hasExt("xml")) continue;
                    try {
                        declmimes.add(MIMEResolverImpl.forDescriptor(f));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                declarativeFolder.removeFileChangeListener(weakDeclarativeFolderListener);
                declarativeFolder.addFileChangeListener(weakDeclarativeFolderListener);
            }
            return declmimes;
        }

        public static boolean isAnyResolver() {
            return CachedFileObject.getResolvers().length > 0;
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
            this.ext = null;
        }

        @Override
        public String getMIMEType() {
            return this.getMIMEType(null);
        }

        @Override
        public String getMIMEType(String ... withinMIMETypes) {
            String resolvedMimeType = this.mimeType;
            if (resolvedMimeType == null) {
                resolvedMimeType = this.resolveMIME(withinMIMETypes);
                if (resolvedMimeType == null) {
                    resolvedMimeType = this.getExt().equalsIgnoreCase("xml") ? "text/xml" : "content/unknown";
                } else if (withinMIMETypes.length == 0) {
                    this.mimeType = resolvedMimeType;
                }
            }
            return resolvedMimeType;
        }

        private boolean canResolveMIMETypes(MIMEResolver resolver, String ... desiredMIMETypes) {
            if (desiredMIMETypes.length == 0) {
                return true;
            }
            String[] resolvableMIMETypes = null;
            resolvableMIMETypes = MIMEResolverImpl.isDeclarative(resolver) ? MIMEResolverImpl.getMIMETypes(resolver) : resolver.getMIMETypes();
            if (resolvableMIMETypes == null || resolvableMIMETypes.length == 0) {
                if (warningPrinted.add(resolver.getClass().getName())) {
                    ERR.warning(resolver.getClass().getName() + "'s constructor should call super(String...) with list of resolvable MIME types.");
                }
                return true;
            }
            for (int i = 0; i < desiredMIMETypes.length; ++i) {
                for (int j = 0; j < resolvableMIMETypes.length; ++j) {
                    if (!resolvableMIMETypes[j].equals(desiredMIMETypes[i])) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMIME(String ... withinMIMETypes) {
            String retVal = null;
            MIMEResolver[] local = CachedFileObject.getResolvers();
            try {
                for (int i = 0; i < local.length; ++i) {
                    MIMEResolver resolver = local[i];
                    if (this.canResolveMIMETypes(resolver, withinMIMETypes)) {
                        retVal = resolver.findMIMEType(this);
                    }
                    if (retVal == null) continue;
                    String string = retVal;
                    return string;
                }
            }
            finally {
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
            }
            return retVal;
        }

        @Override
        public Date lastModified() {
            if (this.lastModified == null) {
                this.lastModified = this.fileObj.lastModified();
            }
            return this.lastModified;
        }

        @Override
        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                if (ERR.isLoggable(Level.FINE)) {
                    LogRecord rec = new LogRecord(Level.FINE, "MSG_CACHED_INPUT_STREAM");
                    rec.setParameters(new Object[]{this});
                    rec.setResourceBundle(NbBundle.getBundle(MIMESupport.class));
                    ERR.log(rec);
                }
                InputStream is = this.fileObj.getInputStream();
                this.fixIt = new CachedInputStream(is, this.fileObj);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        @Override
        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        @Override
        @Deprecated
        public String getPackageNameExt(char separatorChar, char extSepChar) {
            return this.fileObj.getPackageNameExt(separatorChar, extSepChar);
        }

        @Override
        public FileObject copy(FileObject target, String name, String ext) throws IOException {
            return this.fileObj.copy(target, name, ext);
        }

        @Override
        protected void fireFileDeletedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileDeletedEvent(en, fe);
        }

        @Override
        protected void fireFileFolderCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileFolderCreatedEvent(en, fe);
        }

        @Override
        @Deprecated
        public void setImportant(boolean b) {
            this.fileObj.setImportant(b);
        }

        @Override
        public boolean isData() {
            return this.fileObj.isData();
        }

        @Override
        public Object getAttribute(String attrName) {
            return this.fileObj.getAttribute(attrName);
        }

        @Override
        public Enumeration<? extends FileObject> getFolders(boolean rec) {
            return this.fileObj.getFolders(rec);
        }

        @Override
        public void delete(FileLock lock) throws IOException {
            this.fileObj.delete(lock);
        }

        @Override
        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        @Override
        public Enumeration<? extends FileObject> getData(boolean rec) {
            return this.fileObj.getData(rec);
        }

        @Override
        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        @Override
        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        @Override
        public boolean isValid() {
            return this.fileObj.isValid();
        }

        @Override
        @Deprecated
        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        @Override
        public boolean canRead() {
            return this.fileObj.canRead();
        }

        @Override
        public boolean canWrite() {
            return this.fileObj.canWrite();
        }

        @Override
        public String getExt() {
            if (this.ext == null) {
                this.ext = this.fileObj.getExt();
            }
            return this.ext;
        }

        @Override
        public String getName() {
            return this.fileObj.getName();
        }

        @Override
        public void removeFileChangeListener(FileChangeListener fcl) {
            this.fileObj.removeFileChangeListener(fcl);
        }

        @Override
        protected void fireFileRenamedEvent(Enumeration<FileChangeListener> en, FileRenameEvent fe) {
            this.fileObj.fireFileRenamedEvent(en, fe);
        }

        @Override
        public void refresh(boolean expected) {
            this.fileObj.refresh(expected);
        }

        @Override
        protected void fireFileAttributeChangedEvent(Enumeration<FileChangeListener> en, FileAttributeEvent fe) {
            this.fileObj.fireFileAttributeChangedEvent(en, fe);
        }

        @Override
        public long getSize() {
            if (this.size != null) {
                return this.size;
            }
            this.size = this.fileObj.getSize();
            return this.size;
        }

        @Override
        public Enumeration<String> getAttributes() {
            return this.fileObj.getAttributes();
        }

        @Override
        public void rename(FileLock lock, String name, String ext) throws IOException {
            this.fileObj.rename(lock, name, ext);
        }

        @Override
        protected void fireFileChangedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileChangedEvent(en, fe);
        }

        @Override
        public FileObject getFileObject(String name, String ext) {
            return this.fileObj.getFileObject(name, ext);
        }

        @Override
        public void refresh() {
            this.fileObj.refresh();
        }

        @Override
        public FileObject createData(String name, String ext) throws IOException {
            return this.fileObj.createData(name, ext);
        }

        @Override
        public void addFileChangeListener(FileChangeListener fcl) {
            this.fileObj.addFileChangeListener(fcl);
        }

        @Override
        protected void fireFileDataCreatedEvent(Enumeration<FileChangeListener> en, FileEvent fe) {
            this.fileObj.fireFileDataCreatedEvent(en, fe);
        }

        @Override
        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        @Override
        public FileObject createFolder(String name) throws IOException {
            return this.fileObj.createFolder(name);
        }

        @Override
        public Enumeration<? extends FileObject> getChildren(boolean rec) {
            return this.fileObj.getChildren(rec);
        }

        @Override
        public void setAttribute(String attrName, Object value) throws IOException {
            this.fileObj.setAttribute(attrName, value);
        }

        @Override
        @Deprecated
        public String getPackageName(char separatorChar) {
            return this.fileObj.getPackageName(separatorChar);
        }

        @Override
        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        @Override
        public OutputStream getOutputStream(FileLock lock) throws IOException {
            return this.fileObj.getOutputStream(lock);
        }

        @Override
        public boolean existsExt(String ext) {
            return this.fileObj.existsExt(ext);
        }

        @Override
        public FileObject move(FileLock lock, FileObject target, String name, String ext) throws IOException {
            return this.fileObj.move(lock, target, name, ext);
        }

        @Override
        public synchronized boolean isLocked() {
            return this.fileObj.isLocked();
        }

        @Override
        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CachedFileObject) {
                return ((CachedFileObject)obj).fileObj.equals(this.fileObj);
            }
            return super.equals(obj);
        }

        @Override
        public String getPath() {
            return this.fileObj.getPath();
        }

        static {
            warningPrinted = new HashSet<String>();
            declarativeFolderListener = new FileChangeAdapter(){

                @Override
                public void fileDataCreated(FileEvent fe) {
                    CachedFileObject.resetCache();
                }

                @Override
                public void fileDeleted(FileEvent fe) {
                    CachedFileObject.resetCache();
                }
            };
            weakDeclarativeFolderListener = FileUtil.weakFileChangeListener(declarativeFolderListener, null);
            declarativeFolder = null;
        }
    }
}

