/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.net.URL;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

final class MultiModuleUnitTestForSourceQueryImpl
implements MultipleRootsUnitTestForSourceQueryImplementation {
    private final MultiModule sourceModules;
    private final MultiModule testModules;

    MultiModuleUnitTestForSourceQueryImpl(@NonNull MultiModule sourceModules, @NonNull MultiModule testModules) {
        Parameters.notNull((CharSequence)"sourceModules", (Object)sourceModules);
        Parameters.notNull((CharSequence)"testModules", (Object)testModules);
        this.sourceModules = sourceModules;
        this.testModules = testModules;
    }

    public URL[] findUnitTests(FileObject source) {
        return MultiModuleUnitTestForSourceQueryImpl.map(source, this.sourceModules, this.testModules);
    }

    public URL[] findSources(FileObject unitTest) {
        return MultiModuleUnitTestForSourceQueryImpl.map(unitTest, this.testModules, this.sourceModules);
    }

    @CheckForNull
    private static URL[] map(@NonNull FileObject artefact, @NonNull MultiModule from, @NonNull MultiModule to) {
        String moduleName = from.getModuleName(artefact);
        if (moduleName == null) {
            return null;
        }
        ClassPath srcPath = to.getModuleSources(moduleName);
        if (srcPath == null) {
            return null;
        }
        return (URL[])srcPath.entries().stream().map(e -> e.getURL()).toArray(URL[]::new);
    }
}

