/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.db;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.micronaut.db.Bundle;
import org.netbeans.modules.micronaut.db.ClassesSelectorPanel;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MicronautController
implements TemplateWizard.Iterator {
    private WizardDescriptor.Panel[] panels;
    private int index;
    private WizardDescriptor wizardDescriptor;
    private FileObject targetFolder;

    public static TemplateWizard.Iterator create() {
        return new MicronautController();
    }

    public static CreateFromTemplateHandler handler() {
        return new CreateFromTemplateHandler(){

            protected boolean accept(CreateDescriptor desc) {
                return true;
            }

            protected List<FileObject> createFromTemplate(CreateDescriptor desc) throws IOException {
                try {
                    Set repositoryClasses;
                    FileObject folder = desc.getTarget();
                    Project project = FileOwnerQuery.getOwner((FileObject)folder);
                    if (project == null) {
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoProject(folder.getPath()), 0));
                        return Collections.emptyList();
                    }
                    SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])ProjectUtils.getSources((Project)project).getSourceGroups("java"), (FileObject)folder);
                    if (sourceGroup != null && !(repositoryClasses = MicronautController.getRepositoryClasses(sourceGroup)).isEmpty()) {
                        List items = repositoryClasses.stream().map(handle -> {
                            String fqn = handle.getQualifiedName();
                            int idx = fqn.lastIndexOf(46);
                            return idx < 0 ? new NotifyDescriptor.QuickPick.Item(fqn, null) : new NotifyDescriptor.QuickPick.Item(fqn.substring(idx + 1), fqn.substring(0, idx));
                        }).collect(Collectors.toList());
                        NotifyDescriptor.QuickPick qpt = new NotifyDescriptor.QuickPick(Bundle.MSG_SelectRepository(), Bundle.MSG_SelectRepository_Prompt(), items, true);
                        if (DialogDescriptor.OK_OPTION != DialogDisplayer.getDefault().notify((NotifyDescriptor)qpt)) {
                            return Collections.emptyList();
                        }
                        ArrayList<FileObject> generated = new ArrayList<FileObject>();
                        boolean hasSelectedItem = false;
                        for (NotifyDescriptor.QuickPick.Item item : qpt.getItems()) {
                            FileObject fo;
                            if (!item.isSelected()) continue;
                            hasSelectedItem = true;
                            String label = item.getLabel();
                            if (label.toLowerCase().endsWith("repository")) {
                                label = label.substring(0, label.length() - 10);
                            }
                            if ((fo = MicronautController.generate(folder, label, item.getDescription() != null ? item.getDescription() + '.' + item.getLabel() : item.getLabel())) == null) continue;
                            generated.add(fo);
                        }
                        if (hasSelectedItem) {
                            return generated;
                        }
                    }
                    NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(Bundle.MSG_SelectControllerName(), Bundle.MSG_SelectControllerName());
                    if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine)) {
                        ArrayList<FileObject> generated = new ArrayList<FileObject>();
                        String name = inputLine.getInputText();
                        if (!name.isEmpty()) {
                            FileObject fo;
                            if (name.toLowerCase().endsWith("controller")) {
                                name = name.substring(0, name.length() - 10);
                            }
                            if ((fo = MicronautController.generate(desc.getTarget(), name, null)) != null) {
                                generated.add(fo);
                            }
                        }
                        return generated;
                    }
                }
                catch (Exception ex) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)ex.getMessage(), 0));
                }
                return Collections.emptyList();
            }
        };
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        FileObject fo;
        String targetName;
        HashSet<DataObject> generated = new HashSet<DataObject>();
        Map selectedRepositories = (Map)wiz.getProperty("wizard-selected-classes");
        for (String fqn : selectedRepositories.keySet()) {
            FileObject fo2;
            String label;
            int idx = fqn.lastIndexOf(46);
            String string = label = idx < 0 ? fqn : fqn.substring(idx + 1);
            if (label.toLowerCase().endsWith("repository")) {
                label = label.substring(0, label.length() - 10);
            }
            if ((fo2 = MicronautController.generate(this.targetFolder, label, fqn)) == null) continue;
            generated.add(DataObject.find((FileObject)fo2));
        }
        if (generated.isEmpty() && (targetName = Templates.getTargetName((WizardDescriptor)wiz)) != null && !targetName.isEmpty() && (fo = MicronautController.generate(this.targetFolder, targetName, null)) != null) {
            generated.add(DataObject.find((FileObject)fo));
        }
        return generated;
    }

    public void initialize(TemplateWizard wiz) {
        this.wizardDescriptor = wiz;
        this.targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups.length == 0) {
            sourceGroups = sources.getSourceGroups("generic");
            this.panels = new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).create()};
        } else {
            Set<ElementHandle<TypeElement>> repositoryClasses;
            ArrayList<ClassesSelectorPanel.WizardPanel> p = new ArrayList<ClassesSelectorPanel.WizardPanel>();
            SourceGroup sourceGroup = SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)this.targetFolder);
            if (sourceGroup != null && !(repositoryClasses = MicronautController.getRepositoryClasses(sourceGroup)).isEmpty()) {
                HashMap<String, ElementHandle<TypeElement>> repositories = new HashMap<String, ElementHandle<TypeElement>>();
                for (ElementHandle<TypeElement> handle : repositoryClasses) {
                    repositories.put(handle.getQualifiedName(), handle);
                }
                wiz.putProperty("wizard-classes", repositories);
                p.add(new ClassesSelectorPanel.WizardPanel(NbBundle.getMessage(MicronautController.class, (String)"Templates/Micronaut/Controller"), "Repositories", s -> null));
            }
            p.add((ClassesSelectorPanel.WizardPanel)JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups));
            this.panels = p.toArray(new WizardDescriptor.Panel[0]);
        }
        Wizards.mergeSteps((WizardDescriptor)wiz, (WizardDescriptor.Panel[])this.panels, null);
    }

    public void uninitialize(TemplateWizard wiz) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public String name() {
        return null;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1 && (!(this.current() instanceof WizardDescriptor.FinishablePanel) || !((WizardDescriptor.FinishablePanel)this.current()).isFinishPanel());
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (this.index + 1 == this.panels.length) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (this.index == 0) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static Set<ElementHandle<TypeElement>> getRepositoryClasses(SourceGroup sourceGroup) throws IllegalArgumentException {
        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)sourceGroup.getRootFolder());
        HashSet<ElementHandle<TypeElement>> repositoryClasses = new HashSet<ElementHandle<TypeElement>>();
        LinkedList<ElementHandle> bases = new LinkedList<ElementHandle>();
        bases.add(ElementHandle.createTypeElementHandle((ElementKind)ElementKind.INTERFACE, (String)"io.micronaut.data.repository.CrudRepository"));
        while (!bases.isEmpty()) {
            ElementHandle base = (ElementHandle)bases.removeFirst();
            bases.addAll(cpInfo.getClassIndex().getElements(base, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES)));
            Set srcElements = cpInfo.getClassIndex().getElements(base, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            bases.addAll(srcElements);
            repositoryClasses.addAll(srcElements);
        }
        return repositoryClasses;
    }

    private static FileObject generate(FileObject folder, String name, String repositoryFQN) {
        try {
            JavaSource js;
            String controllerName = name.substring(0, 1).toUpperCase() + name.substring(1) + "Controller";
            FileObject fo = GenerationUtils.createClass((FileObject)folder, (String)controllerName, (String)Bundle.MSG_ControllerClass(controllerName));
            if (fo != null && (js = JavaSource.forFileObject((FileObject)fo)) != null) {
                js.runModificationTask(copy -> {
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    Tree origTree = copy.getCompilationUnit().getTypeDecls().get(0);
                    if (origTree.getKind() == Tree.Kind.CLASS) {
                        GenerationUtils gu = GenerationUtils.newInstance((WorkingCopy)copy);
                        TreeMaker tm = copy.getTreeMaker();
                        List<ExpressionTree> annArgs = Collections.singletonList(gu.createAnnotationArgument(null, (Object)("/" + name.toLowerCase())));
                        ClassTree cls = gu.addAnnotation((ClassTree)origTree, gu.createAnnotation("io.micronaut.http.annotation.Controller", annArgs));
                        if (repositoryFQN != null) {
                            MethodTree mt;
                            String repositoryFieldName = name.substring(0, 1).toLowerCase() + name.substring(1) + "Repository";
                            VariableTree repositoryField = tm.Variable(tm.Modifiers(EnumSet.of(Modifier.PRIVATE, Modifier.FINAL)), (CharSequence)repositoryFieldName, (Tree)tm.QualIdent(repositoryFQN), null);
                            cls = tm.addClassMember(cls, (Tree)repositoryField);
                            cls = tm.addClassMember(cls, (Tree)GeneratorUtilities.get((WorkingCopy)copy).createConstructor(cls, Collections.singleton(repositoryField)));
                            TypeElement te = copy.getElements().getTypeElement(repositoryFQN);
                            MethodTree methodTree = mt = te != null ? Utils.createControllerDataEndpointMethod(copy, te, repositoryFieldName, "findAll", null) : null;
                            if (mt != null) {
                                cls = tm.addClassMember(cls, (Tree)mt);
                            }
                        } else {
                            List<ExpressionTree> getAnnArgs = Arrays.asList(gu.createAnnotationArgument("uri", (Object)"/"), gu.createAnnotationArgument("produces", (Object)"text/plain"));
                            ModifiersTree mods = tm.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.singletonList(gu.createAnnotation("io.micronaut.http.annotation.Get", getAnnArgs)));
                            MethodTree indexMethod = tm.Method(mods, (CharSequence)"index", (Tree)tm.QualIdent("java.lang.String"), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), "{return \"Example Response\";}", null);
                            cls = tm.addClassMember(cls, (Tree)indexMethod);
                        }
                        copy.rewrite(origTree, (Tree)cls);
                    }
                }).commit();
            }
            return fo;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }
}

