/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.JpaControllerIterator;
import org.netbeans.modules.j2ee.persistence.wizard.jpacontroller.ProgressReporter;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.ProgressReporterImpl;
import org.netbeans.modules.websvc.rest.codegen.RestFacadeMethod;
import org.netbeans.modules.websvc.rest.codegen.RestGenerationOptions;
import org.netbeans.modules.websvc.rest.codegen.model.EntityClassInfo;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.WebXmlHelper;
import org.openide.filesystems.FileObject;

public class J2eeEntityResourcesGenerator
extends EntityResourcesGenerator {
    private FileObject[] jpaControllers;

    @Override
    protected boolean generateInfrastracture(Set<FileObject> createdFiles, String entityFqn, FileObject facade) throws IOException {
        if (!super.generateInfrastracture(createdFiles, entityFqn, facade)) {
            return false;
        }
        String entityManagerAccessor = this.generateEntityManagerFactoryAccess(facade);
        return this.generateJpaControllerAccess(facade, JavaIdentifiers.unqualify((String)entityFqn), entityManagerAccessor);
    }

    @Override
    protected void preGenerate(List<String> fqnEntities) throws IOException {
        ProgressReporterImpl reporter = new ProgressReporterImpl(this);
        this.jpaControllers = JpaControllerIterator.generateJpaControllers((ProgressReporter)reporter, fqnEntities, (Project)this.getProject(), (String)this.getControllerPackageName(), (FileObject)this.getControllerFolder(), null, (boolean)true);
    }

    @Override
    protected void configurePersistence() {
        new WebXmlHelper(this.getProject(), this.getPersistenceUnit().getName()).configure();
    }

    @Override
    protected int getTotalWorkUnits() {
        return JpaControllerIterator.getProgressStepCount((int)this.getEntitiesCount()) + this.getEntitiesCount();
    }

    @Override
    protected RestGenerationOptions getGenerationOptions(RestFacadeMethod method, String entityFQN, String paramArg, String idType) {
        String entitySimpleName = JavaIdentifiers.unqualify((String)entityFQN);
        RestGenerationOptions options = super.getGenerationOptions(method, entityFQN, paramArg, idType);
        boolean needPathSegment = false;
        EntityClassInfo entityInfo = this.getModel().getEntityInfo(entityFQN);
        if (entityInfo != null) {
            EntityClassInfo.FieldInfo idFieldInfo = entityInfo.getIdFieldInfo();
            needPathSegment = idFieldInfo != null && idFieldInfo.isEmbeddedId() && idFieldInfo.getType() != null;
        }
        switch (method) {
            case CREATE: {
                StringBuilder builder = new StringBuilder("try { ");
                builder.append("getJpaController().create(entity);");
                builder.append("return Response.created(");
                builder.append("URI.create(");
                builder.append(this.getIdFieldToUriStmt(this.getModel().getEntityInfo(entityFQN).getIdFieldInfo()));
                builder.append(".toString())).build();");
                builder.append("} catch (Exception ex) {");
                builder.append("return Response.notModified(ex.getMessage()).build();");
                options.setBody(builder.toString());
                return options;
            }
            case EDIT: {
                StringBuilder builder = new StringBuilder("try { ");
                builder.append("getJpaController().edit(entity);");
                builder.append("return Response.ok().build();");
                builder.append("} catch (Exception ex) {");
                builder.append("return Response.notModified(ex.getMessage()).build();");
                options.setBody(builder.toString());
                return options;
            }
            case REMOVE: {
                StringBuilder builder = new StringBuilder("try { ");
                if (needPathSegment) {
                    builder.append(idType);
                    builder.append(" key=getPrimaryKey(id);\n");
                    paramArg = "key";
                }
                builder.append("getJpaController().destroy(");
                builder.append(paramArg);
                builder.append("; return Response.ok().build();");
                builder.append("} catch (Exception ex) {");
                builder.append("return Response.notModified(ex.getMessage()).build();");
                options.setBody(builder.toString());
                return options;
            }
            case FIND: {
                StringBuilder builder = new StringBuilder();
                if (needPathSegment) {
                    builder.append(idType);
                    builder.append(" key=getPrimaryKey(id);\n");
                    paramArg = "key";
                }
                builder.append("return getJpaController().find");
                builder.append(entitySimpleName);
                builder.append('(');
                builder.append(paramArg);
                builder.append(");");
                options.setBody(builder.toString());
                return options;
            }
            case FIND_ALL: {
                StringBuilder builder = new StringBuilder("return getJpaController().find");
                builder.append(entitySimpleName);
                builder.append("Entities();");
                options.setBody(builder.toString());
                return options;
            }
            case FIND_RANGE: {
                StringBuilder builder = new StringBuilder("return getJpaController().find");
                builder.append(entitySimpleName);
                builder.append("Entities(max,first);");
                options.setBody(builder.toString());
                return options;
            }
            case COUNT: {
                StringBuilder builder = new StringBuilder("return String.valueOf(getJpaController().get");
                builder.append(entitySimpleName);
                builder.append("Count();");
                options.setBody(builder.toString());
                return options;
            }
        }
        return null;
    }

    private boolean generateJpaControllerAccess(FileObject fileObject, String entityName, String emGetter) throws IOException {
        String jpaControllerName = entityName + "JpaController";
        FileObject controller = null;
        for (FileObject jpaController : this.jpaControllers) {
            if (!jpaController.getName().startsWith(jpaControllerName)) continue;
            jpaControllerName = jpaController.getName();
            controller = jpaController;
            break;
        }
        if (controller == null) {
            return false;
        }
        final String fqnController = JavaSourceHelper.getClassType(JavaSource.forFileObject(controller));
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        final StringBuilder bodyText = new StringBuilder("{try { ");
        boolean needUtx = false;
        if (project != null && Util.isContainerManaged((Project)project)) {
            needUtx = true;
            bodyText.append("UserTransaction utx = (UserTransaction) new ");
            bodyText.append("InitialContext().lookup(\"java:comp/UserTransaction\");");
        }
        bodyText.append("return new ");
        bodyText.append(jpaControllerName);
        if (needUtx) {
            bodyText.append("(utx, ");
        } else {
            bodyText.append("(null, ");
        }
        bodyText.append(emGetter);
        bodyText.append("());} catch (NamingException ex) {");
        bodyText.append("throw new RuntimeException(ex);}");
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree tree = workingCopy.getCompilationUnit();
                String[] imports = new String[]{"javax.transaction.UserTransaction", "javax.persistence.EntityManagerFactory", "javax.naming.NamingException", "javax.naming.InitialContext"};
                JavaSourceHelper.addImports(workingCopy, imports);
                for (Tree tree2 : tree.getTypeDecls()) {
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) continue;
                    ClassTree classTree = (ClassTree)tree2;
                    ClassTree newTree = JavaSourceHelper.addMethod(workingCopy, classTree, new Modifier[]{Modifier.PRIVATE}, new String[0], null, "getJpaController", fqnController, null, null, null, null, bodyText.toString(), null);
                    workingCopy.rewrite((Tree)classTree, (Tree)newTree);
                }
            }
        };
        javaSource.runModificationTask((Task)task).commit();
        return true;
    }

    private String generateEntityManagerFactoryAccess(FileObject fileObject) throws IOException {
        final StringBuilder bodyText = new StringBuilder("{return (EntityManagerFactory) new ");
        bodyText.append("InitialContext().lookup(\"java:comp/env/");
        bodyText.append("persistence-factory");
        bodyText.append("\");");
        String entityManagerMethod = "getEntityManagerFactory";
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree tree = workingCopy.getCompilationUnit();
                TreeMaker maker = workingCopy.getTreeMaker();
                ExpressionTree exceptionTree = JavaSourceHelper.createTypeTree(workingCopy, "javax.naming.NamingException");
                ExpressionTree returnTypeTree = JavaSourceHelper.createTypeTree(workingCopy, "javax.persistence.EntityManagerFactory");
                ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(workingCopy, new Modifier[]{Modifier.PRIVATE}, null, null);
                MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)"getEntityManagerFactory", (Tree)returnTypeTree, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(exceptionTree), bodyText.toString(), null);
                for (Tree tree2 : tree.getTypeDecls()) {
                    if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) continue;
                    ClassTree classTree = (ClassTree)tree2;
                    ClassTree newTree = maker.addClassMember(classTree, (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)newTree);
                }
            }
        };
        javaSource.runModificationTask((Task)task).commit();
        return "getEntityManagerFactory";
    }
}

