/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.api.lsp.ResourceOperation;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.modules.project.dependency.impl.Bundle;
import org.netbeans.modules.project.dependency.impl.ProjectModificationResultImpl;
import org.netbeans.modules.project.dependency.impl.TextDocumentEditProcessor;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Union2;

public final class WorkspaceEditAdapter
implements ModificationResult {
    private final ProjectModificationResultImpl impl;

    public WorkspaceEditAdapter(ProjectModificationResultImpl impl) {
        this.impl = impl;
    }

    public Collection<FileObject> getFilesToSave() {
        ArrayList<FileObject> processed = new ArrayList<FileObject>();
        for (FileObject f : this.impl.getFilesToSave()) {
            if (f.isVirtual()) {
                FileObject changed = URLMapper.findFileObject((URL)f.toURL());
                if (changed == null) continue;
                f = changed;
            }
            if (!f.isValid()) continue;
            processed.add(f);
        }
        return processed;
    }

    public String getResultingSource(FileObject file) throws IOException, IllegalArgumentException {
        TextDocumentEdit e = this.impl.getFileEdit(file);
        if (e == null) {
            throw new IllegalArgumentException();
        }
        TextDocumentEditProcessor proc = new TextDocumentEditProcessor(e).setForkDocument(true).execute();
        return proc.getText();
    }

    public Collection<? extends FileObject> getModifiedFileObjects() {
        LinkedHashSet<FileObject> fos = new LinkedHashSet<FileObject>();
        fos.addAll(this.impl.createFiles.keySet());
        fos.addAll(this.impl.fileModifications.keySet());
        return fos;
    }

    public Collection<? extends File> getNewFiles() {
        return ((Stream)this.impl.createFiles.keySet().stream().sequential()).map(f -> FileUtil.toFile((FileObject)f)).collect(Collectors.toList());
    }

    public void commit() throws IOException {
        WorkspaceEdit edit = this.impl.getWorkspaceEdit();
        for (Union2 ch : edit.getDocumentChanges()) {
            if (ch.hasSecond()) {
                ResourceOperation op = (ResourceOperation)ch.second();
                if (op instanceof ResourceOperation.CreateFile) {
                    FileObject parent;
                    ResourceOperation.CreateFile cf = (ResourceOperation.CreateFile)op;
                    FileObject f = ProjectModificationResultImpl.fromString(cf.getNewFile());
                    if (f.isValid()) {
                        throw new IOException(Bundle.ERR_CreatedFileAlreadyExists(f.getPath()));
                    }
                    for (parent = f.getParent(); parent != null && parent.isVirtual(); parent = parent.getParent()) {
                    }
                    String relative = FileUtil.getRelativePath((FileObject)parent, (FileObject)f);
                    FileUtil.createData((FileObject)f, (String)relative);
                    continue;
                }
                throw new IllegalStateException("Unknown resource operation");
            }
            if (!ch.hasFirst()) continue;
            TextDocumentEdit e = (TextDocumentEdit)ch.first();
            TextDocumentEditProcessor proc = new TextDocumentEditProcessor(e).setSaveAfterEdit(true);
            proc.execute();
        }
    }
}

