/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.InstrTimingData;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;

public class StackTraceSnapshotBuilder {
    static final char NAME_SIG_SPLITTER = '|';
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];
    private static final boolean COLLECT_TWO_TIMESTAMPS = true;
    private static final List<MethodInfo> knownBLockingMethods = Arrays.asList(new MethodInfo("java.net.PlainSocketImpl", "socketAccept[native]"), new MethodInfo("java.net.PlainSocketImpl", "socketAccept[native](java.net.SocketImpl) : void"), new MethodInfo("sun.awt.windows.WToolkit", "eventLoop[native]"), new MethodInfo("sun.awt.windows.WToolkit", "eventLoop[native]() : void"), new MethodInfo("java.lang.UNIXProcess", "waitForProcessExit[native]"), new MethodInfo("java.lang.UNIXProcess", "waitForProcessExit[native](int) : int"), new MethodInfo("sun.awt.X11.XToolkit", "waitForEvents[native]"), new MethodInfo("sun.awt.X11.XToolkit", "waitForEvents[native](long) : void"), new MethodInfo("apple.awt.CToolkit", "doAWTRunLoop[native]"), new MethodInfo("apple.awt.CToolkit", "doAWTRunLoop[native](long, boolean, boolean) : void"), new MethodInfo("java.lang.Object", "wait[native]"), new MethodInfo("java.lang.Object", "wait[native](long) : void"), new MethodInfo("java.lang.Thread", "sleep[native]"), new MethodInfo("java.lang.Thread", "sleep[native](long) : void"), new MethodInfo("sun.net.dns.ResolverConfigurationImpl", "notifyAddrChange0[native]"), new MethodInfo("sun.net.dns.ResolverConfigurationImpl", "notifyAddrChange0[native]() : int"), new MethodInfo("java.lang.ProcessImpl", "waitFor[native]"), new MethodInfo("java.lang.ProcessImpl", "waitFor[native]() : int"), new MethodInfo("sun.nio.ch.EPollArrayWrapper", "epollWait[native]"), new MethodInfo("sun.nio.ch.EPollArrayWrapper", "epollWait[native](long, int, long, int) : int"), new MethodInfo("java.net.DualStackPlainSocketImpl", "accept0[native]"), new MethodInfo("java.net.DualStackPlainSocketImpl", "accept0[native](int, java.net.InetSocketAddress[]) : int"), new MethodInfo("java.lang.ProcessImpl", "waitForInterruptibly[native]"), new MethodInfo("java.lang.ProcessImpl", "waitForInterruptibly[native](long) : void"), new MethodInfo("sun.print.Win32PrintServiceLookup", "notifyPrinterChange[native]"), new MethodInfo("sun.print.Win32PrintServiceLookup", "notifyPrinterChange[native](long) : int"), new MethodInfo("java.net.DualStackPlainSocketImpl", "waitForConnect[native]"), new MethodInfo("java.net.DualStackPlainSocketImpl", "waitForConnect[native](int, int) : void"), new MethodInfo("sun.nio.ch.KQueueArrayWrapper", "kevent0[native]"), new MethodInfo("sun.nio.ch.KQueueArrayWrapper", "kevent0[native](int, long, int, long) : int"), new MethodInfo("sun.nio.ch.WindowsSelectorImpl$SubSelector", "poll0[native]"), new MethodInfo("sun.nio.ch.WindowsSelectorImpl$SubSelector", "poll0[native](long, int, int[], int[], int[], long) : int"), new MethodInfo("sun.nio.ch.EPoll", "wait[native]"), new MethodInfo("java.net.PlainSocketImpl", "socketConnect[native]"), new MethodInfo("java.net.PlainSocketImpl", "socketConnect[native](java.net.InetAddress, int, int) : void"), new MethodInfo("java.net.SocketInputStream", "socketRead0[native]"), new MethodInfo("jdk.internal.misc.Unsafe", "park[native]"), new MethodInfo("java.lang.ref.Reference", "waitForReferencePendingList[native]"), new MethodInfo("java.io.FileInputStream", "readBytes[native]"), new MethodInfo("sun.management.ThreadImpl", "dumpThreads0[native]"));
    private InstrumentationFilter filter;
    final List<Long> threadIds = new ArrayList<Long>();
    final List<String> threadNames = new ArrayList<String>();
    final List<byte[]> threadCompactData = new ArrayList<byte[]>();
    final List<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
    final Map<MethodInfo, Integer> methodInfoMap = new HashMap<MethodInfo, Integer>();
    final MethodInfoMapper mapper = new MethodInfoMapper(){

        @Override
        public String getInstrMethodClass(int methodId) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)methodId).className;
        }

        @Override
        public String getInstrMethodName(int methodId) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)methodId).methodName;
        }

        @Override
        public String getInstrMethodSignature(int methodId) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)methodId).signature;
        }

        @Override
        public int getMaxMethodId() {
            return StackTraceSnapshotBuilder.this.methodInfos.size();
        }

        @Override
        public int getMinMethodId() {
            return 0;
        }
    };
    final CPUCallGraphBuilder ccgb;
    final ProfilingSessionStatus status;
    final Object lock = new Object();
    final Object stampLock = new Object();
    long currentDumpTimeStamp = -1L;
    final AtomicReference<Map<Long, SampledThreadInfo>> lastStackTrace = new AtomicReference(Collections.emptyMap());
    int stackTraceCount = 0;
    final Set<String> ignoredThreadNames = new HashSet<String>();
    final Map<Long, Long> threadtimes = new HashMap<Long, Long>();

    public StackTraceSnapshotBuilder() {
        this(1, null);
    }

    StackTraceSnapshotBuilder(CPUCallGraphBuilder b, InstrumentationFilter f, ProfilingSessionStatus s) {
        this.registerNewMethodInfo(new MethodInfo("Thread", ""));
        this.filter = f;
        this.setDefaultTiming();
        this.ccgb = b;
        this.status = s;
    }

    public StackTraceSnapshotBuilder(int batchSize, InstrumentationFilter f) {
        this.registerNewMethodInfo(new MethodInfo("Thread", ""));
        this.filter = f;
        this.setDefaultTiming();
        this.ccgb = new StackTraceCallGraphBuilder(this.mapper, f);
        this.status = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIgnoredThreads(Set<String> ignoredThreadNames) {
        Object object = this.lock;
        synchronized (object) {
            this.ignoredThreadNames.clear();
            this.ignoredThreadNames.addAll(ignoredThreadNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addStacktrace(SampledThreadInfo[] threads, long dumpTimeStamp) throws IllegalStateException {
        long timediff = this.processDumpTimeStamp(dumpTimeStamp);
        if (timediff < 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Long, SampledThreadInfo> tinfoMap = new HashMap<Long, SampledThreadInfo>();
            for (SampledThreadInfo tinfo : threads) {
                tinfoMap.put(tinfo.getThreadId(), tinfo);
            }
            this.processThreadDump(timediff, dumpTimeStamp, tinfoMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStacktrace(ThreadInfo[] threads, long dumpTimeStamp) throws IllegalStateException {
        long timediff = this.processDumpTimeStamp(dumpTimeStamp);
        if (timediff < 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            HashMap<Long, SampledThreadInfo> tinfoMap = new HashMap<Long, SampledThreadInfo>();
            for (ThreadInfo tinfo : threads) {
                if (tinfo == null) continue;
                tinfoMap.put(tinfo.getThreadId(), new SampledThreadInfo(tinfo, this.filter));
            }
            this.processThreadDump(timediff, dumpTimeStamp, tinfoMap);
        }
    }

    private void processThreadDump(long timediff, long dumpTimeStamp, Map<Long, SampledThreadInfo> tinfoMap) throws IllegalStateException {
        Thread.State newState;
        Iterator<Map.Entry<Long, SampledThreadInfo>> tinfoIt = tinfoMap.entrySet().iterator();
        while (tinfoIt.hasNext()) {
            Map.Entry<Long, SampledThreadInfo> tinfoEntry = tinfoIt.next();
            SampledThreadInfo tinfo = tinfoEntry.getValue();
            String tname = tinfo.getThreadName();
            if (this.ignoredThreadNames.contains(tname)) {
                tinfoIt.remove();
                continue;
            }
            newState = tinfo.getThreadState();
            if (Thread.State.NEW == newState) {
                tinfoIt.remove();
                continue;
            }
            long threadId = tinfo.getThreadId();
            if (!this.threadIds.contains(threadId)) {
                this.threadIds.add(threadId);
                this.threadNames.add(tname);
                this.ccgb.newThread((int)threadId, tname, "<none>");
                this.threadtimes.put(threadId, dumpTimeStamp);
            }
            StackTraceElement[] newElements = tinfo.getStackTrace();
            SampledThreadInfo oldTinfo = this.lastStackTrace.get().get(threadId);
            StackTraceElement[] oldElements = NO_STACK_TRACE;
            Thread.State oldState = Thread.State.NEW;
            if (oldTinfo != null) {
                oldElements = oldTinfo.getStackTrace();
                oldState = oldTinfo.getThreadState();
            }
            this.processDiffs((int)threadId, oldElements, newElements, dumpTimeStamp, timediff, oldState, newState);
        }
        for (SampledThreadInfo oldTinfo : this.lastStackTrace.get().values()) {
            if (tinfoMap.containsKey(oldTinfo.getThreadId())) continue;
            Thread.State oldState = oldTinfo.getThreadState();
            newState = Thread.State.TERMINATED;
            this.processDiffs((int)oldTinfo.getThreadId(), oldTinfo.getStackTrace(), NO_STACK_TRACE, dumpTimeStamp, timediff, oldState, newState);
        }
        this.lastStackTrace.set(tinfoMap);
        ++this.stackTraceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long processDumpTimeStamp(long dumpTimeStamp) {
        long timediff;
        Object object = this.stampLock;
        synchronized (object) {
            if (dumpTimeStamp <= this.currentDumpTimeStamp) {
                return -1L;
            }
            timediff = dumpTimeStamp - this.currentDumpTimeStamp;
            this.currentDumpTimeStamp = dumpTimeStamp;
        }
        return timediff;
    }

    private void processDiffs(int threadId, StackTraceElement[] oldElements, StackTraceElement[] newElements, long timestamp, long timediff, Thread.State oldState, Thread.State newState) throws IllegalStateException {
        assert (newState != Thread.State.NEW) : "Invalid thread state " + newState.name() + " for taking a stack trace";
        if (oldState == Thread.State.TERMINATED && newState != Thread.State.TERMINATED) {
            throw new IllegalStateException("Thread has already been set to " + Thread.State.TERMINATED.name() + " - stack trace can not be taken");
        }
        long threadtime = this.threadtimes.get(threadId);
        if (oldState == Thread.State.RUNNABLE) {
            this.threadtimes.put(Long.valueOf(threadId), threadtime += timediff);
        }
        this.processDiffs(threadId, oldElements, newElements, timestamp, threadtime);
    }

    private void processDiffs(int threadId, StackTraceElement[] oldElements, StackTraceElement[] newElements, long timestamp, long threadtimestamp) throws IllegalStateException {
        if (oldElements.length == 0 && newElements.length == 0) {
            return;
        }
        int newMax = newElements.length - 1;
        int oldMax = oldElements.length - 1;
        int globalMax = Math.max(oldMax, newMax);
        List<StackTraceElement> newElementsList = Collections.EMPTY_LIST;
        List<StackTraceElement> oldElementsList = Collections.EMPTY_LIST;
        for (int iteratorIndex = 0; iteratorIndex <= globalMax; ++iteratorIndex) {
            StackTraceElement newElement;
            StackTraceElement oldElement = oldMax >= iteratorIndex ? oldElements[oldMax - iteratorIndex] : null;
            StackTraceElement stackTraceElement = newElement = newMax >= iteratorIndex ? newElements[newMax - iteratorIndex] : null;
            if (oldElement != null && newElement != null) {
                if (oldElement.equals(newElement)) continue;
                if (this.hasSameMethodInfo(oldElement, newElement)) {
                    ++iteratorIndex;
                }
                newElementsList = Arrays.asList(newElements).subList(0, newMax - iteratorIndex + 1);
                oldElementsList = Arrays.asList(oldElements).subList(0, oldMax - iteratorIndex + 1);
                break;
            }
            if (oldElement == null && newElement != null) {
                newElementsList = Arrays.asList(newElements).subList(0, newMax - iteratorIndex + 1);
                break;
            }
            if (oldElement == null || newElement != null) continue;
            oldElementsList = Arrays.asList(oldElements).subList(0, oldMax - iteratorIndex + 1);
            break;
        }
        this.addMethodExits(threadId, oldElementsList, timestamp, threadtimestamp, newElements.length == 0);
        this.addMethodEntries(threadId, newElementsList, timestamp, threadtimestamp, oldElements.length == 0);
    }

    private void addMethodEntries(int threadId, List<StackTraceElement> elements, long timestamp, long threadtimestamp, boolean asRoot) throws IllegalStateException {
        boolean inRoot = false;
        ListIterator<StackTraceElement> reverseIt = elements.listIterator(elements.size());
        while (reverseIt.hasPrevious()) {
            StackTraceElement element = reverseIt.previous();
            MethodInfo mi = new MethodInfo(element);
            Integer mId = this.methodInfoMap.get(mi);
            if (mId == null) {
                mId = this.registerNewMethodInfo(mi);
                if (this.status != null) {
                    String method = mi.methodName;
                    int index = method.indexOf(40);
                    if (index > 0) {
                        method = method.substring(0, index);
                    }
                    this.status.updateInstrMethodsInfo(mi.className, 0, method, mi.signature);
                }
            }
            if (asRoot && !inRoot) {
                inRoot = true;
                this.ccgb.methodEntry(mId, threadId, 2, timestamp, threadtimestamp, null, null);
                continue;
            }
            this.ccgb.methodEntry(mId, threadId, 1, timestamp, threadtimestamp, null, null);
        }
    }

    private Integer registerNewMethodInfo(MethodInfo mi) {
        Integer index = this.methodInfos.size();
        this.methodInfos.add(mi);
        this.methodInfoMap.put(mi, index);
        return index;
    }

    private void addMethodExits(int threadId, List<StackTraceElement> elements, long timestamp, long threadtimestamp, boolean asRoot) throws IllegalStateException {
        int rootIndex = elements.size();
        for (StackTraceElement element : elements) {
            MethodInfo mi = new MethodInfo(element);
            Integer index = this.methodInfoMap.get(mi);
            if (index == null) {
                System.err.println("*** Not found: " + mi);
                throw new IllegalStateException();
            }
            if (asRoot && --rootIndex == 0) {
                this.ccgb.methodExit(index, threadId, 2, timestamp, threadtimestamp, null);
                continue;
            }
            this.ccgb.methodExit(index, threadId, 1, timestamp, threadtimestamp, null);
        }
    }

    private boolean hasSameMethodInfo(StackTraceElement oldElement, StackTraceElement newElement) {
        MethodInfo oldMethodInfo = new MethodInfo(oldElement);
        MethodInfo newMethodInfo = new MethodInfo(newElement);
        return oldMethodInfo.equals(newMethodInfo);
    }

    private void setDefaultTiming() {
        ProfilingSessionStatus pss = new ProfilingSessionStatus();
        pss.timerCountsInSecond[0] = InstrTimingData.DEFAULT.timerCountsInSecond0;
        pss.timerCountsInSecond[1] = InstrTimingData.DEFAULT.timerCountsInSecond1;
        pss.currentInstrType = 3;
        pss.absoluteTimerOn = true;
        pss.threadCPUTimerOn = true;
        TimingAdjusterOld.getInstance(pss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CPUResultsSnapshot createSnapshot(long since) throws CPUResultsSnapshot.NoDataAvailableException {
        if (this.stackTraceCount < 1) {
            throw new CPUResultsSnapshot.NoDataAvailableException();
        }
        Object object = this.lock;
        synchronized (object) {
            int miCount = this.methodInfos.size();
            String[] instrMethodClasses = new String[this.methodInfos.size()];
            String[] instrMethodNames = new String[this.methodInfos.size()];
            String[] instrMethodSigs = new String[this.methodInfos.size()];
            int counter = 0;
            for (MethodInfo mi : this.methodInfos) {
                instrMethodClasses[counter] = mi.className;
                instrMethodNames[counter] = mi.methodName;
                instrMethodSigs[counter] = "";
                ++counter;
            }
            this.addStacktrace(new ThreadInfo[0], this.currentDumpTimeStamp + 1L);
            return new CPUResultsSnapshot(since, System.currentTimeMillis(), this.ccgb, this.ccgb.isCollectingTwoTimeStamps(), instrMethodClasses, instrMethodNames, instrMethodSigs, miCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.ccgb.reset();
            if (this.status != null) {
                this.status.resetInstrClassAndMethodInfo();
            }
            this.methodInfos.clear();
            this.methodInfoMap.clear();
            this.threadIds.clear();
            this.threadNames.clear();
            this.stackTraceCount = 0;
            this.lastStackTrace.set(Collections.emptyMap());
            this.registerNewMethodInfo(new MethodInfo("Thread", ""));
            Object object2 = this.stampLock;
            synchronized (object2) {
                this.currentDumpTimeStamp = -1L;
            }
        }
    }

    public MethodInfoMapper getMapper() {
        return this.mapper;
    }

    public RuntimeCCTNode getAppRootNode() {
        return this.ccgb.getAppRootNode();
    }

    public boolean collectionTwoTimeStamps() {
        return true;
    }

    public InstrumentationFilter getFilter() {
        return this.filter;
    }

    private class StackTraceCallGraphBuilder
    extends CPUCallGraphBuilder {
        StackTraceCallGraphBuilder(MethodInfoMapper mapper, InstrumentationFilter filter) {
            this.setFilter(filter);
            this.setMethodInfoMapper(mapper);
        }

        @Override
        protected boolean isCollectingTwoTimeStamps() {
            return true;
        }

        @Override
        protected boolean isReady() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long getDumpAbsTimeStamp() {
            Object object = StackTraceSnapshotBuilder.this.stampLock;
            synchronized (object) {
                return StackTraceSnapshotBuilder.this.currentDumpTimeStamp;
            }
        }
    }

    static class SampledThreadInfo {
        private StackTraceElement[] stackTrace;
        private Thread.State state;
        private String threadName;
        private long threadId;

        SampledThreadInfo(String tn, long tid, Thread.State ts, StackTraceElement[] st, InstrumentationFilter filter) {
            this.threadName = tn;
            this.threadId = tid;
            this.state = ts;
            this.stackTrace = st;
            if (this.state == Thread.State.RUNNABLE && SampledThreadInfo.containsKnownBlockingMethod(st)) {
                this.state = Thread.State.WAITING;
            }
            if (filter != null) {
                int i;
                for (i = 0; i < st.length; ++i) {
                    StackTraceElement frame = st[i];
                    if (!filter.passes(frame.getClassName().replace('.', '/'))) continue;
                    if (i <= 1) break;
                    this.stackTrace = new StackTraceElement[st.length - i + 1];
                    System.arraycopy(st, i - 1, this.stackTrace, 0, this.stackTrace.length);
                    break;
                }
                if (i == st.length) {
                    this.stackTrace = NO_STACK_TRACE;
                }
            }
        }

        SampledThreadInfo(ThreadInfo info, InstrumentationFilter filter) {
            this(info.getThreadName(), info.getThreadId(), info.getThreadState(), info.getStackTrace(), filter);
        }

        private static boolean containsKnownBlockingMethod(StackTraceElement[] stackTrace) {
            if (stackTrace.length > 0) {
                MethodInfo firstFrame = new MethodInfo(stackTrace[0]);
                return knownBLockingMethods.contains(firstFrame);
            }
            return false;
        }

        private StackTraceElement[] getStackTrace() {
            return this.stackTrace;
        }

        Thread.State getThreadState() {
            return this.state;
        }

        private String getThreadName() {
            return this.threadName;
        }

        private long getThreadId() {
            return this.threadId;
        }
    }

    static class MethodInfo {
        final String className;
        final String methodName;
        final String signature;
        final boolean isNative;

        MethodInfo(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
            this.signature = "";
            this.isNative = false;
        }

        MethodInfo(StackTraceElement element) {
            String method;
            this.isNative = element.isNativeMethod();
            String nativeSuffix = "[native]";
            String methodAndSigName = element.getMethodName();
            int index = methodAndSigName.indexOf(124);
            if (index > 0) {
                method = methodAndSigName.substring(0, index);
                this.signature = methodAndSigName.substring(index + 1);
            } else {
                method = methodAndSigName;
                this.signature = "";
            }
            this.methodName = this.isNative ? ((index = method.indexOf(40)) > 0 ? new StringBuilder(method).insert(index, "[native]").toString() : method + "[native]") : method;
            this.className = element.getClassName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodInfo other = (MethodInfo)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.className != null ? this.className.hashCode() : 0);
            hash = 29 * hash + (this.methodName != null ? this.methodName.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.className + "." + this.methodName + "()";
        }
    }
}

