/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.upgrade.systemoptions.PropertyProcessor;
import org.netbeans.upgrade.systemoptions.SerParser;

class URLProcessor
extends PropertyProcessor {
    URLProcessor() {
        super("java.net.URL");
    }

    @Override
    void processPropertyImpl(String propertyName, Object value) {
        if ("mainProjectURL".equals(propertyName)) {
            List<Object> l = ((SerParser.ObjectWrapper)value).data;
            try {
                URL url = URLProcessor.createURL(l);
                this.addProperty(propertyName, url.toExternalForm());
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public static URL createURL(List l) throws MalformedURLException {
        String protocol = null;
        String host = null;
        int port = -1;
        String file = null;
        String authority = null;
        String ref = null;
        for (Object elem : l) {
            if (!(elem instanceof SerParser.NameValue)) continue;
            SerParser.NameValue nv = (SerParser.NameValue)elem;
            if (nv.value == null || nv.name == null) continue;
            if (nv.name.name.equals("port")) {
                port = (Integer)nv.value;
                continue;
            }
            if (nv.name.name.equals("file")) {
                file = nv.value.toString();
                continue;
            }
            if (nv.name.name.equals("authority")) {
                authority = nv.value.toString();
                continue;
            }
            if (nv.name.name.equals("host")) {
                host = nv.value.toString();
                continue;
            }
            if (nv.name.name.equals("protocol")) {
                protocol = nv.value.toString();
                continue;
            }
            if (!nv.name.name.equals("ref")) continue;
            ref = nv.value.toString();
        }
        return new URL(protocol, host, port, file);
    }
}

