/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.shellsupport.doc;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.EscapeTree;
import com.sun.source.doctree.InlineTagTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.lang.model.element.Name;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

public class JavadocFormatter {
    private static final String CODE_RESET = "\u001b[0m";
    private static final String CODE_HIGHLIGHT = "\u001b[1m";
    private static final String CODE_UNDERLINE = "\u001b[4m";
    private final int lineLimit;
    private final boolean escapeSequencesSupported;
    private static final int MAX_LINE_LENGTH = 95;
    private static final int SHORTEST_LINE = 30;
    private static final int INDENT = 4;
    private static final Map<Sections, String> docSections = new LinkedHashMap<Sections, String>();
    private static final String inlineReturns;

    public JavadocFormatter(int lineLimit, boolean escapeSequencesSupported) {
        this.lineLimit = lineLimit;
        this.escapeSequencesSupported = escapeSequencesSupported;
    }

    public String formatJavadoc(String header, final String javadoc) {
        try {
            StringBuilder result = new StringBuilder();
            result.append(this.escape(CODE_HIGHLIGHT)).append(header).append(this.escape(CODE_RESET)).append("\n");
            if (javadoc == null) {
                return result.toString();
            }
            JavacTask task = (JavacTask)ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, null);
            DocTrees trees = DocTrees.instance(task);
            DocCommentTree docComment = trees.getDocCommentTree(new SimpleJavaFileObject(new URI("mem://doc.html"), JavaFileObject.Kind.HTML){

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    return "<body>" + javadoc + "</body>";
                }
            });
            new FormatJavadocScanner(result, task).scan((DocTree)docComment, (Object)null);
            JavadocFormatter.addNewLineIfNeeded(result);
            return result.toString();
        }
        catch (URISyntaxException ex) {
            throw new InternalError("Unexpected exception", ex);
        }
    }

    private String escape(String sequence) {
        return this.escapeSequencesSupported ? sequence : "";
    }

    private static String indentString(int indent) {
        char[] content = new char[indent];
        Arrays.fill(content, ' ');
        return new String(content);
    }

    private static void reflow(StringBuilder text, int from, int indent, int limit) {
        int lineStart;
        for (lineStart = from; lineStart > 0 && text.charAt(lineStart - 1) != '\n'; --lineStart) {
        }
        int lineChars = from - lineStart;
        int lastSpace = -1;
        for (int pointer = from; pointer < text.length(); ++pointer) {
            if (text.charAt(pointer) == ' ') {
                lastSpace = pointer;
            }
            if (lineChars >= limit && lastSpace != -1) {
                text.setCharAt(lastSpace, '\n');
                text.insert(lastSpace + 1, JavadocFormatter.indentString(indent));
                lineChars = indent + pointer - lastSpace - 1;
                pointer += indent;
                lastSpace = -1;
            }
            ++lineChars;
        }
    }

    private static void addNewLineIfNeeded(StringBuilder text) {
        if (text.length() > 0 && text.charAt(text.length() - 1) != '\n') {
            text.append("\n");
        }
    }

    private static void addSpaceIfNeeded(StringBuilder text) {
        if (text.length() == 0) {
            return;
        }
        char last = text.charAt(text.length() - 1);
        if (last != ' ' && last != '\n') {
            text.append(" ");
        }
    }

    private static HtmlTag getHtmlTag(Name name) {
        HtmlTag tag = HtmlTag.get(name);
        return tag != null ? tag : HtmlTag.HTML;
    }

    private static Map<StartElementTree, Integer> countTableColumns(DocCommentTree dct) {
        final IdentityHashMap<StartElementTree, Integer> result = new IdentityHashMap<StartElementTree, Integer>();
        new DocTreeScanner<Void, Void>(){
            private StartElementTree currentTable;
            private int currentMaxColumns;
            private int currentRowColumns;

            @Override
            public Void visitStartElement(StartElementTree node, Void p) {
                switch (JavadocFormatter.getHtmlTag(node.getName())) {
                    case TABLE: {
                        this.currentTable = node;
                        break;
                    }
                    case TR: {
                        this.currentMaxColumns = Math.max(this.currentMaxColumns, this.currentRowColumns);
                        this.currentRowColumns = 0;
                        break;
                    }
                    case TH: 
                    case TD: {
                        ++this.currentRowColumns;
                    }
                }
                return (Void)super.visitStartElement(node, p);
            }

            @Override
            public Void visitEndElement(EndElementTree node, Void p) {
                if (HtmlTag.get(node.getName()) == HtmlTag.TABLE) {
                    this.closeTable();
                }
                return (Void)super.visitEndElement(node, p);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitDocComment(DocCommentTree node, Void p) {
                try {
                    Void void_ = (Void)super.visitDocComment(node, p);
                    return void_;
                }
                finally {
                    this.closeTable();
                }
            }

            private void closeTable() {
                if (this.currentTable != null) {
                    result.put(this.currentTable, Math.max(this.currentMaxColumns, this.currentRowColumns));
                    this.currentTable = null;
                }
            }
        }.scan(dct, null);
        return result;
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("jdk.internal.shellsupport.doc.resources.javadocformatter");
        docSections.put(Sections.TYPE_PARAMS, bundle.getString("CAP_TypeParameters"));
        docSections.put(Sections.PARAMS, bundle.getString("CAP_Parameters"));
        docSections.put(Sections.RETURNS, bundle.getString("CAP_Returns"));
        docSections.put(Sections.THROWS, bundle.getString("CAP_Thrown_Exceptions"));
        inlineReturns = bundle.getString("Inline_Returns");
    }

    static enum HtmlTag {
        HTML,
        H1,
        H2,
        H3,
        H4,
        H5,
        H6,
        BLOCKQUOTE,
        P,
        PRE,
        IMG,
        OL,
        UL,
        LI,
        DL,
        DT,
        DD,
        TABLE,
        TR,
        TD,
        TH;

        private static final Map<String, HtmlTag> index;

        public static HtmlTag get(Name tagName) {
            return index.get(StringUtils.toLowerCase(tagName.toString()));
        }

        static {
            index = new HashMap<String, HtmlTag>();
            for (HtmlTag t : HtmlTag.values()) {
                index.put(StringUtils.toLowerCase(t.name()), t);
            }
        }
    }

    private class FormatJavadocScanner
    extends DocTreeScanner<Object, Object> {
        private final StringBuilder result;
        private final JavacTask task;
        private final DocTrees trees;
        private int reflownTo;
        private int indent;
        private int limit;
        private boolean pre;
        private Map<StartElementTree, Integer> tableColumns;
        Stack<Integer> listStack;
        Stack<Integer> defStack;
        Stack<Integer> tableStack;
        Stack<List<Integer>> cellsStack;
        Stack<List<Boolean>> headerStack;
        private DocTree lastNode;

        public FormatJavadocScanner(StringBuilder result, JavacTask task) {
            this.limit = Math.min(JavadocFormatter.this.lineLimit, 95);
            this.listStack = new Stack();
            this.defStack = new Stack();
            this.tableStack = new Stack();
            this.cellsStack = new Stack();
            this.headerStack = new Stack();
            this.result = result;
            this.task = task;
            this.trees = DocTrees.instance(task);
        }

        @Override
        public Object visitDocComment(DocCommentTree node, Object p) {
            this.tableColumns = JavadocFormatter.countTableColumns(node);
            this.reflownTo = this.result.length();
            this.scan(node.getFirstSentence(), p);
            this.scan(node.getBody(), p);
            JavadocFormatter.reflow(this.result, this.reflownTo, this.indent, this.limit);
            for (Sections current : docSections.keySet()) {
                List<? extends DocTree> firstSentence;
                boolean seenAny = false;
                for (DocTree docTree : node.getBlockTags()) {
                    if (!current.matches(docTree)) continue;
                    if (!seenAny) {
                        seenAny = true;
                        this.startSection(current);
                    }
                    this.scan(docTree, (Object)null);
                }
                if (current != Sections.RETURNS || seenAny || (firstSentence = node.getFirstSentence()).size() != 1 || firstSentence.get(0).getKind() != DocTree.Kind.RETURN) continue;
                this.startSection(current);
                this.scan(firstSentence.get(0), (Object)true);
            }
            return null;
        }

        private void startSection(Sections current) {
            if (this.result.charAt(this.result.length() - 1) != '\n') {
                this.result.append("\n");
            }
            this.result.append("\n");
            this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_UNDERLINE)).append((String)docSections.get((Object)current)).append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET)).append("\n");
        }

        @Override
        public Object visitText(TextTree node, Object p) {
            String text = node.getBody();
            if (!this.pre) {
                if ((text = text.replaceAll("[ \t\r\n]+", " ").trim()).length() == 0) {
                    text = " ";
                }
            } else {
                text = text.replaceAll("\n", "\n" + JavadocFormatter.indentString(this.indent));
            }
            this.result.append(text);
            return null;
        }

        @Override
        public Object visitEscape(EscapeTree node, Object p) {
            this.result.append(node.getBody());
            return null;
        }

        @Override
        public Object visitLink(LinkTree node, Object p) {
            if (!node.getLabel().isEmpty()) {
                this.scan(node.getLabel(), p);
            } else {
                this.result.append(node.getReference().getSignature());
            }
            return null;
        }

        @Override
        public Object visitParam(ParamTree node, Object p) {
            return this.formatDef(node.getName().getName(), node.getDescription());
        }

        @Override
        public Object visitThrows(ThrowsTree node, Object p) {
            return this.formatDef(node.getExceptionName().getSignature(), node.getDescription());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object formatDef(CharSequence name, List<? extends DocTree> description) {
            this.result.append(name);
            this.result.append(" - ");
            this.reflownTo = this.result.length();
            this.indent = name.length() + 3;
            if (this.limit - this.indent < 30) {
                this.result.append("\n");
                this.result.append(JavadocFormatter.indentString(4));
                this.indent = 4;
                this.reflownTo += 4;
            }
            try {
                Object r = this.scan(description, null);
                return r;
            }
            finally {
                JavadocFormatter.reflow(this.result, this.reflownTo, this.indent, this.limit);
                this.result.append("\n");
            }
        }

        @Override
        public Object visitLiteral(LiteralTree node, Object p) {
            return this.scan((DocTree)node.getBody(), p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object visitReturn(ReturnTree node, Object p) {
            if (node.isInline() && p == null) {
                String MARKER = "{0}";
                int p0 = inlineReturns.indexOf(MARKER);
                this.result.append(inlineReturns, 0, p0);
                try {
                    Object r = super.visitReturn(node, p);
                    return r;
                }
                finally {
                    this.result.append(inlineReturns.substring(p0 + MARKER.length()));
                }
            }
            this.reflownTo = this.result.length();
            try {
                Object r = super.visitReturn(node, p);
                return r;
            }
            finally {
                JavadocFormatter.reflow(this.result, this.reflownTo, 0, this.limit);
            }
        }

        @Override
        public Object visitStartElement(StartElementTree node, Object p) {
            block0 : switch (JavadocFormatter.getHtmlTag(node.getName())) {
                case P: {
                    if (this.lastNode != null && this.lastNode.getKind() == DocTree.Kind.START_ELEMENT && HtmlTag.get(((StartElementTree)this.lastNode).getName()) == HtmlTag.LI) break;
                    this.reflowTillNow();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.result.append(JavadocFormatter.indentString(this.indent));
                    this.reflownTo = this.result.length();
                    break;
                }
                case BLOCKQUOTE: {
                    this.reflowTillNow();
                    this.indent += 4;
                    break;
                }
                case PRE: {
                    this.reflowTillNow();
                    this.pre = true;
                    break;
                }
                case UL: {
                    this.reflowTillNow();
                    this.listStack.push(-1);
                    this.indent += 4;
                    break;
                }
                case OL: {
                    this.reflowTillNow();
                    this.listStack.push(1);
                    this.indent += 4;
                    break;
                }
                case DL: {
                    this.reflowTillNow();
                    this.defStack.push(this.indent);
                    break;
                }
                case LI: {
                    this.reflowTillNow();
                    if (this.listStack.empty()) break;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    int top = this.listStack.pop();
                    if (top == -1) {
                        this.result.append(JavadocFormatter.indentString(this.indent - 2));
                        this.result.append("* ");
                    } else {
                        this.result.append(JavadocFormatter.indentString(this.indent - 3));
                        this.result.append("" + top++ + ". ");
                    }
                    this.listStack.push(top);
                    this.reflownTo = this.result.length();
                    break;
                }
                case DT: {
                    this.reflowTillNow();
                    if (this.defStack.isEmpty()) break;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.indent = this.defStack.peek();
                    this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_HIGHLIGHT));
                    break;
                }
                case DD: {
                    this.reflowTillNow();
                    if (this.defStack.isEmpty()) break;
                    if (this.indent == this.defStack.peek()) {
                        this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET));
                    }
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.indent = this.defStack.peek() + 4;
                    this.result.append(JavadocFormatter.indentString(this.indent));
                    break;
                }
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.reflowTillNow();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.result.append("\n").append(JavadocFormatter.this.escape(JavadocFormatter.CODE_UNDERLINE));
                    this.reflownTo = this.result.length();
                    break;
                }
                case TABLE: {
                    int columns = this.tableColumns.get(node);
                    if (columns == 0) break;
                    this.reflowTillNow();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.reflownTo = this.result.length();
                    this.tableStack.push(this.limit);
                    this.limit = (this.limit - 1) / columns - 3;
                    for (int sep = 0; sep < (this.limit + 3) * columns + 1; ++sep) {
                        this.result.append("-");
                    }
                    this.result.append("\n");
                    break;
                }
                case TR: {
                    if (this.cellsStack.size() >= this.tableStack.size()) {
                        this.handleEndElement(node.getName());
                    }
                    this.cellsStack.push(new ArrayList());
                    this.headerStack.push(new ArrayList());
                    break;
                }
                case TH: 
                case TD: {
                    if (this.cellsStack.isEmpty()) break;
                    this.reflowTillNow();
                    this.result.append("\n");
                    this.reflownTo = this.result.length();
                    this.cellsStack.peek().add(this.result.length());
                    this.headerStack.peek().add(HtmlTag.get(node.getName()) == HtmlTag.TH);
                    break;
                }
                case IMG: {
                    for (DocTree docTree : node.getAttributes()) {
                        AttributeTree at;
                        if (docTree.getKind() != DocTree.Kind.ATTRIBUTE || !"alt".equals(StringUtils.toLowerCase((at = (AttributeTree)docTree).getName().toString()))) continue;
                        JavadocFormatter.addSpaceIfNeeded(this.result);
                        this.scan(at.getValue(), null);
                        JavadocFormatter.addSpaceIfNeeded(this.result);
                        break block0;
                    }
                    break;
                }
                default: {
                    JavadocFormatter.addSpaceIfNeeded(this.result);
                }
            }
            return null;
        }

        @Override
        public Object visitEndElement(EndElementTree node, Object p) {
            this.handleEndElement(node.getName());
            return super.visitEndElement(node, p);
        }

        private void handleEndElement(Name name) {
            switch (JavadocFormatter.getHtmlTag(name)) {
                case BLOCKQUOTE: {
                    this.indent -= 4;
                    break;
                }
                case PRE: {
                    this.pre = false;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.reflownTo = this.result.length();
                    break;
                }
                case UL: 
                case OL: {
                    if (this.listStack.isEmpty()) break;
                    this.reflowTillNow();
                    this.listStack.pop();
                    this.indent -= 4;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    break;
                }
                case DL: {
                    if (this.defStack.isEmpty()) break;
                    this.reflowTillNow();
                    if (this.indent == this.defStack.peek()) {
                        this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET));
                    }
                    this.indent = this.defStack.pop();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    break;
                }
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.reflowTillNow();
                    this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET)).append("\n");
                    this.reflownTo = this.result.length();
                    break;
                }
                case TABLE: {
                    if (this.cellsStack.size() >= this.tableStack.size()) {
                        this.handleEndElement(this.task.getElements().getName("tr"));
                    }
                    if (this.tableStack.isEmpty()) break;
                    this.limit = this.tableStack.pop();
                    break;
                }
                case TR: {
                    if (this.cellsStack.isEmpty()) break;
                    this.reflowTillNow();
                    List<Integer> cells = this.cellsStack.pop();
                    List<Boolean> headerFlags = this.headerStack.pop();
                    ArrayList<String[]> content = new ArrayList<String[]>();
                    int maxLines = 0;
                    this.result.append("\n");
                    while (!cells.isEmpty()) {
                        int currentCell = cells.remove(cells.size() - 1);
                        String[] lines = this.result.substring(currentCell, this.result.length()).split("\n");
                        this.result.delete(currentCell - 1, this.result.length());
                        content.add(lines);
                        maxLines = Math.max(maxLines, lines.length);
                    }
                    Collections.reverse(content);
                    for (int line = 0; line < maxLines; ++line) {
                        for (int column = 0; column < content.size(); ++column) {
                            int padding;
                            String[] lines = (String[])content.get(column);
                            String currentLine = line < lines.length ? lines[line] : "";
                            this.result.append("| ");
                            boolean header = headerFlags.get(column);
                            if (header) {
                                this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_HIGHLIGHT));
                            }
                            this.result.append(currentLine);
                            if (header) {
                                this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET));
                            }
                            if ((padding = this.limit - currentLine.length()) > 0) {
                                this.result.append(JavadocFormatter.indentString(padding));
                            }
                            this.result.append(" ");
                        }
                        this.result.append("|\n");
                    }
                    for (int sep = 0; sep < (this.limit + 3) * content.size() + 1; ++sep) {
                        this.result.append("-");
                    }
                    this.result.append("\n");
                    this.reflownTo = this.result.length();
                    break;
                }
                case TH: 
                case TD: {
                    break;
                }
                default: {
                    JavadocFormatter.addSpaceIfNeeded(this.result);
                }
            }
        }

        @Override
        public Object visitEntity(EntityTree node, Object p) {
            String value = this.trees.getCharacters(node);
            this.result.append(value == null ? node.toString() : value);
            return super.visitEntity(node, p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object scan(DocTree node, Object p) {
            if (node instanceof InlineTagTree) {
                JavadocFormatter.addSpaceIfNeeded(this.result);
            }
            try {
                Object r = super.scan(node, p);
                return r;
            }
            finally {
                if (node instanceof InlineTagTree) {
                    JavadocFormatter.addSpaceIfNeeded(this.result);
                }
                this.lastNode = node;
            }
        }

        private void reflowTillNow() {
            while (this.result.length() > 0 && this.result.charAt(this.result.length() - 1) == ' ') {
                this.result.delete(this.result.length() - 1, this.result.length());
            }
            this.reflownTo = Math.min(this.reflownTo, this.result.length());
            JavadocFormatter.reflow(this.result, this.reflownTo, this.indent, this.limit);
            this.reflownTo = this.result.length();
        }
    }

    private static enum Sections {
        TYPE_PARAMS{

            @Override
            public boolean matches(DocTree t) {
                return t.getKind() == DocTree.Kind.PARAM && ((ParamTree)t).isTypeParameter();
            }
        }
        ,
        PARAMS{

            @Override
            public boolean matches(DocTree t) {
                return t.getKind() == DocTree.Kind.PARAM && !((ParamTree)t).isTypeParameter();
            }
        }
        ,
        RETURNS{

            @Override
            public boolean matches(DocTree t) {
                return t.getKind() == DocTree.Kind.RETURN;
            }
        }
        ,
        THROWS{

            @Override
            public boolean matches(DocTree t) {
                return t.getKind() == DocTree.Kind.THROWS;
            }
        };


        public abstract boolean matches(DocTree var1);
    }
}

