/**
 * The CSSValue interface represents a simple or a complex value. A CSSValue object only occurs in a context of a CSS property.
 */
var CSSValue = {
}
/**
 * A code defining the type of the value as defined above.
 * @syntax cSSValue.cssValueType
 * @returns {Number} 
 */
CSSValue.prototype.cssValueType = new Number();

/**
 * The value is a custom value.
 * @syntax CSSValue.CSS_CUSTOM
 * @returns {Number} 
 * @static
 */
CSSValue.CSS_CUSTOM = new Number();

/**
 * A string representation of the current value. Exceptions on setting DOMException SYNTAX_ERR: Raised if the specified CSS string value has a syntax error (according to the attached property) or is unparsable. INVALID_MODIFICATION_ERR: Raised if the specified CSS string value represents a different type of values than the values allowed by the CSS property. NO_MODIFICATION_ALLOWED_ERR: Raised if this value is readonly.
 * @syntax cSSValue.cssText
 * @returns {String} 
 */
CSSValue.prototype.cssText = new String();

/**
 * The value is a CSSValue list and an instance of the CSSValueList interface can be obtained by using binding-specific casting methods on this instance of the CSSValue interface.
 * @syntax CSSValue.CSS_VALUE_LIST
 * @returns {Number} 
 * @static
 */
CSSValue.CSS_VALUE_LIST = new Number();

/**
 * The value is a primitive value and an instance of the CSSPrimitiveValue interface can be obtained by using binding-specific casting methods on this instance of the CSSValue interface.
 * @syntax CSSValue.CSS_PRIMITIVE_VALUE
 * @returns {Number} 
 * @static
 */
CSSValue.CSS_PRIMITIVE_VALUE = new Number();

/**
 * The value is inherited and the cssText contains "inherit".
 * @syntax CSSValue.CSS_INHERIT
 * @returns {Number} 
 * @static
 */
CSSValue.CSS_INHERIT = new Number();

/**
 * Represents the CSSValue prototype object.
 * @syntax CSSValue.prototype
 * @static
 */
CSSValue.prototype;

