/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.IOException;
import java.lang.ref.WeakReference;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.jsf.refactoring.Modifications;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class DiffElement
extends SimpleRefactoringElementImplementation {
    private final Modifications.Difference diff;
    private final Modifications modification;
    private WeakReference<String> newFileContent;
    private final FileObject parentFile;

    public DiffElement(Modifications.Difference diff, FileObject parentFile, Modifications modification) {
        this.diff = diff;
        this.modification = modification;
        this.parentFile = parentFile;
    }

    public String getDisplayText() {
        return this.diff.getDesription();
    }

    public String getText() {
        return this.diff.getDesription();
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this.parentFile, this.diff});
    }

    public void setEnabled(boolean enabled) {
        this.diff.setExclude(!enabled);
        this.newFileContent = null;
        super.setEnabled(enabled);
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    protected String getNewFileContent() {
        String result;
        if (this.newFileContent != null && (result = (String)this.newFileContent.get()) != null) {
            return result;
        }
        try {
            result = this.modification.getResultingSource(this.parentFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        this.newFileContent = new WeakReference<String>(result);
        return result;
    }

    public static class ChangeFQCNElement
    extends DiffElement {
        private final Occurrences.OccurrenceItem occurence;

        public ChangeFQCNElement(Modifications.Difference diff, Occurrences.OccurrenceItem occurence, Modifications modification) {
            super(diff, occurence.getFacesConfig(), modification);
            this.occurence = occurence;
        }

        public void performChange() {
            try {
                this.occurence.performChange();
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void undoChange() {
            try {
                this.occurence.undoChange();
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public PositionBounds getPosition() {
            return this.occurence.getChangePosition();
        }
    }
}

