/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.NumberFormat;

public class FormattedCounter {
    private final NumberFormat myFormat;
    private final Boolean myLowercase;
    private final String myDelimiter;
    private int myCount;

    public FormattedCounter(NumberFormat format, Boolean lowercase, String delimiter) {
        this.myFormat = format;
        this.myLowercase = lowercase;
        this.myDelimiter = delimiter;
        this.reset();
    }

    public void reset() {
        this.myCount = 0;
    }

    public int getCount() {
        return this.myCount;
    }

    public int nextCount() {
        return ++this.myCount;
    }

    public String getFormatted(boolean withDelimiter) {
        String s = NumberFormat.getFormat(this.myFormat, Utils.minLimit(this.myCount, 1));
        String o = this.myLowercase == null ? s : (this.myLowercase != false ? s.toLowerCase() : s.toUpperCase());
        return withDelimiter && this.myDelimiter != null && !this.myDelimiter.isEmpty() ? o + this.myDelimiter : o;
    }
}

