/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditor;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.FormUtils;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public abstract class FormProperty
extends Node.Property {
    public static final String PROP_VALUE = "propertyValue";
    public static final String CURRENT_EDITOR = "currentEditor";
    public static final String PROP_VALUE_AND_EDITOR = "propertyValueAndEditor";
    public static final String PROP_PRE_CODE = "preCode";
    public static final String PROP_POST_CODE = "postCode";
    public static final int NORMAL_RW = 0;
    public static final int DETACHED_READ = 1;
    public static final int DETACHED_WRITE = 2;
    private static final int NO_READ_PROP = 4;
    private static final int NO_WRITE_PROP = 8;
    public static final int NO_READ = 5;
    public static final int NO_WRITE = 10;
    public static final Object DEFAULT_VALUE = new Object();
    protected int propType = 0;
    FormPropertyContext propertyContext;
    protected Object propertyValue;
    protected boolean valueSet = false;
    boolean valueChanged = false;
    private boolean externalChangeMonitoring = true;
    private Object lastRealValue;
    String preCode;
    String postCode;
    FormPropertyEditor formPropertyEditor;
    PropertyEditor currentEditor;
    private PropertyChangeSupport changeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private boolean fireChanges = true;
    private List<ValueConvertor> convertors;
    public static final Filter CHANGED_PROPERTY_FILTER = new Filter(){

        @Override
        public boolean accept(FormProperty property) {
            return property.isChanged();
        }
    };

    protected FormProperty(FormPropertyContext propertyContext, String name, Class type, String displayName, String shortDescription) {
        super(type);
        this.setValue("changeImmediate", Boolean.FALSE);
        this.setName(name);
        this.setDisplayName(displayName);
        this.setShortDescription(FormProperty.getDescriptionWithType(shortDescription, this.getValueType()));
        this.propertyContext = FormPropertyContext.EmptyImpl.getInstance();
        this.setPropertyContext(propertyContext);
    }

    protected FormProperty(FormPropertyContext propertyContext, Class type) {
        super(type);
        this.setValue("changeImmediate", Boolean.FALSE);
        this.propertyContext = FormPropertyContext.EmptyImpl.getInstance();
        this.setPropertyContext(propertyContext);
    }

    protected FormProperty(String name, Class type, String displayName, String shortDescription) {
        super(type);
        this.setValue("changeImmediate", Boolean.FALSE);
        this.setName(name);
        this.setDisplayName(displayName);
        this.setShortDescription(FormProperty.getDescriptionWithType(shortDescription, this.getValueType()));
        this.propertyContext = FormPropertyContext.EmptyImpl.getInstance();
    }

    protected FormProperty(Class type) {
        super(type);
        this.setValue("changeImmediate", Boolean.FALSE);
        this.propertyContext = FormPropertyContext.EmptyImpl.getInstance();
    }

    static String getDescriptionWithType(String description, Class valueType) {
        String type = Utilities.getClassName((Class)valueType);
        return description == null ? FormUtils.getFormattedBundleString("HINT_PropertyType", type) : FormUtils.getFormattedBundleString("HINT_PropertyTypeWithDescription", type, description);
    }

    public String getHtmlDisplayName() {
        if (this.isChanged()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public abstract Object getTargetValue() throws IllegalAccessException, InvocationTargetException;

    public abstract void setTargetValue(Object var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private void setTargetValueInLAFBlock(final Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!FormLAF.inLAFBlock() && this.propertyContext.getFormModel() != null) {
            final Exception[] ex = new Exception[1];
            FormLAF.executeWithLookAndFeel(this.propertyContext.getFormModel(), new Runnable(){

                @Override
                public void run() {
                    try {
                        FormProperty.this.setTargetValue(value);
                    }
                    catch (IllegalAccessException iaex) {
                        ex[0] = iaex;
                    }
                    catch (IllegalArgumentException argex) {
                        ex[0] = argex;
                    }
                    catch (InvocationTargetException itex) {
                        ex[0] = itex;
                    }
                }
            });
            if (ex[0] != null) {
                if (ex[0] instanceof IllegalArgumentException) {
                    throw new IllegalArgumentException(ex[0]);
                }
                if (ex[0] instanceof InvocationTargetException) {
                    throw new InvocationTargetException(ex[0]);
                }
                if (ex[0] instanceof IllegalAccessException) {
                    throw (IllegalAccessException)ex[0];
                }
            }
        } else {
            this.setTargetValue(value);
        }
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        Object value = this.checkCurrentValue();
        if (this.valueSet || (this.propType & 1) == 0) {
            return value;
        }
        return this.getDefaultValue();
    }

    public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object defValue;
        Object oldValue;
        if (value == DEFAULT_VALUE) {
            value = this.getDefaultValue();
        }
        if (this.fireChanges) {
            value = this.convertValue(value);
        }
        if (this.canRead()) {
            try {
                oldValue = this.getValue();
            }
            catch (Exception e) {
                oldValue = BeanSupport.NO_VALUE;
            }
        } else {
            oldValue = BeanSupport.NO_VALUE;
        }
        if (value instanceof ValueWithEditor) {
            PropertyEditor oldEditor;
            ValueWithEditor vwpe = (ValueWithEditor)value;
            value = vwpe.getValue();
            PropertyEditor newEditor = vwpe.getPropertyEditor(this);
            if (newEditor != (oldEditor = this.currentEditor)) {
                boolean fire = this.fireChanges;
                this.fireChanges = false;
                this.setCurrentEditor(newEditor);
                this.setValue(value);
                this.fireChanges = fire;
                if (oldValue == BeanSupport.NO_VALUE) {
                    oldValue = null;
                }
                this.propertyValueAndEditorChanged(new ValueWithEditor(oldValue, oldEditor), new ValueWithEditor(value, newEditor));
                return;
            }
        }
        if (oldValue != BeanSupport.NO_VALUE) {
            if (!(value instanceof FormDesignValue) && FormProperty.equals(value, oldValue)) {
                return;
            }
        } else {
            oldValue = null;
        }
        if (value == BeanSupport.NO_VALUE) {
            this.valueSet = false;
            this.setChanged(false);
            this.propertyValue = value;
            this.lastRealValue = null;
            this.propertyValueChanged(oldValue, value);
            return;
        }
        Object object = defValue = this.supportsDefaultValue() ? this.getDefaultValue() : BeanSupport.NO_VALUE;
        if (this.canWriteToTarget()) {
            Object realValue = this.getRealValue(value);
            if (realValue != FormDesignValue.IGNORED_VALUE) {
                this.setTargetValueInLAFBlock(realValue);
            } else if (this.valueSet && defValue != BeanSupport.NO_VALUE && (this.lastRealValue != null || defValue != null)) {
                this.setTargetValueInLAFBlock(defValue);
            }
            if (this.canReadFromTarget()) {
                this.lastRealValue = this.getTargetValue();
            }
        }
        this.propertyValue = value;
        this.valueSet = true;
        this.setChanged((this.propType & 0xC) == 0 && (defValue == BeanSupport.NO_VALUE || !FormProperty.equals(value, defValue)));
        this.propertyValueChanged(oldValue, value);
    }

    public final Object getRealValue() throws IllegalAccessException, InvocationTargetException {
        return this.getRealValue(this.getValue());
    }

    protected Object getRealValue(Object value) {
        while (value instanceof FormDesignValue) {
            Object prev = value;
            if ((value = ((FormDesignValue)value).getDesignValue()) != prev) continue;
            break;
        }
        return value;
    }

    public boolean supportsDefaultValue() {
        return false;
    }

    public boolean isDefaultValue() {
        return this.supportsDefaultValue() ? !this.isChanged() : true;
    }

    public Object getDefaultValue() {
        return null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setChanged(false);
        Object oldValue = null;
        Object defValue = this.getDefaultValue();
        if (this.canRead()) {
            try {
                oldValue = this.getValue();
                if (!(defValue instanceof FormDesignValue) && FormProperty.equals(defValue, oldValue)) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.canWriteToTarget()) {
            Object realValue = this.getRealValue(defValue);
            try {
                if (realValue != FormDesignValue.IGNORED_VALUE) {
                    this.setTargetValueInLAFBlock(realValue);
                } else if (defValue != BeanSupport.NO_VALUE) {
                    this.setTargetValueInLAFBlock(defValue);
                }
                this.lastRealValue = this.getTargetValue();
            }
            catch (Exception e) {
                Logger.getLogger(FormProperty.class.getName()).log(Level.INFO, "Failed to reset default value of property: " + this.getName(), e);
            }
        }
        this.propertyValue = defValue;
        this.valueSet = true;
        PropertyEditor prEd = this.findDefaultEditor();
        if (prEd != null) {
            this.setCurrentEditor(prEd);
        }
        this.propertyValueChanged(oldValue, defValue);
    }

    public void reinstateTarget() throws IllegalAccessException, InvocationTargetException {
        if (this.valueSet && this.canWriteToTarget()) {
            try {
                Object realValue = this.getRealValue(this.propertyValue);
                if (realValue != FormDesignValue.IGNORED_VALUE) {
                    this.setTargetValueInLAFBlock(realValue);
                    this.lastRealValue = realValue;
                } else if (this.isExternalChangeMonitoring()) {
                    this.lastRealValue = this.getTargetValue();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void reinstateProperty() throws IllegalAccessException, InvocationTargetException {
        boolean mayChanged;
        boolean bl = mayChanged = this.canReadFromTarget() && (this.propType & 0xC) == 0;
        if (mayChanged) {
            Object value = this.getTargetValue();
            if (this.supportsDefaultValue()) {
                Object defValue = this.getDefaultValue();
                boolean bl2 = mayChanged = !FormProperty.equals(value, defValue);
            }
            if (mayChanged) {
                this.propertyValue = value;
                this.lastRealValue = value;
            }
        }
        this.valueSet = mayChanged;
        this.setChanged(mayChanged);
    }

    public boolean canRead() {
        return (this.propType & 4) == 0;
    }

    public boolean canWrite() {
        return (this.propType & 8) == 0;
    }

    public final boolean canReadFromTarget() {
        return (this.propType & 1) == 0;
    }

    public final boolean canWriteToTarget() {
        return (this.propType & 2) == 0;
    }

    public boolean isChanged() {
        if (this.valueChanged && this.valueSet) {
            try {
                this.checkCurrentValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.valueChanged;
    }

    public void setChanged(boolean changed) {
        this.valueChanged = changed;
    }

    public PropertyEditor getPropertyEditor() {
        PropertyEditor prEd = this.formPropertyEditor == null ? (this.propertyContext.useMultipleEditors() ? (this.formPropertyEditor = new FormPropertyEditor(this)) : this.getCurrentEditor()) : this.formPropertyEditor;
        return prEd;
    }

    public final PropertyEditor getCurrentEditor() {
        if (this.currentEditor == null) {
            this.currentEditor = this.findDefaultEditor();
            if (this.currentEditor != null) {
                this.propertyContext.initPropertyEditor(this.currentEditor, this);
            }
        }
        return this.currentEditor;
    }

    public final void setCurrentEditor(PropertyEditor newEditor) {
        if (newEditor != this.currentEditor) {
            if (newEditor != null) {
                this.propertyContext.initPropertyEditor(newEditor, this);
            }
            if (this.formPropertyEditor != null) {
                if (this.currentEditor != null) {
                    this.currentEditor.removePropertyChangeListener(this.formPropertyEditor);
                }
                if (newEditor != null) {
                    newEditor.addPropertyChangeListener(this.formPropertyEditor);
                }
            }
            PropertyEditor old = this.currentEditor;
            this.currentEditor = newEditor;
            this.currentEditorChanged(old, newEditor);
        }
    }

    public PropertyEditor getExpliciteEditor() {
        return null;
    }

    public String getJavaInitializationString() {
        try {
            Object value = this.getValue();
            if (value == null) {
                return "null";
            }
            if (value == BeanSupport.NO_VALUE) {
                return null;
            }
            PropertyEditor ed = this.getCurrentEditor();
            if (ed == null) {
                return null;
            }
            if (ed.getValue() != value) {
                ed.setValue(value);
            }
            return ed.getJavaInitializationString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    String getPartialSetterCode(String javaInitStr) {
        if (javaInitStr == null) {
            return null;
        }
        Method writeMethod = this.getWriteMethod();
        if (writeMethod == null) {
            return null;
        }
        return writeMethod.getName() + "(" + javaInitStr + ")";
    }

    String getWholeSetterCode(String javaInitStr) {
        return null;
    }

    protected Method getWriteMethod() {
        return null;
    }

    public String getPreCode() {
        return this.preCode;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPreCode(String value) {
        this.preCode = value;
    }

    public void setPostCode(String value) {
        this.postCode = value;
    }

    public FormPropertyContext getPropertyContext() {
        return this.propertyContext;
    }

    public void setPropertyContext(FormPropertyContext newContext) {
        if (newContext == null) {
            newContext = FormPropertyContext.EmptyImpl.getInstance();
        }
        if (this.propertyContext != null && this.formPropertyEditor != null && this.propertyContext.useMultipleEditors() != newContext.useMultipleEditors()) {
            if (this.currentEditor != null) {
                this.currentEditor.removePropertyChangeListener(this.formPropertyEditor);
            }
            this.formPropertyEditor = null;
        }
        this.propertyContext = newContext;
        if (this.currentEditor != null) {
            this.propertyContext.initPropertyEditor(this.currentEditor, this);
        }
    }

    public int getAccessType() {
        return this.propType;
    }

    public void setAccessType(int type) {
        if (type >= 0) {
            this.propType = type;
        }
    }

    public boolean isExternalChangeMonitoring() {
        return this.externalChangeMonitoring && this.propType == 0;
    }

    public void setExternalChangeMonitoring(boolean val) {
        this.externalChangeMonitoring = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        FormProperty formProperty = this;
        synchronized (formProperty) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport((Object)this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener l) {
        FormProperty formProperty = this;
        synchronized (formProperty) {
            if (this.vetoableChangeSupport == null) {
                this.vetoableChangeSupport = new VetoableChangeSupport((Object)this);
            }
        }
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(l);
        }
    }

    public boolean isChangeFiring() {
        return this.fireChanges;
    }

    public void setChangeFiring(boolean fire) {
        this.fireChanges = fire;
    }

    protected void propertyValueChanged(Object old, Object current) {
        if (this.fireChanges) {
            try {
                Object value;
                PropertyEditor editor;
                this.firePropertyChange(PROP_VALUE, old, current);
                if (current instanceof ValueWithEditor) {
                    editor = ((ValueWithEditor)current).getPropertyEditor();
                    value = ((ValueWithEditor)current).getValue();
                } else {
                    value = current;
                    editor = this.currentEditor;
                }
                FormUtils.checkVersionLevelForProperty(this, value, editor);
            }
            catch (PropertyVetoException ex) {
                boolean fire = this.fireChanges;
                this.fireChanges = false;
                try {
                    this.setValue(old);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fireChanges = fire;
            }
        }
    }

    protected void currentEditorChanged(PropertyEditor old, PropertyEditor current) {
        if (this.fireChanges) {
            try {
                this.firePropertyChange(CURRENT_EDITOR, old, current);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void propertyValueAndEditorChanged(ValueWithEditor old, ValueWithEditor current) {
        if (this.fireChanges) {
            try {
                this.firePropertyChange(PROP_VALUE_AND_EDITOR, old, current);
            }
            catch (PropertyVetoException ex) {
                boolean fire = this.fireChanges;
                this.fireChanges = false;
                try {
                    this.setValue(old);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fireChanges = fire;
            }
        }
    }

    private void firePropertyChange(String propName, Object old, Object current) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null && !CURRENT_EDITOR.equals(propName)) {
            this.vetoableChangeSupport.fireVetoableChange(propName, old, current);
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propName, old, current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValueConvertor(ValueConvertor conv) {
        FormProperty formProperty = this;
        synchronized (formProperty) {
            if (this.convertors == null) {
                this.convertors = new LinkedList<ValueConvertor>();
            } else {
                this.convertors.remove(conv);
            }
            this.convertors.add(conv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueConvertor(ValueConvertor conv) {
        FormProperty formProperty = this;
        synchronized (formProperty) {
            if (this.convertors != null) {
                this.convertors.remove(conv);
            }
        }
    }

    protected Object convertValue(Object value) {
        if (this.convertors != null) {
            for (ValueConvertor conv : this.convertors) {
                Object val = conv.convert(value, this);
                if (val == value) continue;
                return val;
            }
        }
        return value;
    }

    private Object checkCurrentValue() throws IllegalAccessException, InvocationTargetException {
        if (this.valueSet) {
            Object value = null;
            if (this.isExternalChangeMonitoring() && !FormProperty.equals(value = this.getTargetValue(), this.lastRealValue)) {
                Object propValue;
                Object object = propValue = this.propertyValue instanceof FormDesignValue ? ((FormDesignValue)this.propertyValue).getDesignValue() : this.propertyValue;
                if (FormProperty.equals(value, propValue)) {
                    this.lastRealValue = value;
                } else if (propValue != FormDesignValue.IGNORED_VALUE) {
                    this.valueSet = false;
                    this.setChanged(false);
                    this.lastRealValue = null;
                    return value;
                }
            }
            return this.propertyValue;
        }
        return (this.propType & 1) == 0 ? this.getTargetValue() : null;
    }

    PropertyEditor findDefaultEditor() {
        PropertyEditor defaultEditor = this.getExpliciteEditor();
        if (defaultEditor != null) {
            return defaultEditor;
        }
        return FormPropertyEditorManager.findEditor(this);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        Class<?> cls1 = obj1.getClass();
        Class<?> cls2 = obj2.getClass();
        if (!cls1.isArray() || !cls1.equals(cls2)) {
            return obj1.equals(obj2);
        }
        Class<?> cType = cls1.getComponentType();
        if (!cType.isPrimitive()) {
            Object[] array1 = (Object[])obj1;
            Object[] array2 = (Object[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (FormProperty.equals(array1[i], array2[i])) continue;
                return false;
            }
            return true;
        }
        if (Integer.TYPE.equals(cType)) {
            int[] array1 = (int[])obj1;
            int[] array2 = (int[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Boolean.TYPE.equals(cType)) {
            boolean[] array1 = (boolean[])obj1;
            boolean[] array2 = (boolean[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Long.TYPE.equals(cType)) {
            long[] array1 = (long[])obj1;
            long[] array2 = (long[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Double.TYPE.equals(cType)) {
            double[] array1 = (double[])obj1;
            double[] array2 = (double[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Byte.TYPE.equals(cType)) {
            byte[] array1 = (byte[])obj1;
            byte[] array2 = (byte[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Character.TYPE.equals(cType)) {
            char[] array1 = (char[])obj1;
            char[] array2 = (char[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Float.TYPE.equals(cType)) {
            float[] array1 = (float[])obj1;
            float[] array2 = (float[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        if (Short.TYPE.equals(cType)) {
            short[] array1 = (short[])obj1;
            short[] array2 = (short[])obj2;
            if (array1.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array1.length; ++i) {
                if (array1[i] == array2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object getEnclosedValue(Object value) {
        return value instanceof ValueWithEditor ? ((ValueWithEditor)value).getValue() : value;
    }

    public static interface Filter {
        public boolean accept(FormProperty var1);
    }

    public static final class ValueWithEditor {
        private Object value;
        private PropertyEditor propertyEditor;
        private int propertyEditorIndex;
        private boolean editorSetByUser;

        public ValueWithEditor(Object value, PropertyEditor propertyEditor) {
            this.value = value;
            this.propertyEditor = propertyEditor;
        }

        ValueWithEditor(Object value, PropertyEditor propertyEditor, boolean editorSetByUser) {
            this(value, propertyEditor);
            this.editorSetByUser = editorSetByUser;
        }

        ValueWithEditor(Object value, int propertyEditorIndex, boolean editorSetByUser) {
            this.value = value;
            this.propertyEditorIndex = propertyEditorIndex;
            this.editorSetByUser = editorSetByUser;
        }

        public Object getValue() {
            return this.value;
        }

        public PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        boolean getEditorSetByUser() {
            return this.editorSetByUser;
        }

        PropertyEditor getPropertyEditor(FormProperty property) {
            FormPropertyEditor fpe;
            PropertyEditor[] allEds;
            if (this.propertyEditor != null) {
                return this.propertyEditor;
            }
            if (this.propertyEditorIndex < 0) {
                return null;
            }
            PropertyEditor pe = property.getPropertyEditor();
            if (pe instanceof FormPropertyEditor && this.propertyEditorIndex < (allEds = (fpe = (FormPropertyEditor)pe).getAllEditors()).length) {
                return allEds[this.propertyEditorIndex];
            }
            return null;
        }
    }

    public static interface ValueConvertor {
        public Object convert(Object var1, FormProperty var2);
    }
}

