/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnItem;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Identifier;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.TableNode;

public class ColumnNode
extends ColumnItem
implements Column {
    private TableNode _table;
    private Identifier _columnName;
    private Identifier _derivedColName;

    public ColumnNode(String tableSpec, String columnName) {
        String tableName = null;
        String schemaName = null;
        String[] table = tableSpec.split("\\.");
        if (table.length > 1) {
            schemaName = table[0];
            tableName = table[1];
        } else {
            tableName = tableSpec;
        }
        this._table = new TableNode(tableName, null, schemaName);
        this._columnName = new Identifier(columnName);
    }

    public ColumnNode(String tableName, String columnName, String corrName, String schemaName) {
        this._table = new TableNode(tableName, corrName, schemaName);
        this._columnName = new Identifier(columnName);
    }

    public ColumnNode(Table table, String columnName) {
        this._table = (TableNode)table;
        this._columnName = new Identifier(columnName);
    }

    private ColumnNode() {
    }

    public static ColumnNode make(Identifier tableName, Identifier columnName, Identifier schemaName, Identifier derivedColName) {
        ColumnNode c = new ColumnNode();
        c._columnName = columnName;
        c._derivedColName = derivedColName;
        c._table = tableName != null ? TableNode.make(tableName, null, schemaName) : null;
        return c;
    }

    @Override
    Column getReferencedColumn() {
        return this;
    }

    @Override
    public void getReferencedColumns(Collection columns) {
    }

    @Override
    public boolean matches(String table, String column) {
        return table.equals(this.getTableSpec()) && column.equals(this.getColumnName());
    }

    @Override
    public boolean matches(String table) {
        return table.equals(this.getTableSpec());
    }

    @Override
    public boolean equals(Column column) {
        return column.matches(this.getTableSpec(), this.getColumnName());
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter, boolean select) {
        return (this._table != null && this._table.getTableSpec() != null ? this._table.genText(quoter, false) + "." : "") + this._columnName.genText(quoter) + (select && this._derivedColName != null ? " AS " + this._derivedColName.genText(quoter) : "");
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        return this.genText(quoter, false);
    }

    @Override
    public void renameTableSpec(String oldTableSpec, String corrName) {
        this._table.renameTableSpec(oldTableSpec, corrName);
    }

    @Override
    public void setTableSpec(String oldTableSpec, String newTableSpec) {
        if (this._table == null) {
            String tableName = null;
            String schemaName = null;
            String[] table = newTableSpec.split("\\.");
            if (table.length > 1) {
                schemaName = table[0];
                tableName = table[1];
            } else {
                tableName = newTableSpec;
            }
            this._table = new TableNode(tableName, null, schemaName);
        }
        this._table.setTableSpec(oldTableSpec, newTableSpec);
    }

    @Override
    public String getColumnName() {
        return this._columnName.getName();
    }

    @Override
    public String getTableSpec() {
        return this._table == null ? null : this._table.getTableSpec();
    }

    @Override
    public String getFullTableName() {
        return this._table == null ? null : this._table.getFullTableName();
    }

    @Override
    public String getDerivedColName() {
        return this._derivedColName == null ? null : this._derivedColName.getName();
    }

    @Override
    public void setDerivedColName(String derivedColName) {
        this._derivedColName = derivedColName == null ? null : new Identifier(derivedColName);
    }

    @Override
    public void setColumnName(String oldColumnName, String newColumnName) {
        if (this._columnName.getName().equals(oldColumnName)) {
            this._columnName = new Identifier(newColumnName);
        }
    }

    @Override
    public void setColumnTableName(String tableName) {
        if (this._table == null) {
            this._table = new TableNode();
        }
        this._table.setTableName(tableName);
    }

    @Override
    public void setColumnCorrName(String corrName) {
        if (this._table == null) {
            this._table = new TableNode();
        }
        this._table.setCorrName(corrName);
    }

    @Override
    public boolean isParameterized() {
        return false;
    }

    @Override
    public Expression findExpression(String table1, String column1, String table2, String column2) {
        return null;
    }
}

