/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import org.netbeans.junit.Log;
import org.netbeans.junit.diff.Diff;

public class Manager {
    public static final String JUNIT_PROPERTIES_FILENAME = "junit.properties";
    public static final String JUNIT_PROPERTIES_LOCATION_PROPERTY = "junit.properties.file";
    protected static final String PROP_DIFF_IMPL = "nbjunit.diff.impl";
    protected static final String DEFAULT_DIFF_IMPL = "org.netbeans.junit.diff.SimpleDiff";
    protected static Diff systemDiff = null;
    protected static Properties fPreferences = null;
    public static final String NBJUNIT_WORKDIR = "nbjunit.workdir";
    public static final String NBJUNIT_HOME = "nbjunit.home";

    private Manager() {
    }

    public static Diff getSystemDiff() {
        if (null == systemDiff) {
            Manager.readProperties();
            String diffImplName = fPreferences.getProperty(PROP_DIFF_IMPL);
            systemDiff = Manager.instantiateDiffImpl(diffImplName);
            if (null == systemDiff && !diffImplName.equals(DEFAULT_DIFF_IMPL)) {
                systemDiff = Manager.instantiateDiffImpl(DEFAULT_DIFF_IMPL);
            }
        }
        return systemDiff;
    }

    public static String getWorkDirPath() {
        String path = System.getProperty(NBJUNIT_WORKDIR);
        if (path == null) {
            Manager.readProperties();
            path = fPreferences.getProperty(NBJUNIT_WORKDIR);
        }
        path = path != null ? path.replace('/', File.separatorChar) : System.getProperty("java.io.tmpdir") + File.separatorChar + "tests-" + System.getProperty("user.name");
        return path;
    }

    public static String getNbJUnitHomePath() throws IOException {
        String path = System.getProperty(NBJUNIT_HOME);
        if (path == null) {
            Manager.readProperties();
            path = fPreferences.getProperty(NBJUNIT_HOME);
        }
        if (path != null) {
            path = path.replace('/', File.separatorChar);
            return path;
        }
        throw new IOException("Cannot determine NbJUnit home. Please make sure you have nbjunit.home propery set in your junit.properties file.");
    }

    public static File getNbJUnitHome() throws IOException {
        File nbJUnitHome = Manager.normalizeFile(new File(Manager.getNbJUnitHomePath()));
        if (nbJUnitHome.isDirectory()) {
            return nbJUnitHome;
        }
        throw new IOException("Property nbjunit.home does not point to nbjunit home.");
    }

    protected static Diff instantiateDiffImpl(String diffImplName) {
        Diff impl;
        block5: {
            impl = null;
            Object diffImpl = null;
            Class[] prmString = null;
            try {
                prmString = new Class[]{Class.forName("java.lang.String")};
                Class<?> clazz = Class.forName(diffImplName);
                diffImpl = clazz.newInstance();
                if (!(diffImpl instanceof Diff)) break block5;
                impl = diffImpl;
                Enumeration<?> propNames = fPreferences.propertyNames();
                while (propNames.hasMoreElements()) {
                    Method method;
                    String propName = (String)propNames.nextElement();
                    if (propName.equals(PROP_DIFF_IMPL) || !propName.startsWith(PROP_DIFF_IMPL)) continue;
                    String setter = "set" + propName.substring(PROP_DIFF_IMPL.length() + 1);
                    try {
                        method = clazz.getMethod(setter, prmString);
                    }
                    catch (NoSuchMethodException e) {
                        System.out.println("The method " + setter + " not fond in class " + diffImplName + ".");
                        method = null;
                    }
                    if (null == method) continue;
                    method.invoke((Object)impl, fPreferences.getProperty(propName, ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return impl;
    }

    private static File getPreferencesFile() {
        File propertyFile;
        String junitPropertiesLocation = System.getProperty(JUNIT_PROPERTIES_LOCATION_PROPERTY);
        if (junitPropertiesLocation != null && (propertyFile = new File(junitPropertiesLocation)).exists()) {
            return propertyFile;
        }
        String home = System.getProperty("user.home");
        return new File(home, JUNIT_PROPERTIES_FILENAME);
    }

    protected static void readProperties() {
        try {
            File propFile = Manager.getPreferencesFile();
            fPreferences = new Properties(fPreferences);
            try (FileInputStream is = new FileInputStream(propFile);){
                fPreferences.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File normalizeFile(File file) {
        Runnable off = Log.internalLog();
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    Logger.getLogger(Manager.class.getName()).warning("getCanonicalFile() on file " + file + " failed: " + e);
                    file = file.getAbsoluteFile();
                }
            } else {
                file = new File(file.toURI().normalize()).getAbsoluteFile();
            }
            File file2 = file;
            return file2;
        }
        finally {
            off.run();
        }
    }

    static {
        fPreferences = new Properties();
        fPreferences.put(PROP_DIFF_IMPL, DEFAULT_DIFF_IMPL);
    }
}

