/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.bugtracking.tasks.TaskAttribute;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SortAttributePanel
extends JPanel {
    private final List<TaskAttribute> attributes;
    private TaskAttribute selected;
    private final int index;
    private ArrayList<TaskAttribute> availableAttributes;
    private final List<ActionListener> changeListeners = new ArrayList<ActionListener>();
    private final ActionListener comboActionListener = new ComboActionListener();
    private final ItemListener ascendingListener = new AscendingListener();
    private ButtonGroup buttonGroup1;
    private JComboBox comboAttributes;
    private JRadioButton rbAscending;
    private JRadioButton rbDescending;

    public SortAttributePanel(List<TaskAttribute> attributes, TaskAttribute selected, int index) {
        this.attributes = attributes;
        this.selected = selected;
        this.index = index;
        this.initComponents();
        this.initCombo();
    }

    public void addSortingChangeListener(ActionListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeSortingChangeListener(ActionListener listener) {
        this.changeListeners.remove(listener);
    }

    public TaskAttribute getSelectedAttribute() {
        return this.selected;
    }

    public int getIndex() {
        return this.index;
    }

    public void updateModel(TaskAttribute selected) {
        this.selected = selected;
        this.initCombo();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.comboAttributes = new JComboBox();
        this.rbAscending = new JRadioButton();
        this.rbDescending = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.comboAttributes.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.comboAttributes, gridBagConstraints);
        this.buttonGroup1.add(this.rbAscending);
        Mnemonics.setLocalizedText((AbstractButton)this.rbAscending, (String)NbBundle.getMessage(SortAttributePanel.class, (String)"SortAttributePanel.rbAscending.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        this.add((Component)this.rbAscending, gridBagConstraints);
        this.buttonGroup1.add(this.rbDescending);
        Mnemonics.setLocalizedText((AbstractButton)this.rbDescending, (String)NbBundle.getMessage(SortAttributePanel.class, (String)"SortAttributePanel.rbDescending.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 18, 0, 0);
        this.add((Component)this.rbDescending, gridBagConstraints);
    }

    private void initCombo() {
        this.comboAttributes.removeActionListener(this.comboActionListener);
        this.rbAscending.removeItemListener(this.ascendingListener);
        this.availableAttributes = new ArrayList();
        for (TaskAttribute attribute : this.attributes) {
            if (attribute.getRank() < this.index) continue;
            this.availableAttributes.add(attribute);
        }
        String[] values = new String[this.attributes.size() + 1];
        values[0] = "<" + NbBundle.getMessage(SortAttributePanel.class, (String)"LBL_NoCategory") + ">";
        for (int i = 0; i < this.availableAttributes.size(); ++i) {
            values[i + 1] = this.availableAttributes.get(i).getDisplayName();
        }
        this.comboAttributes.setModel(new DefaultComboBoxModel<String>(values));
        this.comboAttributes.setSelectedIndex(this.availableAttributes.indexOf(this.selected) + 1);
        if (this.selected != null) {
            this.rbAscending.setEnabled(true);
            this.rbDescending.setEnabled(true);
            if (this.selected.isAsceding()) {
                this.rbAscending.setSelected(true);
            } else {
                this.rbDescending.setSelected(true);
            }
        } else {
            this.rbAscending.setEnabled(false);
            this.rbDescending.setEnabled(false);
        }
        this.rbAscending.addItemListener(this.ascendingListener);
        this.comboAttributes.addActionListener(this.comboActionListener);
    }

    void setComponentsEnabled(boolean enabled) {
        this.comboAttributes.setEnabled(enabled);
        this.rbAscending.setEnabled(enabled);
        this.rbDescending.setEnabled(enabled);
    }

    private class AscendingListener
    implements ItemListener {
        private AscendingListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SortAttributePanel.this.selected.setAsceding(SortAttributePanel.this.rbAscending.isSelected());
        }
    }

    private class ComboActionListener
    implements ActionListener {
        private ComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskAttribute lastSelected = SortAttributePanel.this.selected;
            int i = SortAttributePanel.this.comboAttributes.getSelectedIndex() - 1;
            SortAttributePanel.this.selected = i == -1 ? null : (TaskAttribute)SortAttributePanel.this.availableAttributes.get(i);
            if (lastSelected != null) {
                lastSelected.setRank(SortAttributePanel.this.selected != null ? SortAttributePanel.this.selected.getRank() : Integer.MAX_VALUE);
            }
            if (SortAttributePanel.this.selected != null) {
                SortAttributePanel.this.selected.setRank(SortAttributePanel.this.index);
            }
            this.fireEvent(e);
        }

        private void fireEvent(ActionEvent e) {
            for (ActionListener listener : SortAttributePanel.this.changeListeners) {
                listener.actionPerformed(e);
            }
        }
    }
}

