/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.IssueQuickSearch;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HgQueueHookPanel
extends VerticallyNonResizingPanel
implements ChangeListener {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.vcshooks.HookPanel");
    private IssueQuickSearch qs;
    private boolean blockEvents;
    private Issue preselectedIssue;
    private FieldValues fieldValues = null;
    private ButtonGroup buttonGroup1;
    final LinkButton changeFormatButton = new LinkButton();
    final JRadioButton commitRadioButton = new JRadioButton();
    private JPanel issuePanel;
    final JCheckBox linkCheckBox = new JCheckBox();
    final JRadioButton pushRadioButton = new JRadioButton();
    final JCheckBox resolveCheckBox = new JCheckBox();

    public HgQueueHookPanel(FileObject context, boolean link, boolean resolve, boolean commit) {
        this.initComponents();
        this.fieldValues = new FieldValues();
        this.qs = IssueQuickSearch.create((FileObject)context);
        this.qs.setChangeListener((ChangeListener)this);
        this.qs.setEnabled(true);
        this.issuePanel.add((Component)this.qs.getComponent(), "North");
        this.linkCheckBox.setSelected(link);
        this.resolveCheckBox.setSelected(resolve);
        this.commitRadioButton.setSelected(commit);
        this.pushRadioButton.setSelected(!commit);
        this.enableFields();
    }

    Issue getIssue() {
        return this.qs.getIssue();
    }

    void enableFields() {
        boolean enableFields;
        boolean repoSelected = !this.blockEvents && this.qs.getSelectedRepository() != null;
        boolean bl = enableFields = repoSelected && this.getIssue() != null;
        if (!enableFields && !this.fieldValues.stored) {
            this.fieldValues.store();
        } else if (enableFields && this.fieldValues.stored) {
            this.fieldValues.restore();
        }
        this.linkCheckBox.setEnabled(enableFields);
        this.resolveCheckBox.setEnabled(enableFields);
        this.pushRadioButton.setEnabled(enableFields);
        this.commitRadioButton.setEnabled(enableFields);
        this.changeFormatButton.setEnabled(enableFields);
    }

    void enableIssueField(boolean enabled) {
        boolean bl = this.blockEvents = !enabled;
        if (enabled) {
            this.enableFields();
        }
    }

    void setIssue(Issue issue) {
        this.preselectedIssue = issue;
        this.qs.setRepository(issue.getRepository());
        this.preselectIssue();
    }

    private void preselectIssue() {
        this.qs.setIssue(this.preselectedIssue);
        this.enableFields();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.issuePanel = new JPanel();
        this.setFocusable(false);
        this.issuePanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.resolveCheckBox, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.resolveCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.linkCheckBox, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.linkCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeFormatButton, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.changeFormatButton.text"));
        this.buttonGroup1.add(this.commitRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.commitRadioButton, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.commitRadioButton.text"));
        this.buttonGroup1.add(this.pushRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.pushRadioButton, (String)NbBundle.getMessage(HgQueueHookPanel.class, (String)"HgQueueHookPanel.pushRadioButton.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(116, 116, 116).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resolveCheckBox).addComponent(this.linkCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.changeFormatButton, -2, -1, -2).addGap(65, 65, 65).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commitRadioButton).addComponent(this.pushRadioButton)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.issuePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.issuePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.resolveCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.linkCheckBox).addComponent((Component)this.changeFormatButton, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.commitRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pushRadioButton))).addContainerGap()));
        this.resolveCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.resolveCheckBox.AccessibleContext.accessibleDescription"));
        this.linkCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.addRevisionCheckBox.AccessibleContext.accessibleDescription"));
        this.changeFormatButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.changeRevisionFormatButton.AccessibleContext.accessibleDescription"));
        this.commitRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.commitRadioButton.AccessibleContext.accessibleDescription"));
        this.pushRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HgQueueHookPanel.class, (String)"HookPanel.pushRadioButton.AccessibleContext.accessibleDescription"));
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableFields();
    }

    private class FieldValues {
        private boolean addLinkInfo = false;
        private boolean resolve = false;
        private boolean commit = false;
        private boolean stored = false;

        private FieldValues() {
        }

        void store() {
            this.addLinkInfo = HgQueueHookPanel.this.linkCheckBox.isSelected();
            this.resolve = HgQueueHookPanel.this.resolveCheckBox.isSelected();
            this.commit = HgQueueHookPanel.this.commitRadioButton.isSelected();
            HgQueueHookPanel.this.linkCheckBox.setSelected(false);
            HgQueueHookPanel.this.resolveCheckBox.setSelected(false);
            HgQueueHookPanel.this.commitRadioButton.setSelected(false);
            this.stored = true;
        }

        void restore() {
            HgQueueHookPanel.this.linkCheckBox.setSelected(this.addLinkInfo);
            HgQueueHookPanel.this.resolveCheckBox.setSelected(this.resolve);
            HgQueueHookPanel.this.commitRadioButton.setSelected(this.commit);
            this.stored = false;
        }
    }
}

