/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.css.prep.sass.SassCli;
import org.netbeans.modules.css.prep.ui.options.Bundle;
import org.netbeans.modules.css.prep.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class SassOptionsPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(SassOptionsPanel.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel installSassLabel;
    private JCheckBox sassDebugCheckBox;
    private JCheckBox sassOutputOnErrorCheckBox;
    private JButton sassPathBrowseButton;
    private JLabel sassPathHintLabel;
    private JLabel sassPathLabel;
    private JButton sassPathSearchButton;
    private JTextField sassPathTextField;

    public SassOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        String[] executableNames = SassCli.getExecutableNames();
        this.sassPathHintLabel.setText(Bundle.SassOptionsPanel_path_hint(executableNames[0], executableNames[1]));
        this.sassPathTextField.getDocument().addDocumentListener(new DefaultDocumentListener());
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.sassOutputOnErrorCheckBox.addItemListener(defaultItemListener);
        this.sassDebugCheckBox.addItemListener(defaultItemListener);
    }

    public String getSassPath() {
        return this.sassPathTextField.getText();
    }

    public void setSassPath(String path) {
        this.sassPathTextField.setText(path);
    }

    public boolean getSassOutputOnError() {
        return this.sassOutputOnErrorCheckBox.isSelected();
    }

    public void setSassOutputOnError(boolean outputOnError) {
        this.sassOutputOnErrorCheckBox.setSelected(outputOnError);
    }

    public boolean getSassDebug() {
        return this.sassDebugCheckBox.isSelected();
    }

    public void setSassDebug(boolean debug) {
        this.sassDebugCheckBox.setSelected(debug);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.sassPathLabel = new JLabel();
        this.sassPathTextField = new JTextField();
        this.sassPathBrowseButton = new JButton();
        this.sassPathSearchButton = new JButton();
        this.sassPathHintLabel = new JLabel();
        this.installSassLabel = new JLabel();
        this.sassOutputOnErrorCheckBox = new JCheckBox();
        this.sassDebugCheckBox = new JCheckBox();
        this.sassPathLabel.setLabelFor(this.sassPathTextField);
        Mnemonics.setLocalizedText((JLabel)this.sassPathLabel, (String)NbBundle.getMessage(SassOptionsPanel.class, (String)"SassOptionsPanel.sassPathLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sassPathBrowseButton, (String)NbBundle.getMessage(SassOptionsPanel.class, (String)"SassOptionsPanel.sassPathBrowseButton.text"));
        this.sassPathBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SassOptionsPanel.this.sassPathBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.sassPathSearchButton, (String)NbBundle.getMessage(SassOptionsPanel.class, (String)"SassOptionsPanel.sassPathSearchButton.text"));
        this.sassPathSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SassOptionsPanel.this.sassPathSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sassPathHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.installSassLabel, (String)NbBundle.getMessage(SassOptionsPanel.class, (String)"SassOptionsPanel.installSassLabel.text"));
        this.installSassLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SassOptionsPanel.this.installSassLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SassOptionsPanel.this.installSassLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.sassOutputOnErrorCheckBox, (String)NbBundle.getMessage(SassOptionsPanel.class, (String)"SassOptionsPanel.sassOutputOnErrorCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sassDebugCheckBox, (String)NbBundle.getMessage(SassOptionsPanel.class, (String)"SassOptionsPanel.sassDebugCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sassPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sassPathHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.installSassLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.sassPathTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sassPathBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sassPathSearchButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sassOutputOnErrorCheckBox).addComponent(this.sassDebugCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.sassPathBrowseButton, this.sassPathSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sassPathLabel).addComponent(this.sassPathBrowseButton).addComponent(this.sassPathSearchButton).addComponent(this.sassPathTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sassPathHintLabel).addComponent(this.installSassLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sassOutputOnErrorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sassDebugCheckBox).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void sassPathBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(SassOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.SassOptionsPanel_browse_title()).showOpenDialog();
        if (file != null) {
            this.sassPathTextField.setText(file.getAbsolutePath());
        }
    }

    private void sassPathSearchButtonActionPerformed(ActionEvent evt) {
        List<String> sassPaths = FileUtils.findFileOnUsersPath(SassCli.getExecutableNames());
        if (sassPaths.isEmpty()) {
            StatusDisplayer.getDefault().setStatusText(Bundle.SassOptionsPanel_executable_notFound());
        } else {
            this.sassPathTextField.setText(sassPaths.get(0));
        }
    }

    private void installSassLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void installSassLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://sass-lang.com/");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SassOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SassOptionsPanel.this.fireChange();
        }
    }
}

