/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.stack;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.stack.Stack;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.WidgetBuilder;

public class StackRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu menu) throws IOException {
        Stack stack = (Stack)menu;
        String clientId = stack.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("Stack", stack.resolveWidgetVar(), clientId, "stack").attr("openSpeed", stack.getOpenSpeed()).attr("closeSpeed", stack.getCloseSpeed()).attr("expanded", stack.isExpanded(), false);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Stack stack = (Stack)menu;
        String clientId = stack.getClientId(context);
        writer.startElement("div", (UIComponent)stack);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)"ui-stack", null);
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, stack.getIcon()), null);
        writer.endElement("img");
        if (stack.getElementsCount() > 0) {
            List elements = stack.getElements();
            writer.startElement("ul", null);
            writer.writeAttribute("id", (Object)(clientId + "_stack"), "id");
            for (MenuElement element : elements) {
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                MenuItem menuItem = (MenuItem)element;
                String containerStyle = menuItem.getContainerStyle();
                String containerStyleClass = menuItem.getContainerStyleClass();
                writer.startElement("li", null);
                if (containerStyle != null) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                if (containerStyleClass != null) {
                    writer.writeAttribute("class", (Object)containerStyleClass, null);
                }
                this.encodeMenuItem(context, stack, menuItem);
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        if (menuitem.getValue() != null) {
            writer.write((String)menuitem.getValue());
        }
        writer.endElement("span");
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, menuitem.getIcon()), null);
        writer.endElement("img");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

