/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.instrumentation.DeclareTagProvider;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import java.util.Set;

public abstract class JSFunctionExpressionNode
extends JavaScriptNode
implements FunctionNameHolder {
    protected final JSFunctionData functionData;
    protected final FunctionRootNode functionNode;

    protected JSFunctionExpressionNode(JSFunctionData functionData, FunctionRootNode functionNode) {
        this.functionData = functionData;
        this.functionNode = functionNode;
    }

    public static JSFunctionExpressionNode create(JSFunctionData function, FunctionRootNode functionNode) {
        if (function.needsParentFrame()) {
            return new DefaultFunctionExpressionNode(function, functionNode);
        }
        return new AutonomousFunctionExpressionNode(function, functionNode);
    }

    public static JSFunctionExpressionNode createLexicalThis(JSFunctionData function, FunctionRootNode functionNode, JavaScriptNode thisNode) {
        return new LexicalThisFunctionExpressionNode(function, functionNode, thisNode);
    }

    public static JSFunctionExpressionNode createEmpty(JSContext context, int length, String sourceName) {
        return new AutonomousFunctionExpressionNode(JSFunctionData.create(context, context.getEmptyFunctionCallTarget(), length, sourceName), null);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        if (tag == JSTags.InputNodeTag.class) {
            return true;
        }
        if (tag == JSTags.DeclareTag.class) {
            return !super.hasTag(StandardTags.ExpressionTag.class);
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        if (super.hasTag(StandardTags.ExpressionTag.class)) {
            return JSTags.createNodeObjectDescriptor("literalType", JSTags.LiteralTag.Type.FunctionLiteral.name());
        }
        NodeObjectDescriptor descriptor = DeclareTagProvider.createDeclareNodeObject(this.functionData.getName(), "var");
        descriptor.addProperty("literalType", JSTags.LiteralTag.Type.FunctionLiteral.name());
        return descriptor;
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (!materializedTags.isEmpty()) {
            this.functionData.materialize();
        }
        return this;
    }

    public JSFunctionData getFunctionData() {
        return this.functionData;
    }

    public FunctionRootNode getFunctionNode() {
        CompilerAsserts.neverPartOfCompilation();
        return this.functionNode;
    }

    @Override
    public String getFunctionName() {
        return this.functionData.getName();
    }

    @Override
    public void setFunctionName(String name) {
        CompilerAsserts.neverPartOfCompilation();
        this.functionData.setName(name);
    }

    private static final class LexicalThisFunctionExpressionNode
    extends JSFunctionExpressionNode {
        @Node.Child
        private JavaScriptNode thisNode;

        protected LexicalThisFunctionExpressionNode(JSFunctionData functionData, FunctionRootNode functionNode, JavaScriptNode thisNode) {
            super(functionData, functionNode);
            this.thisNode = thisNode;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return JSFunction.createLexicalThis(this.functionData.getContext().getRealm(), this.functionData, this.functionData.needsParentFrame() ? frame.materialize() : JSFrameUtil.NULL_MATERIALIZED_FRAME, this.thisNode.execute(frame));
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new LexicalThisFunctionExpressionNode(this.functionData, this.functionNode, LexicalThisFunctionExpressionNode.cloneUninitialized(this.thisNode, materializedTags));
        }
    }

    private static final class AutonomousFunctionExpressionNode
    extends JSFunctionExpressionNode {
        protected AutonomousFunctionExpressionNode(JSFunctionData functionData, FunctionRootNode functionNode) {
            super(functionData, functionNode);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return JSFunction.create(this.functionData.getContext().getRealm(), this.functionData);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new AutonomousFunctionExpressionNode(this.functionData, this.functionNode);
        }
    }

    private static final class DefaultFunctionExpressionNode
    extends JSFunctionExpressionNode {
        protected DefaultFunctionExpressionNode(JSFunctionData functionData, FunctionRootNode functionNode) {
            super(functionData, functionNode);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return JSFunction.create(this.functionData.getContext().getRealm(), this.functionData, frame.materialize());
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new DefaultFunctionExpressionNode(this.functionData, this.functionNode);
        }
    }
}

