/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.debugger.jpda.projects.ASTOperationCreationDelegate;
import org.netbeans.modules.debugger.jpda.projects.ConstantPool;
import org.netbeans.modules.debugger.jpda.projects.ExpressionScanner;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.util.Exceptions;

class AST2Bytecode {
    private AST2Bytecode() {
    }

    static EditorContext.Operation[] matchSourceTree2Bytecode(CompilationUnitTree cu, CompilationController ci, List<Tree> treeNodes, ExpressionScanner.ExpressionsInfo info, byte[] bytecodes, int[] indexes, byte[] constantPoolBytes, ASTOperationCreationDelegate opCreationDelegate, Map<Tree, EditorContext.Operation> nodeOperations) {
        Trees trees = ci.getTrees();
        Types types = ci.getTypes();
        SourcePositions sp = trees.getSourcePositions();
        if (treeNodes == null) {
            return null;
        }
        if (indexes == null) {
            return null;
        }
        int length = treeNodes.size();
        ArrayList<EditorContext.Operation> operations = new ArrayList<EditorContext.Operation>(length);
        LineMap lineMap = cu.getLineMap();
        int indexesIndex = 0;
        int from = indexes[indexesIndex];
        int to = indexes[indexesIndex + 1];
        ConstantPool constantPool = constantPoolBytes != null ? ConstantPool.parse(constantPoolBytes, ci.getFileObject().toString()) : null;
        for (int treeIndex = 0; treeIndex < length; ++treeIndex) {
            EditorContext.Operation op;
            Tree node;
            block53: {
                block54: {
                    int opcode;
                    block55: {
                        String methodClassType;
                        String methodName;
                        ExpressionTree identifier;
                        boolean getStartPosFromMethodLength;
                        EditorContext.Position endPosition;
                        EditorContext.Position startPosition;
                        int pos;
                        String methodDescriptorInBytecode;
                        boolean isNativeMethod;
                        block56: {
                            TreePath iPath;
                            node = treeNodes.get(treeIndex);
                            Tree.Kind kind = node.getKind();
                            op = null;
                            if (!kind.equals((Object)Tree.Kind.METHOD_INVOCATION) && !kind.equals((Object)Tree.Kind.NEW_CLASS)) break block53;
                            while (true) {
                                if (from < 0 || from >= bytecodes.length) {
                                    return null;
                                }
                                opcode = bytecodes[from] & 0xFF;
                                if (!AST2Bytecode.isMethodCall(opcode) && (from += AST2Bytecode.getInstrSize(opcode, bytecodes, from)) < to) continue;
                                if (from < to || indexesIndex + 2 >= indexes.length) break;
                                from = indexes[indexesIndex += 2];
                                to = indexes[indexesIndex + 1];
                            }
                            if (from >= to) break block54;
                            TreePath nodePath = trees.getPath(cu, node);
                            if (nodePath == null || ci.getTreeUtilities().isSynthetic(nodePath)) break block55;
                            Element methodElement = ci.getTrees().getElement(nodePath);
                            isNativeMethod = methodElement != null && methodElement.getModifiers().contains((Object)Modifier.NATIVE);
                            String methodNameInBytecode = null;
                            methodDescriptorInBytecode = null;
                            if (constantPool != null) {
                                int constantPoolIndex = ((bytecodes[from + 1] & 0xFF) << 8) + (bytecodes[from + 2] & 0xFF);
                                try {
                                    methodNameInBytecode = constantPool.getMethodName(constantPoolIndex);
                                    methodDescriptorInBytecode = constantPool.getMethodDescriptor(constantPoolIndex);
                                }
                                catch (IndexOutOfBoundsException ioobex) {
                                    ioobex = (IndexOutOfBoundsException)Exceptions.attachMessage((Throwable)ioobex, (String)("While matching " + treeNodes + ". Please attach the code where this happens to http://www.netbeans.org/issues/show_bug.cgi?id=161839"));
                                    Exceptions.printStackTrace((Throwable)ioobex);
                                }
                            }
                            if ((long)(pos = (int)sp.getStartPosition(cu, node)) == -1L) {
                                return null;
                            }
                            startPosition = opCreationDelegate.createPosition(pos, (int)lineMap.getLineNumber(pos), (int)lineMap.getColumnNumber(pos));
                            pos = (int)sp.getEndPosition(cu, node);
                            if ((long)pos == -1L) {
                                return null;
                            }
                            endPosition = opCreationDelegate.createPosition(pos, (int)lineMap.getLineNumber(pos), (int)lineMap.getColumnNumber(pos));
                            getStartPosFromMethodLength = false;
                            if (kind.equals((Object)Tree.Kind.NEW_CLASS)) {
                                identifier = ((NewClassTree)node).getIdentifier();
                                methodName = "<init>";
                                iPath = TreePath.getPath(cu, (Tree)identifier);
                                if (iPath == null) {
                                    return null;
                                }
                                TypeMirror type = trees.getTypeMirror(iPath);
                                if (type == null || type.getKind() == TypeKind.ERROR) {
                                    return null;
                                }
                                assert (type.getKind() == TypeKind.DECLARED);
                                TypeElement te = (TypeElement)types.asElement(type);
                                methodClassType = ElementUtilities.getBinaryName((TypeElement)te);
                            } else {
                                identifier = ((MethodInvocationTree)node).getMethodSelect();
                                if (identifier.getKind() == Tree.Kind.IDENTIFIER) {
                                    methodName = ((IdentifierTree)identifier).getName().toString();
                                    iPath = TreePath.getPath(cu, (Tree)identifier);
                                    if (iPath == null) {
                                        return null;
                                    }
                                    TypeElement te = trees.getScope(iPath).getEnclosingClass();
                                    if (te == null) {
                                        return null;
                                    }
                                    methodClassType = ElementUtilities.getBinaryName((TypeElement)te);
                                } else {
                                    TypeElement te;
                                    methodName = ((MemberSelectTree)identifier).getIdentifier().toString();
                                    getStartPosFromMethodLength = true;
                                    ExpressionTree exp = ((MemberSelectTree)identifier).getExpression();
                                    TreePath expPath = TreePath.getPath(cu, (Tree)exp);
                                    if (expPath == null) {
                                        return null;
                                    }
                                    TypeMirror type = trees.getTypeMirror(expPath);
                                    if (type == null || type.getKind() == TypeKind.ERROR) {
                                        return null;
                                    }
                                    String array = "";
                                    while (type.getKind() == TypeKind.ARRAY) {
                                        type = ((ArrayType)type).getComponentType();
                                        array = array + "[]";
                                    }
                                    TypeKind k = type.getKind();
                                    if (k == TypeKind.DECLARED) {
                                        te = (TypeElement)types.asElement(type);
                                        methodClassType = ElementUtilities.getBinaryName((TypeElement)te) + array;
                                    } else if (k == TypeKind.TYPEVAR) {
                                        TypeParameterElement tpe = (TypeParameterElement)types.asElement(type);
                                        List<? extends TypeMirror> exts = tpe.getBounds();
                                        if (exts.size() == 1) {
                                            type = exts.get(0);
                                            if (type.getKind() != TypeKind.DECLARED) {
                                                return null;
                                            }
                                        } else {
                                            return null;
                                        }
                                        te = (TypeElement)types.asElement(type);
                                        methodClassType = ElementUtilities.getBinaryName((TypeElement)te) + array;
                                    } else if (k == TypeKind.UNION) {
                                        UnionType ut = (UnionType)type;
                                        if ((type = AST2Bytecode.getUnionType(types, ut.getAlternatives())) == null) {
                                            Exceptions.printStackTrace((Throwable)new IllegalStateException("No union type found from " + ut + ", alternatives = " + ut.getAlternatives()));
                                            return null;
                                        }
                                        TypeElement te2 = (TypeElement)types.asElement(type);
                                        methodClassType = ElementUtilities.getBinaryName((TypeElement)te2) + array;
                                    } else if (type instanceof PrimitiveType) {
                                        methodClassType = type.toString() + array;
                                    } else {
                                        Exceptions.printStackTrace((Throwable)new IllegalStateException("Unexpected type " + type + " of kind " + (Object)((Object)type.getKind()) + " in " + treeNodes));
                                        return null;
                                    }
                                }
                            }
                            if (methodNameInBytecode == null || methodNameInBytecode.equals(methodName)) break block56;
                            int next = from;
                            next += AST2Bytecode.getInstrSize(opcode, bytecodes, next);
                            while (true) {
                                block52: {
                                    block57: {
                                        if (next >= to) break block52;
                                        opcode = bytecodes[next] & 0xFF;
                                        if (!AST2Bytecode.isMethodCall(opcode)) break block57;
                                        int constantPoolIndex = ((bytecodes[next + 1] & 0xFF) << 8) + (bytecodes[next + 2] & 0xFF);
                                        try {
                                            methodNameInBytecode = constantPool.getMethodName(constantPoolIndex);
                                            methodDescriptorInBytecode = constantPool.getMethodDescriptor(constantPoolIndex);
                                        }
                                        catch (IndexOutOfBoundsException ioobex) {
                                            ioobex = (IndexOutOfBoundsException)Exceptions.attachMessage((Throwable)ioobex, (String)("While matching " + treeNodes + ". Please attach the code where this happens to http://www.netbeans.org/issues/show_bug.cgi?id=161839"));
                                            Exceptions.printStackTrace((Throwable)ioobex);
                                            break block52;
                                        }
                                        if (methodNameInBytecode.equals(methodName)) break block52;
                                        methodDescriptorInBytecode = null;
                                    }
                                    next += AST2Bytecode.getInstrSize(opcode, bytecodes, next);
                                    continue;
                                }
                                if (next < to) {
                                    from = next;
                                    break;
                                }
                                if (indexesIndex + 2 >= indexes.length) break;
                                from = indexes[indexesIndex += 2];
                                to = indexes[indexesIndex + 1];
                            }
                        }
                        if ((long)(pos = (int)sp.getEndPosition(cu, identifier)) == -1L) {
                            return null;
                        }
                        EditorContext.Position methodEndPosition = opCreationDelegate.createPosition(pos, (int)lineMap.getLineNumber(pos), (int)lineMap.getColumnNumber(pos));
                        if (getStartPosFromMethodLength) {
                            pos -= methodName.length();
                        } else {
                            pos = (int)sp.getStartPosition(cu, identifier);
                            if ((long)pos == -1L) {
                                return null;
                            }
                        }
                        EditorContext.Position methodStartPosition = opCreationDelegate.createPosition(pos, (int)lineMap.getLineNumber(pos), (int)lineMap.getColumnNumber(pos));
                        op = opCreationDelegate.createMethodOperation(startPosition, endPosition, methodStartPosition, methodEndPosition, methodName, methodClassType, from, isNativeMethod);
                        try {
                            Field methodDescriptorField = EditorContext.Operation.class.getDeclaredField("methodDescriptor");
                            methodDescriptorField.setAccessible(true);
                            methodDescriptorField.set(op, methodDescriptorInBytecode);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        operations.add(op);
                    }
                    from += AST2Bytecode.getInstrSize(opcode, bytecodes, from);
                    break block53;
                }
                return null;
            }
            if (op == null) continue;
            nodeOperations.put(node, op);
        }
        if (constantPool == null) {
            while (true) {
                if (from < to) {
                    int opcode = bytecodes[from] & 0xFF;
                    if (AST2Bytecode.isMethodCall(opcode)) {
                        return null;
                    }
                    from += AST2Bytecode.getInstrSize(opcode, bytecodes, from);
                    continue;
                }
                if (indexesIndex + 2 >= indexes.length) break;
                from = indexes[indexesIndex += 2];
                to = indexes[indexesIndex + 1];
            }
        }
        return operations.toArray(new EditorContext.Operation[0]);
    }

    private static TypeMirror getUnionType(Types types, List<? extends TypeMirror> tms) {
        TypeMirror unionType;
        int n = tms.size();
        List[] superTypes = new List[n];
        for (int i = 0; i < n; ++i) {
            superTypes[i] = new ArrayList();
            TypeMirror tm = tms.get(i);
            TypeElement te = (TypeElement)types.asElement(tm);
            superTypes[i].add(te.getSuperclass());
        }
        while ((unionType = AST2Bytecode.findUnion(types, superTypes)) == null) {
            boolean noSuper = true;
            for (int i = 0; i < n; ++i) {
                TypeMirror superclass;
                TypeMirror lastTM = (TypeMirror)superTypes[i].get(superTypes[i].size() - 1);
                TypeElement te = (TypeElement)types.asElement(lastTM);
                if (te == null || (superclass = te.getSuperclass()) == null) continue;
                superTypes[i].add(superclass);
                noSuper = false;
            }
            if (!noSuper) continue;
            break;
        }
        return unionType;
    }

    private static TypeMirror findUnion(Types types, List<TypeMirror>[] sTypes) {
        for (TypeMirror tm : sTypes[0]) {
            if (!AST2Bytecode.isInTypes(types, tm, sTypes, 1)) continue;
            return tm;
        }
        return null;
    }

    private static boolean isInTypes(Types types, TypeMirror tm, List<TypeMirror>[] sTypes, int from) {
        if (from >= sTypes.length) {
            return true;
        }
        for (TypeMirror testTM : sTypes[from]) {
            if (!types.isSameType(tm, testTM)) continue;
            return AST2Bytecode.isInTypes(types, tm, sTypes, from + 1);
        }
        return false;
    }

    private static boolean isMethodCall(int opcode) {
        return opcode >= 182 && opcode <= 185;
    }

    private static int getInstrSize(int opcode, byte[] bytecodes, long codeIndex) {
        if (opcode <= 15) {
            return 1;
        }
        if (opcode == 16) {
            return 2;
        }
        if (opcode == 17) {
            return 3;
        }
        if (opcode == 18) {
            return 2;
        }
        if (opcode <= 20) {
            return 3;
        }
        if (opcode <= 25) {
            return 2;
        }
        if (opcode <= 53) {
            return 1;
        }
        if (opcode <= 58) {
            return 2;
        }
        if (opcode <= 86) {
            return 1;
        }
        if (opcode <= 94) {
            return 1;
        }
        if (opcode <= 131) {
            return 1;
        }
        if (opcode <= 132) {
            return 3;
        }
        if (opcode <= 147) {
            return 1;
        }
        if (opcode <= 152) {
            return 1;
        }
        if (opcode <= 168) {
            return 3;
        }
        if (opcode <= 169) {
            return 2;
        }
        if (opcode == 170) {
            return AST2Bytecode.tableswitchSize(bytecodes, codeIndex);
        }
        if (opcode == 171) {
            return AST2Bytecode.lookupswitchSize(bytecodes, codeIndex);
        }
        if (opcode <= 177) {
            return 1;
        }
        if (opcode <= 184) {
            return 3;
        }
        if (opcode == 185) {
            return 5;
        }
        if (opcode == 186) {
            return 5;
        }
        if (opcode == 187) {
            return 3;
        }
        if (opcode == 188) {
            return 2;
        }
        if (opcode == 189) {
            return 3;
        }
        if (opcode <= 191) {
            return 1;
        }
        if (opcode <= 193) {
            return 3;
        }
        if (opcode <= 195) {
            return 1;
        }
        if (opcode == 196) {
            return AST2Bytecode.wideSize(bytecodes, codeIndex);
        }
        if (opcode == 197) {
            return 4;
        }
        if (opcode <= 199) {
            return 3;
        }
        if (opcode <= 201) {
            return 5;
        }
        return 1;
    }

    private static int tableswitchSize(byte[] bytecodes, long codeIndex) {
        int padding = 4 - (int)codeIndex % 4;
        int pos = (int)codeIndex + padding;
        int low = AST2Bytecode.readInt(bytecodes, pos += 4);
        int high = AST2Bytecode.readInt(bytecodes, pos += 4);
        pos += 4;
        return (pos += high - low + 1 << 2) - (int)codeIndex;
    }

    private static int lookupswitchSize(byte[] bytecodes, long codeIndex) {
        int padding = 4 - (int)codeIndex % 4;
        int pos = (int)codeIndex + padding;
        int npairs = AST2Bytecode.readInt(bytecodes, pos += 4);
        pos += 4;
        return (pos += npairs << 3) - (int)codeIndex;
    }

    private static int wideSize(byte[] bytecodes, long codeIndex) {
        int opcode = bytecodes[(int)codeIndex + 1] & 0xFF;
        if (opcode == 132) {
            return 6;
        }
        return 4;
    }

    private static int readUnsignedShort(byte[] bytecodes, int pos) {
        return (bytecodes[pos] & 0xFF) << 8 | bytecodes[pos + 1] & 0xFF;
    }

    private static int readInt(byte[] bytecodes, int pos) {
        return (bytecodes[pos] & 0xFF) << 24 | (bytecodes[pos + 1] & 0xFF) << 16 | (bytecodes[pos + 2] & 0xFF) << 8 | bytecodes[pos + 3] & 0xFF;
    }
}

