/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.project.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cpplite.project.BuildConfiguration;
import org.netbeans.modules.cpplite.project.CPPLiteProject;
import org.netbeans.modules.cpplite.project.ui.Build;
import org.netbeans.modules.cpplite.project.ui.Editor;
import org.netbeans.modules.cpplite.project.ui.wizard.Bundle;
import org.netbeans.modules.cpplite.project.ui.wizard.CPPLiteProjectPathPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;

public class CPPLiteProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private final WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new CPPLiteProjectPathPanel.PanelImpl(), new EditorPanelImpl(), new BuildPanelImpl()};
    private WizardDescriptor wizard;
    private int idx;

    public Set instantiate() throws IOException {
        CPPLiteProjectSettings settings = CPPLiteProjectSettings.get(this.wizard);
        FileObject projectDirectory = FileUtil.toFileObject((File)new File(settings.projectPath));
        Preferences prefs = CPPLiteProject.getRootPreferences(projectDirectory);
        prefs.putBoolean("is-project", true);
        settings.getBuildConfig().save(CPPLiteProject.getBuildPreferences(projectDirectory));
        return Collections.singleton(projectDirectory);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.idx = 0;
        int i = 0;
        String[] captions = new String[]{Bundle.CAP_ProjectPath(), Bundle.CAP_Editor(), Bundle.CAP_Build()};
        for (WizardDescriptor.Panel p : this.panels) {
            ((JComponent)p.getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", i++);
            ((JComponent)p.getComponent()).putClientProperty("WizardPanel_contentData", captions);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizard = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.idx];
    }

    public String name() {
        return "TODO - wizard name";
    }

    public boolean hasNext() {
        return this.idx < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.idx > 0;
    }

    public void nextPanel() {
        ++this.idx;
    }

    public void previousPanel() {
        --this.idx;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private static class BuildPanelImpl
    implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private Build panel;

        private BuildPanelImpl() {
        }

        public Build getComponent() {
            if (this.panel == null) {
                this.panel = new Build();
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor settings) {
            this.getComponent().load(CPPLiteProjectSettings.get(settings).getBuildConfig());
        }

        public void storeSettings(WizardDescriptor settings) {
            if (this.panel != null) {
                CPPLiteProjectSettings.get(settings).setBuildConfig(this.panel.save());
            }
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isFinishPanel() {
            return true;
        }
    }

    private static class EditorPanelImpl
    implements WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private Editor panel;

        private EditorPanelImpl() {
        }

        public Editor getComponent() {
            if (this.panel == null) {
                this.panel = new Editor();
            }
            return this.panel;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor settings) {
            this.getComponent().load(CPPLiteProjectSettings.get(settings).getEditorConfigPath());
        }

        public void storeSettings(WizardDescriptor settings) {
            if (this.panel != null) {
                CPPLiteProjectSettings.get(settings).setEditorConfigPath(this.panel.save());
            }
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public boolean isFinishPanel() {
            return true;
        }
    }

    public static final class CPPLiteProjectSettings {
        private String projectPath;
        private String editorConfigPath;
        private BuildConfiguration buildConfig;

        public static CPPLiteProjectSettings get(WizardDescriptor desc) {
            CPPLiteProjectSettings setting = (CPPLiteProjectSettings)desc.getProperty(CPPLiteProjectSettings.class.getName());
            if (setting == null) {
                setting = new CPPLiteProjectSettings();
                desc.putProperty(CPPLiteProjectSettings.class.getName(), (Object)setting);
            }
            return setting;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public void setProjectPath(String projectPath) {
            this.projectPath = projectPath;
        }

        public String getEditorConfigPath() {
            if (this.editorConfigPath != null) {
                return this.editorConfigPath;
            }
            FileObject projectDirectory = FileUtil.toFileObject((File)new File(this.projectPath));
            if (projectDirectory != null && projectDirectory.getFileObject("compile_commands.json") != null) {
                return FileUtil.toFile((FileObject)projectDirectory.getFileObject("compile_commands.json")).getAbsolutePath();
            }
            return "";
        }

        public void setEditorConfigPath(String editorConfigPath) {
            this.editorConfigPath = editorConfigPath;
        }

        public BuildConfiguration getBuildConfig() {
            if (this.buildConfig != null) {
                return this.buildConfig;
            }
            FileObject projectDirectory = FileUtil.toFileObject((File)new File(this.projectPath));
            if (projectDirectory != null && projectDirectory.getFileObject("CMakeLists.txt") != null) {
                return CPPLiteProjectSettings.cmakeBuildConfiguration("Release");
            }
            return new BuildConfiguration("", Collections.emptyMap());
        }

        private static BuildConfiguration cmakeBuildConfiguration(String name) {
            HashMap<String, List<List<String>>> action2Comments = new HashMap<String, List<List<String>>>();
            action2Comments.put("build", Arrays.asList(Arrays.asList("cmake", "-H.", "-B" + name, "-DCMAKE_BUILD_TYPE=" + name), Arrays.asList("cmake", "--build", name)));
            return new BuildConfiguration("Release", action2Comments);
        }

        public void setBuildConfig(BuildConfiguration buildConfig) {
            this.buildConfig = buildConfig;
        }
    }
}

