/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.FoldingRangeProviderOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RenameOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkDoneProgressCancelParams;
import org.eclipse.lsp4j.WorkDoneProgressParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.messages.NotificationMessage;
import org.eclipse.lsp4j.jsonrpc.messages.RequestMessage;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientCapabilities;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientWrapper;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.NbLspServer;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowStatusMessageParams;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceIOContext;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceServiceImpl;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceUIContext;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Server {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    static final ThreadLocal<NbCodeLanguageClient> DISPATCHERS = new ThreadLocal();
    public static final String JAVA_BUILD_WORKSPACE = "java.build.workspace";
    public static final String JAVA_LOAD_WORKSPACE_TESTS = "java.load.workspace.tests";
    public static final String JAVA_SUPER_IMPLEMENTATION = "java.super.implementation";
    public static final String GRAALVM_PAUSE_SCRIPT = "graalvm.pause.script";
    static final String INDEXING_COMPLETED = "Indexing completed.";
    static final String NO_JAVA_SUPPORT = "Cannot initialize Java support on JDK ";
    static final NbCodeLanguageClient STUB_CLIENT = new NbCodeLanguageClient(){
        private final NbCodeClientCapabilities caps = new NbCodeClientCapabilities();

        private void logWarning(Object ... args) {
            LOG.log(Level.WARNING, "LSP Client called without proper context with param(s): {0}", Arrays.asList(args));
        }

        @Override
        public void showStatusBarMessage(ShowStatusMessageParams params) {
            this.logWarning(new Object[]{params});
        }

        @Override
        public CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(params.getCanPickMany() || params.getItems().isEmpty() ? params.getItems() : Collections.singletonList(params.getItems().get(0)));
        }

        @Override
        public CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
            this.logWarning(params);
            return CompletableFuture.completedFuture(params.getValue());
        }

        @Override
        public void notifyTestProgress(TestProgressParams params) {
            this.logWarning(params);
        }

        @Override
        public NbCodeClientCapabilities getNbCodeCapabilities() {
            this.logWarning(new Object[0]);
            return this.caps;
        }

        public void telemetryEvent(Object object) {
            this.logWarning(object);
        }

        public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
            this.logWarning(diagnostics);
        }

        public void showMessage(MessageParams messageParams) {
            this.logWarning(messageParams);
        }

        public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
            this.logWarning(requestParams);
            CompletableFuture<MessageActionItem> x = new CompletableFuture<MessageActionItem>();
            x.complete(null);
            return x;
        }

        public void logMessage(MessageParams message) {
            this.logWarning(message);
        }
    };

    private Server() {
    }

    public static NbCodeLanguageClient getStubClient() {
        return STUB_CLIENT;
    }

    public static boolean isClientResponseThread(NbCodeLanguageClient client) {
        return client != null ? DISPATCHERS.get() == client : DISPATCHERS.get() != null;
    }

    public static NbLspServer launchServer(Pair<InputStream, OutputStream> io, LspSession session) {
        LanguageServerImpl server = new LanguageServerImpl();
        ConsumeWithLookup msgProcessor = new ConsumeWithLookup(server.getSessionLookup());
        Launcher<NbCodeLanguageClient> serverLauncher = Server.createLauncher(server, io, msgProcessor::attachLookup);
        NbCodeLanguageClient remote = (NbCodeLanguageClient)serverLauncher.getRemoteProxy();
        server.connect(remote);
        msgProcessor.attachClient(server.client);
        Future runningServer = serverLauncher.startListening();
        return new NbLspServer(server, runningServer);
    }

    private static Launcher<NbCodeLanguageClient> createLauncher(LanguageServerImpl server, Pair<InputStream, OutputStream> io, Function<MessageConsumer, MessageConsumer> processor) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(NbCodeLanguageClient.class).setInput((InputStream)io.first()).setOutput((OutputStream)io.second()).wrapMessages(processor).create();
    }

    public static Iterable<Project> projectPath(final @NonNull Project project, final boolean excludeSelf) {
        return new Iterable<Project>(){

            @Override
            public Iterator<Project> iterator() {
                return new Iterator<Project>(){
                    Project next;
                    {
                        this.next = excludeSelf ? project : ProjectUtils.parentOf((Project)project);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Project next() {
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                        Project r = this.next;
                        this.next = ProjectUtils.parentOf((Project)r);
                        return r;
                    }
                };
            }
        };
    }

    static class LanguageServerImpl
    implements LanguageServer,
    LanguageClientAware,
    LspServerState {
        private static final RequestProcessor SERVER_INIT_RP = new RequestProcessor(LanguageServerImpl.class.getName());
        private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class.getName());
        private NbCodeClientWrapper client;
        private final TextDocumentService textDocumentService = new TextDocumentServiceImpl(this);
        private final WorkspaceService workspaceService = new WorkspaceServiceImpl(this);
        private final InstanceContent sessionServices = new InstanceContent();
        private final Lookup sessionLookup = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.sessionServices), Lookup.getDefault()});
        private final Map<Project, CompletableFuture<Void>> beingOpened = new HashMap<Project, CompletableFuture<Void>>();
        private final Map<Project, CompletableFuture<Project>> openingFileOwners = new HashMap<Project, CompletableFuture<Project>>();
        private volatile CompletableFuture<Project[]> workspaceProjects = new CompletableFuture();
        private volatile Collection<Project> openedProjects = Collections.emptyList();
        private AtomicInteger openRequestId = new AtomicInteger(1);

        LanguageServerImpl() {
        }

        Lookup getSessionLookup() {
            return this.sessionLookup;
        }

        @Override
        public CompletableFuture<Project[]> asyncOpenSelectedProjects(List<FileObject> projectCandidates) {
            CompletableFuture<Project[]> f = new CompletableFuture<Project[]>();
            SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(f, projectCandidates, true));
            return f;
        }

        @Override
        public CompletableFuture<Project> asyncOpenFileOwner(FileObject file) {
            Project prj = FileOwnerQuery.getOwner((FileObject)file);
            if (prj == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.workspaceProjects.thenCompose(wprj -> {
                CompletableFuture f = new CompletableFuture();
                CompletionStage g = f.thenApply(arr -> ((Project[])arr).length > 0 ? arr[0] : null);
                List<Project> prjs = Arrays.asList(wprj);
                boolean openImmediately = false;
                LanguageServerImpl languageServerImpl = this;
                synchronized (languageServerImpl) {
                    if (this.openedProjects.contains(prj)) {
                        return CompletableFuture.completedFuture(prj);
                    }
                    CompletableFuture<Void> h = this.beingOpened.get(prj);
                    if (h != null) {
                        return h.thenApply(unused -> prj);
                    }
                    CompletableFuture<Project> p = this.openingFileOwners.putIfAbsent(prj, (CompletableFuture<Project>)g);
                    if (p != null) {
                        return p;
                    }
                    for (Project check : Server.projectPath(prj, false)) {
                        if (!prjs.contains(check)) continue;
                        openImmediately = true;
                        break;
                    }
                }
                if (openImmediately) {
                    SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(f, Collections.singletonList(file), false));
                } else {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)prj);
                    String dispName = pi != null ? pi.getDisplayName() : Bundle.PROMPT_AskOpenProjectForFile_Unnamed();
                    MessageActionItem yes = new MessageActionItem(Bundle.PROMPT_AskOpenProjectForFile_Yes());
                    ShowMessageRequestParams smrp = new ShowMessageRequestParams(Arrays.asList(yes, new MessageActionItem(Bundle.PROMPT_AskOpenProjectForFile_No())));
                    if (dispName.equals(prj.getProjectDirectory().getPath())) {
                        smrp.setMessage(Bundle.PROMPT_AskOpenProjectForFileNoName(file.getPath()));
                    } else {
                        smrp.setMessage(Bundle.PROMPT_AskOpenProjectForFile(file.getPath(), dispName));
                    }
                    smrp.setType(MessageType.Info);
                    this.client.showMessageRequest(smrp).thenAccept(ai -> {
                        if (!yes.equals(ai)) {
                            f.completeExceptionally(new CancellationException());
                            return;
                        }
                        SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(f, Collections.singletonList(file), false));
                    });
                }
                return f.thenApply(arr -> ((Project[])arr).length > 0 ? arr[0] : null);
            });
        }

        private void asyncOpenSelectedProjects0(CompletableFuture<Project[]> f, List<FileObject> projectCandidates, boolean asWorkspaceProjects) {
            ArrayList<Project> projects = new ArrayList<Project>();
            try {
                Project[] previouslyOpened;
                for (FileObject candidate : projectCandidates) {
                    Project prj = FileOwnerQuery.getOwner((FileObject)candidate);
                    if (prj == null) continue;
                    projects.add(prj);
                }
                try {
                    previouslyOpened = (Project[])OpenProjects.getDefault().openProjects().get();
                    if (previouslyOpened.length > 0) {
                        Level level = Level.FINEST;
                        assert ((level = Level.CONFIG) != null);
                        for (Project p : previouslyOpened) {
                            LOG.log(level, "Previously opened project at {0}", p.getProjectDirectory());
                        }
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
                this.asyncOpenSelectedProjects1(f, previouslyOpened, projects, asWorkspaceProjects);
            }
            catch (RuntimeException ex) {
                f.completeExceptionally(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void asyncOpenSelectedProjects1(CompletableFuture<Project[]> f, Project[] previouslyOpened, List<Project> projects, boolean addToWorkspace) {
            final int id = this.openRequestId.getAndIncrement();
            ArrayList primingBuilds = new ArrayList();
            ArrayList<Project> toOpen = new ArrayList<Project>();
            HashMap local = new HashMap();
            LanguageServerImpl languageServerImpl = this;
            synchronized (languageServerImpl) {
                LOG.log(Level.FINER, "{0}: Asked to open project(s): {1}", new Object[]{id, Arrays.asList(projects)});
                for (Project p : projects) {
                    CompletableFuture<Void> pending = this.beingOpened.get(p);
                    if (pending != null) {
                        primingBuilds.add(pending);
                        continue;
                    }
                    toOpen.add(p);
                    local.put(p, new CompletableFuture());
                }
                this.beingOpened.putAll(local);
            }
            LOG.log(Level.FINER, id + ": Opening projects: {0}", Arrays.asList(toOpen));
            for (final Project p : toOpen) {
                ActionProvider pap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
                if (pap == null) {
                    LOG.log(Level.FINER, "{0}: No action provider at all !", id);
                    continue;
                }
                if (!Arrays.asList(pap.getSupportedActions()).contains("prime")) {
                    LOG.log(Level.FINER, "{0}: No action provider gives PRIME", id);
                    continue;
                }
                LOG.log(Level.FINER, "{0}: Found Priming action: {1}", new Object[]{id, p});
                if (!pap.isActionEnabled("prime", Lookup.EMPTY)) continue;
                final CompletableFuture primeF = new CompletableFuture();
                LOG.log(Level.FINER, "{0}: Found enabled Priming build for: {1}", new Object[]{id, p});
                ActionProgress progress = new ActionProgress(){

                    protected void started() {
                    }

                    public void finished(boolean success) {
                        LOG.log(Level.FINER, id + ": Priming build completed for project " + p);
                        primeF.complete(null);
                    }
                };
                primingBuilds.add(primeF);
                pap.invokeAction("prime", Lookups.fixed((Object[])new Object[]{progress}));
            }
            ((CompletableFuture)CompletableFuture.allOf(primingBuilds.toArray(new CompletableFuture[primingBuilds.size()])).thenRun(() -> {
                OpenProjects.getDefault().open(projects.toArray(new Project[0]), false);
                try {
                    LOG.log(Level.FINER, "{0}: Calling openProjects() for : {1}", new Object[]{id, Arrays.asList(projects)});
                    OpenProjects.getDefault().openProjects().get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
                for (Project prj : projects) {
                    ProjectUtils.getSources((Project)prj).getSourceGroups("generic");
                    CompletableFuture prjF = (CompletableFuture)local.get(prj);
                    if (prjF == null) continue;
                    prjF.complete(null);
                }
                HashSet<Project> projectSet = new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects()));
                projectSet.retainAll(this.openedProjects);
                projectSet.addAll(projects);
                Project[] prjs = projects.toArray(new Project[projects.size()]);
                LOG.log(Level.FINER, "{0}: Finished opening projects: {1}", new Object[]{id, Arrays.asList(projects)});
                LanguageServerImpl languageServerImpl = this;
                synchronized (languageServerImpl) {
                    this.openedProjects = projectSet;
                    if (addToWorkspace) {
                        HashSet<Object> ns = new HashSet<Object>(projects);
                        int s = ns.size();
                        ns.addAll(Arrays.asList((Object[])this.workspaceProjects.getNow(new Project[0])));
                        if (s != ns.size()) {
                            prjs = ns.toArray(new Project[ns.size()]);
                            this.workspaceProjects = CompletableFuture.completedFuture(prjs);
                        }
                    }
                    for (Project p : prjs) {
                        this.openingFileOwners.put(p, (CompletableFuture<Project>)f.thenApply(unused -> p));
                    }
                }
                f.complete(prjs);
            })).exceptionally(e -> {
                f.completeExceptionally((Throwable)e);
                return null;
            });
        }

        private JavaSource checkJavaSupport() {
            ClasspathInfo info = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
            JavaSource source = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
            if (source == null) {
                SERVER_INIT_RP.post(() -> {
                    String msg = Server.NO_JAVA_SUPPORT + System.getProperty("java.version");
                    this.showStatusBarMessage(MessageType.Error, msg, 5000);
                });
            }
            return source;
        }

        @Override
        public CompletableFuture<Project[]> openedProjects() {
            return this.workspaceProjects;
        }

        private JavaSource showIndexingCompleted(Project[] opened) {
            try {
                JavaSource source = this.checkJavaSupport();
                if (source != null) {
                    source.runWhenScanFinished(cc -> this.showStatusBarMessage(MessageType.Info, Server.INDEXING_COMPLETED, 0), true);
                }
                return source;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void showStatusBarMessage(MessageType type, String msg, int timeout) {
            if (this.client.getNbCodeCapabilities().hasStatusBarMessageSupport()) {
                this.client.showStatusBarMessage(new ShowStatusMessageParams(type, msg, timeout));
            } else {
                this.client.showMessage(new ShowStatusMessageParams(type, msg, timeout));
            }
        }

        private InitializeResult constructInitResponse(JavaSource src) {
            ServerCapabilities capabilities = new ServerCapabilities();
            if (src != null) {
                capabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
                CompletionOptions completionOptions = new CompletionOptions();
                completionOptions.setResolveProvider(Boolean.valueOf(true));
                completionOptions.setTriggerCharacters(Collections.singletonList("."));
                capabilities.setCompletionProvider(completionOptions);
                capabilities.setHoverProvider(Boolean.valueOf(true));
                capabilities.setCodeActionProvider(new CodeActionOptions(Arrays.asList("quickfix", "source")));
                capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
                capabilities.setDefinitionProvider(Boolean.valueOf(true));
                capabilities.setImplementationProvider(Boolean.valueOf(true));
                capabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
                capabilities.setReferencesProvider(Boolean.valueOf(true));
                ArrayList<String> commands = new ArrayList<String>(Arrays.asList(Server.JAVA_BUILD_WORKSPACE, Server.JAVA_LOAD_WORKSPACE_TESTS, Server.GRAALVM_PAUSE_SCRIPT, Server.JAVA_SUPER_IMPLEMENTATION));
                for (CodeGenerator codeGenerator : Lookup.getDefault().lookupAll(CodeGenerator.class)) {
                    commands.addAll(codeGenerator.getCommands());
                }
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(commands));
                capabilities.setWorkspaceSymbolProvider(Boolean.valueOf(true));
                capabilities.setCodeLensProvider(new CodeLensOptions(false));
                RenameOptions renOpt = new RenameOptions();
                renOpt.setPrepareProvider(Boolean.valueOf(true));
                capabilities.setRenameProvider(renOpt);
                FoldingRangeProviderOptions foldingOptions = new FoldingRangeProviderOptions();
                capabilities.setFoldingRangeProvider(foldingOptions);
            }
            return new InitializeResult(capabilities);
        }

        public CompletableFuture<InitializeResult> initialize(InitializeParams init) {
            NbCodeClientCapabilities capa = NbCodeClientCapabilities.get(init);
            this.client.setClientCaps(capa);
            ArrayList<FileObject> projectCandidates = new ArrayList<FileObject>();
            List folders = init.getWorkspaceFolders();
            if (folders != null) {
                for (WorkspaceFolder w : folders) {
                    try {
                        projectCandidates.add(Utils.fromUri(w.getUri()));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            } else {
                String root = init.getRootUri();
                if (root != null) {
                    try {
                        projectCandidates.add(Utils.fromUri(root));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            }
            CompletableFuture<Project[]> prjs = this.workspaceProjects;
            SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects0(prjs, projectCandidates, true));
            prjs.thenApply(this::showIndexingCompleted);
            return CompletableFuture.completedFuture(this.finishInitialization(this.constructInitResponse(this.checkJavaSupport())));
        }

        public CompletableFuture<Project[]> getWorkspaceProjects() {
            return this.workspaceProjects;
        }

        public InitializeResult finishInitialization(InitializeResult res) {
            OperationContext c = OperationContext.find(this.sessionLookup);
            c.acquireProgressToken();
            return res;
        }

        public CompletableFuture<Object> shutdown() {
            return CompletableFuture.completedFuture(null);
        }

        public void exit() {
        }

        @Override
        public TextDocumentService getTextDocumentService() {
            return this.textDocumentService;
        }

        public WorkspaceService getWorkspaceService() {
            return this.workspaceService;
        }

        public void cancelProgress(WorkDoneProgressCancelParams params) {
        }

        public void connect(LanguageClient aClient) {
            this.client = new NbCodeClientWrapper((NbCodeLanguageClient)aClient);
            this.sessionServices.add((Object)this);
            this.sessionServices.add((Object)this.client);
            this.sessionServices.add((Object)new WorkspaceIOContext(){

                @Override
                protected LanguageClient client() {
                    return client;
                }
            });
            this.sessionServices.add((Object)new WorkspaceUIContext(this.client));
            ((LanguageClientAware)this.getTextDocumentService()).connect(aClient);
            ((LanguageClientAware)this.getWorkspaceService()).connect(aClient);
        }
    }

    private static class ConsumeWithLookup {
        private final Lookup sessionLookup;
        private NbCodeLanguageClient client;
        private OperationContext initialContext;

        public ConsumeWithLookup(Lookup sessionLookup) {
            this.sessionLookup = sessionLookup;
        }

        synchronized void attachClient(NbCodeLanguageClient client) {
            this.client = client;
        }

        public MessageConsumer attachLookup(final MessageConsumer delegate) {
            return new MessageConsumer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void consume(Message msg) throws MessageIssueException, JsonRpcException {
                    OperationContext ctx;
                    InstanceContent ic = new InstanceContent();
                    ProxyLookup ll = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), sessionLookup});
                    InternalHandle toCancel = null;
                    if (msg instanceof RequestMessage) {
                        RequestMessage rq = (RequestMessage)msg;
                        Object p = rq.getParams();
                        if (initialContext == null) {
                            initialContext = OperationContext.create(client);
                            ctx = initialContext;
                        } else {
                            ctx = initialContext.operationContext();
                        }
                        if (p instanceof WorkDoneProgressParams) {
                            ctx.setProgressToken((Either<String, Number>)((WorkDoneProgressParams)p).getWorkDoneToken());
                        }
                    } else if (msg instanceof NotificationMessage) {
                        NotificationMessage not = (NotificationMessage)msg;
                        Object p = not.getParams();
                        OperationContext selected = null;
                        if (p instanceof WorkDoneProgressCancelParams && initialContext != null) {
                            WorkDoneProgressCancelParams wdc = (WorkDoneProgressCancelParams)p;
                            toCancel = initialContext.findActiveHandle((Either<String, Number>)wdc.getToken());
                            selected = OperationContext.getHandleContext(toCancel);
                        }
                        ctx = selected;
                    } else {
                        ctx = null;
                    }
                    if (ctx != null) {
                        ic.add(ctx);
                    }
                    InternalHandle ftoCancel = toCancel;
                    try {
                        DISPATCHERS.set(client);
                        Lookups.executeWith((Lookup)ll, () -> {
                            try {
                                delegate.consume(msg);
                            }
                            finally {
                                if (ftoCancel != null) {
                                    ftoCancel.requestCancel();
                                }
                                if (ctx != null) {
                                    ctx.stop();
                                }
                            }
                        });
                    }
                    finally {
                        DISPATCHERS.remove();
                    }
                }
            };
        }
    }
}

