/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.ConfigurableLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.execute.AbstractGradleExecutor;
import org.netbeans.modules.gradle.execute.Bundle;
import org.netbeans.modules.gradle.execute.EscapeProcessingOutputStream;
import org.netbeans.modules.gradle.execute.GradlePlainEscapeProcessor;
import org.netbeans.modules.gradle.loaders.GradleDaemon;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleProgressListenerProvider;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.netbeans.modules.gradle.spi.execute.GradleJavaPlatformProvider;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.io.ReaderInputStream;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;

public final class GradleDaemonExecutor
extends AbstractGradleExecutor {
    private CancellationTokenSource cancelTokenSource;
    private static final Logger LOGGER = Logger.getLogger(GradleDaemonExecutor.class.getName());
    private final ProgressHandle handle;
    private InputStream inStream;
    private OutputStream outStream;
    private OutputStream errStream;
    private boolean cancelling;
    private GradleTask gradleTask;

    public GradleDaemonExecutor(RunConfig config) {
        super(config);
        this.handle = ProgressHandle.createHandle((String)config.getTaskDisplayName(), (Cancellable)this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GradleDaemonExecutor.this.getInputOutput().select();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.taskSemaphore;
        synchronized (object) {
            if (this.task == null) {
                try {
                    this.taskSemaphore.wait();
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINE, "interrupted", ex);
                }
            }
        }
        InputOutput ioput = this.getInputOutput();
        this.actionStatesAtStart();
        this.handle.start();
        final Lookup execLookup = Lookup.getDefault();
        try {
            GradleBaseProject gbp;
            GradleDistributionManager.GradleDistribution dist;
            BuildExecutionSupport.registerRunningItem((BuildExecutionSupport.Item)this.item);
            if (GradleSettings.getDefault().isAlwaysShowOutput()) {
                ioput.select();
            }
            this.cancelTokenSource = GradleConnector.newCancellationTokenSource();
            GradleDistributionProvider distProvider = (GradleDistributionProvider)this.config.getProject().getLookup().lookup(GradleDistributionProvider.class);
            GradleDistributionManager.GradleDistribution gradleDistribution = dist = distProvider != null ? distProvider.getGradleDistribution() : null;
            if (dist != null && !dist.isAvailable()) {
                try {
                    IOColorPrint.print((InputOutput)this.io, (CharSequence)(Bundle.DOWNLOAD_GRADLE(dist.getVersion()) + "\n"), (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.LOG_WARNING));
                    try {
                        dist.install().get();
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        IOColorPrint.print((InputOutput)this.io, (CharSequence)Bundle.DOWNLOAD_GRADLE_FAILED(dist.getVersion(), dist.getDistributionURI()), (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.LOG_FAILURE));
                        throw new BuildException(Bundle.DOWNLOAD_GRADLE_FAILED(dist.getVersion(), dist.getDistributionURI()), (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            ProjectConnection pconn = (ProjectConnection)this.config.getProject().getLookup().lookup(ProjectConnection.class);
            BuildLauncher buildLauncher = pconn.newBuild();
            GradleCommandLine cmd = this.config.getCommandLine();
            if (RunUtils.isAugmentedBuildEnabled(this.config.getProject())) {
                cmd = new GradleCommandLine(cmd);
                cmd.addParameter(GradleCommandLine.Parameter.INIT_SCRIPT, GradleDaemon.INIT_SCRIPT);
                cmd.addSystemProperty("NETBEANS_TOOLING_JAR", GradleDaemon.TOOLING_JAR);
            }
            cmd.configure((ConfigurableLauncher<?>)buildLauncher, (gbp = GradleBaseProject.get(this.config.getProject())) != null ? gbp.getRootDir() : null);
            this.printCommandLine();
            GradleJavaPlatformProvider platformProvider = (GradleJavaPlatformProvider)this.config.getProject().getLookup().lookup(GradleJavaPlatformProvider.class);
            if (platformProvider != null) {
                try {
                    buildLauncher.setJavaHome(platformProvider.getJavaHome());
                    HashMap<String, String> envs = new HashMap<String, String>(System.getenv());
                    envs.put("JAVA_HOME", platformProvider.getJavaHome().getCanonicalPath());
                    buildLauncher.setEnvironmentVariables(envs);
                }
                catch (IOException ex) {
                    this.io.getErr().println(Bundle.NO_PLATFORM(ex.getMessage()));
                    BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)this.item);
                    this.closeInOutErr();
                    this.checkForExternalModifications();
                    this.handle.finish();
                    this.markFreeTab();
                    this.actionStatesAtFinish();
                    return;
                }
            }
            this.outStream = new EscapeProcessingOutputStream(new GradlePlainEscapeProcessor(this.io, this.config, false));
            this.errStream = new EscapeProcessingOutputStream(new GradlePlainEscapeProcessor(this.io, this.config, true));
            try {
                this.inStream = new ReaderInputStream(this.io.getIn(), "UTF-8");
                buildLauncher.setStandardInput(this.inStream);
            }
            catch (IOException ex) {
                // empty catch block
            }
            buildLauncher.setStandardOutput(this.outStream);
            buildLauncher.setStandardError(this.errStream);
            buildLauncher.addProgressListener(pe -> Lookups.executeWith((Lookup)execLookup, () -> this.handle.progress(pe.getDescription())));
            buildLauncher.withCancellationToken(this.cancelTokenSource.token());
            if (this.config.getProject() != null) {
                Collection providers = this.config.getProject().getLookup().lookupAll(GradleProgressListenerProvider.class);
                for (GradleProgressListenerProvider provider : providers) {
                    class ProgressLookupListener
                    implements ProgressListener {
                        private final ProgressListener delegate;

                        public ProgressLookupListener(ProgressListener delegate) {
                            this.delegate = delegate;
                        }

                        public void statusChanged(ProgressEvent event) {
                            Lookups.executeWith((Lookup)execLookup, () -> this.delegate.statusChanged(event));
                        }
                    }
                    buildLauncher.addProgressListener((ProgressListener)new ProgressLookupListener(provider.getProgressListener()), provider.getSupportedOperationTypes());
                }
            }
            buildLauncher.run();
            StatusDisplayer.getDefault().setStatusText(Bundle.BUILD_SUCCESS(this.getProjectName()));
            this.gradleTask.finish(0);
        }
        catch (BuildCancelledException ex) {
            this.showAbort();
        }
        catch (UncheckedException | BuildException ex) {
            if (!this.cancelling) {
                StatusDisplayer.getDefault().setStatusText(Bundle.BUILD_FAILED(this.getProjectName()));
                this.gradleTask.finish(1);
            } else {
                this.showAbort();
            }
        }
        catch (GradleConnectionException ex) {
            boolean handled = false;
            for (Throwable th = ex.getCause(); th != null && !handled; th = th.getCause()) {
                if (!(th instanceof StreamCorruptedException)) continue;
                LOGGER.log(Level.INFO, "Suspecting Gradle Serialization IO Error:", ex);
                try {
                    IOColorPrint.print((InputOutput)this.io, (CharSequence)Bundle.GRADLE_IO_ERROR(), (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.LOG_WARNING));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                handled = true;
            }
            if (!handled) {
                throw ex;
            }
        }
        finally {
            BuildExecutionSupport.registerFinishedItem((BuildExecutionSupport.Item)this.item);
            this.closeInOutErr();
            this.checkForExternalModifications();
            this.handle.finish();
            this.markFreeTab();
            this.actionStatesAtFinish();
        }
    }

    private String getProjectName() {
        ProjectInformation info = ProjectUtils.getInformation((Project)this.config.getProject());
        return info.getDisplayName();
    }

    private void printCommandLine() {
        GradleBaseProject gbp;
        File dir;
        GradleJavaPlatformProvider platformProvider;
        StringBuilder commandLine = new StringBuilder(1024);
        String userHome = GradleSettings.getDefault().getPreferences().get("gradleUserHome", null);
        if (userHome != null) {
            commandLine.append("GRADLE_USER_HOME=\"").append(userHome).append("\"\n");
        }
        if ((platformProvider = (GradleJavaPlatformProvider)this.config.getProject().getLookup().lookup(GradleJavaPlatformProvider.class)) != null) {
            try {
                File javaHome = platformProvider.getJavaHome();
                commandLine.append("JAVA_HOME=\"").append(javaHome.getAbsolutePath()).append("\"\n");
            }
            catch (FileNotFoundException javaHome) {
                // empty catch block
            }
        }
        if ((dir = FileUtil.toFile((FileObject)this.config.getProject().getProjectDirectory())) != null) {
            commandLine.append("cd ").append(dir.getAbsolutePath()).append("; ");
        }
        if ((gbp = GradleBaseProject.get(this.config.getProject())) != null && new GradleFiles(gbp.getProjectDir(), true).hasWrapper() && GradleSettings.getDefault().isWrapperPreferred()) {
            Path rootPath = gbp.getRootDir().toPath();
            Path projectPath = gbp.getProjectDir().toPath();
            String relRoot = projectPath.relativize(rootPath).toString();
            relRoot = relRoot.isEmpty() ? "." : relRoot;
            commandLine.append(relRoot).append(GradleDaemonExecutor.gradlewExecutable());
        } else {
            GradleDistributionManager.GradleDistribution dist;
            GradleDistributionProvider pvd = (GradleDistributionProvider)this.config.getProject().getLookup().lookup(GradleDistributionProvider.class);
            GradleDistributionManager.GradleDistribution gradleDistribution = dist = pvd != null ? pvd.getGradleDistribution() : null;
            if (dist != null) {
                File gradle = new File(dist.getDistributionDir(), GradleDaemonExecutor.gradleExecutable());
                commandLine.append(gradle.getAbsolutePath());
            }
        }
        for (String arg : this.config.getCommandLine().getSupportedCommandLine()) {
            commandLine.append(' ');
            if (arg.contains(" ") || arg.contains("*")) {
                commandLine.append('\'').append(arg).append('\'');
                continue;
            }
            commandLine.append(arg);
        }
        commandLine.append('\n');
        try {
            if (IOColorPrint.isSupported((InputOutput)this.io)) {
                IOColorPrint.print((InputOutput)this.io, (CharSequence)commandLine, (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.INPUT));
            } else {
                this.io.getOut().print((Object)commandLine);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void closeInOutErr() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.errStream != null) {
            try {
                this.errStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void showAbort() {
        try {
            IOColorPrint.print((InputOutput)this.io, (CharSequence)Bundle.TXT_BUILD_ABORTED(), (Color)IOColors.getColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.LOG_DEBUG));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean cancel() {
        if (!this.cancelling && this.cancelTokenSource != null) {
            this.handle.switchToIndeterminate();
            this.handle.setDisplayName(Bundle.LBL_ABORTING_BUILD());
            this.closeInOutErr();
            this.cancelling = true;
            this.cancelTokenSource.cancel();
            return true;
        }
        return false;
    }

    private static String gradlewExecutable() {
        return Utilities.isWindows() ? "\\gradlew.bat" : "/gradlew";
    }

    private static String gradleExecutable() {
        return Utilities.isWindows() ? "bin\\gradle.bat" : "bin/gradle";
    }

    public final ExecutorTask createTask(ExecutorTask process) {
        assert (this.gradleTask == null);
        this.gradleTask = new GradleTask(process);
        return this.gradleTask;
    }

    private static final class GradleTask
    extends ExecutorTask {
        private final ExecutorTask delegate;
        private Integer result;

        GradleTask(ExecutorTask delegate) {
            super(() -> {});
            this.delegate = delegate;
        }

        public void stop() {
            this.delegate.stop();
        }

        public int result() {
            if (this.result != null) {
                return this.result;
            }
            return this.delegate.result();
        }

        public InputOutput getInputOutput() {
            return this.delegate.getInputOutput();
        }

        public void finish(int result) {
            this.result = result;
            this.notifyFinished();
        }
    }
}

