/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;

public class LabelBracketTableCellRenderer
extends EnhancedTableCellRenderer {
    private JLabel label1;
    private JLabel label2;
    private int digitsWidth = -1;

    public LabelBracketTableCellRenderer() {
        this(10);
    }

    public LabelBracketTableCellRenderer(int horizontalAlignment) {
        this(horizontalAlignment, "(99.9%)");
    }

    public LabelBracketTableCellRenderer(int horizontalAlignment, final String widestBracketText) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.label1 = new JLabel("", horizontalAlignment);
        this.label2 = new JLabel("", horizontalAlignment){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                if (LabelBracketTableCellRenderer.this.digitsWidth == -1) {
                    LabelBracketTableCellRenderer.this.digitsWidth = this.getFontMetrics(this.getFont()).stringWidth(widestBracketText);
                }
                if (d.width < LabelBracketTableCellRenderer.this.digitsWidth) {
                    return new Dimension(LabelBracketTableCellRenderer.this.digitsWidth, d.height);
                }
                return d;
            }
        };
        Font f = this.label2.getFont();
        this.label2.setFont(new Font(f.getName(), f.getStyle(), f.getSize() - 1));
        this.setLayout(new BorderLayout());
        if (horizontalAlignment == 10) {
            this.add((Component)this.label1, "West");
            this.add((Component)this.label2, "Center");
        } else {
            this.add((Component)this.label1, "Center");
            this.add((Component)this.label2, "East");
        }
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return new LabelBracketTableCellRenderer(this.label1.getHorizontalAlignment()).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void setRowForeground(Color c) {
        super.setRowForeground(c);
        this.label1.setForeground(c);
        this.label2.setForeground(UIUtils.getDisabledForeground(c));
    }

    @Override
    protected void setValue(JTable table, Object value, int row, int column) {
        if (table != null) {
            this.setFont(table.getFont());
        }
        if (value != null) {
            String str = value.toString();
            int bracketIdx = str.lastIndexOf(40);
            if (bracketIdx != -1) {
                this.label1.setText(str.substring(0, bracketIdx));
                this.label2.setText(str.substring(bracketIdx));
            } else {
                this.label1.setText(str);
                this.label2.setText("");
            }
        } else {
            this.label1.setText("");
            this.label2.setText("");
        }
    }
}

