/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.netbeans.modules.java.disco.archive.Unarchiver;
import org.openide.windows.InputOutput;

public class CommonsUnzip
implements Unarchiver {
    @Override
    public void uncompress(File zip, File targetDir, InputOutput io) throws IOException {
        try (ZipArchiveInputStream i = new ZipArchiveInputStream(new FileInputStream(zip));){
            ZipArchiveEntry entry = null;
            while ((entry = i.getNextZipEntry()) != null) {
                File f;
                if (!i.canReadEntryData(entry) || !CommonsUnzip.isAncestor(targetDir, f = new File(targetDir, entry.getName()).getAbsoluteFile())) continue;
                if (entry.isDirectory()) {
                    io.getOut().println("   creating: " + entry.getName());
                    if (f.isDirectory() || f.mkdirs()) continue;
                    throw new IOException("Could not create dirs" + f);
                }
                File parent = f.getParentFile();
                if (parent == null || !parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Could not create dirs" + parent);
                }
                io.getOut().println("  inflating: " + entry.getName());
                try (OutputStream o = Files.newOutputStream(f.toPath(), new OpenOption[0]);){
                    IOUtils.copy(i, o);
                }
                if (entry.getUnixMode() == 0 || (entry.getUnixMode() & 1) == 0) continue;
                f.setExecutable(true);
            }
        }
    }

    private static boolean isAncestor(File targetDir, File child) {
        while (child.getParentFile() != null) {
            if (child.getParentFile().equals(targetDir)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    @Override
    public boolean isSupported(File input) {
        return input.getName().toLowerCase().endsWith(".zip");
    }
}

