/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import io.foojay.api.discoclient.pkg.TermOfSupport;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.netbeans.modules.java.disco.LTSes;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class QuickPanel
extends JPanel {
    private JRadioButton autoInstallJDK;
    private ButtonGroup buttonGroup1;
    private JRadioButton manualJDK;
    private JSlider versions;
    private @MonotonicNonNull VersionsModel versionsModel;

    public QuickPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        JLabel jLabel1 = new JLabel();
        this.versions = new JSlider();
        this.autoInstallJDK = new JRadioButton();
        this.manualJDK = new JRadioButton();
        Mnemonics.setLocalizedText((JLabel)jLabel1, (String)NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.jLabel1.text"));
        this.versions.setMaximum(20);
        this.versions.setMinimum(8);
        this.versions.setPaintLabels(true);
        this.versions.setPaintTicks(true);
        this.versions.setSnapToTicks(true);
        this.versions.setValue(15);
        this.versions.setInverted(true);
        this.buttonGroup1.add(this.autoInstallJDK);
        this.autoInstallJDK.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoInstallJDK, (String)NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.autoInstallJDK.text"));
        this.autoInstallJDK.setToolTipText(NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.autoInstallJDK.toolTipText"));
        this.buttonGroup1.add(this.manualJDK);
        Mnemonics.setLocalizedText((AbstractButton)this.manualJDK, (String)NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.manualJDK.text"));
        this.manualJDK.setToolTipText(NbBundle.getMessage(QuickPanel.class, (String)"QuickPanel.manualJDK.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versions, -1, 481, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoInstallJDK).addComponent(this.manualJDK)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versions, -1, -1, -2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoInstallJDK).addGap(12, 12, 12).addComponent(this.manualJDK).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void setVersions(List<Integer> jdks, Map<Integer, TermOfSupport> lts) {
        this.versionsModel = new VersionsModel(jdks, lts);
        this.versions.setMaximum(this.versionsModel.getMaximum());
        this.versions.setMinimum(this.versionsModel.getMinimum());
        this.versions.setLabelTable(this.versionsModel.createLabels());
        this.versions.setValue(this.versionsModel.getDefaultValue());
    }

    @UIEffect
    @NonNull QuickSelection getSelectedPackage() {
        return new QuickSelection(this.versionsModel.getJDK(this.versions.getValue()), this.autoInstallJDK.isSelected());
    }

    static class QuickSelection {
        final int version;
        final boolean zip;

        public QuickSelection(int version, boolean zip) {
            this.version = version;
            this.zip = zip;
        }
    }

    static class VersionsModel {
        private final List<Integer> versionJDKs;
        private final Map<Integer, TermOfSupport> lts;

        private VersionsModel(List<Integer> jdks, Map<Integer, TermOfSupport> lts) {
            this.versionJDKs = new ArrayList<Integer>(jdks);
            this.versionJDKs.removeIf(v -> !lts.containsKey(v));
            this.versionJDKs.removeIf(v -> v <= 6);
            this.lts = lts;
        }

        public int getMinimum() {
            return 0;
        }

        public int getMaximum() {
            return this.versionJDKs.size() - 1;
        }

        public int getDefaultValue() {
            return this.versionJDKs.indexOf(LTSes.latest(this.lts));
        }

        @UIEffect
        public @NonNull Hashtable<Integer, JLabel> createLabels() {
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            for (Integer v : this.versionJDKs) {
                boolean isLTS = this.lts.containsKey(v);
                String name = isLTS ? LTSes.text(v, this.lts.get(v)) : String.valueOf(v);
                JLabel label = new JLabel(name);
                if (isLTS) {
                    Font font = label.getFont();
                    label.setFont(font.deriveFont(font.getStyle() | 1));
                    label.setToolTipText("Long Term Support");
                }
                labels.put(this.versionJDKs.indexOf(v), label);
            }
            return labels;
        }

        private int getJDK(int index) {
            return this.versionJDKs.get(index);
        }
    }
}

