/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class CatchNode
extends Statement {
    private final IdentNode exception;
    private final Expression exceptionCondition;
    private final Block body;
    private final boolean isSyntheticRethrow;

    public CatchNode(int n, long l, int n2, IdentNode identNode, Expression expression, Block block, boolean bl) {
        super(n, l, n2);
        this.exception = identNode == null ? null : identNode.setIsInitializedHere();
        this.exceptionCondition = expression;
        this.body = block;
        this.isSyntheticRethrow = bl;
    }

    private CatchNode(CatchNode catchNode, IdentNode identNode, Expression expression, Block block, boolean bl) {
        super(catchNode);
        this.exception = identNode;
        this.exceptionCondition = expression;
        this.body = block;
        this.isSyntheticRethrow = bl;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterCatchNode(this)) {
            return nodeVisitor.leaveCatchNode(this.setException((IdentNode)this.exception.accept(nodeVisitor)).setExceptionCondition(this.exceptionCondition == null ? null : (Expression)this.exceptionCondition.accept(nodeVisitor)).setBody((Block)this.body.accept(nodeVisitor)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterCatchNode(this);
    }

    @Override
    public boolean isTerminal() {
        return this.body.isTerminal();
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(" catch (");
        this.exception.toString(stringBuilder, bl);
        if (this.exceptionCondition != null) {
            stringBuilder.append(" if ");
            this.exceptionCondition.toString(stringBuilder, bl);
        }
        stringBuilder.append(')');
    }

    public IdentNode getException() {
        return this.exception;
    }

    public Expression getExceptionCondition() {
        return this.exceptionCondition;
    }

    public CatchNode setExceptionCondition(Expression expression) {
        if (this.exceptionCondition == expression) {
            return this;
        }
        return new CatchNode(this, this.exception, expression, this.body, this.isSyntheticRethrow);
    }

    public Block getBody() {
        return this.body;
    }

    public CatchNode setException(IdentNode identNode) {
        if (this.exception == identNode) {
            return this;
        }
        return new CatchNode(this, identNode, this.exceptionCondition, this.body, this.isSyntheticRethrow);
    }

    private CatchNode setBody(Block block) {
        if (this.body == block) {
            return this;
        }
        return new CatchNode(this, this.exception, this.exceptionCondition, block, this.isSyntheticRethrow);
    }

    public boolean isSyntheticRethrow() {
        return this.isSyntheticRethrow;
    }
}

