/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.ExternalContextFactoryImpl;
import com.sun.faces.context.FacesContextImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionFacesContextFactory
extends FacesContextFactory
implements FacesWrapper<FacesContextFactory> {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private FacesContextFactory delegate;
    private Field defaultFacesContext;
    private Field defaultExternalContext;

    public InjectionFacesContextFactory() {
    }

    public InjectionFacesContextFactory(FacesContextFactory delegate) {
        Util.notNull("facesContextFactory", delegate);
        this.delegate = delegate;
        try {
            this.defaultFacesContext = FacesContext.class.getDeclaredField("defaultFacesContext");
            this.defaultFacesContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultFacesContext' in javax.faces.context.FacesContext.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultFacesContext = null;
        }
        try {
            this.defaultExternalContext = ExternalContext.class.getDeclaredField("defaultExternalContext");
            this.defaultExternalContext.setAccessible(true);
        }
        catch (NoSuchFieldException nsfe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to find private field named 'defaultExternalContext' in javax.faces.context.ExternalContext.");
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
            this.defaultExternalContext = null;
        }
    }

    @Override
    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        FacesContext ctx = this.delegate.getFacesContext(context, request, response, lifecycle);
        if (ctx == null) {
            String message = MessageFormat.format("Delegate FacesContextFactory, {0}, returned null when calling getFacesContext().", this.delegate.getClass().getName());
            throw new IllegalStateException(message);
        }
        this.injectDefaults(ctx, request);
        return ctx;
    }

    @Override
    public FacesContextFactory getWrapped() {
        return this.delegate;
    }

    private void injectDefaults(FacesContext target, Object request) {
        block9: {
            block8: {
                FacesContext defaultFC;
                if (this.defaultFacesContext != null && (defaultFC = FacesContextImpl.getDefaultFacesContext()) != null) {
                    try {
                        this.defaultFacesContext.set(target, defaultFC);
                    }
                    catch (IllegalAccessException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            if (this.defaultExternalContext != null) {
                ServletRequest reqObj;
                ExternalContext defaultExtContext = null;
                if (request instanceof ServletRequest && (defaultExtContext = (ExternalContext)(reqObj = (ServletRequest)request).getAttribute(ExternalContextFactoryImpl.DEFAULT_EXTERNAL_CONTEXT_KEY)) != null) {
                    reqObj.removeAttribute(ExternalContextFactoryImpl.DEFAULT_EXTERNAL_CONTEXT_KEY);
                }
                if (defaultExtContext != null) {
                    try {
                        this.defaultExternalContext.set(target.getExternalContext(), defaultExtContext);
                    }
                    catch (IllegalAccessException e) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
        }
    }
}

